// position to sit on the ball e.g <0.0, 0.0, 0.43>
// sit  0.5 meter above the ball
vector POSITION=<-0.03, -0.2, 0.76>;

// rotate avatar to correct postion for this object
vector AVATAR_ROT=<0.0, 0.0, -90.0>*DEG_TO_RAD;

// Pie Menu Sit Text. Will only work for the
// main prim but included it anyway. If no text
// is entered between "" it won't be used.
string SIT_TEXT="";

// * * * * * * * STOP MODIFY * * * * * * * *//

string animation;

default 
{
    state_entry() 
    {
        if (llStringLength(SIT_TEXT)>0)
            llSetSitText(SIT_TEXT);
        llSitTarget(POSITION, llEuler2Rot(AVATAR_ROT)); 
    }
    
    changed(integer change) 
    { 
        if (change & CHANGED_LINK) 
        {
            
            if (llAvatarOnSitTarget() != NULL_KEY) 
            { 
                llRequestPermissions(llAvatarOnSitTarget(), PERMISSION_TRIGGER_ANIMATION);
            }
            else
            {
                integer perm=llGetPermissions();
                if ((perm & PERMISSION_TRIGGER_ANIMATION) && llStringLength(animation)>0)       
                    llStopAnimation(animation);
                animation="";
            }
        }
    }
    run_time_permissions(integer perm)
    {
        if (perm & PERMISSION_TRIGGER_ANIMATION)
        {
                llStopAnimation("sit");
                animation=llGetInventoryName(INVENTORY_ANIMATION,0);
                llStartAnimation(animation);
        }
    }
}