 // @author Jeroen Frans aka Frans aka MrFrans aka Frans Charming
 // @author The Vesuvius Group
 // @copyright 2009


integer webServerCheckInterval = 3600;  //Time interval between downloads of texture list from webserver
integer textureRefreshRate = 15;        //Texture changes after 15 seconds.


key http_request_id;
list textures;
string url = "http://www.thevesuviusgroup.com/SLTextureManager/OSCC13/textures.txt";
integer i = 0;                  //texture number
integer time;

default
{
    state_entry()
    {
        http_request_id = llHTTPRequest(url, [], "");
        llSetTimerEvent(textureRefreshRate);
    }
    
    on_rez(integer start_param){
        llResetScript();
    }
    
    timer(){
        llSetTexture((key)llList2String(textures, i), 0);         
        i++;
        if(i >= llGetListLength(textures)){ i = 0; }
        if(llGetUnixTime() > time){
            time = llGetUnixTime() + webServerCheckInterval;
            http_request_id = llHTTPRequest(url, [], "");
        }
    }
 
    http_response(key request_id, integer status, list metadata, string body)
    {
        if (request_id == http_request_id)
        {
            textures = llCSV2List(body);

        }
    }
}
