// hour hand start

rotation make_quaternion( vector axis, float angle )
{
    vector unit_axis = llVecNorm( axis );
    float sine_half_angle = llSin( angle/2 );
    float cosine_half_angle = llCos( angle/2 );

    rotation quat;
    quat.x = sine_half_angle * unit_axis.x;
    quat.y = sine_half_angle * unit_axis.y;
    quat.z = sine_half_angle * unit_axis.z;
    quat.s = cosine_half_angle;

    return quat;
}

default
{
    state_entry()
    {
        llSetTimerEvent(1);   
    }
    timer()
    {
        float now = llGetWallclock();
        float minute = (integer)now / 60;
        float hour = minute / 60;
        
        rotation hand_rot = make_quaternion(<1, 0, 0>, 30 * hour * DEG_TO_RAD);
        
        llSetLocalRot(hand_rot);
        
    }    
}

