string Where="opensim.3dles.com:8002";
string Sign = "3D LES";
vector LandingPoint = <128.0, 128.0,37.5>;
vector LookAt       = <1.0,1.0,0.0>;
integer JUMP_DELAY = 2;
list LastFewAgents;

PerformTeleport( key WhomToTeleport )
     {
          integer CurrentTime = llGetUnixTime();
          integer AgentIndex = llListFindList( LastFewAgents, [ WhomToTeleport ] );
          if (AgentIndex != -1)
          {    integer PreviousTime = llList2Integer( LastFewAgents, AgentIndex+1 );
               if (PreviousTime >= (CurrentTime - 5)) return;
               LastFewAgents = llDeleteSubList( LastFewAgents, AgentIndex, AgentIndex+1);
          }
          LastFewAgents += [ WhomToTeleport, CurrentTime ];
          llMapDestination(Where, LandingPoint, LookAt);

         
         llPlaySound ("teleportSound", 1.0); llSleep (JUMP_DELAY);
 
         //IF OS scripts are enabled, you can use this:
         // *******************************************
        //  osTeleportAgent( WhomToTeleport, Where, LandingPoint, LookAt );

     }
default
{
    state_entry()
    {
   llSetText(Sign,<1.0,0.0,0.0>,1.0);
    
    }
    
    touch_start(integer number)

     {    
          PerformTeleport( llDetectedKey( 0 ));  
     }
}
