// Ouverture au toucher.
// Ouverture à la collision.
// Fermeture automatique via un timer.
// Emet un son à l'ouverture et à la fermeture.
 
// Réglages que vous pouvez changer.
 
float  delay = 4.0;                         // Temps d'attente en secondes avant la fermeture automatique
float  direction = -1.0;                     // Régler sur 1.0 ou -1.0 pour définir la direction d'ouverture
float  volume = 0.5;                      // 0.0 pour muet, 1.0 pour un son maximal
 
// Vous pouvez changer ces variables pour inclure l'UUID de vos propres sons entre les guillemets
 
key    open_sound  = "";
key    close_sound = "";
 
// Initialisation du script, ne touchez à rien après cette ligne si vous ne savez pas ce que vous faites ...
 
default {
 
    state_entry() {
        state open;
    }
}
 
state closed {
 
    state_entry() {
        llTriggerSound(close_sound, volume);
        llSetRot(llEuler2Rot(<0, 0, direction * PI_BY_TWO>) * llGetRot());
 
    }
 
    touch_start(integer total_number) {
        state open;
    }
 
    collision_start(integer total_number)
    {
        state open;
    }
 
    timer()
    {
        llSetTimerEvent(0.0);
    }
}
 
 
state open {
 
    state_entry() {
        llTriggerSound(open_sound, volume);
        llSetRot(llEuler2Rot(<0, 0, -direction * PI_BY_TWO>) * llGetRot());
 
        llSetTimerEvent(delay);
    }
 
    on_rez(integer start_param) {
        state closed;
    }
 
    touch_start(integer total_number) {
        state closed;
    }
 
    collision_start(integer total_number)
    {
    }
 
    timer()
    {
        llSetTimerEvent(0.0);
        state closed;
    }
}