list buttons = ["Lab 4", "Lab 5", "Cancel", "Lab 1", "Lab 2", "Lab 3"];
string dialogInfo = "\nWhich Learning Lab region do you want to visit?  The Lab 1 region is the main track region.";
 
key ToucherID;
integer dialogChannel;
integer listenHandle;
 
default
{
    state_entry()
    {
        dialogChannel = -1 - (integer)("0x" + llGetSubString( (string)llGetKey(), -7, -1) );
    }
 
    touch_start(integer num_detected)
    {
        ToucherID = llDetectedKey(0);
        llListenRemove(listenHandle);
        listenHandle = llListen(dialogChannel, "", ToucherID, "");
        llDialog(ToucherID, dialogInfo, buttons, dialogChannel);
        llSetTimerEvent(60.0); // Here we set a time limit for responses
    }
 
    listen(integer channel, string name, key id, string message)
    {
        llListenRemove(listenHandle);
        //  stop timer since the menu was clicked
        llSetTimerEvent(0);
        if (message == "Lab 1")
        {
            osTeleportAgent(ToucherID, "Learning Lab", <128,128,30>, <1,1,1>); 
        }
        else if (message == "Lab 2")
        {
            osTeleportAgent(ToucherID, "Learning Lab 2", <128,128,30>, <1,1,1>); 
        }
        else if (message == "Lab 3")
        {
            osTeleportAgent(ToucherID, "Learning Lab 3", <128,128,30>, <1,1,1>); 
        }
        else if (message == "Lab 4")
        {
            osTeleportAgent(ToucherID, "Learning Lab 4", <128,128,30>, <1,1,1>); 
        } 
        else if (message == "Lab 5")
        {
            osTeleportAgent(ToucherID, "Learning Lab 5", <128,128,30>, <1,1,1>); 
        }
        else if (message == "Cancel")
        {
            llWhisper(0, "Ok, please make another choice."); 
        } 
        else
        {
            // do any other action here
        }
    }
 
    timer()
    {
    //  stop timer
        llSetTimerEvent(0);
 
        llListenRemove(listenHandle);
        llWhisper(0, "Sorry, you took too long to make a choice.");
    }
}