//*******************************************************
// Modified by Ken Savage 12/16/2015
// LSL | OPENSIM | ubODE
// Modified to work with boat and added proper banking
// December 06, 2015
//*******************************************************
//
//*******************************************************
// Hans Ingen²
// LSL | OPENSIM | ODE
// i-TEC + e3s + DC (ENGINE SPEED SENSITIVE STEERING WITH DYNAMIC CAMERA)
// JANUARY 28, 2013
// TODO: KEYWORD PROCESSOR FOR ** PRIM ANIMATION | AVATAR ANIMATION | SOUNDS | MENU | HUD | DYNAMIC CAMERA
//*******************************************************2
//**####################################################
//                BULLETSIM                            #
//                                                     #OSgrid 0.9.0.0 (Dev) be43fc2: 2016-03-06
// Modify  from  Cuteulala Artis and Hans Nerido       #
//                                                     #
//                                                     #New Script
//**###################################################
//---PERMISSION VARIABLES---------------------OSgrid 0.9.0.0 (Dev) be43fc2: 2016-03-06-----------------------
integer         gDrivePermit = 0; // 0=EVERYONE 1=OWNERONLY
string          gSitMessage = "Captain Seat";
string          gUrNotAllowedMessage = "Step Away From The Vehicle";
vector          gSitTarget_Pos = <0.15, -0.4, 0.625>;
vector          gSitTarget_Rot = <-0, 0.1, 0.0>;
key             gOldAgent;
key             gAgent;
integer         gRun;     //ENGINE RUNNING
integer         gMoving;  //VEHICLE MOVING
float         gTick=.1;
string      gDrivingAnim = "drive";
///
//float floatheight = 0.20;
///2
//---SOUND VARIABLES---------------------------------------------------
string       gSoundHorn =            "";// "s_horn";2
string       gSoundStartup =         "steam engine medium speed";// "steam engine medium speed";
string       gSoundIdle =            "steam engine medium speed";// "steam engine medium speed";
string       gSoundSlow =            "steam engine medium speed";// "steam engine medium speed
string       gSoundMedium =          "steam engine medium speed";// "s_medium";
string       gSoundAggressive =      "";// "s_fast";
string       gSoundRev =             "";// "s_rev";
string       gSoundAlarm =           "";// "s_alarm";
string       gSoundStop =            "";// "steam engine medium speed;
//NEED KEYWORD SOUND PROCESSOR
integer      gOldSound=4;   //variable for sound function2
integer      gNewSound=4;
//---Z-TEC POWERTRAIN + (e3s) GLOBAL VARIABLES -----------------
integer      gGear;
integer      gNewGear;
float        gGearPower;
float        gReversePower            =     -2;     //  12Res
list         gGearPowerList           = [   6,      //  Parking
                                            8,      //  1st
                                            0,     //  2nd
                                            0,     //  3rd
                                            0,     //  4th
                                            0      //  4th
                                         ];
//integer     gGearCount;
float       gTurnRatio;
list        gTurnRatioList            = [   2.0,   //  1st
                                            3.0,   //  2nd
                                            0.0    //  3rd
                                        //  3.0,    //  4th
                                        //  4.0,    //  5th180.00
                                        //  4.0     //  6th
                                         ];
string     gGearName;
list       gGearNameList                 =[ "Parking",
                                            "G-1",
                                            "G-2",
                                            "G-3"
                                               //  "G-4",
                                               //  "G-5"
                                         ];
                                         
float         gSpeed=0;
//NEED A KEYWORD PRIM ANIMATION PROCESSOR
integer            gTurnCount;
string             gTurnAngle =               "NoTurn";  // LeftTurn or RightTurn or NoTurn
string             gNewTurnAngle =            "NoTurn";
string             gTireSpin =                "prop-start";   // ForwardSpin or BackwardSpin or NoSpin
string             gNewTireSpin =             "prop-start";
integer            gTcountL;
integer            gTcountR;
//
preload_sounds(){
    llPreloadSound(gSoundHorn);
    llPreloadSound(gSoundStartup);
    llPreloadSound(gSoundIdle);
    llPreloadSound(gSoundSlow);
    llPreloadSound(gSoundMedium);
    llPreloadSound(gSoundAggressive);
    llPreloadSound(gSoundRev);
    llPreloadSound(gSoundAlarm);
}
init_engine(){
    gRun = 0;
    llSetBuoyancy(1); // ACTIVATE  THE NEX ONLY  FOR UBODE  !!e image!
//    llSetLinkPrimitiveParamsFast(LINK_ALL_CHILDREN, [PRIM_PHYSICS_SHAPE_TYPE, PRIM_PHYSICS_SHAPE_PRIM]);
    vector here = llGetPos();
    float h = llWater(<0,0,0>) - 0.12;
    vector rotv = llRot2Euler(llGetRot());
    rotation rot = llEuler2Rot(<0,0,rotv.z>);
    llSetPos(<here.x, here.y,h>);
    llSetRot(rot);
    
    llSetSitText(gSitMessage);
    llCollisionSound("", 0.0);
    llSitTarget(gSitTarget_Pos, llEuler2Rot(DEG_TO_RAD * gSitTarget_Rot));
    gOldSound=0; 
    gNewSound=4;
    llMessageLinked(LINK_SET, 0, "engines off", NULL_KEY);
}

init_camera(){
    llSetCameraParams([
                       CAMERA_ACTIVE, 1,                 // 0=INACTIVE  1=ACTIVE
                       CAMERA_BEHINDNESS_ANGLE, 10.0,     // (0 to 180) DEGREES
                       CAMERA_BEHINDNESS_LAG, 0.0,       // (0 to 3) SECONDS
                       CAMERA_DISTANCE, 10.0,             // ( 0.5 to 10) METERS
                       CAMERA_PITCH, 20.0,               // (-45 to 80) DEGREES
                       CAMERA_POSITION_LOCKED, FALSE,    // (TRUE or FALSE)
                       CAMERA_POSITION_LAG, 0.0,         // (0 to 3) SECONDS
                       CAMERA_POSITION_THRESHOLD, 0.5,   // (0 to 4) METERS
                       CAMERA_FOCUS_LOCKED, FALSE,       // (TRUE or FALSE)
                       CAMERA_FOCUS_LAG, 0.0 ,           // (0 to 3) SECONDS
                       CAMERA_FOCUS_THRESHOLD, 0.5,      // (0 to 4) METERS
                       CAMERA_FOCUS_OFFSET, <1,0.5,-1>   // <-10,-10,-10> to <10,10,10> METERS
                      ]);
}
set_engine(){
    integer vfW = VEHICLE_FLAG_HOVER_WATER_ONLY |  VEHICLE_FLAG_HOVER_GLOBAL_HEIGHT; //VEHICLE_FLAG_HOVER_TERRAIN_ONLY |
    integer vfG = VEHICLE_FLAG_NO_DEFLECTION_UP | VEHICLE_FLAG_LIMIT_ROLL_ONLY | VEHICLE_FLAG_HOVER_UP_ONLY | VEHICLE_FLAG_LIMIT_MOTOR_UP;
    integer vfA = VEHICLE_FLAG_HOVER_GLOBAL_HEIGHT;
    llSetVehicleType(VEHICLE_TYPE_BOAT);
// default rotation of local frame
    llSetVehicleRotationParam(VEHICLE_REFERENCE_FRAME, <0.00000, 0.00000, 0.00000, 0.00000>);
// linear motor wins after about five seconds, decays after about a minute 
    llSetVehicleFloatParam(VEHICLE_LINEAR_MOTOR_TIMESCALE, 0.50);  // 0.9
    llSetVehicleFloatParam(VEHICLE_LINEAR_MOTOR_DECAY_TIMESCALE, 1.10); //0.10
// least for forward-back, most friction for up-down
    llSetVehicleVectorParam(VEHICLE_LINEAR_FRICTION_TIMESCALE, <5.0,0.5,1.0> ); // <1.0,1.0,1.0> )
// uniform angular friction (setting it as a scalar rather than a vector)
    llSetVehicleVectorParam(VEHICLE_ANGULAR_FRICTION_TIMESCALE, <0.10,0.10,100.20> ); // <1.0,1000.0,1000.0> )    
// agular motor wins after four seconds, decays in same amount of time
    llSetVehicleFloatParam(VEHICLE_ANGULAR_MOTOR_TIMESCALE, 0.5); //0.2
    llSetVehicleFloatParam(VEHICLE_ANGULAR_MOTOR_DECAY_TIMESCALE, 0.2); //0.10
// halfway linear deflection with timescale of 3 seconds
    llSetVehicleFloatParam(VEHICLE_LINEAR_DEFLECTION_EFFICIENCY, 0.10);
    llSetVehicleFloatParam(VEHICLE_LINEAR_DEFLECTION_TIMESCALE, 10.00);
// angular deflection
    llSetVehicleFloatParam(VEHICLE_ANGULAR_DEFLECTION_EFFICIENCY, 0.50);//0.1
    llSetVehicleFloatParam(VEHICLE_ANGULAR_DEFLECTION_TIMESCALE, 10.00);
// somewhat bounscy vertical attractor
    llSetVehicleFloatParam(VEHICLE_VERTICAL_ATTRACTION_EFFICIENCY, 0.5);
    llSetVehicleFloatParam(VEHICLE_VERTICAL_ATTRACTION_TIMESCALE, 2.00);
// hover
    llSetVehicleFloatParam(VEHICLE_HOVER_HEIGHT, 0.0 );
    llSetVehicleFloatParam(VEHICLE_HOVER_EFFICIENCY, 0.5 );
    llSetVehicleFloatParam(VEHICLE_HOVER_TIMESCALE, 50.0 );
    llSetVehicleFloatParam(VEHICLE_BUOYANCY, 1.0 );
// weak negative damped banking
    llSetVehicleFloatParam( VEHICLE_BANKING_EFFICIENCY, 0.25 );
//    llSetVehicleFloatParam( VEHICLE_BANKING_MIX, 1.0 );
//    llSetVehicleFloatParam( VEHICLE_BANKING_TIMESCALE, 0.5 );
// remove these flags
    llRemoveVehicleFlags( VEHICLE_FLAG_HOVER_TERRAIN_ONLY
        | VEHICLE_FLAG_LIMIT_ROLL_ONLY
        | VEHICLE_FLAG_HOVER_GLOBAL_HEIGHT);
// set these flags
    llSetVehicleFlags( VEHICLE_FLAG_NO_DEFLECTION_UP
        | VEHICLE_FLAG_HOVER_WATER_ONLY
        | VEHICLE_FLAG_HOVER_UP_ONLY
        | VEHICLE_FLAG_LIMIT_MOTOR_UP );
}  
powershift(integer g){
    if(!gMoving){
        llSetCameraParams([CAMERA_BEHINDNESS_ANGLE,0.0]);
        llSetCameraParams([CAMERA_DISTANCE,0.0]);
    }
    else {
    vector vel = llGetVel();
    float speed = llVecMag(vel);
    if (speed <=20){
        llSetCameraParams([CAMERA_BEHINDNESS_ANGLE,0.0]);
        llSetCameraParams([CAMERA_DISTANCE,9.0]);
        }
        else if ((speed >=21) || (speed <=50)){
        llSetCameraParams([CAMERA_BEHINDNESS_ANGLE,0.0]);
        llSetCameraParams([CAMERA_DISTANCE,9.0]);
        }
        else  if (speed >=51) {
        llSetCameraParams([CAMERA_BEHINDNESS_ANGLE,0.0]);
        llSetCameraParams([CAMERA_DISTANCE,0.0]);
        }
    }
    gGearPower = llList2Integer(gGearPowerList, g);
}
gearshift(integer g){
    gGearName = llList2String(gGearNameList, g);
    enginesound();
    llSay(0,gGearName);     
}
nearestpi(){
    vector Rad = llRot2Euler( llGetRootRotation() );
    llSetRot( llEuler2Rot( <Rad.x, Rad.y, llRound( Rad.z / PI_BY_TWO ) * PI_BY_TWO > ) );
}

showdata(string s){
    llSetText(s+"\n.\n.\n.\n.",<1,1,.6>,1.0);
}

enginesound(){
    vector vel = llGetVel();
    float speed = llVecMag(vel);
        
    if (speed <= 3) {
        gNewSound = 0;
        } 
        else if (speed <= 5) {
            gNewSound = 1;
        } 
        else if (speed <= 12) {
            gNewSound = 2;
        } 
        else if (speed <= 10000) 
            gNewSound = 3;

    if (gOldSound != gNewSound) {
        if (gNewSound == 0) {
            llLoopSound(gSoundIdle,0.2);
        }
        if (gNewSound == 1) {
            llLoopSound(gSoundSlow,0.2);
        }
        if (gNewSound == 2) {
            llLoopSound(gSoundMedium,0.2);
        }
        if (gNewSound == 3) {
            llLoopSound(gSoundAggressive,0.2);
        }
        gOldSound = gNewSound;
    }   
}
cornerFXR(){
    vector vel = llGetVel();
    float speed = llVecMag(vel);
    if (speed >50){
        }
}
cornerFXL(){
    vector vel = llGetVel();
    float speed = llVecMag(vel);
    if (speed >50){
        }
}
default {
    state_entry()
    {   llSetText("",<1,1,1>,1.0);
        init_engine();
        state Ground;
    }
}
state Ground{

    state_entry(){
    }
    on_rez(integer param) {
        llResetScript();
        preload_sounds();
    }
    changed(integer change){
        if ((change & CHANGED_LINK) == CHANGED_LINK){
            gAgent = llAvatarOnSitTarget();
            if (gAgent != NULL_KEY){
                if( (gAgent != llGetOwner()) && (gDrivePermit == 1)){
                    llSay(0, gUrNotAllowedMessage);
                    llUnSit(gAgent);
                    llPlaySound(gSoundAlarm,0.2);
                    llPushObject(gAgent, <0,0,20>, ZERO_VECTOR, FALSE);
                }
                else {
                    llSetStatus(STATUS_PHYSICS, TRUE);
                    gOldAgent = gAgent;
                    set_engine();
                    llRequestPermissions(gAgent, PERMISSION_TRIGGER_ANIMATION | PERMISSION_TAKE_CONTROLS | PERMISSION_CONTROL_CAMERA);
                    gRun = 1;
                llMessageLinked(LINK_SET, 0, "engines on", NULL_KEY);                }
                llSetText("",<0,0,0>,0.0);
            }
            else {
//                llSetLinkPrimitiveParamsFast(LINK_ALL_CHILDREN, [PRIM_PHYSICS_SHAPE_TYPE, PRIM_PHYSICS_SHAPE_PRIM]);
                llSetStatus(STATUS_PHYSICS, FALSE);
                gRun = 0;
                init_engine();
                llTriggerSound(gSoundStop,0.2);
                llStopAnimation(gDrivingAnim);
                llSetTimerEvent(0.0);
                llStopSound();
                llSetText("Captain Must Sit First",<1,1,1>,1.0);
                llReleaseControls();
                llClearCameraParams();
                llMessageLinked(LINK_SET, 0, "engines off", NULL_KEY);
            }
        }
    }
    run_time_permissions(integer perm){
        if (perm) {
            gGear = 0; // GEAR#0 IS STAGER | GEAR#1 IS BURNOUT | GEAR#2 IS THE FIRST GEAR (LIST INDEX STARTS @ 0)
            //gNewGear = 2;  
            llTakeControls(CONTROL_FWD | CONTROL_BACK | CONTROL_DOWN | CONTROL_UP | CONTROL_RIGHT | CONTROL_LEFT | CONTROL_ROT_RIGHT | CONTROL_ROT_LEFT, TRUE, FALSE);

//------------------------------------  MUST BE  DEACTIVATE  FOR UBODE !!!!!!  --------------------------------------
            llSetLinkPrimitiveParamsFast(LINK_ALL_CHILDREN, [PRIM_PHYSICS_SHAPE_TYPE, PRIM_PHYSICS_SHAPE_NONE]);
//-------------------------------------------------------------------------------------------------------------------
            init_camera();
            llMessageLinked(LINK_SET, 0, "pipeflame", NULL_KEY);
            llMessageLinked(LINK_SET, 0, "headlight", "0");
            llMessageLinked(LINK_SET, 0, "speed on", NULL_KEY);
            llStartAnimation(gDrivingAnim);
            llTriggerSound(gSoundStartup,0.2);
            gOldSound = 4;
            llSleep(1.5);
            enginesound();
        }
    }
    control(key id, integer held, integer change){
        if(gRun == 0){
            return;
        }
        enginesound();
        integer reverse=1;
        vector vel = llGetVel();
        vector speedvec = llGetVel() / llGetRot();
        vector adjustedvec=<speedvec.x,0,speedvec.z>;
         llSetVelocity(adjustedvec,TRUE );
        gSpeed = llVecMag(vel);
        gTurnRatio = llList2Float(gTurnRatioList,gGear);
        if ((held & change & CONTROL_UP) || ((gGear >= 5) && (held & CONTROL_UP))){
            gGear=gGear+1;
            if (gGear < 0) gGear = 0;
            if (gGear > 1) gGear = 1;
            gearshift(gGear);
        }
        if ((held & change & CONTROL_DOWN) || ((gGear >= 5) && (held & CONTROL_DOWN))){
            gGear=gGear-1;
            if (gGear < 0) gGear = 0;
            if (gGear > 1) gGear = 1;
            gearshift(gGear);
        }
        if (held & CONTROL_FWD){
            if(gGear == 0) {
                llSetVehicleVectorParam(VEHICLE_LINEAR_FRICTION_TIMESCALE, <1.0, 2.0, 1000.0>);
            }else{
                llSetVehicleVectorParam(VEHICLE_LINEAR_FRICTION_TIMESCALE, <7.0, 3000.0, 1000.0>);
            }
            if(gGear == 1)  {
            }
            if(gGear == 2)  {
            }
            if(gGear == 3)  {
            }
            if(gGear == 4)  {
            }
            if(gGear == 5)  {
    llSetVehicleFloatParam(VEHICLE_LINEAR_MOTOR_TIMESCALE, 0.8);
            }
            powershift(gGear);
            llSetVehicleVectorParam(VEHICLE_LINEAR_MOTOR_DIRECTION, <gGearPower,0,0>);
            gMoving=1;
            reverse=1;
            gNewTireSpin = "prop-start";
        }
        if (held & CONTROL_BACK){
            llSetVehicleVectorParam(VEHICLE_LINEAR_MOTOR_DIRECTION, <gReversePower,0,0>);
            llSetCameraParams([CAMERA_BEHINDNESS_ANGLE,-45.0]);
            llSetCameraParams([CAMERA_DISTANCE,8.0]);
            gTurnRatio = -2.0;
            reverse = -1;
            gNewTireSpin = "prop-start";
        }
         if (~held & change & CONTROL_FWD){            
            gNewTireSpin = "NoSpin";
            gNewTurnAngle = "NoTurn";
            if (gGear > 9){
                gGear = 3;
            }
                }
         if (~held & change & CONTROL_BACK){            
            gNewTireSpin = "NoSpin";
            gNewTurnAngle = "NoTurn";
        }
    
       enginesound();
       
       float gYBankCompensation = -.08;
        
        vector AngularMotor;
        if (held & (CONTROL_RIGHT|CONTROL_ROT_RIGHT)){
            if (gGear==0){
            AngularMotor.z -= gSpeed / (gTurnRatio*1);
            }else{
            AngularMotor.z -= gSpeed / (gTurnRatio*gGear);
            }
            gNewTurnAngle = "RightTurn";
            gTurnCount = 6;
            gTcountR = 2;
            if ((reverse != -1) && (gGear >= 2) ) { 
                llSetVehicleVectorParam( VEHICLE_ANGULAR_MOTOR_DIRECTION, < 0.2, AngularMotor.y+gYBankCompensation, AngularMotor.z> ); //0.75
            } else {
                // No banking when in reverse or low gears
                llSetVehicleVectorParam( VEHICLE_ANGULAR_MOTOR_DIRECTION, < 0.0, AngularMotor.y, AngularMotor.z> );
            }
        }
        if (held & (CONTROL_LEFT|CONTROL_ROT_LEFT)){
            if (gGear==0){
            AngularMotor.z += gSpeed / (gTurnRatio*1);
            }else{
            AngularMotor.z += gSpeed / (gTurnRatio*gGear);
            }
            gNewTurnAngle = "LeftTurn";
            gTurnCount = 6;
            gTcountL = 2;
            if ( (reverse != -1) && (gGear >= 2) ) {
                llSetVehicleVectorParam( VEHICLE_ANGULAR_MOTOR_DIRECTION, < -0.2, AngularMotor.y+gYBankCompensation,AngularMotor.z> ); // -0.75
            } else {
                // No banking when in reverse or low gears
                llSetVehicleVectorParam( VEHICLE_ANGULAR_MOTOR_DIRECTION, < 0.0, AngularMotor.y,AngularMotor.z> ); 
            }
         }
           if(gTcountL > 0){
                gTcountL--;
            }
            if(gTcountL == 1){
                cornerFXL();
            }
            if(gTcountR > 0){
                gTcountR--;
            }
            if(gTcountR == 1){
                cornerFXR();
            }
        if(gTurnCount > 0){
            gTurnCount--;
        }
        if(gTurnCount == 1){
            gNewTurnAngle = "NoTurn";
        }
        if(gTurnAngle != gNewTurnAngle){
            gTurnAngle = gNewTurnAngle;
            llMessageLinked(LINK_ALL_OTHERS, 0, "prop-start", NULL_KEY);
        }
        if(gTireSpin != gNewTireSpin){
            gTireSpin = gNewTireSpin;
            llMessageLinked(LINK_ALL_OTHERS, 0, "prop-start", NULL_KEY);
        }}} 