// Youtube TV Set
// Script by Fogo Sagrado

// Multiple Dialogs created by Ugleh Ulrik
 
// TV Channel
string chann;
            
// Here we set the Dialog Channel
integer channel = -900;
 
integer listen_handle;
 
// Here we make a huge list for an example
list The_List = ["STORE", "RESTORE", "Youtube", "Vevo", "Dailymotion", "Filmon", "Putlocker", "123Movies", "FMovies", "AllTVSeries", "Popcorn", "FFilms", "Hulu", "Netflix"];

list GetPrimMediaParams(integer face, list input)
{//Returns a list that can be fed to llSetLinkMedia or llSetPrimMediaParams
    list output;
    integer c = ~llGetListLength(input);
    while((c = - ~c))
    {
        list flag = llList2List(input, c, c);
        output += flag + llGetLinkMedia(LINK_THIS, face, flag);
    }
    if(output == input)
        return [];
    return output;
}

list order_buttons(list buttons)
{
    return llList2List(buttons, -3, -1) + llList2List(buttons, -6, -4) +
        llList2List(buttons, -9, -7) + llList2List(buttons, -12, -10);
}
 
integer menuindex = 0;
 
DialogPlus(key avatar, string message, list buttons, integer channel, integer CurMenu)
{
    if (12 < llGetListLength(buttons))
    {
        list lbut = buttons;
        list Nbuttons = [];
        if(CurMenu == -1)
        {
            CurMenu = 0;
            menuindex = 0;
        }
 
        if((Nbuttons = (llList2List(buttons, (CurMenu * 10), ((CurMenu * 10) + 9)) + ["Back", "Next"])) == ["Back", "Next"]) {
            menuindex = 0;
            DialogPlus(avatar, message, lbut, channel, 0);
            }
        else
            llDialog(avatar, message,  order_buttons(Nbuttons), channel);
    }
    else
        llDialog(avatar, message,  order_buttons(buttons), channel);
}

default
{
    state_entry()
    {
 
        // Required media params
        list media_params = [PRIM_MEDIA_AUTO_PLAY, TRUE,  PRIM_MEDIA_AUTO_SCALE, TRUE, PRIM_MEDIA_WIDTH_PIXELS, 1024, PRIM_MEDIA_HEIGHT_PIXELS, 512, PRIM_MEDIA_PERMS_INTERACT , PRIM_MEDIA_PERM_ANYONE, PRIM_MEDIA_PERMS_CONTROL, PRIM_MEDIA_PERM_ANYONE, PRIM_MEDIA_HOME_URL, "https://www.youtube.com/", PRIM_MEDIA_CURRENT_URL, "https://www.youtube.com/"];

         // Set media params
         llSetPrimMediaParams(2, media_params);
         
    }

    touch_start(integer total_number)
    {
        key owner = llGetOwner();
 
        // We set a listen for only the owner
        // So this script assumes the object will only be touched by the owner
        listen_handle = llListen(channel, "", owner, "");
 
        // Touch_Start we issue menuindex as 0 inside of the function itself
        DialogPlus(owner, "Select an Option", The_List, channel, 0);
    }
 
    // We need a listen for the dialog itself, but as well as the Back/Next button.
    listen(integer chan, string name, key id, string msg)
    {
        key owner = llGetOwner();
 
        // If they clicked Next it will go to the next dialog window
        if(msg == "Next")
        {
            // ++menuindex will turn menuindex plus 1, making it give the next page.
            DialogPlus(owner, "Select an Option", The_List, channel, ++menuindex);
        }
 
        // if they clicked back it will go to the last dialog window.
        else if(msg == "Back") {
            DialogPlus(owner, "Select an Option", The_List, channel, --menuindex);
            }
            // --menuindex will turn menuindex minus 1, making it give the previous page.
 
        // If they choose anything besides Back/Next it will be in this section
        else
        {
            // Be Safe
            llListenRemove(listen_handle);
            
            // User has selected an action from the menu

            if (msg == "STORE") {
               list listURL = GetPrimMediaParams(2,[PRIM_MEDIA_CURRENT_URL]);
               chann = llList2String(listURL,1);
               if (llStringLength(chann)<127) {
                  llSetObjectDesc(chann);
               } else {
                  llSay(0,"Error: URL too long"); }
            }
            
            if (msg == "RESTORE") {
               string cha = llGetObjectDesc();
               if (cha != " ") {
                  chann = cha; };
                  }

            if (msg == "Youtube") {
               chann = "https://www.youtube.com/";
               }
            if (msg == "Vevo") {
               chann = "https://www.vevo.com/";
               }
            if (msg == "Dailymotion") {
               chann = "http://www.dailymotion.com/us";
               }
            if (msg == "Filmon") {
               chann = "https://www.filmon.com/";
               }
            if (msg == "Putlocker") {
               chann = "http://putlockers.ch/featured/1";
               }
            if (msg == "123Movies") {
               chann = "http://123movies.is/";
               }
            if (msg == "FMovies") {
               chann = "http://fmovies.to/";
               }
            if (msg == "AllTVSeries") {
               chann = "http://moviewatcher.io/tv-series";
               }
            if (msg == "Popcorn") {
               chann = "http://www.popcornflix.com/";
               }
            if (msg == "FFilms") {
               chann = "http://ffilms.org/";
               }
            if (msg == "Hulu") {
               chann = "http://www.hulu.com/";
               }
            if (msg == "Netflix") {
               chann = "https://www.netflix.com/";
               }
               
            llSay(0,"Selected channel "+ msg + " url: " + chann);
               
            // Required media params
            list media_params = [PRIM_MEDIA_AUTO_PLAY, TRUE,  PRIM_MEDIA_AUTO_SCALE, TRUE, PRIM_MEDIA_WIDTH_PIXELS, 1024, PRIM_MEDIA_HEIGHT_PIXELS, 512, PRIM_MEDIA_PERMS_INTERACT , PRIM_MEDIA_PERM_ANYONE, PRIM_MEDIA_PERMS_CONTROL, PRIM_MEDIA_PERM_ANYONE, PRIM_MEDIA_HOME_URL, "https://www.youtube.com/", PRIM_MEDIA_CURRENT_URL, chann];

            // Set media params
            llSetPrimMediaParams(2, media_params);

        }
    }
} 