string mixerstr;
list mixer;
integer step;
vector mixcolour;
string mixcolstr;
integer time = 1;
integer loop;
integer effectFlags=0;
integer colorInterpolation  = TRUE;
vector  startColor          = <1,1,1>; //edit these for colours
vector  endColor            = <1,1,1>;
float   startAlpha          = 0.1;
float   endAlpha            = 0.2;
integer glowEffect          = FALSE;
integer sizeInterpolation   = TRUE;
vector  startSize           = <1,0.4,4>;
vector  endSize             = <4,0.4,4>;
integer followVelocity      = FALSE;
//string  texture             = "86d3ac9d-2b3a-c934-04f1-13a94c0161a1";
string  texture             = "3efdfa6c-b9b1-488a-9825-e15462cf99a5";
float   particleLife        = 30; //edit this for range
float   SystemLife          = 0.0;
float   emissionRate        = 0.0;
integer partPerEmission     = 1; //edit this for density
float   radius              = 0;
float   innerAngle          = 0;
float   outerAngle          = PI; //PI_BY_TWO; //PI;
vector  omega               = <0.0, 0.0, 0.0>;
float   minSpeed            = 1;
float   maxSpeed            = 1;
vector  acceleration        = <0.0, 0.0, 0.0>;
integer windEffect          = FALSE;
integer bounceEffect        = FALSE;
integer followSource        = TRUE;
key     target              = "";
integer pattern = PSYS_SRC_PATTERN_ANGLE;
integer on = FALSE;
integer i;
integer channel;
integer debug;
string string2;
integer mixfunc;
updateParticles()
{
    if (on)
    {
        target="";
        if (colorInterpolation) effectFlags = effectFlags|PSYS_PART_INTERP_COLOR_MASK;
        if (sizeInterpolation)  effectFlags = effectFlags|PSYS_PART_INTERP_SCALE_MASK;
        if (windEffect)         effectFlags = effectFlags|PSYS_PART_WIND_MASK;
        if (bounceEffect)       effectFlags = effectFlags|PSYS_PART_BOUNCE_MASK;
        if (followSource)       effectFlags = effectFlags|PSYS_PART_FOLLOW_SRC_MASK;
        if (followVelocity)     effectFlags = effectFlags|PSYS_PART_FOLLOW_VELOCITY_MASK;
        if (target!="")         effectFlags = effectFlags|PSYS_PART_TARGET_POS_MASK;
        if (glowEffect)         effectFlags = effectFlags|PSYS_PART_EMISSIVE_MASK;
        
        llParticleSystem([
            PSYS_PART_FLAGS,            effectFlags,
            PSYS_SRC_PATTERN,           pattern,
            PSYS_PART_START_COLOR,      startColor,
            PSYS_PART_END_COLOR,        endColor,
            PSYS_PART_START_ALPHA,      startAlpha,
            PSYS_PART_END_ALPHA,        endAlpha,
            PSYS_PART_START_SCALE,      startSize,
            PSYS_PART_END_SCALE,        endSize,    
            PSYS_PART_MAX_AGE,          particleLife,
            PSYS_SRC_ACCEL,             acceleration,
            PSYS_SRC_TEXTURE,           texture,
            PSYS_SRC_BURST_RATE,        emissionRate,
            //PSYS_SRC_INNERANGLE,        innerAngle,
            //PSYS_SRC_OUTERANGLE,        outerAngle,
            PSYS_SRC_ANGLE_BEGIN,       innerAngle,
            PSYS_SRC_ANGLE_END,         outerAngle,
            PSYS_SRC_BURST_PART_COUNT,  partPerEmission,      
            PSYS_SRC_BURST_RADIUS,      radius,
            PSYS_SRC_BURST_SPEED_MIN,   minSpeed,
            PSYS_SRC_BURST_SPEED_MAX,   maxSpeed, 
            PSYS_SRC_MAX_AGE,           SystemLife,
            PSYS_SRC_TARGET_KEY,        target,
            PSYS_SRC_OMEGA,             omega   ]);
    }
}


default
{
    state_entry()
    {
        
            channel = (integer)llGetObjectDesc() + 12050;
            //llOwnerSay((string)channel);
            if (channel == 12050)
            {
                llOwnerSay("Error! Fog Blaster channel set to 0, or not a correct channel. Please reconfigure the channel by typing your desired channel in the description field of the Fog Blaster. This must be the same channel as configured in the controller.");
            }
            else
            {
                llOwnerSay("d'Elle Tech Fog Blaster Emitter Ready.\n Configured for channel " + llGetObjectDesc() + ".");
            }
            llParticleSystem([]);
            //updateParticles();
            llListen(channel,"","","");
    }
    
    listen (integer channel, string name, key id, string message)
    {
        if (debug)
        {
            llSay(0,message);
        }
        list strings = llParseString2List(message,[" "],[]);
        string command=llList2String(strings,0);
        string string1=llList2String(strings,1);
        string string2=llList2String(strings,2);
        string string3=llList2String(strings,3);
        string string4=llList2String(strings,4); 
        if (debug)
        {  
            llSay(0,string1);
            llSay(0,string2);
            llSay(0,string3);
            llSay(0,string4);
        }
        if (command == "debug")
        {
            if (string1 == "on")
            {
                debug = TRUE;
            }
            if (string1 == "off")
            {
                debug = FALSE;
            }
        }
        if (command == "glow")
        {
            if (string1 == "1")
            {
                glowEffect = TRUE;
                effectFlags = 0;
                updateParticles();
            }
            if (string1 == "0")
            {
                glowEffect = FALSE;
                effectFlags = 0;
                updateParticles();
            }
        }
        if (command == "operation")
        {
            if (string1 == "on")
            {
                on = TRUE;
                llMessageLinked(LINK_SET, 0, "on", "NULL_KEY");
                updateParticles();
            }
            if (string1 == "off")
            {
                on = FALSE;
                llMessageLinked(LINK_SET, 0, "off", "NULL_KEY");
                effectFlags = 0;
                llParticleSystem([]);
            }
            if (string1 == "360")
            {
                outerAngle = PI;
                updateParticles();
            }
            if (string1 == "180")
            {
                outerAngle = PI_BY_TWO;
                updateParticles();
            }
            if (string1 == "show")
            {
                llSetPrimitiveParams([25, ALL_SIDES, 0.1, PRIM_FULLBRIGHT, ALL_SIDES, TRUE]);
                llSetLinkAlpha(LINK_SET, 1, ALL_SIDES);
            }
            if (string1 == "hide")
            {
                llSetPrimitiveParams([25, ALL_SIDES, 0.0, PRIM_FULLBRIGHT, ALL_SIDES, FALSE]);
                llSetLinkAlpha(LINK_SET, 0, ALL_SIDES);
            }
            if (string1 == "mixer")
            {
                if (string2 == "config")
                {
                    mixerstr = string3;
                    if (debug)
                    {
                        llSay(0,"Mixer = " + mixerstr);
                    }
                }
            }
                if (string2 == "on")
                {
                    mixer = llParseString2List(mixerstr, [":"], []);
                    if (debug)
                    {
                        llSay(0,(string)mixer);
                        llSay(0,(string)llGetListLength(mixer));
                    }
                    llSetTimerEvent(0.1);
                }
                if (string2 == "off")
                {
                    llSetTimerEvent(0.0);
                }
        }
        if (command == "density")
        {
            if (string1 == "10")
            {
                partPerEmission = 1;
                startAlpha = 0.05;
                endAlpha = startAlpha * 2;
                updateParticles();
            }
            if (string1 == "20")
            {
                partPerEmission = 2;
                startAlpha = 0.06;
                endAlpha = startAlpha * 2;
                updateParticles();
            }
            if (string1 == "30")
            {
                partPerEmission = 3;
                startAlpha = 0.07;
                endAlpha = startAlpha * 2;
                updateParticles();
            }
            if (string1 == "40")
            {
                partPerEmission = 4;
                startAlpha = 0.08;
                endAlpha = startAlpha * 2;
                updateParticles();
            }
            if (string1 == "50")
            {
                partPerEmission = 5;
                startAlpha = 0.09;
                endAlpha = startAlpha * 2;
                updateParticles();
            }
            if (string1 == "60")
            {
                partPerEmission = 6;
                startAlpha = 0.10;
                endAlpha = startAlpha * 2;
                updateParticles();
            }
            if (string1 == "70")
            {
                partPerEmission = 7;
                startAlpha = 0.11;
                endAlpha = startAlpha * 2;
                updateParticles();
            }
            if (string1 == "80")
            {
                partPerEmission = 8;
                startAlpha = 0.12;
                endAlpha = startAlpha * 2;
                updateParticles();
            }
            if (string1 == "90")
            {
                partPerEmission = 9;
                startAlpha = 0.13;
                endAlpha = startAlpha * 2;
                updateParticles();
            }
            if (string1 == "100")
            {
                partPerEmission = 10;
                startAlpha = 0.14;
                endAlpha = startAlpha * 2;
                updateParticles();
            }
        }
        if (command == "depth")
        {
            if (string1 == "10")
            {
                startSize = <1,0.4,4>;
                endSize = <4,0.4,4>;
                updateParticles();
            }
            if (string1 == "20")
            {
                startSize = <1,0.8,4>;
                endSize = <4,0.8,4>;
                updateParticles();
            }
            if (string1 == "30")
            {
                startSize = <1,1.2,4>;
                endSize = <4,1.2,4>;
                updateParticles();
            }
            if (string1 == "40")
            {
                startSize = <1,1.6,4>;
                endSize = <4,1.6,4>;
                updateParticles();
            }
            if (string1 == "50")
            {
                startSize = <1,2,4>;
                endSize = <4,2,4>;
                updateParticles();
            }
            if (string1 == "60")
            {
                startSize = <1,2.4,4>;
                endSize = <4,2.4,4>;
                updateParticles();
            }
            if (string1 == "70")
            {
                startSize = <1,2.8,4>;
                endSize = <4,2.8,4>;
                updateParticles();
            }
            if (string1 == "80")
            {
                startSize = <1,3.2,4>;
                endSize = <4,3.2,4>;
                updateParticles();
            }
            if (string1 == "90")
            {
                startSize = <1,3.6,4>;
                endSize = <4,3.6,4>;
                updateParticles();
            }
            if (string1 == "100")
            {
                startSize = <1,4,4>;
                endSize = <4,4,4>;
                updateParticles();
            }
        }
        if (command == "distance")
        {
            if (string1 == "10")
            {
                particleLife = 3;
                updateParticles();
            }
            if (string1 == "20")
            {
                particleLife = 6;
                updateParticles();
            }
            if (string1 == "30")
            {
                particleLife = 9;
                updateParticles();
            }
            if (string1 == "40")
            {
                particleLife = 12;
                updateParticles();
            }
            if (string1 == "50")
            {
                particleLife = 15;
                updateParticles();
            }
            if (string1 == "60")
            {
                particleLife = 18;
                updateParticles();
            }
            if (string1 == "70")
            {
                particleLife = 21;
                updateParticles();
            }
            if (string1 == "80")
            {
                particleLife = 24;
                updateParticles();
            }
            if (string1 == "90")
            {
                particleLife = 27;
                updateParticles();
            }
            if (string1 == "100")
            {
                particleLife = 30;
                updateParticles();
            }
        }
        if (command == "scolour")
        {
            startColor = (vector)string1;
            updateParticles();
        }
        if (command == "ecolour")
        {
            endColor =  (vector)string1;
            updateParticles();
        }
        if (command == "position")
        {
            if (string1 == "up")
            {
                for(i=0; i<10; i++)
                {
                    llSetPos(llGetPos() + <0, 0, 0.05>);
                }
            }
            if (string1 == "down")
            {
                for(i=0; i<10; i++)
                {
                    llSetPos(llGetPos() - <0, 0, 0.05>);
                }
            }
        }
    }
    link_message(integer int,integer num,string msg,key id)
    {
        if (msg == "stop")
        {
                    mixfunc = FALSE;
                on = TRUE;
                llMessageLinked(LINK_SET, 0, "on", "NULL_KEY");
                updateParticles();
            }
        }
            
    on_rez( integer param )
    {
        llResetScript();
    }
    timer()
    {
        if (debug)
        {
            llSay(0,"Step = " + (string)step);
            llSay(0,(string)llList2String(mixer,step));
        }
        mixcolstr = "<" + llList2String(mixer,step) + ">";
        mixcolour = (vector)mixcolstr;
        step += 1;
        time = ((integer)llList2String(mixer,step));
        step += 1;
        if (debug)
        {
            llSay(0,"Vector = " + (string)mixcolour);
            llSay(0,(string)llGetListLength(mixer));
        }
        startColor = mixcolour;
        endColor = mixcolour;
        updateParticles();
        if (step > llGetListLength(mixer) - 2)
        {
            step = 0;
        }
        llSetTimerEvent(time);
    }
        
}
