//########################### OpenSim - Physical Flight Script v2.1 ###############################


//---------------------- Set Aktion-Range here (Simborder-crossing Protection) --------------------

integer EN =  1; // Switcher:  EN = 1 (enables Protection),  EN = 0 (disables Protection)
integer RX =  1; // how many Regions in X-Direction (West  to East)  default for single Region is 1
integer RY =  1; // how many Regions in Y-Direction (South to North) default for single Region is 1
integer VL = 10; // Minimum Distance to a Simborder (is one length of the Vehicle in Meters)

//-------------------------------------------------------------------------------------------------


//
// GLOBAL VARIABLES FOR PILOT SEATING AND CAMERA VIEWPOINT
//
string PILOT_ANIM = "flight pose";         // current Sit-Animation (must be in Vehicle Content)
vector SIT_POSITION =<0.0, 0.50, 0.2> ; // position of pilot on sit prim
vector SIT_ROTATION = <0, 0, 90>;        // rotation of pilot on sit prim
integer Private = 0;                     // 1= Owner Only Pilot. 0= Anyone can be Pilot.
float CAM_ZOOM  =  9.0;                  // How far back the pilot's camera follows
float CAM_ANGLE = 12.0;                  // Vertical angle pilot's camera follows
//
// GLOBAL VARIABLES FOR TEXT & DIALOG
//
string sit_message = "Fly";
string not_owner_message = "Sorry. You are not the owner.";
string TITLE="Helicopter";
string StartUpText = "  Use Arrows:    Fwd/Rew,  Left/Right,  PageUp/Down";
string mainMenuDialog1 = "\nGear 1 of 8             Gear 1 of 4";
list mainMenuButtons = ["- Climb", "- Speed", "Close", "+ Climb", "+ Speed"];
integer dialogChannel;
integer dialogHandle;
//
// GLOBAL VARIABLES FOR VEHICLE MOTION
//
integer hps = 8;                         // Minimum horizontal Power-Rate
float hpm = 64;                          // Maximum horizontal Power-Rate
float hpr = 2;                           // Power change Factor
float hp;
float hp_old; 
integer vps = 2;                         // Minimum vertical Power-Rate
integer vpm = 16;                        // Maximum vertical Power-Rate
integer vpr = 2;                         // climb change rate
float vlo = 0.50;                        // vertical landing Offset
float vmin = 0.75;                       // minimum Hoverhigh over Water
float vp;
float Curveangl = 7.5;                   // Angle of Vihicle at Curves
float angz = 0.5;                        // Sharpness of turns/curves (practical values 0.5 to 1.0)
float angz_low = 0.2;
float angz_high = 0.5;
//
//  GLOBAL VARIABLES FOR PARTICLES
//-----------------
//------------------------------------
integer H_dir = 1; // Indicator for Vihicle Horizontal moving Back = -1 or FWD = 1 or stop = 0
integer V_dir = 1; // Indicator for Vihicle Vertical moving Up = 1 or Down = -1 or stop = 0
float VS;
integer VPC;
//
//  GENEREL GLOBAL VARIABLES  (DO NOT CHANGE !!!)
//
float ALTITUDE;
vector ANGULAR_MOTOR;
integer RUN;
key AVATAR;
float SPEED;
float OFFSET;
integer HELD;
integer P;
integer H_Gear;
integer V_Gear;
//float SB;
float HGfac = 2.0;
float PXY_S;
integer ME = 1;
integer dir;                  // Indicator for Vehicle Direction FWD/BACK used at XYrotation
integer V_END;                // Indicator Ground or Prim touched
integer Menu;
float HF = DEG_TO_RAD * 90;
float HB = DEG_TO_RAD * 270;
float VU = DEG_TO_RAD * 180;
float L2;

//----------------------------------- Subroutines ----------------------------------------

  
MOVE_ENABLE_FWD()
{
 vector R_Pos = llGetPos(); vector R_Rot = llRot2Euler(llGetRot()); float AZ = R_Rot.z * RAD_TO_DEG;
 float sin = llFabs(llSin(R_Rot.z)); float cos = llFabs(llCos(R_Rot.z));
 
 float PXL = VL + PXY_S * sin; float PXH = RX * 256 - (VL + PXY_S * sin);
 float PYL = VL + PXY_S * cos; float PYH = RY * 256 - (VL + PXY_S * cos);
 
 if((AZ >= 0) && (AZ < 90))
 {
  if((R_Pos.x <= PXL) || (R_Pos.y >= PYH)) {ME = 0;}
 }
 
 if(AZ >= 90)
 {
  if((R_Pos.x <= PXL) || (R_Pos.y <= PYL)) {ME = 0;}
 }

 if((AZ < 0) && (AZ > -90))
 {
  if((R_Pos.x >= PXH) || (R_Pos.y >= PYH)) {ME = 0;}
 }
 
 if(AZ <= -90)
 {
  if((R_Pos.x >= PXH) || (R_Pos.y <= PYL)) {ME = 0;}
 }
 
}


MOVE_ENABLE_REW()
{
 vector R_Pos = llGetPos(); vector R_Rot = llRot2Euler(llGetRot()); float AZ = R_Rot.z * RAD_TO_DEG;
 float sin = llFabs(llSin(R_Rot.z)); float cos = llFabs(llCos(R_Rot.z));
 
 float PXL = VL + PXY_S * sin; float PXH = RX * 256 - (VL + PXY_S * sin);
 float PYL = VL + PXY_S * cos; float PYH = RY * 256 - (VL + PXY_S * cos);
 
 if((AZ >= 0) && (AZ < 90))
 {
  if((R_Pos.x >= PXH) || (R_Pos.y <= PYL)) {ME = 0;}
 }
 
 if(AZ >= 90)
 {
  if((R_Pos.x >= PXH) || (R_Pos.y >= PYH)) {ME = 0;}
 }

 if((AZ < 0) && (AZ > -90))
 {
  if((R_Pos.x <= PXL) || (R_Pos.y <= PYL)) {ME = 0;}
 }
 
 if(AZ <= -90)
 {
  if((R_Pos.x <= PXL) || (R_Pos.y >= PYH)) {ME = 0;}
 }
 
}


open_menu(key inputKey, string inputString, list inputList)
{
    dialogChannel = (integer)llFrand(DEBUG_CHANNEL)*-1;
    dialogHandle = llListen(dialogChannel, "", inputKey, "");
    llDialog(inputKey, inputString, inputList, dialogChannel);
}
 
close_menu()
{
    llListenRemove(dialogHandle);
    dialogHandle = FALSE;
    dialogChannel = (integer)llFrand(DEBUG_CHANNEL)*-1;
}


SETUP_CAMERA()
{
    llSetCameraParams([
        CAMERA_ACTIVE, 1,                     // 1 is active, 0 is inactive
        CAMERA_BEHINDNESS_ANGLE, 0,           // (0 to 180) degrees
        CAMERA_BEHINDNESS_LAG, 0.0,           // (0 to 3) seconds
        CAMERA_DISTANCE, CAM_ZOOM,            // ( 1 to 30) meters
        CAMERA_FOCUS_LAG, 0.0 ,               // (0 to 3) seconds
        CAMERA_FOCUS_LOCKED,FALSE,            // (FALSE)
        CAMERA_FOCUS_THRESHOLD, 0.0,          // (0 to 4) meters
        CAMERA_PITCH, CAM_ANGLE,              // (-45 to 80) degrees
        CAMERA_POSITION_LAG, 0.0,             // (0 to 3) seconds
        CAMERA_POSITION_LOCKED, FALSE,        // (TRUE or FALSE)
        CAMERA_POSITION_THRESHOLD, 0.0,       // (0 to 4) meters
        CAMERA_FOCUS_OFFSET, <0.0, 0.0, 0.5>  // <-10,-10,-10> to <10,10,10> meters
    ]);
}


SETUP_VEHICLE()
{
        // Vehicle Type
        llSetVehicleType(VEHICLE_TYPE_BOAT);                                         // in use
        
        // Type Vector --------------------------------------------------------------
        
        // friction
        llSetVehicleVectorParam(VEHICLE_ANGULAR_FRICTION_TIMESCALE, <1.0, 1.0, 1.0>);// z in use
        llSetVehicleVectorParam(VEHICLE_LINEAR_FRICTION_TIMESCALE, <1.0, 1.0, 1.0>); // x,y in use
        // motor
        llSetVehicleVectorParam(VEHICLE_ANGULAR_MOTOR_DIRECTION, <0, 0, 0>);         // in use
        llSetVehicleVectorParam(VEHICLE_LINEAR_MOTOR_DIRECTION, <0, 0, 0>);          // in use
        llSetVehicleVectorParam(VEHICLE_LINEAR_MOTOR_OFFSET, <0, 0, 0>);             // ???
        
        // Type Float -------------------------------------------------------
        
        // hover
        llSetVehicleFloatParam(VEHICLE_HOVER_HEIGHT, ALTITUDE);              // in use
        llSetVehicleFloatParam(VEHICLE_HOVER_EFFICIENCY, 1.0);               // ???
        llSetVehicleFloatParam(VEHICLE_HOVER_TIMESCALE, 1.0);                // ???
        llSetVehicleFloatParam(VEHICLE_BUOYANCY, 1.0);                       // ???
        // friction
        llSetVehicleFloatParam(VEHICLE_ANGULAR_FRICTION_TIMESCALE, 1.0);     // ???
        // motor
        llSetVehicleFloatParam(VEHICLE_LINEAR_MOTOR_TIMESCALE, 0.1);         // in use
        llSetVehicleFloatParam(VEHICLE_LINEAR_MOTOR_DECAY_TIMESCALE, 0.2);   // in use
        llSetVehicleFloatParam(VEHICLE_ANGULAR_MOTOR_TIMESCALE, 0.1);        // in use
        llSetVehicleFloatParam(VEHICLE_ANGULAR_MOTOR_DECAY_TIMESCALE, 1.0);  // in use
        //deflection
        llSetVehicleFloatParam(VEHICLE_LINEAR_DEFLECTION_EFFICIENCY, 1.0);   // ???
        llSetVehicleFloatParam(VEHICLE_LINEAR_DEFLECTION_TIMESCALE, 1.0);    // ???
        llSetVehicleFloatParam(VEHICLE_ANGULAR_DEFLECTION_EFFICIENCY, 1.0);  // ???
        llSetVehicleFloatParam(VEHICLE_ANGULAR_DEFLECTION_TIMESCALE, 1.0);   // ???
        // attraction
        llSetVehicleFloatParam(VEHICLE_VERTICAL_ATTRACTION_EFFICIENCY, 1.0); // ???
        llSetVehicleFloatParam(VEHICLE_VERTICAL_ATTRACTION_TIMESCALE, 1.0);  // ???
        // banking
        llSetVehicleFloatParam(VEHICLE_BANKING_EFFICIENCY, 1.0);             // ???
        llSetVehicleFloatParam(VEHICLE_BANKING_MIX, 1.0);                    // ???
        llSetVehicleFloatParam(VEHICLE_BANKING_TIMESCALE, 1.0);              // ???
}

//------------------------------------ Default Programm -----------------------------------------

default
{
    state_entry()
    {
     llSetStatus(STATUS_PHANTOM, FALSE);
     llSetLinkPrimitiveParams(LINK_ALL_OTHERS, [PRIM_PHANTOM,FALSE]); 
     llSetStatus(STATUS_PHYSICS, FALSE);
     llSetLinkPrimitiveParams(LINK_ALL_OTHERS, [PRIM_PHYSICS,FALSE]); 
     llSetSitText(sit_message);
     llSetText(TITLE, <0.5, 0.5, 1.0>, 1.0);
     llSitTarget(SIT_POSITION,llEuler2Rot(DEG_TO_RAD * SIT_ROTATION));
    }


   on_rez(integer rn)
    {
     llResetScript();
    }


    touch_start(integer total_number)
    {
     if ((RUN == 1) && (Menu == 0))
     {
      open_menu(AVATAR, mainMenuDialog1, mainMenuButtons); Menu = 1;
     }
    }

//----------------------------------- Changed Watcher ---------------------------------------------        
            
    changed(integer change)
    {
        if ((change & CHANGED_LINK) == CHANGED_LINK)
        {
            AVATAR = llAvatarOnSitTarget();
            if (AVATAR != NULL_KEY)
            {                
                if( (AVATAR != llGetOwner()) & (Private == 1))
                {
                    llSay(0, not_owner_message);
                    llUnSit(AVATAR);    
                }
                else
                {
                 vector posv = llGetPos(); ALTITUDE = (posv.z - 20.00) + vlo;
                 SETUP_VEHICLE(); llSleep(0.3);
                 llSetStatus(STATUS_PHANTOM, FALSE);
                 llSetLinkPrimitiveParams(LINK_ALL_OTHERS, [PRIM_PHANTOM,FALSE]); 
                 llSetStatus(STATUS_PHYSICS, TRUE);
                 llSetLinkPrimitiveParams(LINK_ALL_OTHERS, [PRIM_PHYSICS, TRUE]); 
                 llRequestPermissions(AVATAR,
                 PERMISSION_TRIGGER_ANIMATION | PERMISSION_TAKE_CONTROLS | PERMISSION_CONTROL_CAMERA);
                 
                 RUN = 1; OFFSET=0; hp = hps; vp = vps; V_Gear = 1; L2 = llLog(2);
                 VS = llLog(vp) / L2 - 1; VPC = llRound(2 * llPow(2, VS));
                 H_Gear = 1; PXY_S = HGfac * llPow(2, llLog(vps) / L2 - 2);
                 dir = 1; H_dir = 0; V_dir = 0; V_END = 0; Menu = 1; angz = angz_high; P = 1;
                 llStartAnimation(PILOT_ANIM); 
                 llSay(0, StartUpText);
                 llSetText("", <0.5, 0.5, 1.0>, 1.0);
                 llMessageLinked(LINK_SET, 0, "seated", "");
                 CAM_ZOOM  = 1.5; SETUP_CAMERA(); llSleep(3.5); CAM_ZOOM  = 9.0; SETUP_CAMERA();
                 llSetTimerEvent(0.2);
                 mainMenuDialog1 = "\nGear " + (string)V_Gear + " of 8"
                                 + "             Gear " + (string)H_Gear + " of 4";
                 open_menu(AVATAR, mainMenuDialog1, mainMenuButtons);
                
                }
            }
            else
            {
                RUN = 0; Menu = 0;
                llReleaseControls();
                llStopAnimation(PILOT_ANIM);
                llMessageLinked(LINK_SET, 0, "unseated", "");
                llSetText(TITLE, <0.5, 0.5, 1.0>, 1.0);
                llSetStatus(STATUS_PHYSICS, FALSE);
                llSetLinkPrimitiveParams(LINK_ALL_OTHERS, [PRIM_PHYSICS, FALSE]); 
                llSetVehicleType(VEHICLE_TYPE_NONE);
                llSetTimerEvent((float)FALSE); close_menu();
                llSetPos(llGetPos() - <0, 0, (vlo - vlo/2)>);
            }
        }
    }
    
//------------------------------------- Runtime declaration --------------------------------

    run_time_permissions(integer perm)
    {
     if (perm)
     {
      llTakeControls(CONTROL_FWD | CONTROL_BACK |
                     CONTROL_DOWN | CONTROL_UP |
                     CONTROL_ROT_RIGHT | CONTROL_ROT_LEFT |CONTROL_RIGHT, TRUE, FALSE);
     }
    }
    
//-------------------------------------- Menue - listening ---------------------------------

    listen(integer channel, string name, key id, string message)
    {
        if(channel != dialogChannel)
            return;
  
        if(message == "- Speed")
        {
         H_Gear -= 1; hp = 4 * llPow(2, H_Gear);
         if(hp < hps) {hp = hps; H_Gear = 1;}
         PXY_S = HGfac * llPow(2, llLog(hp) / L2 - 2);
         llWhisper(0, " Speed-Gear: " + (string)H_Gear );
         mainMenuDialog1 = "\nGear " + (string)V_Gear + " of 8"
                         + "             Gear " + (string)H_Gear + " of 4";
         open_menu(AVATAR, mainMenuDialog1, mainMenuButtons); Menu = 1;
        }
 
        else if(message == "+ Speed")
        {
         H_Gear += 1; hp = 4 * llPow(2, H_Gear);
         if(hp >= hpm) {hp = hpm; H_Gear = 4;}
         PXY_S = HGfac * llPow(2, llLog(hp) / L2 - 2);
         llWhisper(0, " Speed-Gear: " + (string)H_Gear );
         mainMenuDialog1 = "\nGear " + (string)V_Gear + " of 8"
                         + "             Gear " + (string)H_Gear + " of 4";
         open_menu(AVATAR, mainMenuDialog1, mainMenuButtons); Menu = 1;
        }
 
        else if(message == "- Climb")
        {
         vp = vp - vpr;
         if(vp < vpr) {vp = vpr;}
         V_Gear = llRound(vp / vpr); VS = llLog(vp) / L2 - 1; VPC = llRound(2 * llPow(2, VS));
         llWhisper(0, " Climb-Gear: " + (string)V_Gear);
         mainMenuDialog1 = "\nGear " + (string)V_Gear + " of 8"
                         + "             Gear " + (string)H_Gear + " of 4";
         open_menu(AVATAR, mainMenuDialog1, mainMenuButtons); Menu = 1;
        }
 
        else if (message == "+ Climb")
        {
         vp = vp + vpr;
         if(vp > vpm) {vp = vpm;}
         V_Gear = llRound(vp / vpr); VS = llLog(vp) / L2 - 1; VPC = llRound(2 * llPow(2, VS));
         llWhisper(0, " Climb-Gear: " + (string)V_Gear);
         mainMenuDialog1 = "\nGear " + (string)V_Gear + " of 8"
                         + "             Gear " + (string)H_Gear + " of 4";
         open_menu(AVATAR, mainMenuDialog1, mainMenuButtons); Menu = 1;
        }
        
        else if (message == "Close")
        {
         close_menu(); Menu = 0;
        }
    }

//---------------------------------------- Speed - metering -------------------------------------
    
timer()
{
    if(RUN == 1)
    {
     SPEED = llVecMag(llGetVel());
     string SpeedText = ((string)llRound(SPEED * 1.852) + " Km/h");
     llMessageLinked(3, 0, SpeedText, "");
     
    }
}

//----------------------------------- Object & Land Collision -----------------------------------

collision_start(integer cs)
{
    if(RUN == 1)
    {
     vector posv = llGetPos(); ALTITUDE = (posv.z - 20) + vlo;
     llSetVehicleFloatParam( VEHICLE_HOVER_HEIGHT, ALTITUDE);
     llWhisper(0, "Prim-touch !!!"); V_END = 1;
    }
}  
   
land_collision(vector pos)
{
    if(RUN == 1)
    {
     vector posv = llGetPos(); ALTITUDE = (posv.z - 20) + vlo;
     llSetVehicleFloatParam( VEHICLE_HOVER_HEIGHT, ALTITUDE);
     llWhisper(0, "Ground-touch !!!"); V_END = 1;
    }
}
  
//-------------------------------------- Keybord Control --------------------------------------------
    
    control(key id, integer level, integer edge)
    {
        if(RUN == 0) {return;}
        
//------------------ Parking Mode on/off

        if(level & CONTROL_RIGHT)
        {
         if(angz == angz_low)
         {
          angz = angz_high; hp = 4 * llPow(2, H_Gear); P = 0;
          vp = vpr * V_Gear; VS = llLog(vp) / L2 - 1; VPC = llRound(2 * llPow(2, VS));
          llWhisper(0, "Driving !");
         }
        
         if((angz == angz_high) && (P == 1)) 
         {
          angz = angz_low; hp = 4; vp = vps; VS = 0; VPC = 2;
          llWhisper(0, "Parking !");
         } 
         P = 1;           
        }
    
//------------------ move Up/Down 

        if (level & CONTROL_UP)
        {
            ALTITUDE = ALTITUDE + vp; V_dir = -1;
            //SetPartVar_V2(); SetPrimParam_VU();
            if(ALTITUDE > 4000) {ALTITUDE = 4000;}
            llSetVehicleFloatParam( VEHICLE_HOVER_HEIGHT, ALTITUDE);
        }
        
        if ((level & CONTROL_DOWN) && (V_END == 0))
        {
            ALTITUDE = ALTITUDE - vp; V_dir = 1;
            //SetPartVar_V1(); SetPrimParam_VD();
            if(ALTITUDE < vmin) {ALTITUDE = vmin;}
            llSetVehicleFloatParam( VEHICLE_HOVER_HEIGHT, ALTITUDE);
        }
        
//------------------ move Fwd/Back

        if(level & CONTROL_FWD)
        {
         //if(EN == 1) {MOVE_ENABLE_FWD();}
        
           if(ME == 1)
           {
            H_dir = 1; dir = 1;
            llSetVehicleVectorParam(VEHICLE_LINEAR_MOTOR_DIRECTION, <0, hp,0>); 
           }
        }
        
        if(level & CONTROL_BACK)
        {
         //if(EN == 1) {MOVE_ENABLE_REW();}
        
           if(ME == 1)
           {
            H_dir = -1; dir = -1;
            llSetVehicleVectorParam(VEHICLE_LINEAR_MOTOR_DIRECTION, <0,-hp,0>);
           }
        }  

//------------------ turn Right/Left

        if(level & CONTROL_ROT_RIGHT)
        {
         ANGULAR_MOTOR = <0, 0, -(angz + SPEED / (10 * hp))>; 
         OFFSET = Curveangl; HELD=1;
         llSetVehicleVectorParam(VEHICLE_ANGULAR_MOTOR_DIRECTION, ANGULAR_MOTOR);
         ANGULAR_MOTOR = <0, 0, 0>;
        }
                        
        if(level & CONTROL_ROT_LEFT)
        {
         ANGULAR_MOTOR = <0, 0, (angz + SPEED / (10 * hp))>; 
         OFFSET = -Curveangl; HELD=1; 
         llSetVehicleVectorParam(VEHICLE_ANGULAR_MOTOR_DIRECTION, ANGULAR_MOTOR);
         ANGULAR_MOTOR = <0, 0, 0>;
        }

//--------------------------------------------------------------------------------------------------

        if(HELD==0) {OFFSET=0;}
        vector rot = llRot2Euler(llGetRot());
        llSetRot(llEuler2Rot(<0, DEG_TO_RAD * OFFSET * dir, 0>)* llEuler2Rot(<0 ,0, rot.z>));
        
        if(H_dir == 0)
        {
         if(OFFSET == 0)
         {
          //SetPartVar_H0(); SetPrimParam_HLF(); SetPrimParam_HRF();
          //SetParticle_HL(); SetParticle_HR();
         }
         
         if(OFFSET < 0)
         {
          hp_old = hp; hp = hps;
          //SetPartVar_H1(); SetPrimParam_HLB(); SetPrimParam_HRF();
          //SetParticle_HL(); SetParticle_HR();
          hp = hp_old;
         }
         
         if(OFFSET > 0)
         {
          hp_old = hp; hp = hps;
          //SetPartVar_H1(); SetPrimParam_HLF(); SetPrimParam_HRB();
          //SetParticle_HL(); SetParticle_HR();
          hp = hp_old;
         }
            
        }
        
        if(H_dir == 1)
        {
         //SetPartVar_H1(); SetPrimParam_HLF(); SetPrimParam_HRF();
        // SetParticle_HL(); SetParticle_HR();
        }
        
        if(H_dir == -1)
        {
         //SetPartVar_H1(); SetPrimParam_HLB(); SetPrimParam_HRB();
        // SetParticle_HL(); SetParticle_HR();
        }
        
    if(V_dir == 0)
        {
        //SetPartVar_V1(); SetPrimParam_VU();
        }
        //SetParticle_VRL(); SetParticle_VRR(); SetParticle_VFL(); SetParticle_VFR();
        
        dir = 1; HELD = 0; V_END = 0; ME = 1; H_dir = 0; V_dir = 0;
        

    } // End Keybord Control
    
}// End Default
