//*******************************************************
// Hans Ingen²
// LSL | OPENSIM | ODE
// i-TEC + e3s + DC (ENGINE SPEED SENSITIVE STEERING WITH DYNAMIC CAMERA)
// JANUARY 28, 2013
// TODO: KEYWORD PROCESSOR FOR ** PRIM ANIMATION | AVATAR ANIMATION | SOUNDS | MENU | HUD | DYNAMIC CAMERA
//*******************************************************
//
// 
//**####################################################
//                BULLETSIM                            #
//                                                     #
// Modify  from  Cuteulala Artis and Hans Nerido       #
//                                                     #
//                                                     #
//**###################################################
//---PERMISSION VARIABLES---------------------------------------------
integer         gDrivePermit = 1; // 0=EVERYONE 1=OWNERONLY
string          gSitMessage = "BurnOut";
string          gUrNotAllowedMessage = "Step Away From The Vehicle";
vector          gSitTarget_Pos = <-0.425,0.375,0.200>;
vector          gSitTarget_Rot;
key             gOldAgent;
key             gAgent;
integer         gRun;     //ENGINE RUNNING
integer         gMoving;  //VEHICLE MOVING
float         gTick=.1;
string      gDrivingAnim = "Driver sit";
//---SOUND VARIABLES---------------------------------------------------
string       gSoundHorn =            "s_horn";
string       gSoundStartup =         "s_startup";
string       gSoundIdle =            "s_idle";
string       gSoundSlow =            "s_slow";
string       gSoundAggressive =      "s_fast";
string       gSoundGearUp =          "s_gearup";
string       gSoundGearDown =        "s_geardown";
string       gSoundRev =             "s_rev";
string       gSoundAlarm =           "s_alarm";
string       gSoundStop =            "s_rev";
//NEED KEYWORD SOUND PROCESSOR
integer      gOldSound=3;   //variable for sound function
integer      gNewSound=3;
//---Z-TEC POWERTRAIN + (e3s) GLOBAL VARIABLES -----------------
integer      gGear;
integer      gNewGear;
float        gGearPower;
float        gReversePower            =    -15;
list         gGearPowerList           = [     2,    //  STAGER
                                             7,    //  BURNOUT
                                             10,    //  1ST
                                             20,    //  2ND
                                             30,    //  3RD
                                             40,    //  4TH
                                             50,    //  5TH
                                             60,    //  6TH
                                             70,    //  PRO-STOCK (START-DRAG-CLASS)
                                             80,    //  PRO-MOD
                                             90,    //  TOP-FUEL
                                             100     //  OPEN-PRO
                                         ];
//integer     gGearCount;
float       gTurnRatio;
list        gTurnRatioList            = [   1.00,    //  STAGER
                                            1.00,    //  BURNOUT
                                            1.50,    //  1ST
                                            1.55,    //  2ND
                                            1.60,    //  3RD
                                            1.65,    //  4TH
                                            1.70,    //  5TH
                                            1.75,    //  6TH
                                            1.80,    //  PRO-STOCK (START-DRAG-CLASS)
                                            1.85,    //  PRO-MOD
                                            1.90,    //  TOP-FUEL
                                            1.95    //  OPEN-PRO
                                         ];
string     gGearName;
list       gGearNameList                 =[    "STAGER",
                                               "BURNOUT",
                                               "1ST-GEAR",
                                               "2ND-GEAR",
                                               "3RD-GEAR",
                                               "4TH-GEAR",
                                               "5TH-GEAR",
                                               "6TH-GEAR",
                                               "7TH-GEAR",
                                               "8TH-GEAR",
                                               "9TH-GEAR",
                                               "10TH-GEAR"
                                         ];
float         gSpeed=0;
//NEED A KEYWORD PRIM ANIMATION PROCESSOR
integer            gTurnCount;
string             gTurnAngle =               "NoTurn";  // LeftTurn or RightTurn or NoTurn
string             gNewTurnAngle =            "NoTurn";
string             gTireSpin =                "ForwardSpin";   // ForwardSpin or BackwardSpin or NoSpin
string             gNewTireSpin =             "ForwardSpin";
integer            gTcountL;
integer            gTcountR;
//
preload_sounds(){
    llPreloadSound(gSoundHorn);
    llPreloadSound(gSoundStartup);
    llPreloadSound(gSoundIdle);
    llPreloadSound(gSoundSlow);
    llPreloadSound(gSoundAggressive);
    llPreloadSound(gSoundGearUp);
    llPreloadSound(gSoundGearDown);
    llPreloadSound(gSoundRev);
    llPreloadSound(gSoundAlarm);
}
init_engine(){
    gRun = 0;
    llSetSitText(gSitMessage);
    llCollisionSound("", 0.0);
    gSitTarget_Rot = llRot2Euler( llGetRootRotation() );
    llSitTarget(gSitTarget_Pos, llEuler2Rot(DEG_TO_RAD * gSitTarget_Rot));
    gOldSound=3; 
    gNewSound=3;
    gTireSpin = "NoSpin";
    gTurnAngle = "NoTurn";
    llMessageLinked(LINK_ALL_OTHERS, 0, gTireSpin, NULL_KEY);
    llMessageLinked(LINK_ALL_OTHERS, 0, gTurnAngle, NULL_KEY);
}
init_camera(){
    llSetCameraParams([
                       CAMERA_ACTIVE, 1,                 // 0=INACTIVE  1=ACTIVE
                       CAMERA_BEHINDNESS_ANGLE, 10.0,     // (0 to 180) DEGREES
                       CAMERA_BEHINDNESS_LAG, 0.0,       // (0 to 3) SECONDS
                       CAMERA_DISTANCE, 6.0,             // ( 0.5 to 10) METERS
                       CAMERA_PITCH, 20.0,               // (-45 to 80) DEGREES
                       CAMERA_POSITION_LOCKED, FALSE,    // (TRUE or FALSE)
                       CAMERA_POSITION_LAG, 0.0,         // (0 to 3) SECONDS
                       CAMERA_POSITION_THRESHOLD, 0.5,   // (0 to 4) METERS
                       CAMERA_FOCUS_LOCKED, FALSE,       // (TRUE or FALSE)
                       CAMERA_FOCUS_LAG, 0.0 ,           // (0 to 3) SECONDS
                       CAMERA_FOCUS_THRESHOLD, 0.5,      // (0 to 4) METERS
                       CAMERA_FOCUS_OFFSET, <0.10,0,0>   // <-10,-10,-10> to <10,10,10> METERS
                      ]);
}
set_engine(){
    integer vfW = VEHICLE_FLAG_HOVER_WATER_ONLY | VEHICLE_FLAG_HOVER_TERRAIN_ONLY | VEHICLE_FLAG_HOVER_GLOBAL_HEIGHT;
    integer vfG = VEHICLE_FLAG_NO_DEFLECTION_UP | VEHICLE_FLAG_LIMIT_ROLL_ONLY | VEHICLE_FLAG_HOVER_UP_ONLY |
        VEHICLE_FLAG_LIMIT_MOTOR_UP;
    integer vfA = VEHICLE_FLAG_HOVER_GLOBAL_HEIGHT;
    llSetVehicleType(VEHICLE_TYPE_CAR);
    llSetVehicleRotationParam(VEHICLE_REFERENCE_FRAME, <0.00000, 0.00000, 0.00000, 0.00000>);
    llSetVehicleFloatParam(VEHICLE_ANGULAR_MOTOR_TIMESCALE, 0.10);
    llSetVehicleFloatParam(VEHICLE_ANGULAR_MOTOR_DECAY_TIMESCALE, 0.10);
    llSetVehicleFloatParam(VEHICLE_ANGULAR_DEFLECTION_EFFICIENCY, 0.20);
    llSetVehicleFloatParam(VEHICLE_ANGULAR_DEFLECTION_TIMESCALE, 0.10);
    llSetVehicleFloatParam(VEHICLE_VERTICAL_ATTRACTION_EFFICIENCY, 0.50);
    llSetVehicleFloatParam(VEHICLE_VERTICAL_ATTRACTION_TIMESCALE, 2.0); // 5.0
    llSetVehicleFloatParam(VEHICLE_LINEAR_DEFLECTION_EFFICIENCY, 0.80);
    llSetVehicleFloatParam(VEHICLE_LINEAR_DEFLECTION_TIMESCALE, 0.10);
    llSetVehicleFloatParam(VEHICLE_LINEAR_MOTOR_TIMESCALE, 0.6); // 3.0
    llSetVehicleFloatParam(VEHICLE_LINEAR_MOTOR_DECAY_TIMESCALE, 0.10);
    llSetVehicleFloatParam(VEHICLE_HOVER_EFFICIENCY, 0.0 );
    llSetVehicleFloatParam(VEHICLE_HOVER_TIMESCALE, 0.0 );
    llSetVehicleFloatParam(VEHICLE_HOVER_HEIGHT, 0.0 );
    llSetVehicleFloatParam(VEHICLE_BUOYANCY, 0.0 );
    llSetVehicleVectorParam(VEHICLE_LINEAR_FRICTION_TIMESCALE, <5.0, 0.5, 1000.0> );
    llSetVehicleVectorParam(VEHICLE_ANGULAR_FRICTION_TIMESCALE, <0.10, 0.10, 0.20> );
     llRemoveVehicleFlags(vfW);
     llRemoveVehicleFlags(vfA);
     llSetVehicleFlags(vfG);
}
powershift(integer g){
    if(!gMoving){
        llSetCameraParams([CAMERA_BEHINDNESS_ANGLE,0.0]);
        llSetCameraParams([CAMERA_DISTANCE,0.0]);
    }
    else {
    vector vel = llGetVel();
    float speed = llVecMag(vel);
    if (speed <=20){
        llSetCameraParams([CAMERA_BEHINDNESS_ANGLE,2.5]);
        llSetCameraParams([CAMERA_DISTANCE,9.0]);
        }
        else if ((speed >=21) || (speed <=50)){
        llSetCameraParams([CAMERA_BEHINDNESS_ANGLE,1.5]);
        llSetCameraParams([CAMERA_DISTANCE,9.0]);
        }
        else  if (speed >=51) {
        llSetCameraParams([CAMERA_BEHINDNESS_ANGLE,0.0]);
        llSetCameraParams([CAMERA_DISTANCE,0.0]);
        }
    }
    gGearPower = llList2Integer(gGearPowerList, g);
}
gearshift(integer g){
    gGearName = llList2String(gGearNameList, g);
    enginesound();
    llSay(0,gGearName);
}
nearestpi(){
    vector Rad = llRot2Euler( llGetRootRotation() );
    llSetRot( llEuler2Rot( <Rad.x, Rad.y, llRound( Rad.z / PI_BY_TWO ) * PI_BY_TWO > ) );
}

showdata(string s){
    llSetText(s+"\n.\n.\n.\n.",<1,1,.6>,1.0);
}

enginesound(){
    vector vel = llGetVel();
    float speed = llVecMag(vel);
    if (speed <=20){
        gNewSound = 0;
        }
        else if (speed >=50){
            gNewSound = 2;
        }
        else {
            gNewSound = 1;
        }
        
    if (gOldSound != gNewSound){
        if (speed <=20){
            llLoopSound(gSoundIdle,1.0);
            }
            else if (speed >=50){
                llLoopSound(gSoundAggressive,1.0);
            }
            else {
                llLoopSound(gSoundSlow,1.0);
            }    
    gOldSound = gNewSound;
    }
}
cornerFXR(){
    vector vel = llGetVel();
    float speed = llVecMag(vel);
    if (speed >50){
    llMessageLinked(LINK_SET, 0, "letsburnR", NULL_KEY);
        }
}
cornerFXL(){
    vector vel = llGetVel();
    float speed = llVecMag(vel);
    if (speed >50){
    llMessageLinked(LINK_SET, 0, "letsburnL", NULL_KEY);
        }
}
default {
    state_entry()
    {
        init_engine();
        state Ground;
    }
}
state Ground{

    state_entry(){
    }
    on_rez(integer param) {
        llResetScript();
        preload_sounds();
    }
    changed(integer change){
        if ((change & CHANGED_LINK) == CHANGED_LINK){
            gAgent = llAvatarOnSitTarget();
            if (gAgent != NULL_KEY){
                if( (gAgent != llGetOwner()) && (gDrivePermit == 1)){
                    llSay(0, gUrNotAllowedMessage);
                    llUnSit(gAgent);
                    llPlaySound(gSoundAlarm,1.0);
                    llPushObject(gAgent, <0,0,20>, ZERO_VECTOR, FALSE);
                }
                else {
                    llSetStatus(STATUS_PHYSICS, TRUE);
                    gOldAgent = gAgent;
                    set_engine();
                    llRequestPermissions(gAgent, PERMISSION_TRIGGER_ANIMATION | PERMISSION_TAKE_CONTROLS | PERMISSION_CONTROL_CAMERA);
                    gRun = 1;
                }
            }
            else {
                llSetStatus(STATUS_PHYSICS, FALSE);
                gRun = 0;
                init_engine();
                llTriggerSound(gSoundStop,1);
                llStopAnimation(gDrivingAnim);
                llSetTimerEvent(0.0);
                llStopSound();
                llSetText("",<0,0,0>,1.0);
                llReleaseControls();
                llClearCameraParams();
                llMessageLinked(LINK_SET, 0, "speed off", NULL_KEY);
            }
        }
    }
    run_time_permissions(integer perm){
        if (perm) {
            gGear = 2; // GEAR#0 IS STAGER | GEAR#1 IS BURNOUT | GEAR#2 IS THE FIRST GEAR (LIST INDEX STARTS @ 0)
            //gNewGear = 2;  
            llTakeControls(CONTROL_FWD | CONTROL_BACK | CONTROL_DOWN | CONTROL_UP | CONTROL_RIGHT | CONTROL_LEFT | CONTROL_ROT_RIGHT | CONTROL_ROT_LEFT, TRUE, FALSE);
            init_camera();
            llMessageLinked(LINK_SET, 0, "pipeflame", NULL_KEY);
            llMessageLinked(LINK_SET, 0, "headlight", "0");
            llMessageLinked(LINK_SET, 0, "speed on", NULL_KEY);
            llStartAnimation(gDrivingAnim);
            llTriggerSound(gSoundStartup,1.0);
            llSleep(1.5);
            enginesound();
        }
    }
    control(key id, integer held, integer change){
        if(gRun == 0){
            return;
        }
        integer reverse=1;
        vector vel = llGetVel();
        vector speedvec = llGetVel() / llGetRot();
        vector adjustedvec=<speedvec.x,0,speedvec.z>;
         llSetVelocity(adjustedvec,TRUE );
        gSpeed = llVecMag(vel);
        gTurnRatio = llList2Float(gTurnRatioList,gGear);
        if ((held & change & CONTROL_UP) || ((gGear >= 11) && (held & CONTROL_UP))){
            gGear=gGear+1;
            if (gGear < 0) gGear = 0;
            if (gGear > 11) gGear = 11;
            gearshift(gGear);
        }
        if ((held & change & CONTROL_DOWN) || ((gGear >= 11) && (held & CONTROL_DOWN))){
            gGear=gGear-1;
            if (gGear < 0) gGear = 0;
            if (gGear > 11) gGear = 11;
            gearshift(gGear);
        }
        if (held & CONTROL_FWD){
            if(gGear == 0) {
                llSetVehicleVectorParam(VEHICLE_LINEAR_FRICTION_TIMESCALE, <1.0, 2.0, 1000.0>);
            }else{
                    llSetVehicleVectorParam(VEHICLE_LINEAR_FRICTION_TIMESCALE, <7.0, 3000.0, 1000.0>);
            }
            if(gGear == 1)  {
                llMessageLinked(LINK_SET, 0, "letsburn", NULL_KEY);
                llMessageLinked(LINK_SET, 0, "letsscreech", NULL_KEY);
                llMessageLinked(LINK_SET, 0, "pipeflame", NULL_KEY);
            }
            if(gGear == 2)  {
            }
            if(gGear == 3)  {
            }
            if(gGear == 4)  {
            }
            if(gGear == 5)  {
    llSetVehicleFloatParam(VEHICLE_LINEAR_MOTOR_TIMESCALE, 0.8);
            }
            if(gGear == 6)  {
    llSetVehicleFloatParam(VEHICLE_LINEAR_MOTOR_TIMESCALE, 2.5);
                llMessageLinked(LINK_SET, 0, "pipeflame", NULL_KEY);
            }
            if(gGear == 7)  {
    llSetVehicleFloatParam(VEHICLE_LINEAR_MOTOR_TIMESCALE, 5.5);
            }
            if(gGear == 8)  {
    llSetVehicleFloatParam(VEHICLE_LINEAR_MOTOR_TIMESCALE, 5.5);
            }
            if(gGear == 9)  {
    llSetVehicleFloatParam(VEHICLE_LINEAR_MOTOR_TIMESCALE, 9.5);
            }
            if(gGear == 10) {
    llSetVehicleFloatParam(VEHICLE_LINEAR_MOTOR_TIMESCALE, 11.0);
            }
            if(gGear == 11) {
    llSetVehicleFloatParam(VEHICLE_LINEAR_MOTOR_TIMESCALE, 11.5);
            }
            powershift(gGear);
            llSetVehicleVectorParam(VEHICLE_LINEAR_MOTOR_DIRECTION, <gGearPower,0,0>);
            gMoving=1;
            reverse=1;
            gNewTireSpin = "ForwardSpin";
        }
        if (held & CONTROL_BACK){
            llSetVehicleVectorParam(VEHICLE_LINEAR_MOTOR_DIRECTION, <gReversePower,0,0>);
            llSetCameraParams([CAMERA_BEHINDNESS_ANGLE,-45.0]);
            llSetCameraParams([CAMERA_DISTANCE,8.0]);
            gTurnRatio = -2.0;
            reverse = -1;
            gNewTireSpin = "BackwardSpin";
        }
         if (~held & change & CONTROL_FWD){            
            gNewTireSpin = "NoSpin";
            gNewTurnAngle = "NoTurn";
            if (gGear > 9){
                gGear = 3;
            }
                }
         if (~held & change & CONTROL_BACK){            
            gNewTireSpin = "NoSpin";
            gNewTurnAngle = "NoTurn";
        }
         if (~held & ~change & CONTROL_FWD){            
        }
         if (~held & ~change & CONTROL_BACK){             
        }
       enginesound();
         vector AngularMotor;
        if (held & (CONTROL_RIGHT|CONTROL_ROT_RIGHT)){
            if (gGear==0){
            AngularMotor.z -= gSpeed / (gTurnRatio*1);
            }else{
            AngularMotor.z -= gSpeed / (gTurnRatio*gGear);
            }
            gNewTurnAngle = "RightTurn";
            gTurnCount = 6;
            gTcountR = 2;
        }
        if (held & (CONTROL_LEFT|CONTROL_ROT_LEFT)){
            if (gGear==0){
            AngularMotor.z += gSpeed / (gTurnRatio*1);
            }else{
            AngularMotor.z += gSpeed / (gTurnRatio*gGear);
            }
            gNewTurnAngle = "LeftTurn";
            gTurnCount = 6;
            gTcountL = 2;
         }
        llSetVehicleVectorParam(VEHICLE_ANGULAR_MOTOR_DIRECTION, AngularMotor);
            if(gTcountL > 0){
                gTcountL--;
            }
            if(gTcountL == 1){
                cornerFXL();
            }
            if(gTcountR > 0){
                gTcountR--;
            }
            if(gTcountR == 1){
                cornerFXR();
            }
        if(gTurnCount > 0){
            gTurnCount--;
        }
        if(gTurnCount == 1){
            gNewTurnAngle = "NoTurn";
        }
        if(gTurnAngle != gNewTurnAngle){
            gTurnAngle = gNewTurnAngle;
            llMessageLinked(LINK_ALL_OTHERS, 0, gTurnAngle, NULL_KEY);
        }
        if(gTireSpin != gNewTireSpin){
            gTireSpin = gNewTireSpin;
            llMessageLinked(LINK_ALL_OTHERS, 0, gTireSpin, NULL_KEY);
        }}}