// This script is a work-around for the current SL bug (still applicable as of SL ver. 1.8.4) which causes certain objects that use the llSetTextureAnim() command to lose the texture scale settings during relogging or when rezzed

list texture_params; //list used to store texture scaling for each face

Get_Texture_Params() //function to read texture scale settings and store them
{
    texture_params = []; // clear list of previous settings
    integer i;
    for (i = 0; i < llGetNumberOfSides(); i++) // repeat for each face of the prim
    {
        vector scale = llGetTextureScale(i); // get texture scaling for current face
        texture_params += [scale.x,scale.y]; // add them to the list
    }
}

Set_Texture_Params()
{
    integer i;
    llScaleTexture(1,1,ALL_SIDES); // llScaleTexture only seems to function correctly per face after it's been used with the ALL_SIDES constant
    for (i = 0; i < llGetNumberOfSides(); i++) //repeat for each face of the prim
    {
        llScaleTexture(llList2Float(texture_params, (i * 2)), llList2Float(texture_params, (i * 2) + 1), i); //set texture scaling for current face
    }
}

default
{
    on_rez(integer start_param)
    {
        if (llGetLinkNumber() == 1) // if prim is root of a linked object
            llMessageLinked(LINK_SET, 0, "", ""); // send link message to all prims in object
    }
    
    state_entry()
    {
        Get_Texture_Params(); // retrieve current texture scaling settings for prim
        llSetTimerEvent(9999999); // set timer event to trigger occasionally to make prim 'active' so it retains texture scaling settings 
    }
    
    link_message(integer sender, integer num, string str, key id)
    {
        Set_Texture_Params(); // set texture scaling for prim faces if a link message is received (triggered on_rez)
    }        
    
    changed(integer change)
    {
        if (change & CHANGED_TEXTURE) // if texture settings have changed
            Get_Texture_Params(); // retrieve current texture scaling settings for prim 
    }
    
    timer(){} // empty timer event used to keep prim 'active' so it retains texture scaling settings 
}
