default {
    state_entry()
    {
        // Don't break stuff if we're in root.
        if (llGetLinkNumber() < 2)
        {
            llSay(0, "This child phantom script will have no effect until you put it in a child prim.");
            return;
        }
            
        llSetPrimitiveParams([PRIM_TYPE, PRIM_TYPE_BOX,
            0, <0,1,0>, 0, <0,0,0>, <1,1,0>, <0,0,0>,
            PRIM_FLEXIBLE, TRUE, 0, 0, 0, 0, 0, <0,0,0>,
            PRIM_TYPE] + llGetPrimitiveParams([PRIM_TYPE]));
    }
 
    on_rez(integer s)
    {
        llResetScript();
    }
 
    changed(integer changes)
    {
        // Don't break stuff if we're in root.
        if (llGetLinkNumber() < 2)
        {
            return;
        }
        
        // Ignore changes other than server reboot, linking/unlinking
        if (changes & (CHANGED_LINK + 0x400))
        {
            llSetPrimitiveParams([PRIM_TYPE, PRIM_TYPE_BOX,
                0, <0,1,0>, 0, <0,0,0>, <1,1,0>, <0,0,0>,
                PRIM_FLEXIBLE, TRUE, 0, 0, 0, 0, 0, <0,0,0>,
                PRIM_TYPE] + llGetPrimitiveParams([PRIM_TYPE]));
        }
    }
    
    // A catch-all trick; collision is only possible if the child phantom flag was lost.
    collision_start(integer num_detected)
    {
        llResetScript();
    }
}


 