// Sim FPS Graph Meter v0.1

float maxFPS = 55;
float simFPS;
float percentCurrFPS;
float red;
float green;
vector iniPos;
vector newPos;

ParticleGraph()
{
    llSetText ("FPS", <red, green, 0>, 1.0);
    
    llParticleSystem([
        PSYS_PART_FLAGS, PSYS_PART_EMISSIVE_MASK,
        PSYS_SRC_PATTERN, PSYS_SRC_PATTERN_ANGLE,
        PSYS_PART_START_ALPHA, 1,
        PSYS_PART_END_ALPHA, 1,
        PSYS_PART_START_COLOR, <red, green, 0>,
        // PSYS_PART_END_COLOR, <0,0,0> ,
        PSYS_PART_START_SCALE, <0.05, 0.25, 0>,
        // PSYS_PART_END_SCALE, <0.05, 0.5, 0>,
        PSYS_PART_MAX_AGE, 30,
        PSYS_SRC_MAX_AGE, 0,
        PSYS_SRC_ACCEL, <0,0,0>,
        PSYS_SRC_BURST_PART_COUNT, 1,
        PSYS_SRC_BURST_RADIUS, 0,
        PSYS_SRC_BURST_RATE, 0.05,
        PSYS_SRC_BURST_SPEED_MIN, 0.2,
        PSYS_SRC_BURST_SPEED_MAX, 0.2,
        PSYS_SRC_ANGLE_BEGIN, 0,
        PSYS_SRC_ANGLE_END, 0,
        PSYS_SRC_OMEGA, <0,0,0>,
        PSYS_SRC_TEXTURE, "",
        PSYS_SRC_TARGET_KEY, ""
    ]);
}

default
{
    state_entry ()
    {
        iniPos = llGetPos();
        llSetTimerEvent(0.5);   
    }

    timer ()
    {
        simFPS = llGetRegionFPS();
        if (simFPS > maxFPS) simFPS = maxFPS;
        simFPS = maxFPS - simFPS;
        percentCurrFPS = 100 / maxFPS * simFPS;

        if (percentCurrFPS < 50) red = percentCurrFPS / 10;
        else red = 1.0;   
        if (percentCurrFPS < 50) green = 1.0;
        else green = percentCurrFPS / 50;
      
        newPos = iniPos + <0, 0, percentCurrFPS / 50>;

        llSetPos(newPos);
        
        llSetLinkPrimitiveParams(0, [
            // PRIM_SIZE, <size, 0.1, 0.2>,
            PRIM_COLOR, ALL_SIDES, <red, green, 0>, 1.0
            // , PRIM_POSITION, newPos     
        ]);
        ParticleGraph();           
    }
}