default
{
    state_entry()
    {
        llLinkParticleSystem(2, [
            PSYS_PART_FLAGS,
                PSYS_PART_INTERP_COLOR_MASK |
                PSYS_PART_INTERP_SCALE_MASK |
                PSYS_PART_FOLLOW_SRC_MASK |
                PSYS_PART_FOLLOW_VELOCITY_MASK |
                PSYS_PART_EMISSIVE_MASK,
            PSYS_PART_MAX_AGE, 0.25,
            PSYS_PART_START_COLOR, <1.0,0.0,0.0>,
            PSYS_PART_END_COLOR, <1.0,0.0,0.0>,
            PSYS_PART_START_SCALE, <0.04,0.25,0.0>,
            PSYS_PART_END_SCALE, <0.04,0.25,0.0>,
            PSYS_SRC_PATTERN, PSYS_SRC_PATTERN_EXPLODE,
            PSYS_SRC_BURST_RATE, 0.01,
            PSYS_SRC_ACCEL, <0.0,0.0,0.0>,
            PSYS_SRC_BURST_PART_COUNT, 10,
            PSYS_SRC_BURST_RADIUS, 0.01,
            PSYS_SRC_BURST_SPEED_MIN, 0.0,
            PSYS_SRC_BURST_SPEED_MAX, 2.0,
            PSYS_SRC_ANGLE_BEGIN, 0.0,
            PSYS_SRC_ANGLE_END, PI,
            PSYS_SRC_OMEGA, <0.0,0.0,0.0>,
            PSYS_SRC_MAX_AGE, 0.0,
            PSYS_SRC_TEXTURE, "",
            PSYS_PART_START_ALPHA, 0.7,
            PSYS_PART_END_ALPHA, 0.0
        ]);
        llSetTimerEvent(0.05);
    }
    
    timer()
    {
        vector position = llGetPos();
        vector direction = llRot2Fwd(llGetRot());
        vector rayStart = position + direction * 0.01; // avoid hitting ray prim end
        vector rayEnd = position + direction * 32.0;
        list cast = llCastRay(rayStart, rayEnd, [RC_MAX_HITS, 1]);
        if ( llList2Integer(cast, -1) < 1 )
            return; // discard zero hits and status codes
        float distance = llVecDist(position, llList2Vector(cast, 1));
        if ( distance > 32.0 )
            distance = 32.0;
        llSetLinkPrimitiveParamsFast(2, [PRIM_SIZE, <0.0,0.0,distance * 2.0>, PRIM_POSITION, <distance,0.0,0.0>]);
    }
} 