string TITLE="Sit here";   
vector offset=<0,0,-0.15>;
vector rot = <0,0,270>;     
string ANIMATION;
integer visible = TRUE;
key avatar;
vector COLOR = <1.0,1.0,1.0>;
float ALPHA_ON = 1.0;
float ALPHA_OFF = 1.0;
 
show(){
    visible = TRUE;
    llSetAlpha(ALPHA_ON, ALL_SIDES);
}
 
hide(){
    visible = FALSE;
    llSetAlpha(ALPHA_OFF, ALL_SIDES);
}
 
default{
    state_entry() {
        
        llSitTarget(offset, llEuler2Rot(rot*DEG_TO_RAD));
        if((ANIMATION = llGetInventoryName(INVENTORY_ANIMATION,0)) == ""){
            llOwnerSay("Error: No animation");
            ANIMATION = "sit";
            }
           llSetSitText(TITLE);
           show();
    }
 
    touch_start(integer detected) {
        if(visible){ hide(); }
        else       { show(); }
    }
 
    changed(integer change) {
        if(change & CHANGED_LINK) {
            avatar = llAvatarOnSitTarget();
            if(avatar != NULL_KEY){
                hide();
                llRequestPermissions(avatar,PERMISSION_TRIGGER_ANIMATION);
                return;
            }else{
                if (llGetPermissionsKey() != NULL_KEY){ llStopAnimation(ANIMATION); }
                show();
                return;
            }
        }
        if(change & CHANGED_INVENTORY) { llResetScript(); }
        if(change & CHANGED_OWNER)     { llResetScript(); }
    }
 
    run_time_permissions(integer perm) {
        if(perm & PERMISSION_TRIGGER_ANIMATION) {
            llStopAnimation("sit");
            llStartAnimation(ANIMATION);
            hide();
        }
    }
}