// Very simple vehicle script, mod for OpenSim & ODE & VEHICLE code

integer Private = 1;    // Change to 1 to prevent others riding.

vector Sitpos = <-0.15,0,.9>;
vector SitrotV = <0,-20,0>;
rotation Sitrot;
integer tt;
key oldagent;
key agent;
float forward_power = 8; //Power used to go forward (1 to 30)
float reverse_power = -2; //Power ued to go reverse (-1 to -30)
float turning_ratio = 0.3; //How sharply the vehicle turns. Less is more sharply. (.1 to 10)
integer turncount;
string Wheeldir = "WC";
string NewWheeldir = "WC";
string Wheelrot = "S";
string NewWheelrot = "S";
integer scount;
float Speed;
integer Gear = 1;
integer Run;
integer oldn;
string sit_message = "Ride"; //Sit message
string not_owner_message = "You are not the owner of this vehicle, but you can copy it and have your own to test in this sim. It will not work in other Open Sim Regions."; //Not owner message
vector COLOR = <1.0,1.0,1.0>;
float ALPHA_ON = 0.25;
float ALPHA_OFF = 0.0;
integer visible = TRUE;
string TITLE="Drive!";   
string GearChangeSound = "gear change";

setCamera(float degrees) {
rotation sitRot = llAxisAngle2Rot(<0, 0, 1>, degrees * DEG_TO_RAD);
llSetCameraEyeOffset(<-4, 0, 3> * sitRot);
llSetCameraAtOffset(<4, 0, 3> * sitRot);
//llForceMouselook(TRUE);
}

setVehicle()
{
    //car
        llSetVehicleType(VEHICLE_TYPE_CAR);
        llSetVehicleFloatParam(VEHICLE_ANGULAR_DEFLECTION_EFFICIENCY, 0.2);
        llSetVehicleFloatParam(VEHICLE_LINEAR_DEFLECTION_EFFICIENCY, 0.80);
        llSetVehicleFloatParam(VEHICLE_ANGULAR_DEFLECTION_TIMESCALE, 0.10);
        llSetVehicleFloatParam(VEHICLE_LINEAR_DEFLECTION_TIMESCALE, 0.10);
        llSetVehicleFloatParam(VEHICLE_LINEAR_MOTOR_TIMESCALE, 3.0);
        llSetVehicleFloatParam(VEHICLE_LINEAR_MOTOR_DECAY_TIMESCALE, 0.1);
        llSetVehicleFloatParam(VEHICLE_ANGULAR_MOTOR_TIMESCALE, 0.1);
        llSetVehicleFloatParam(VEHICLE_ANGULAR_MOTOR_DECAY_TIMESCALE, 0.1);
        llSetVehicleVectorParam(VEHICLE_LINEAR_FRICTION_TIMESCALE, <10.0, 2.0, 1000.0>);
        llSetVehicleVectorParam(VEHICLE_ANGULAR_FRICTION_TIMESCALE, <0.1, 0.1, 0.1>);
        llSetVehicleFloatParam(VEHICLE_VERTICAL_ATTRACTION_EFFICIENCY, 0.1);
        llSetVehicleFloatParam(VEHICLE_VERTICAL_ATTRACTION_TIMESCALE, 5.0);
    
}
Init()
{
    Sound(0);
    llSetStatus(STATUS_PHYSICS, FALSE);
    vector here = llGetPos();
//    float h = llGround(<0,0,0>) + 0.52;
    vector rotv = llRot2Euler(llGetRot());
    rotation rot = llEuler2Rot(<0,0,rotv.z>);
  //  llSetPos(<here.x, here.y,h>);
    llSetRot(rot);
    Sitrot = llEuler2Rot(DEG_TO_RAD * SitrotV);
    llSetVehicleType(VEHICLE_TYPE_NONE);
    llMessageLinked(LINK_ALL_OTHERS, 0, "S", NULL_KEY);     // wheels stop
    llMessageLinked(LINK_ALL_OTHERS, 0, "WC", NULL_KEY);     // wheels straight
    Run = 0;
}

SetMaterial()
{
    llSetPrimitiveParams([PRIM_MATERIAL, PRIM_MATERIAL_GLASS]);
    llMessageLinked(LINK_ALL_OTHERS, 0, "SetMat", NULL_KEY);    // Tell daughter pims on ground to be glass
}

Sound(integer n)
{
    if(n != oldn)
    {
        oldn = n;
        if(n == 2)
        {
            llStopSound();
            llLoopSound("run",1);
        }
        else if(n == 1)
        {
            llStopSound();
            llLoopSound("idle",1);
        }
        else
        {
             llStopSound();
        }
    }
}

show(){
visible = TRUE;
llSetText(TITLE, COLOR,ALPHA_ON);        
llSetAlpha(ALPHA_ON, ALL_SIDES);
}
 
hide(){
    visible = FALSE;
    llSetText("", COLOR,ALPHA_ON);        
    llSetAlpha(ALPHA_OFF, ALL_SIDES);
}    

default
{
    state_entry()
    {
        Init();
        llSetSitText(sit_message);
        // forward-back,left-right,updown
        llSitTarget(Sitpos, Sitrot);
        llStopSound();
        setCamera(0);
    }
    
    on_rez(integer rn)
    {
        llResetScript();
    }
    
    changed(integer change)
    {
        if ((change & CHANGED_LINK) == CHANGED_LINK)
        {
            agent = llAvatarOnSitTarget();
            if (agent != NULL_KEY)
            {                
                if( (agent != llGetOwner()) && (Private == 1) )
                {
                    show();
                    llSay(0, not_owner_message);
                    llUnSit(agent);
// not functional   llPushObject(agent, <0,0,50>, ZERO_VECTOR, FALSE);
                }
                else
                {
                    oldagent = agent;
                    setVehicle();
                    SetMaterial();
                    llSleep(.4);
                    llSetStatus(STATUS_PHYSICS, TRUE);
                    llSleep(.1);
                    Run = 1;
                    llSetTimerEvent(0.3);
                    llRequestPermissions(agent, PERMISSION_TRIGGER_ANIMATION | PERMISSION_TAKE_CONTROLS);
                    Sound(1);
                    hide();
                }
            }
            else
            {
                Init();
                llSleep(.4);
                show();
                llReleaseControls();
                llMessageLinked(LINK_ALL_OTHERS, 0, "S", NULL_KEY);
                Run = 0;
                llStopSound();
            }
        }
    }
    
    run_time_permissions(integer perm)
    {
        if (perm)
        {
            llTakeControls(CONTROL_FWD | CONTROL_BACK | CONTROL_DOWN | CONTROL_UP | CONTROL_RIGHT | 
                            CONTROL_LEFT | CONTROL_ROT_RIGHT | CONTROL_ROT_LEFT, TRUE, FALSE);
   //   llSetCameraEyeOffset(<-8.0,0.0,-8.0>);
   llWhisper(0,"Hit M for mouselook, page up and down for shifting, if you flip standing will flip car back on its wheels.");
        }
    }
    
    control(key id, integer level, integer edge)
    {
        integer reverse=1;
        vector angular_motor;
        
        //get current speed
        vector vel = llGetVel();
        Speed = llVecMag(vel);
//llOwnerSay((string)Speed);
        //car controls
        
        if ((level & edge & CONTROL_UP) || ((Gear >= 6) && (level & CONTROL_UP)))
        {
            Gear=Gear+1;
            llSay(0,Gear +"Gear");
            llTriggerSound(GearChangeSound, 1.0);
            if(Gear == 1) llMessageLinked(LINK_SET, 0, "letsburn", NULL_KEY);
            if(Gear == 1) llMessageLinked(LINK_SET, 0, "screech", NULL_KEY);
            if (Gear >=6)
            {
                Gear = 6;
         //       llApplyImpulse(<150*llGetMass(),0,0>*llGetRot(),FALSE);
            }
            if (Gear < 1)
            {
                Gear = 1;
            }
        }
        if ((level & edge & CONTROL_DOWN) || ((Gear >= 6) && (level & CONTROL_DOWN)))
        {
            Gear=Gear-1;
            llSay(0,Gear +"Gear");
            llTriggerSound(GearChangeSound, 1.0);
            if (Gear < 1)
            {
                Gear = 1;
            }   
        }
        
        if(level & CONTROL_FWD)
        {
            llSetVehicleVectorParam(VEHICLE_LINEAR_FRICTION_TIMESCALE, <10.0, 2.0, 1000.0>);
            llSetVehicleVectorParam(VEHICLE_LINEAR_MOTOR_DIRECTION, <Gear*forward_power,0,0>);
            llLoopSound("gear"+Gear,1);
            reverse=1;
            NewWheelrot = "F";
        }
        if(level & CONTROL_BACK)
        {
            llSetVehicleVectorParam(VEHICLE_LINEAR_FRICTION_TIMESCALE, <10.0, 2.0, 1000.0>);
            llSetVehicleVectorParam(VEHICLE_LINEAR_MOTOR_DIRECTION, <Gear*reverse_power,0,0>);
            reverse = -1;
            NewWheelrot = "R";
        }

        if(level & (CONTROL_RIGHT|CONTROL_ROT_RIGHT))
        {
            angular_motor.z -= Speed / (turning_ratio*Gear) * reverse;
            NewWheeldir = "WR";
            turncount = 10;
        }
        
        if(level & (CONTROL_LEFT|CONTROL_ROT_LEFT))
        {
            angular_motor.z += Speed / (turning_ratio*Gear) * reverse;
            NewWheeldir = "WL";
            turncount = 10;
        }

        llSetVehicleVectorParam(VEHICLE_ANGULAR_MOTOR_DIRECTION, angular_motor);
        if(turncount > 0)
        {
            turncount--;
        }
        if(turncount == 1)
        {
            NewWheeldir = "WC";
        }
        if(Wheeldir != NewWheeldir){
            Wheeldir = NewWheeldir;
            llMessageLinked(LINK_ALL_OTHERS, 0, Wheeldir, NULL_KEY);
        }
        if(Wheelrot != NewWheelrot){
            Wheelrot = NewWheelrot;
            llMessageLinked(LINK_ALL_OTHERS, 0, Wheelrot, NULL_KEY);
        }
    } //end control       

    timer(){
        if(Run == 1){
            vector vel = llGetVel();
            Speed = llVecMag(vel);
//llOwnerSay("t, Speed " + (string)Speed);            
            if(Speed > 2.0)
            {
                Sound(2);
            }
            else if(Speed > 0.0)
            {
                llSetVehicleVectorParam(VEHICLE_LINEAR_FRICTION_TIMESCALE, <1.0, 2.0, 1000.0>);
                llSetVehicleVectorParam(VEHICLE_LINEAR_MOTOR_DIRECTION, <0,0,0>);
                llMessageLinked(LINK_ALL_OTHERS, 0, "S", NULL_KEY);
                Sound(1);
                Wheelrot = "S";
            }
            llSetTimerEvent(0.3);          // If restarted timer() appears to keep working  
        }else{
            llSetTimerEvent(0.0);
        }
    }
    
} //end default