//////////////////////////////////////////// 
// XyText v1.0.3 Script (5 Face, Multi Texture) 
// 
// Written by Xylor Baysklef 
// 
// Modified by Thraxis Epsilon January 20, 2006 
// Added Support for 5 Face Prim, based on modification 
// of XyText v1.1.1 by Kermitt Quick for Single Texture. 
// 
//////////////////////////////////////////// 

/////////////// CONSTANTS /////////////////// 
// XyText Message Map. 
integer DISPLAY_STRING = 204000; 
integer DISPLAY_EXTENDED = 204001; 
integer REMAP_INDICES = 204002; 
integer RESET_INDICES = 204003; 
integer SET_CELL_INFO = 204004;
integer SET_THICKNESS = 204006; 
integer SET_COLOR = 204007; 

// This is an extended character escape sequence. 
string ESCAPE_SEQUENCE = "\\e"; 

// This is used to get an index for the extended character. 
string EXTENDED_INDEX = "123456789abcdef"; 

// Face numbers. 
integer FACE_1 = 3; 
integer FACE_2 = 7; 
integer FACE_3 = 4; 
integer FACE_4 = 6; 
integer FACE_5 = 1; 

// Used to hide the text after a fade-out. 
key TRANSPARENT = "701917a8-d614-471f-13dd-5f4644e36e3c"; 
// This is a list of textures for all 2-character combinations. 
list CHARACTER_GRID = [ 
"8409a760-c2df-4af0-a70e-12c9d2b859d0", 
"8035650a-411f-4a97-92f1-acd293cc7b0f", 
"93c46731-748e-484f-bdb9-6bd89538b60d", 
"3e737d9e-2191-4df4-944b-5132b1ddbbd4", 
"ca45dffa-4f58-478d-b2e1-15cde767736e", 
"3eafedf4-0dbc-49f0-b05d-9c838d118e1a", 
"5ab9cacd-c1ad-4bfe-827e-fced58fe2ca0", 
"ba9aeeed-fb79-4db3-80a5-dcd2536bf20f", 
"cd8d02ec-3827-4808-a830-5482717675a5", 
"fd8407ad-dac3-4364-a609-d5fe545ae63c", 
"852b2b01-d6cd-431d-ad8c-a5fc5a49d4de", 
"f3c618f1-8bd4-4c6c-a320-1139a5a0e178", 
"8ad1b3e2-4834-4eda-8c33-8c3ac58ee0ca", 
"6443ee23-c8bf-4d21-bca4-fac28494a28c", 
"24e4fae5-096b-4195-b6f7-7ba69504f839", 
"6e3b5da3-cffa-4e77-8212-f42f2fdb20b0", 
"2a190e44-7b29-dadb-0bff-c31adaf5a170", 
"987ba839-3f0e-40b3-8b31-1a956a21915d", 
"c27e6a1e-a327-46c7-a994-9c037e96673e", 
"e0118689-89d1-462a-a156-7365aaa00fcf", 
"05117753-cb7e-4812-ba6f-1db172848a58", 
"62d95371-6769-45e4-a063-47b753268a61", 
"eb4f256a-ddc1-4333-bceb-88670e38015f", 
"178ce3f9-7f4c-4b8b-9878-41cd41a0a1fc", 
"18ec1f8b-ebcc-4bc1-8a35-ee5b55d1e3d3", 
"c22deaac-a925-4626-b64a-7c0fcbf6fa95", 
"0e0fc319-b5f2-40da-bd98-5b42115d53df", 
"55de41f9-b6ba-43b0-8d3e-743bf664ffd9", 
"a7b9ecc5-8373-4cbd-8116-abebb498a55c", 
"30a2d864-0a8f-4ada-9154-cc9784f4f0bd", 
"fa4362f0-0fcb-4233-9399-55a3b736a323", 
"8f3ad089-4018-42c0-a7f9-54486de8e2e5", 
"04ba7f27-b00f-4680-a5f0-435b4fef7f28", 
"9df2d0df-582c-4283-99b2-ecb02164734a", 
"372f41e3-a8c7-4026-85af-bd346f6a321b", 
"899a4106-bc0a-42eb-a114-6778da69d848", 
"aafc9601-4d02-45a8-8242-3a8cf2d5cbdd", 
"6584a3db-78f9-4fdf-a7e4-3f9ffd1b24b1", 
"050027b1-e299-4c68-9701-89e75b346fbf", 
"17b2024a-9022-4579-b944-58aed17c627e", 
"eeb7667c-4b26-43ae-8b1b-2c0d7e12c1b0", 
"b43a1944-422b-4d97-a492-45a031db1745", 
"2ccce24b-1531-4e69-b261-40d5ffeae256", 
"4306e9b7-b7fe-4ca0-99ff-a871a20d6e9c", 
"3160b68d-a0fe-422e-9952-77dd490b3579", 
"933e905a-753b-49e8-82cf-a02a7738b91a", 
"0116d940-9d93-4023-bed0-baf2dfea0579", 
"df21f7f5-db04-4312-a622-780a4ebe68bf", 
"1b8e2204-d5c9-4f0c-be3a-4ce9023aacff", 
"ed165a50-70cd-4d9b-8808-43900c2fef8d", 
"31d8b2b3-03ed-4227-adc8-a3679e6da6ae", 
"2dd71a24-4474-43b0-897a-0474bb8d31c5", 
"6a0ada5b-2ad4-46db-9498-92b9a97618e5", 
"e963688b-a10d-49e3-95b7-d9dbf8d10375", 
"6a81fbd5-0649-4d0a-b6e9-cc065a6af5d4", 
"e6b870ca-d479-4a8a-847c-e3c133a18738", 
"56a1431d-b1e0-48f5-94fb-17093015fa54", 
"69773bc5-f064-49f8-9e8d-cc9544750180", 
"20b52e3e-6928-4b8f-be55-e50f0a2779f8", 
"eae924eb-1e7c-41b4-ba09-012fb832ea3f", 
"046900a2-69cb-488c-869c-57b2da18e581", 
"b1a9666e-86ca-4293-8bbf-913c2f21c616", 
"48e05d38-0c3f-40e7-b5ac-37a6fb1a94db", 
"da2bc683-7130-4683-aae4-a4b11c166420", 
"b035dc18-cc2f-466a-afe0-b89ead8b8497", 
"63b29bcc-f71a-48de-a84a-46bf90290319" 
]; 

///////////// END CONSTANTS //////////////// 


///////////// Set Channel for line//////////////////
integer SET_LINE_CHANNEL = 100103;

//Set the start character - used for long line of chars//
//fisrt 10 chars start at 0, 2nd line starts at 10//
//3rd line starts at 20 and so on...//
integer START_CHAR = 0;


///////////// GLOBAL VARIABLES /////////////// 
// All displayable characters. Default to ASCII order. 
string gCharIndex; 
// This is the channel to listen on while acting 
// as a cell in a larger display. 
integer gCellChannel = -1; 
// This is the starting character position in the cell channel message 
// to render. 
integer gCellCharPosition = 0;
// This is whether or not to use the fade in/out special effect. 
integer gCellUseFading = FALSE; 
// This is how long to display the text before fading out (if using 
// fading special effect). 
// Note: < 0 means don't fade out. 
float gCellHoldDelay = 1.0; 
/////////// END GLOBAL VARIABLES //////////// 

ResetCharIndex() { 
gCharIndex = " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`"; 
// \" <-- Fixes LSL syntax highlighting bug. 
gCharIndex += "abcdefghijklmnopqrstuvwxyz{|}~"; 
gCharIndex += "\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n"; 
} 

vector GetGridPos(integer index1, integer index2) { 
// There are two ways to use the lookup table... 
integer Col; 
integer Row; 
if (index1 >= index2) { 
// In this case, the row is the index of the first character: 
Row = index1; 
// And the col is the index of the second character (x2) 
Col = index2 * 2; 
} 
else { // Index1 < Index2 
// In this case, the row is the index of the second character: 
Row = index2; 
// And the col is the index of the first character, x2, offset by 1. 
Col = index1 * 2 + 1; 
} 
return <Col, Row, 0>; 
} 

string GetGridTexture(vector grid_pos) { 
// Calculate the texture in the grid to use. 
integer GridCol = llRound(grid_pos.x) / 20; 
integer GridRow = llRound(grid_pos.y) / 10; 

// Lookup the texture. 
key Texture = llList2Key(CHARACTER_GRID, GridRow * (GridRow + 1) / 2 + GridCol); 
return Texture; 
} 

vector GetGridOffset(vector grid_pos) { 
// Zoom in on the texture showing our character pair. 
integer Col = llRound(grid_pos.x) % 20; 
integer Row = llRound(grid_pos.y) % 10; 

// Return the offset in the texture. 
return <-0.45 + 0.05 * Col, 0.45 - 0.1 * Row, 0.0>; 
} 

ShowChars(vector grid_pos1, vector grid_pos2, vector grid_pos3, vector grid_pos4, vector grid_pos5) { 
// Set the primitive textures directly. 


llSetPrimitiveParams( [ 
PRIM_TEXTURE, FACE_1, GetGridTexture(grid_pos1), <0.25, 0.1, 0>, GetGridOffset(grid_pos1) + <0.075, 0, 0>, 0.0, 
PRIM_TEXTURE, FACE_2, GetGridTexture(grid_pos2), <0.1, 0.1, 0>, GetGridOffset(grid_pos2), 0.0, 
PRIM_TEXTURE, FACE_3, GetGridTexture(grid_pos3), <-1.48, 0.1, 0>, GetGridOffset(grid_pos3)+ <0.37, 0, 0>, 0.0, 
PRIM_TEXTURE, FACE_4, GetGridTexture(grid_pos4), <0.1, 0.1, 0>, GetGridOffset(grid_pos4), 0.0, 
PRIM_TEXTURE, FACE_5, GetGridTexture(grid_pos5), <0.25, 0.1, 0>, GetGridOffset(grid_pos5) - <0.075, 0, 0>, 0.0 
]); 
}

RenderString(string str) { 
// Get the grid positions for each pair of characters. 
vector GridPos1 = GetGridPos( llSubStringIndex(gCharIndex, llGetSubString(str, 0, 0)), 
llSubStringIndex(gCharIndex, llGetSubString(str, 1, 1)) ); 
vector GridPos2 = GetGridPos( llSubStringIndex(gCharIndex, llGetSubString(str, 2, 2)), 
llSubStringIndex(gCharIndex, llGetSubString(str, 3, 3)) ); 
vector GridPos3 = GetGridPos( llSubStringIndex(gCharIndex, llGetSubString(str, 4, 4)), 
llSubStringIndex(gCharIndex, llGetSubString(str, 5, 5)) ); 
vector GridPos4 = GetGridPos( llSubStringIndex(gCharIndex, llGetSubString(str, 6, 6)), 
llSubStringIndex(gCharIndex, llGetSubString(str, 7, 7)) ); 
vector GridPos5 = GetGridPos( llSubStringIndex(gCharIndex, llGetSubString(str, 8, 8)), 
llSubStringIndex(gCharIndex, llGetSubString(str, 9, 9)) ); 

// Use these grid positions to display the correct textures/offsets. 
ShowChars(GridPos1, GridPos2, GridPos3, GridPos4, GridPos5); 
}

RenderWithEffects(string str) { 
// Get the grid positions for each pair of characters. 
vector GridPos1 = GetGridPos( llSubStringIndex(gCharIndex, llGetSubString(str, 0, 0)), 
llSubStringIndex(gCharIndex, llGetSubString(str, 1, 1)) ); 
vector GridPos2 = GetGridPos( llSubStringIndex(gCharIndex, llGetSubString(str, 2, 2)), 
llSubStringIndex(gCharIndex, llGetSubString(str, 3, 3)) ); 
vector GridPos3 = GetGridPos( llSubStringIndex(gCharIndex, llGetSubString(str, 4, 4)), 
llSubStringIndex(gCharIndex, llGetSubString(str, 5, 5)) ); 
vector GridPos4 = GetGridPos( llSubStringIndex(gCharIndex, llGetSubString(str, 6, 6)), 
llSubStringIndex(gCharIndex, llGetSubString(str, 7, 7)) ); 
vector GridPos5 = GetGridPos( llSubStringIndex(gCharIndex, llGetSubString(str, 8, 8)), 
llSubStringIndex(gCharIndex, llGetSubString(str, 9, 9)) ); 

// First set the alpha to the lowest possible. 
llSetAlpha(0.05, ALL_SIDES); 

// Use these grid positions to display the correct textures/offsets. 
ShowChars(GridPos1, GridPos2, GridPos3, GridPos4, GridPos5);

float Alpha; 
for (Alpha = 0.10; Alpha <= 1.0; Alpha += 0.05) 
llSetAlpha(Alpha, ALL_SIDES); 
// See if we want to fade out as well. 
if (gCellHoldDelay < 0.0) 
// No, bail out. (Just keep showing the string at full strength). 
return; 
// Hold the text for a while. 
llSleep(gCellHoldDelay); 
// Now fade out. 
for (Alpha = 0.95; Alpha >= 0.05; Alpha -= 0.05) 
llSetAlpha(Alpha, ALL_SIDES); 
// Make the text transparent to fully hide it. 
llSetTexture(TRANSPARENT, ALL_SIDES); 
} 

RenderExtended(string str) { 
// Look for escape sequences. 
list Parsed = llParseString2List(str, [], [ESCAPE_SEQUENCE]); 
integer ParsedLen = llGetListLength(Parsed); 

// Create a list of index values to work with. 
list Indices; 
// We start with room for 6 indices. 
integer IndicesLeft = 10; 

integer i; 
string Token; 
integer Clipped; 
integer LastWasEscapeSequence = FALSE; 
// Work from left to right. 
for (i = 0; i < ParsedLen && IndicesLeft > 0; i++) { 
Token = llList2String(Parsed, i); 

// If this is an escape sequence, just set the flag and move on. 
if (Token == ESCAPE_SEQUENCE) { 
LastWasEscapeSequence = TRUE; 
} 
else { // Token != ESCAPE_SEQUENCE 
// Otherwise this is a normal token. Check its length. 
Clipped = FALSE; 
integer TokenLength = llStringLength(Token); 
// Clip if necessary. 
if (TokenLength > IndicesLeft) { 
Token = llGetSubString(Token, 0, IndicesLeft - 1); 
TokenLength = llStringLength(Token); 
IndicesLeft = 0; 
Clipped = TRUE; 
} 
else 
IndicesLeft -= TokenLength; 

// Was the previous token an escape sequence? 
if (LastWasEscapeSequence) { 
// Yes, the first character is an escape character, the rest are normal. 

// This is the extended character. 
Indices += [llSubStringIndex(EXTENDED_INDEX, llGetSubString(Token, 0, 0)) + 95]; 

// These are the normal characters. 
integer j; 
for (j = 1; j < TokenLength; j++) 
Indices += [llSubStringIndex(gCharIndex, llGetSubString(Token, j, j))]; 
} 
else { // Normal string. 
// Just add the characters normally. 
integer j; 
for (j = 0; j < TokenLength; j++) 
Indices += [llSubStringIndex(gCharIndex, llGetSubString(Token, j, j))]; 
} 

// Unset this flag, since this was not an escape sequence. 
LastWasEscapeSequence = FALSE; 
} 
} 

// Use the indices to create grid positions. 
vector GridPos1 = GetGridPos( llList2Integer(Indices, 0), llList2Integer(Indices, 1) ); 
vector GridPos2 = GetGridPos( llList2Integer(Indices, 2), llList2Integer(Indices, 3) ); 
vector GridPos3 = GetGridPos( llList2Integer(Indices, 4), llList2Integer(Indices, 5) ); 
vector GridPos4 = GetGridPos( llList2Integer(Indices, 6), llList2Integer(Indices, 7) ); 
vector GridPos5 = GetGridPos( llList2Integer(Indices, 8), llList2Integer(Indices, 9) ); 

// Use these grid positions to display the correct textures/offsets. 
ShowChars(GridPos1, GridPos2, GridPos3, GridPos4, GridPos5); 
} 

integer ConvertIndex(integer index) { 
// This converts from an ASCII based index to our indexing scheme. 
if (index >= 32) // ' ' or higher 
index -= 32; 
else { // index < 32 
// Quick bounds check. 
if (index > 15) 
index = 15; 

index += 94; // extended characters 
} 

return index; 
} 

default { 
state_entry() { 
// Initialize the character index. 
ResetCharIndex(); 

 integer ThisLink = llGetLinkNumber();

llMessageLinked(ThisLink , SET_CELL_INFO, llList2CSV([SET_LINE_CHANNEL, START_CHAR]), "");
//llSay(0, "Free Memory: " + (string) llGetFreeMemory()); 
} 

link_message(integer sender, integer channel, string data, key id) { 
if (channel == DISPLAY_STRING) { 
RenderString(data); 
return; 
} 
if (channel == DISPLAY_EXTENDED) { 
RenderExtended(data); 
return; 
} 
if (channel == gCellChannel) { 
// Extract the characters we are interested in, and use those to render. 
string TextToRender = llGetSubString(data, gCellCharPosition, gCellCharPosition + 9);
if (gCellUseFading)
RenderWithEffects( TextToRender );
else // !gCellUseFading
RenderString( TextToRender );
return;
} 
if (channel == REMAP_INDICES) { 
// Parse the message, splitting it up into index values. 
list Parsed = llCSV2List(data); 
integer i; 
// Go through the list and swap each pair of indices. 
for (i = 0; i < llGetListLength(Parsed); i += 2) { 
integer Index1 = ConvertIndex( llList2Integer(Parsed, i) ); 
integer Index2 = ConvertIndex( llList2Integer(Parsed, i + 1) ); 

// Swap these index values. 
string Value1 = llGetSubString(gCharIndex, Index1, Index1); 
string Value2 = llGetSubString(gCharIndex, Index2, Index2); 

gCharIndex = llDeleteSubString(gCharIndex, Index1, Index1); 
gCharIndex = llInsertString(gCharIndex, Index1, Value2); 

gCharIndex = llDeleteSubString(gCharIndex, Index2, Index2); 
gCharIndex = llInsertString(gCharIndex, Index2, Value1); 
} 
return; 
} 
if (channel == RESET_INDICES) { 
// Restore the character index back to default settings. 
ResetCharIndex(); 
return; 
} 
if (channel == SET_CELL_INFO) { 
// Change the channel we listen to for cell commands, and the 
// starting character position to extract from. 
list Parsed = llCSV2List(data); 
gCellChannel = (integer) llList2String(Parsed, 0);
gCellCharPosition = (integer) llList2String(Parsed, 1);
gCellUseFading = (integer) llList2String(Parsed, 2); 
gCellHoldDelay = (float) llList2String(Parsed, 3); 
return; 
}
if (channel == SET_THICKNESS) { 
// Set our z scale to thickness, while staying fixed 
// in position relative the prim below us. 
vector Scale = llGetScale(); 
float Thickness = (float) data; 
// Reposition only if this isn't the root prim. 
integer ThisLink = llGetLinkNumber(); 
if (ThisLink != 0 || ThisLink != 1) { 
// This is not the root prim. 
vector Up = llRot2Up(llGetLocalRot()); 
float DistanceToMove = Thickness / 2.0 - Scale.z / 2.0; 
vector Pos = llGetLocalPos(); 
llSetPos(Pos + DistanceToMove * Up); 
} 
// Apply the new thickness. 
Scale.z = Thickness; 
llSetScale(Scale); 
return; 
} 
if (channel == SET_COLOR) { 
vector newColor = (vector)data; 
llSetColor(newColor, ALL_SIDES); 
} 
} 
} 
