// Move
//
// Multimove follower

integer offchan = -2200;    // this is the unique identifier for this type of vehicle
integer unichan;    // the channel used by the controller and objects to
            // sync and move, will be composed of this and part
            // of your UUID

integer handle;            // handle for the listen function

vector my_offset;        // original offset, set at first activation
rotation my_orientation;    // original rotation, set at first activation
integer my_num;            // position in the chain of redundancy
float azimut;

default
{
    on_rez(integer p)
    {
        unichan = offchan - (integer)("0x" + llGetSubString((string)llGetOwner(), 0, 6));
        llListenRemove(handle);
        handle = llListen(unichan + my_num, "", "", "");
    }
    
    state_entry()
    {
        unichan = offchan - (integer)("0x" + llGetSubString((string)llGetOwner(), 0, 6));
        my_num = (integer)llGetSubString(llGetScriptName(), -1, -1);
        handle = llListen(unichan + my_num, "", "", "");
    }
    
    listen(integer chan, string name, key id, string mesg)
    {
        if (mesg == "k") llDie();
        else if (mesg == "s") return;

        integer index = llSubStringIndex(mesg, "*");
        
        my_offset = llGetPos() + llGetRegionCorner() - (vector)llGetSubString(mesg, 0, index - 1);
        my_orientation = llGetRot() / (rotation)(llDeleteSubString(mesg, 0, index));
        my_offset = my_offset / llGetRot();
        state running;
    }
    
    state_exit()
    {
        llListenRemove(handle);
    }
}

state running
{
    on_rez(integer p)
    {
        unichan = offchan - (integer)("0x" + llGetSubString((string)llGetOwner(), 0, 6));
        llListenRemove(handle);
        handle = llListen(unichan + my_num, "", "", "");
    }
    
    state_entry()
    {
        handle = llListen(unichan + my_num, "", "", "");
    }
    
    listen(integer chan, string name, key id, string mesg)
    {
        if (mesg == "k")
        {
            llDie();
        } else if (mesg == "s")
        {
            state default;
        } else {
            integer index = llSubStringIndex(mesg, "*");
            rotation rtarget = my_orientation * (rotation)llDeleteSubString(mesg, 0, index);
            vector target = my_offset * rtarget + (vector)llGetSubString(mesg, 0, index - 1) - llGetRegionCorner();
            llSetPrimitiveParams([PRIM_POSITION, target, PRIM_ROTATION, rtarget]);
        }
    }
    
    state_exit()
    {
        llListenRemove(handle);
    }
}
