float x=16.0;
float y=16.0;
integer Pos;
integer debug = FALSE; //Turn this on for some chat feedback ;-)
vector colour;
vector litVect;
list thisColour;
string hexColourVect;
string hexc="0123456789ABCDEF";
list exterior;
list interior;
integer isExterior = TRUE;
//key owner;
//key clicker;

//convert RGB vector to literal vector (0.0 - 1.0), needed for most lsl applications
convertToLiteralVector()
{
    thisColour = llParseString2List((string)colour, ["<", ",", ">"], []);
    float litVectX = 0.003922 * llList2Float(thisColour, 0);
    float litVectY = 0.003922 * llList2Float(thisColour, 1);
    float litVectZ = 0.003922 * llList2Float(thisColour, 2);
    litVect = <0,0,0> + <litVectX, litVectY, litVectZ>;
}

//convert RGB vector to hex vector (0 - FF), needed for osCommands? outputs as string
convertToHexVectorStr()
{
    thisColour = llParseString2List((string)colour, ["<", ",", ">"], []);
    string hexVectX = int2hex(llList2Integer(thisColour, 0));
    string hexVectY = int2hex(llList2Integer(thisColour, 1));
    string hexVectZ = int2hex(llList2Integer(thisColour, 2));
    hexColourVect = "<" + hexVectX + "," + hexVectY + "," + hexVectZ + ">";
}


//convert integer to hex string
string int2hex(integer x)
{
    integer x0 = x & 0xF;
    string res = llGetSubString(hexc, x0, x0);
    x = (x >> 4) & 0x0FFFFFFF; //otherwise we get infinite loop on negatives.
    while( x != 0 )
    {
        x0 = x & 0xF;
        res = llGetSubString(hexc, x0, x0) + res;
        x = x >> 4;
    } 
    return res;
}

doExteriorColour() //Change the 'Exterior Part' colour
{
    integer i;
    integer index = 0;
    for (i = 0; i < llGetListLength(exterior); ++i)
    {
        llSetLinkPrimitiveParams(llList2Integer(exterior, index), [PRIM_COLOR, ALL_SIDES, litVect, 0.5]);
        index += 1;
    }
}

doInteriorColour() //Change the 'Interior Part' colour
{
    integer i;
    integer index = 0;
    for (i = 0; i < llGetListLength(interior); ++i)
    {
        llSetLinkPrimitiveParams(llList2Integer(interior, index), [PRIM_COLOR, ALL_SIDES, litVect, 0.5]);
        index += 1;
    }
}


//List RGB colour colums in native RGB format (0-255). Each list represents 16 columns of RGB colours. And yes, it took me aaages to work these out!
list col1 = [<0,0,0>,<16,16,16>,<33,33,33>,<49,49,49>,<66,66,66>,<82,82,82>,<99,99,99>,<115,115,115>,<148,148,148>,<165,165,165>,<181,181,181>,<198,198,198>,<214,214,214>,<231,231,231>,<247,247,247>,<255,255,255>];

list col2 = [<82,0,0>,<115,0,0>,<148,0,0>,<198,0,0>,<231,0,0>,<255,0,0>,<255,33,33>,<255,66,66>,<255,82,82>,<255,99,99>,<255,132,132>,<255,148,148>,<255,165,165>,<255,181,181>,<255,214,214>,<198,198,198>];

list col3 = [<82,16,0>,<115,24,0>,<148,33,0>,<165,41,0>,<198,49,0>,<231,57,0>,<255,66,0>,<255,90,33>,
<255,115,66>,<255,123,82>,<255,148,115>,<255,165,132>,<255,189,165>,<255,198,181>,<255,222,214>,<132,132,132>];

list col4 = [<82,42,0>,<99,49,0>,<132,66,0>,<165,82,0>,<181,90,0>,<214,107,0>,<231,115,0>,<255,132,0>,
<255,156,49>,<255,173,82>,<255,181,99>,<255,198,132>,<255,214,165>,<255,222,181>,<255,239,214>,<0,0,0>];

list col5 = [<82,57,0>,<99,74,0>,<132,99,0>,<148,107,0>,<165,123,0>,<198,148,0>,<214,156,0>,<247,181,0>,<255,198,0>,<255,214,66>,<255,222,99>,<255,222,115>,<255,231,148>,<255,239,181>,<255,247,214>,<255,0,0>];

list col6 = [<66,66,0>,<82,82,0>,<99,99,0>,<115,115,0>,<148,148,0>,<165,165,0>,<181,181,0>,<198,198,0>,<231,231,0>,<247,247,0>,<255,255,66>,<255,255,115>,<255,255,148>,<255,255,181>,<247,255,214>,<255,255,0>];

list col7 = [<49,82,0>,<57,99,0>,<82,132,0>,<90,148,0>,<99,165,0>,<115,198,0>,<132,214,0>,<148,247,0>,<156,255,0>,<181,255,66>,<198,255,99>,<214,255,132>,<214,255,148>,<231,255,181>,<247,255,214>,<0,255,0>];

list col8 = [<0,82,0>,<0,99,0>,<0,132,0>,<0,165,0>,<0,181,0>,<0,214,0>,<0,231,0>,<0,255,0>,<82,255,82>,<99,255,99>,<115,255,115>,<148,255,148>,<165,255,165>,<181,255,181>,<214,255,214>,<0,255,255>];

list col9 = [<0,82,41>,<0,99,49>,<0,132,66>,<0,165,82>,<0,181,90>,<0,214,107>,<0,231,115>,<0,255,132>,<82,255,173>,<99,255,181>,<115,255,189>,<148,255,206>,<165,255,214>,<181,255,222>,<214,255,239>,<0,0,255>];

list col10 = [<0,82,82>,<0,99,99>,<0,132,132>,<0,148,148>,<0,165,165>,<0,198,198>,<0,214,214>,<0,230,230>,<0,247,247>,<82,255,255>,<115,255,255>,<132,255,255>,<165,255,255>,<181,255,255>,<214,255,255>,<255,0,255>];

list col11 = [<0,49,82>,<0,74,115>,<0,99,148>,<0,107,165>,<0,132,198>,<0,148,231>,<0,173,255>,<66,198,255>,<82,198,255>,<99,206,255>,<132,214,255>,<148,222,255>,<165,231,255>,<181,231,255>,<214,247,255>,<132,0,0>];

list col12 = [<0,24,82>,<0,33,115>,<0,49,148>,<0,66,198>,<0,74,231>,<0,82,255>,<49,115,255>,<66,132,255>,<82,140,255>,<115,165,255>,<132,173,255>,<148,181,255>,<165,198,255>,<198,214,255>,<214,231,255>,<132,132,0>];

list col13 = [<0,0,82>,<0,0,132>,<0,0,165>,<0,0,214>,<0,0,255>,<33,33,255>,<49,49,255>,<82,82,255>,<99,99,255>,<115,115,255>,<132,132,255>,<148,148,255>,<165,165,255>,<198,198,255>,<214,214,255>,<0,132,0>];

list col14 = [<41,0,82>,<57,0,115>,<74,0,148>,<99,0,198>,<115,0,231>,<132,0,255>,<148,33,255>,<165,66,255>,<173,82,255>,<181,99,255>,<198,132,255>,<206,148,255>,<214,165,255>,<222,181,255>,<239,214,255>,<0,132,132>];

list col15 = [<82,0,82>,<115,0,115>,<148,0,148>,<165,0,165>,<198,0,198>,<231,0,231>,<255,0,255>,<255,33,255>,<255,66,255>,<255,82,255>,<255,115,255>,<255,132,255>,<255,165,255>,<255,181,255>,<255,214,255>,<0,0,132>];

list col16 = [<82,0,41>,<115,0,57>,<148,0,74>,<198,0,99>,<231,0,115>,<255,0,132>,<255,33,148>,<255,66,165>,<255,82,255>,<255,99,181>,<255,132,198>,<255,148,206>,<255,165,214>,<255,181,222>,<255,214,239>,<132,0,132>];


default
{
    state_entry()
    {
        //Loop through every prim to determine its name. If the prim name is 'Interior Part' or 'Exterior Part' place the link numbers for those prims in the corresponding list
        llOwnerSay("Initialising...");
        integer i;
        for (i = 0; i < (llGetNumberOfPrims() + 1); ++i)
        {
            if (debug)
            {
                llSay(0, (string)i + (string)llGetLinkName(i));
            }
            if (llGetLinkName(i) == "Interior Part")
            {
                interior += [(integer)i];
            }
            if (llGetLinkName(i) == "Exterior Part")
            {
                exterior += [(integer)i];
            }
        }
        if (debug)
        {
            llSay(0, "Interior Link Nunbers = " + llList2CSV(interior));
            llSay(0, "Exterior Link Numbers = " + llList2CSV(exterior));
        }
    }

    on_rez(integer start_param)
    {
        llResetScript();
    }
    touch_start(integer total_number)
    {
//        owner = llGetOwner();
//        clicker = llDetectedKey(0);

//        if (owner == clicker)
//        {
        if (llDetectedTouchFace(0) == -1) llOwnerSay("old client"); //check for old client that doesn't support llDetectedTouch###
        else
        {
            vector pos = llDetectedTouchST(0);//give us our literal position on the prim face
            Pos = ((llFloor((pos.x*10)*x)/10)*(integer)y)+llCeil(pos.y*y);//do some magic to convert the literal into a grid of 256 cells. we need this to be able to reference out lists
            if (debug) llSay(0,(string)Pos);
            //reference our list and return the index for the specific grid cell touched
            if (Pos <= 16) colour = llList2Vector(col1,(Pos - 1));
            else if (Pos >= 17 && Pos <= 32) colour = llList2Vector(col2,(Pos - 17));
            else if (Pos >= 33 && Pos <= 48) colour = llList2Vector(col3,(Pos - 33));
            else if (Pos >= 49 && Pos <= 64) colour = llList2Vector(col4,(Pos - 49));
            else if (Pos >= 65 && Pos <= 80) colour = llList2Vector(col5,(Pos - 65));
            else if (Pos >= 81 && Pos <= 96) colour = llList2Vector(col6,(Pos - 81));
            else if (Pos >= 97 && Pos <= 112) colour = llList2Vector(col7,(Pos - 97));
            else if (Pos >= 113 && Pos <= 128) colour = llList2Vector(col8,(Pos - 113));
            else if (Pos >= 129 && Pos <= 144) colour = llList2Vector(col9,(Pos - 129));
            else if (Pos >= 145 && Pos <= 160) colour = llList2Vector(col10,(Pos - 145));
            else if (Pos >= 161 && Pos <= 176) colour = llList2Vector(col11,(Pos - 161));
            else if (Pos >= 177 && Pos <= 192) colour = llList2Vector(col12,(Pos - 177));
            else if (Pos >= 193 && Pos <= 208) colour = llList2Vector(col13,(Pos - 193));
            else if (Pos >= 209 && Pos <= 224) colour = llList2Vector(col14,(Pos - 209));
            else if (Pos >= 225 && Pos <= 240) colour = llList2Vector(col15,(Pos - 225));
            else if (Pos >= 241 && Pos <= 256) colour = llList2Vector(col16,(Pos - 241));
            if (debug) llSay(0, (string)colour);
            
            convertToLiteralVector(); //Convert colour to literal vector (this we need in LSL scripts)
            llSay(67, (string)litVect);
            if (debug) llSay(0, (string)litVect);
            
            
            convertToHexVectorStr(); //Convert to HEX vector (may be useful for something and can be commented out for now)
            if (debug) llSay(0, hexColourVect);
            
            if (isExterior) doExteriorColour(); //Do the colour change thang
            else doInteriorColour();
        }
//      }
//      else{
//          llSay(0,"You are not the owner of this vehicle!!");
//      }    
    }
    link_message(integer int,integer num,string str,key id)
    {         
        
        if(str == "external") isExterior = TRUE;
        else if (str == "internal") isExterior = FALSE;
        else if (str == "reset") { llResetScript();}
    }
}
