integer g_OpenNow;                 // True (1) if iris is 'open' now

default
{
    on_rez(integer param)
    {
        llResetScript();
    }
    
    state_entry()
    {
        if (g_OpenNow == TRUE) // Prim is in open state, so calculate new 'closed' size
        {
            state WaitToClose;
        }
        else // Prim is in a closed (or undefined state), so calculate new 'open' size
        {
            g_OpenNow = FALSE;
            state WaitToOpen;
        }
    }
}
      
state WaitToClose // Iris is Open, and waiting to close
{
    touch_start(integer total_number)
    {
         llSetPrimitiveParams([PRIM_TYPE, PRIM_TYPE_TORUS, 0, <0.0, 1.0, 0.0>, 0.0, <0.0, 0.0, 0.0>, <1.0, 0.5, 0.0>, <0.0, 0.0, 0.0>, <0.0, 1.0, 0.0>, <0.0, 0.0, 0.0>, 1.0, 0.0, 0.0]);
        g_OpenNow = FALSE;
        state WaitToOpen;
    }
}

state WaitToOpen // Iris is closed, and waiting to open
{
    touch_start(integer total_number)
    {
         llSetPrimitiveParams([PRIM_TYPE, PRIM_TYPE_TORUS, 0, <0.0, 1.0, 0.0>, 0.0, <0.0, 0.0, 0.0>, <1.0, 0.05, 0.0>, <0.0, 0.0, 0.0>, <0.0, 1.0, 0.0>, <0.0, 0.0, 0.0>, 1.0, 0.0, 0.0]);
        g_OpenNow = TRUE;
        state WaitToClose;
    }
}