// Copyright 2011 Michael Bailey (Marcus Llewellyn). All rights reserved.
// This script distributed under the Simplified BSD License. A copy of
// this license should be included with this script.
// modified by Nebadon Izumi 12/11/2011

string itemname = "";
integer link_sign = 0;
integer link_button = 0;
integer link_base = 0;
integer link_posestand = 0;

GiveOutfit(key target, string folder) {
    // Give the outfit items to the visitor in a folder.
    list items = [];
    integer i = 0;
    integer loopsize = llGetInventoryNumber(INVENTORY_NOTECARD);
    for (i=0;i<loopsize;i++) {
        items += [llGetInventoryName(INVENTORY_NOTECARD, i)];
    }
    loopsize = llGetInventoryNumber(INVENTORY_OBJECT);
    for (i=0;i<loopsize;i++) {
        items += [llGetInventoryName(INVENTORY_OBJECT, i)];
    }
    llGiveInventoryList(target, folder, items);
}

default
{
    state_entry() {
        llSay(0, llGetObjectName() + " is starting up!");
        itemname = llGetObjectName();
        llSay(0, llGetObjectName() + " is operational.");
    }
    
    touch_start(integer num) {
            GiveOutfit(llDetectedKey(0), itemname);
            llInstantMessage(llDetectedKey(0), "Thank you! A folder named \"" + itemname + "\" was placed in your inventory.");
            return;
        }
    
    changed(integer change) {
        // Cover our butts.
        if (change & CHANGED_INVENTORY) { llResetScript(); }
        if (change & CHANGED_OWNER) { llResetScript(); }
        if (change & CHANGED_REGION) { llResetScript(); }
    }
}