string TipjarName_s = "Tipjar";


string owner;
integer total;
integer last;
string textcolour = "<0,1,0>";//change hovertext colour here. Values are red,green,blue. Range 0 to 1. Red = <1,0,0>, Green = <0,1,0>, <1,1,1> = white, <0,0,0> = black, etc.


default
{
    on_rez( integer sparam )
    {
        llResetScript();
    }
    state_entry()
    {
        llSetObjectName(llDumpList2String([TipjarName_s, "@", llGetRegionName()], " "));
        owner = llKey2Name( llGetOwner() );
        
        string HoverText_s = llList2String(llGetPrimitiveParams([PRIM_TEXT]), 0);
        list Amounts_l = llParseStringKeepNulls(HoverText_s, ["\n", "Bucks$"], []);
        string AmountLast_s = llList2String(Amounts_l, 1);
        string AmountTotal_s = llList2String(Amounts_l, 3);
        if (llStringTrim(AmountLast_s, STRING_TRIM) != "") { last = (integer)AmountLast_s; }
        if (llStringTrim(AmountTotal_s, STRING_TRIM) != "") { total = (integer)AmountTotal_s; }
        else { total = 0; last = 0; }
        string Message_s = owner +"'s Tip Jar";
        if (total && last) { Message_s += "\n" + (string)last + "Bucks$ tipped last\n" + (string)total + "Bucks$ tipped so far!"; }
        llSetText(Message_s,(vector)textcolour,1);
        
        llSetPayPrice(PAY_DEFAULT, [100, 200, 300, 500]);
        llSetClickAction(CLICK_ACTION_PAY);
    }
    money(key tipper, integer amount)
    {
        total += amount;
        string tipname = llKey2Name(tipper);
        llSetText(owner +"'s Tip Jar\n" + (string)amount + "Bucks$ tipped last\n" + (string)total + "Bucks$ tipped so far!",(vector)textcolour,1);
        llInstantMessage(tipper,"Thank you very much for helping out ! , " +(string)tipname);
        //llInstantMessage(llGetOwner(),(string)tipname+" tipped at Tamara Bucks$" + (string)amount);
        llInstantMessage(llGetOwner(), llDumpList2String([tipname, "tipped at", llGetRegionName(), "Bucks$", amount], " "));
    }
}
