//BASIC MOVING NPC
//READS INSTRUCTIONS FROM NOTECARD, takes commands GOTO, ANIMATE, PAUSE, TALK, SIT
//SEE INCLUDED "actionCard" NOTECARD FOR EXAMPLE
//THE NPC REZZES WHEN YOU TOUCH THE PRIM, AND WHEN THE REGION RESTARTS
//THE NPC WILL HAVE THE APPEARANCE I DEFINED IN THE INCLUDED "npc_apppearance" NOTECARD
//YOU CAN CHANGE THE LOOK OF THE NPC BY DELETING THAT NOTECARD, CHANGE YOUR OWN APPEARANCE
//TO WHAT YOU WANT THE NPC TO LOOK LIKE, INCLUDING ATTACHMENTS, THEN TOUCH THE PRIM
//This script uses states to manage the different types of actions, such as moving, pausing, animating, etc.
//The default state is only used to set stuff up at the very beginning, once you have configured
//any objects you want rezzed for the npc to sit on in the objects2rez card, 
//and configured the actions in the actionCard. In the default state is where 
//the NPC is first created by the owner touching the prim. As soon as that happens, 
//the script transitions to the NPCidle state, and from there, cycles through the actions
//each type of action (move, pause, sit, stand, say, etc.) is managed by a state.
//E.g. moving is managed in the NPCgoto state. Once an action is complete the script 
//transitions back to NPCidle to figure out what to do next.
//That should make it easy to use this script to make far, far fancier scripts ;)
//For example, you could add an NPCtouch state to make the NPC touch scripted items.
//OR you could add an NPCinteract state and make the NPC interact with avs, like Q&A stuff.
//This script doesn't have any listens or sensors, and using the default notecards and 
//npc appearance card, the NPC doesn't wear any special scripted items, but you could 
//certainly do that.
//Currently this script has a function to rez and position seats based on the objects2rez card.
//The default actionCard has the NPC sit on these seats at one time or other
//You could customize the script to rez other objects, such as scripted objects for the npc to touch

//change these values as you wish
integer debug = FALSE;//whether to chat extra stuff to the owner (look for if(debug) ... statements to see what is chatted)
string firstName = "Moving";//npc first name, change as you wish
string lastName = "Man";//npc last name, change as you wish

string appearanceCard = "npc_appearance";//name of the card that is used to create the npc appearance
string curActionCard = "actionCard";//name of action card
string rezObjectsCard = "objects2rez";//card to define objects in inventory and where to place them
string rezzedObjectsCard = "objectsARERezzed";//automatically created when objects are rezzed, contains object keys


//don't touch stuff below this line unless you intend to change the script function
vector npcHomePos;//automatically set, first GOTO vector in curActionCard
vector npcPos;//automatically set, npc position
rotation npcRot;//automatically set, npc position

key npcKey;//automatically set, npc UUID
key ownerKey;//automatically set, prim owner UUID
key thisObjectKey;//automatically set, npc rezzer object key

list rezzedObjectKeys;//keys of rezzed objects, get saved to objectsARERezzed card
list rezzedObjectPos;//populated from objects2rez card
integer lastActionComplete;//frequently updated variable, identifies last action completed (card line # in curActionCard), -1 starting from scratch 
integer curAction;//next action to perform 
string curActionCmd;//next action command to perform
string curActionValue;//value for next action command (such as a vector for GOTO)
integer totalActionCnt;//total number of actions in curActionCard - 1

//function to move objects, such as to position objects rezzed from prim
//warpPos from lsl wiki, modified for ossl osSetPrimitiveParams() and osGetPrimitiveParams(), as these allow
//setting prim parameters for a prim identified by its key 
osWarpPos(key id, vector destpos ) 
 {   
     vector primPos = llList2Vector(osGetPrimitiveParams(id, [PRIM_POSITION]), 0);
     integer jumps = (integer)(llVecDist(destpos, primPos) / 10.0) + 1;
     // Try and avoid stack/heap collisions
     if (jumps > 411)
         jumps = 411;
     list rules = [ PRIM_POSITION, destpos ];  //The start for the rules list
     integer count = 1;
     while ( ( count = count << 1 ) < jumps)
         rules = [] + rules + rules;   //should tighten memory use.
     osSetPrimitiveParams(id, rules + llList2List( rules, (count - jumps) << 1, count) );
     vector primPos2 = llList2Vector(osGetPrimitiveParams(id, [PRIM_POSITION]), 0);
     if ( llVecDist( primPos2, destpos ) > .001 ) //Failsafe
         while ( --jumps ) 
            osSetPrimitiveParams(id, [PRIM_POSITION, destpos]);
 }
//function to remove the npc
removeNpc(key toucher, key npcToRemove) {
    if(toucher == ownerKey) {
        osNpcSay(npcToRemove, "To oblivion and BEYOND, beyond, beyond ...");
        osNpcRemove(npcToRemove);
        npcKey = NULL_KEY;
    }

}
//function to create the npc
createNpc(key ownerKey) {
    if(llStringLength(osGetNotecard(appearanceCard)) < 15) {//this checks for an already existing notecard
                                                            //and, if absent, creates an NPC that looks just like you!
        osAgentSaveAppearance(ownerKey, appearanceCard);
    }

    npcKey = osNpcCreate(firstName, lastName, npcHomePos, appearanceCard);
    npcRot = llGetRot();
    osNpcSetRot(npcKey, npcRot);
    osNpcSay(npcKey, "It's great to be ALIVE!! Thank you!");
    osNpcSay(npcKey, "WoooooHooooooooo!");
    llSleep(4.0);    
}

//nice generic function to check for a particular card in inventory
integer checkForCard(string cardName) {
    integer numNoteCards = llGetInventoryNumber(INVENTORY_NOTECARD);
    integer i;
    integer cardExists = 0;
    for(i=0;i<numNoteCards;i++) {
        if(llGetInventoryName(INVENTORY_NOTECARD, i) == cardName) {
            cardExists = 1;
        }
    }
    return cardExists; 
        
}

//function to rez the objects in inventory that are sat on by the NPC
rezObjects() {
    if(!checkForCard("objectsARERezzed")) {
       integer i;
        rezzedObjectKeys = [];
        for(i=0; i<osGetNumberOfNotecardLines(rezObjectsCard); i++) {  
            list seats = llParseString2List(osGetNotecardLine(rezObjectsCard, i), ["==="], [""]);
            string seatName = llList2String(seats, 0);
            vector seatPos = llList2Vector(seats, 1);
            //rezzedObjectKeys, rezzedObjectPos
            rezzedObjectPos += seatPos;
            llRezObject(seatName, llGetPos() + <0.0,0.0,2.0>, ZERO_VECTOR, llGetRot(), 0);
        }    
    }
}

//just gets the total number of curActionCard lines minus 1
setTotalActions() {
    totalActionCnt = osGetNumberOfNotecardLines(curActionCard) - 1;
    if(debug) {llOwnerSay("totalActionCnt = " + (string)totalActionCnt);}
}
//called each time an action is completed
updateLastAction() {
    if(lastActionComplete == -1) {
        lastActionComplete = 0;
    }
    else if (lastActionComplete == totalActionCnt) {
        lastActionComplete = 0;
    }
    else if(lastActionComplete >= 0 && lastActionComplete < totalActionCnt){
        lastActionComplete = lastActionComplete + 1;
    }
    if(debug) {llOwnerSay("lastActionComplete = " + (string)lastActionComplete);}
}
//gets the next action command and value
getNextAction() {
    if(lastActionComplete == -1 || lastActionComplete == totalActionCnt) {
        curAction = 0;
    }
    else {
        curAction = lastActionComplete + 1;
    }
    if(debug) {llOwnerSay("curAction = " + (string)curAction);}
    list action = llParseString2List(osGetNotecardLine(curActionCard, curAction), ["==="], [""]);
    curActionCmd = llList2String(action, 0);
    curActionValue = llList2String(action, 1);
}
//sets the home position from the first GOTO line in curActionCard
setHome() {
    list action = llParseString2List(osGetNotecardLine(curActionCard, 0), ["==="], [""]);
    npcHomePos = llList2Vector(action, 1);
}
//function to move the npc. I just customized a piece of a script from http://forums.osgrid.org/viewtopic.php?f=5&t=3514, and 
//turned it into a function. Note the original author's comments here

moveNpc(key npcKey, vector position) {

    if (position.x > 1){                                   
        osNpcSetRot(npcKey, llRotBetween(<PI,PI,0>,llVecNorm(position - osNpcGetPos(npcKey))));
        osNpcMoveToTarget(npcKey, position, OS_NPC_NO_FLY);
        integer i;   
        while (llFabs(llVecDist(position, npcPos)) > 2 && i <170){
            npcPos = osNpcGetPos(npcKey);
            i++;
            llSleep(1);
        } // Probably a lower lag way to do this with states or something
        if(llFabs(llVecDist(position, npcPos)) > 2) {
            moveNpc(npcKey, position); 
        }
        // This also locks out the script until the loop is complete
        // Which I really really hate! :P
                             
    }
    llSetTimerEvent(0.1);
    
}

default
{
    state_entry()
    {
        ownerKey = llGetOwner();
        thisObjectKey = llGetKey();
        llSitTarget(<0.0, 0.0, 0.01>, ZERO_ROTATION); 
        llSetText("Read INSTRUCTIONS inside\n Touch after updating configuration,"
        + "\n any necessary objects added to this prim,\n and you are ready to rez NPC."
        + "\n HOME position MUST be first GOTO===[vector] line of action card", 
        <1.0,1.0, 1.0>,1.0);
        
    }//end state entry

    touch_start(integer number)
    {
        llSetText("", <1.0,1.0, 1.0>,1.0);
        key toucher = llDetectedKey(0);
        if(toucher == ownerKey) { 
            lastActionComplete = -1;//starts fresh
            setHome();
            setTotalActions();
            rezObjects();     
            llSetTimerEvent(5.0); 
            llOwnerSay("Rezzing and positioning any objects. NPC will be created in 5 seconds.");                 
        }

    }//end touch start
    timer() {
        llSetTimerEvent(0);
        createNpc(ownerKey);//creates the npc   
        state NPCidle;

    }
    on_rez(integer param)
    {   
        //Just restarting everything, not removing any cards or anything
        llResetScript();
    }//end on rez

    changed(integer mask)
    {   
        // Triggered when the object containing this script changes owner.
        if(mask & CHANGED_OWNER)
        {
            llResetScript();
        }
        if(mask & CHANGED_REGION_START) {
            //npcs aren't persistent, so when the region shuts down, the npc is removed
            //this recreates the npc everytime a restart is detected
            createNpc(ownerKey);
            state NPCidle;
        
        }

    }//end changed

    //this event is triggered when llRezObject is run to rez object from prim inventory
    object_rez(key id)
    {
        rezzedObjectKeys += id;

        integer rezzedObjectCnt = llGetListLength(rezzedObjectKeys) - 1;
        vector objPos = llList2Vector(rezzedObjectPos, rezzedObjectCnt);
        osWarpPos(id, objPos);
        if(checkForCard(rezzedObjectsCard)) {
            llRemoveInventory(rezzedObjectsCard);
        }
        osMakeNotecard(rezzedObjectsCard, rezzedObjectKeys);
        //delete the objectsARERezzed notecard and reset the script to re-rezz objects from inventory.

    }//end object rez
}
state NPCidle
{
    state_entry()
    {
        llSetTimerEvent(0);//kill any existing timers
        if(debug){llOwnerSay("NPCidle");}//Set debug=FALSE to turn off these messages
        getNextAction();
        llSetTimerEvent(0.1);//trigger timer event to decide what state to transition to
                        
    }//end state entry

    timer() {
        if(curActionCmd == "GOTO") {//curActionCmd comes from the action card
            if(debug){llOwnerSay("NPCidle-tmer-goto");}
            state NPCgoto;//GOTO command triggers transition to NPCgoto state
        }
        else if(curActionCmd == "PAUSE") {
             if(debug){llOwnerSay("NPCidle-tmer-pause");}
            state NPCpause;

        }
        else if(curActionCmd == "ANIMATE") {
             if(debug){llOwnerSay("NPCidle-tmer-animate");}
            state NPCanimate;

        }
        else if(curActionCmd == "STOPANIMATE") {
             if(debug){llOwnerSay("NPCidle-tmer-deanimate");}
            state NPCdeanimate;

        }

        else if(curActionCmd == "TALK") {
             if(debug){llOwnerSay("NPCidle-tmer-talk");}
            state NPCtalk;

        }
        else if(curActionCmd == "SIT") {
             if(debug){llOwnerSay("NPCidle-tmer-sit");}
            state NPCsit;

        }
        else if(curActionCmd == "STAND") {
             if(debug){llOwnerSay("NPCidle-tmer-stand");}
            state NPCstand;

        }
        else {
            if(debug){llOwnerSay("NPCidle-tmer-command UNKNOWN. " + curActionCmd + " " + curActionValue + ". Going to next action");}
            updateLastAction();
        }
        
    }

    touch_end(integer number)
    {
        //IMPORTANT: if using touch to trigger state change, use touch_end NOT touch_start, as done here
        removeNpc(llDetectedKey(0), npcKey);
        state default;
    
    }//end touch end

    changed(integer mask)
    {   
        if(mask & CHANGED_OWNER)
        {
            llResetScript();//resets script when owner changes
        }
        if(mask & CHANGED_REGION_START) {
            createNpc(ownerKey);
            state NPCidle;

        }
    }//end changed

}

state NPCtalk
{
    state_entry()
    {
        llSetTimerEvent(0);
        if(debug){llOwnerSay("NPCtalk");}
        string npcChat = curActionValue;
        if(debug) {llOwnerSay("commanded to chat "); }
        osNpcSay(npcKey, npcChat);
        llSetTimerEvent(0.1);

    }
    timer()
    {
        updateLastAction();
        state NPCidle;
    }
    touch_end(integer number)
    {
        removeNpc(llDetectedKey(0), npcKey);
        state default;
    
    }//end touch end
    changed(integer mask)
    {   
        if(mask & CHANGED_OWNER)
        {
            llResetScript();//resets script when owner changes
        }
        if(mask & CHANGED_REGION_START) {
            createNpc(ownerKey);
            state NPCidle;

        }

    }//end changed

}

state NPCanimate
{
    state_entry()
    {
        llSetTimerEvent(0);
        if(debug){llOwnerSay("NPCanimate");}
        string npcAnim = curActionValue;
        if(debug) {llOwnerSay("playing " + npcAnim + " animation"); }
        osNpcPlayAnimation(npcKey, npcAnim);
        llSetTimerEvent(0.1);
    }
    timer()
    {
        updateLastAction();
        state NPCidle;
    }
    touch_end(integer number)
    {
        removeNpc(llDetectedKey(0), npcKey);
        state default;
    
    }//end touch end

        changed(integer mask)
    {   
        if(mask & CHANGED_OWNER)
        {
            llResetScript();//resets script when owner changes
        }
        if(mask & CHANGED_REGION_START) {
            createNpc(ownerKey);
            state NPCidle;

        }

    }//end changed


}
state NPCdeanimate
{
    state_entry()
    {
        llSetTimerEvent(0);
        if(debug){llOwnerSay("NPCdeanimate");}
        string npcAnim = curActionValue;
        if(debug) {llOwnerSay("playing " + npcAnim + " animation"); }
        osNpcStopAnimation(npcKey, npcAnim);
        llSetTimerEvent(0.1);
    }
    timer()
    {
        updateLastAction();
        state NPCidle;
    }
    touch_end(integer number)
    {
        removeNpc(llDetectedKey(0), npcKey);
        state default;
    
    }//end touch end

    changed(integer mask)
    {   
        if(mask & CHANGED_OWNER)
        {
            llResetScript();//resets script when owner changes
        }
        if(mask & CHANGED_REGION_START) {
            createNpc(ownerKey);
            state NPCidle;

        }

    }//end changed
}


state NPCsit
{
    state_entry()
    {
        llSetTimerEvent(0);
         if(debug){llOwnerSay("NPCsit");}
        integer npcSeat = (integer)curActionValue;
        key npcSeatKey = (key)osGetNotecardLine("objectsARERezzed", npcSeat);
        if(debug) {llOwnerSay("commanded to sit on seat " + (string)npcSeat); }
        osNpcSit(npcKey, npcSeatKey, OS_NPC_SIT_NOW);
        llSetTimerEvent(0.1);
        
    }
    timer()
    {
        updateLastAction();
        state NPCidle;
    }
    touch_end(integer number)
    {
        removeNpc(llDetectedKey(0), npcKey);
        state default;
    
    }//end touch end

    changed(integer mask)
    {   
        if(mask & CHANGED_OWNER)
        {
            llResetScript();//resets script when owner changes
        }
        if(mask & CHANGED_REGION_START) {
            createNpc(ownerKey);
            state NPCidle;

        }

    }//end changed


}
state NPCstand
{
    state_entry()
    {
        llSetTimerEvent(0);
        if(debug){llOwnerSay("NPCstand");}
        if(debug) {llOwnerSay("commanded to stand "); }
        osNpcStand(npcKey);
        llSetTimerEvent(0.1);
        
    }
    timer()
    {
        updateLastAction();
        state NPCidle;
    }

    touch_end(integer number)
    {
        removeNpc(llDetectedKey(0), npcKey);
        state default;
    
    }//end touch end

    changed(integer mask)
    {   
        if(mask & CHANGED_OWNER)
        {
            llResetScript();//resets script when owner changes
        }
        if(mask & CHANGED_REGION_START) {
            createNpc(ownerKey);
            state NPCidle;

        }

    }//end changed


}

state NPCpause
{
    state_entry()
    {
        llSetTimerEvent(0);
        if(debug){llOwnerSay("NPCpause");}
        float pause = (float)curActionValue;
        if(debug) {llOwnerSay("Pausing " + (string)pause + " seconds"); }
        llSetTimerEvent(pause);
    }
    timer()
    {
        updateLastAction();
        state NPCidle;
    }
    touch_end(integer number)
    {
        removeNpc(llDetectedKey(0), npcKey);
        state default;
    
    }//end touch end

    changed(integer mask)
    {   
        if(mask & CHANGED_OWNER)
        {
            llResetScript();//resets script when owner changes
        }
        if(mask & CHANGED_REGION_START) {
            createNpc(ownerKey);
            state NPCidle;

        }

    }//end changed

}

state NPCgoto
{
    state_entry()
    {
        llSetTimerEvent(0);
        if(debug){llOwnerSay("NPCgoto");}
        npcPos = osNpcGetPos(npcKey);
        vector position = (vector)curActionValue;
        if(debug) {llOwnerSay("moving to " + (string)position);}
        moveNpc(npcKey, position);
       
        
    }
    timer()
    {
        updateLastAction();
        state NPCidle;
    }


    touch_end(integer number)
    {
        removeNpc(llDetectedKey(0), npcKey);
        state default;
    
    }//end touch end

    changed(integer mask)
    {   
        if(mask & CHANGED_OWNER)
        {
            llResetScript();//resets script when owner changes
        }
        if(mask & CHANGED_REGION_START) {
            createNpc(ownerKey);
            state NPCidle;

        }

    }//end changed
}