// Freebie Fire Script w/Environmental Sounds
// by Babu Oh (2008)
//
// - simple wrapper around particle fire script by Ama Omega (10-10-2003)
// and freebie environmental sound script by Apotheus Silverman
// (found within the "Giving Campfire" freebie by Cherry Asturias).
//
// - THIS SCRIPT IS OPEN SOURCE AND FREE. PLEASE DISTRIBUTE ACCORDINGLY.


// 2008-11-02
// - version 0.2
// - added simple menu to particle fire script
// - added link message functions to environmental sound script
//
// 2008-02-04
// - version 0.1
// - uses Ama Omega's freebie fire particle script
// and freebie environmental sound script




// =====================================================================
// VARS
// =====================================================================


// ================ [ menu dialog vars ]

// channel used for menu dialog
integer gChannel = -987654;

string MENU_DIALOG_TEXT = "Please choose an option:";

integer gDialogListener = 0;


// ================ [ link message vars ]

string ON_OFF = "SND_ON_OFF";
string RESET = "RESET";


// ================ [ script vars ]


// this is the "on" or "off" flag

integer gParticlesOn = 0;


// set to 1 if you want menu to be accessible by owner only
// set to 0 if you want everyone to access the menu

integer gControlByOwnerOnly = 0;

// sound

// set to 1 if you want environmental sounds
// set to 0 if you do not

integer gSoundOn = 0;

// sound params

string FIRE_SOUND = "fire";
float SOUND_VOLUME = 1.0;

// light params

vector gLightsOnVector = <1.0, 0.5, 0.0>;
float gLightIntensity = 1.0;
float gLightRadius = 10.0;
float gLightFalloff = 0.75;
float gLightAlpha = 1.0;
float gPrimGlow = 0.0;
integer gPrimFullbright = 1;


// =====================================================================






// =====================================================================
// FREEBIE PARTICLE SCRIPT FUNCTIONS
// =====================================================================

// This is the entire freebie script by Ama Omega

// Particle Script 0.3
// Created by Ama Omega
// 10-10-2003

// Mask Flags - set to TRUE to enable
integer glow = TRUE;            // Make the particles glow
integer bounce = FALSE;          // Make particles bounce on Z plan of object
integer interpColor = TRUE;     // Go from start to end color
integer interpSize = TRUE;      // Go from start to end size
integer wind = TRUE;           // Particles effected by wind
integer followSource = FALSE;    // Particles follow the source
integer followVel = TRUE;       // Particles turn to velocity direction

// Choose a pattern from the following:
// PSYS_SRC_PATTERN_EXPLODE
// PSYS_SRC_PATTERN_DROP
// PSYS_SRC_PATTERN_ANGLE_CONE_EMPTY
// PSYS_SRC_PATTERN_ANGLE_CONE
// PSYS_SRC_PATTERN_ANGLE
integer pattern = PSYS_SRC_PATTERN_EXPLODE;

// Select a target for particles to go towards
// "" for no target, "owner" will follow object owner 
//    and "self" will target this object
//    or put the key of an object for particles to go to
key target = "";

// Particle paramaters
float age = .9;                  // Life of each particle
float maxSpeed = .2;            // Max speed each particle is spit out at
float minSpeed = .01;            // Min speed each particle is spit out at
string texture;                 // Texture used for particles, default used if blank
float startAlpha = 1;           // Start alpha (transparency) value
float endAlpha = 0.1;           // End alpha (transparency) value
vector startColor = <1,1,0>;    // Start color of particles <R,G,B>
vector endColor = <1,0,0>;      // End color of particles <R,G,B> (if interpColor == TRUE)
vector startSize = <.5,.5,.5>;     // Start size of particles 
vector endSize = <.1,1,.1>;       // End size of particles (if interpSize == TRUE)
vector push = <0,0,3>;          // Force pushed on particles

// System paramaters
float rate = .1;            // How fast (rate) to emit particles
float radius = .1;          // Radius to emit particles for BURST pattern
integer count = 15;        // How many particles to emit per BURST 
float outerAngle = 1.75;    // Outer angle for all ANGLE patterns
float innerAngle = 1.55;    // Inner angle for all ANGLE patterns
vector omega = <5,1,10>;    // Rotation of ANGLE patterns around the source
float life = 0;             // Life in seconds for the system to make particles

// Script variables
integer flags;

updateParticles()
{
    flags = 0;
    if (target == "owner") target = llGetOwner();
    if (target == "self") target = llGetKey();
    if (glow) flags = flags | PSYS_PART_EMISSIVE_MASK;
    if (bounce) flags = flags | PSYS_PART_BOUNCE_MASK;
    if (interpColor) flags = flags | PSYS_PART_INTERP_COLOR_MASK;
    if (interpSize) flags = flags | PSYS_PART_INTERP_SCALE_MASK;
    if (wind) flags = flags | PSYS_PART_WIND_MASK;
    if (followSource) flags = flags | PSYS_PART_FOLLOW_SRC_MASK;
    if (followVel) flags = flags | PSYS_PART_FOLLOW_VELOCITY_MASK;
    if (target != "") flags = flags | PSYS_PART_TARGET_POS_MASK;

    llParticleSystem([  PSYS_PART_MAX_AGE,age,
                        PSYS_PART_FLAGS,flags,
                        PSYS_PART_START_COLOR, startColor,
                        PSYS_PART_END_COLOR, endColor,
                        PSYS_PART_START_SCALE,startSize,
                        PSYS_PART_END_SCALE,endSize, 
                        PSYS_SRC_PATTERN, pattern,
                        PSYS_SRC_BURST_RATE,rate,
                        PSYS_SRC_ACCEL, push,
                        PSYS_SRC_BURST_PART_COUNT,count,
                        PSYS_SRC_BURST_RADIUS,radius,
                        PSYS_SRC_BURST_SPEED_MIN,minSpeed,
                        PSYS_SRC_BURST_SPEED_MAX,maxSpeed,
                        PSYS_SRC_TARGET_KEY,target,
                        PSYS_SRC_INNERANGLE,innerAngle, 
                        PSYS_SRC_OUTERANGLE,outerAngle,
                        PSYS_SRC_OMEGA, omega,
                        PSYS_SRC_MAX_AGE, life,
                        PSYS_SRC_TEXTURE, texture,
                        PSYS_PART_START_ALPHA, startAlpha,
                        PSYS_PART_END_ALPHA, endAlpha
                            ]);
}


// =====================================================================






// =====================================================================
// CONTROL FUNCTIONS
// =====================================================================


initialize()
{
    update_fire();
    update_sounds();
}


// update particle fire according to particle on/particle off status

update_fire()
{
    if (gParticlesOn)
    {
        updateParticles();
        loop_sound(FIRE_SOUND);
    }
    else
    {
        llParticleSystem([]);
        llStopSound();
    }
    
    update_light();
}


// update light

update_light()
{
    list params;

    if (gParticlesOn)
    {
        params = [ PRIM_POINT_LIGHT, TRUE,
                        gLightsOnVector, gLightIntensity,
                        gLightRadius, gLightFalloff,
                    PRIM_FULLBRIGHT, ALL_SIDES, gPrimFullbright,
                    PRIM_GLOW, ALL_SIDES, gPrimGlow ];
    }
    else
    {
        params = [ PRIM_POINT_LIGHT, FALSE,
                        <1.0,1.0,1.0>, 0.0,
                        0.0, 0.0,
                    PRIM_FULLBRIGHT, ALL_SIDES, 0,
                    PRIM_GLOW, ALL_SIDES, 0.0 ];
    }
    
    llSetPrimitiveParams(params);
}


// loop a sound

loop_sound(string sound)
{
    if (llGetInventoryType(sound) == INVENTORY_SOUND)
    {
        llLoopSound(sound, SOUND_VOLUME);
    }
}



// update environmental sounds
// - this sends a link message to the auxiliary environmental sound script

update_sounds()
{
    llMessageLinked(LINK_SET, gSoundOn, ON_OFF, NULL_KEY);
}


// =====================================================================







// =====================================================================
// STATES
// =====================================================================

default
{
    state_entry()
    {
        initialize();
        llSay(0, "Ready! Click for menu.");
    }

    
    touch_start(integer num)
    {
        integer channel;
        list menu_options = [];
        string display = "";
        string label = "";
        string text = "";
        key id;
        
        id = llDetectedKey(0);
        
        if ((id != llGetOwner()) && gControlByOwnerOnly)
            return;

        do
        {
            channel = (integer) (llFrand(-1000000000.0) - 1000000000.0);
        }
        while (channel == gChannel);
        
        gChannel = channel;
        gDialogListener = llListen(gChannel, "", id, "");

        
        if (id == llGetOwner())
        {        
            if (gControlByOwnerOnly)
            {
                text = "Locked";
                label = "Unlock";
            }
            else
            {
                text = "Unlocked";
                label = "Lock";
            }
    
            menu_options += label;
            display = "Menu control: " + text + "\n";
        }
        
        if (gParticlesOn)
        {
            menu_options += "Fire Off";
            text = "On";
        }
        else
        {
            menu_options += "Fire On";
            text = "Off";
        }
        
        display += "Fire is: " + text + "\n";
                
        if (gSoundOn)
        {
            menu_options += "Sound Off";
            text = "On";
        }
        else
        {
            menu_options += "Sound On";
            text = "Off";
        }
        
        menu_options += "Reset";

        display += "Environmental sounds are: " + text;
        
        display += "\n" + MENU_DIALOG_TEXT;
    
        llDialog(id, display, menu_options, gChannel);
    }


    listen(integer channel, string name, key id, string message)
    {
        if (channel != gChannel)
            return;

        llListenRemove(gDialogListener);
        gDialogListener = 0;
        
        if (message == "Lock")
        {
            gControlByOwnerOnly = 1;
        }
        else if (message == "Unlock")
        {
            gControlByOwnerOnly = 0;
        }
        else if (message == "Fire On")
        {
            gParticlesOn = 1;
            update_fire();
        }
        else if (message == "Fire Off")
        {
            gParticlesOn = 0;
            update_fire();
        }
        else if (message == "Sound On")
        {
            gSoundOn = 1;
            update_sounds();
        }
        else if (message == "Sound Off")
        {
            gSoundOn = 0;
            update_sounds();
        }
        else if (message == "Reset")
        {
            // reset scripts

            gParticlesOn = 0;
            update_fire();
            
            llMessageLinked(LINK_SET, 0, RESET, NULL_KEY);
            llResetScript();
        }
    }

}


// =====================================================================
