//First value is the waiting animation, second and else is for motion. The order is respected!
//Example: list animation = ["wait", "motion1", "motion2", "motionN"];
list ANIMS = ["underyourspell-m-wait", "underyourspell2-m", "underyourspell-m","underyourspell2-m","underyourspell-m"];

string  BUTTON      =   "DANCE";    // text of the pie menu
string  TITLE       =   "DANCE-M";     // floating text
float   TIMEOUT     =   30.0;      // time to play each anim listed 
vector  ROTATION    =   <0,0,0>;   // euler in degrees (like the edit box)
vector  OFFSET      =   <0,0,0.5>; // how far the person sits from the ball. ( <X,Y,Z> )

//do not edit after this line if you are not confortable with programmin languages

string  BALL = "MAL"; integer RUN  = TRUE; integer MAL; integer FEM; integer INDEX;

show() { RUN = TRUE; llSetText(TITLE, <1.0,1.0,1.0> ,1.0); llSetAlpha(1.0, ALL_SIDES); }

hide() { RUN = FALSE; llSetText("", ZERO_VECTOR, FALSE); llSetAlpha(0.0, ALL_SIDES); }

stopAnims() {
    integer i; list anims = llGetAnimationList(llGetPermissionsKey());            
    for (i=0;i<llGetListLength(anims);++i) llStopAnimation(llList2Key(anims, i));
}
    
default {
    state_entry() {
        llSitTarget(OFFSET, llEuler2Rot(ROTATION * DEG_TO_RAD));
        if (llAvatarOnSitTarget()) { llUnSit(llAvatarOnSitTarget()); }
        llSetSitText(BUTTON); if (RUN) show(); else hide(); MAL = FALSE; FEM = FALSE;
    }

    link_message(integer sender_num, integer num, string str, key id) {
        if ((string)id=="BALL") {
            if (str=="MAL") { MAL=num; } else if (str=="FEM") { FEM=num; }
            if (FEM && MAL) { llMessageLinked(LINK_SET, TRUE, "ANIMS", NULL_KEY); }
            else if (FEM || MAL) { llMessageLinked(LINK_SET, FALSE, "ANIMS", NULL_KEY); }
            else { llResetScript(); }
        }
        else if (str=="ANIMS") {
            if (num) { INDEX = 0; llSetTimerEvent(0.01); }
            else { llSetTimerEvent(0.0); if (llAvatarOnSitTarget()) { stopAnims(); llStartAnimation(llList2String(ANIMS,0)); } }
        }
    }

    timer() { if (++INDEX==llGetListLength(ANIMS)) { INDEX=TRUE; } llStartAnimation(llList2String(ANIMS,INDEX)); llSetTimerEvent(TIMEOUT); }
    
    changed(integer change) {
        if(change & CHANGED_LINK) { key avatar = llAvatarOnSitTarget();
            if (avatar!=NULL_KEY) {
                if(llGetPermissionsKey() != avatar) { llRequestPermissions(avatar, PERMISSION_TRIGGER_ANIMATION); }
                hide(); llMessageLinked(LINK_SET, TRUE, BALL, (key)"BALL");
            }
            else if ((llGetPermissionsKey()!=NULL_KEY) && (llGetPermissions() & PERMISSION_TRIGGER_ANIMATION)) {
                show(); llMessageLinked(LINK_SET, FALSE, BALL, (key)"BALL"); stopAnims();
    }    } if (change & CHANGED_INVENTORY) { llResetScript(); }    }

    run_time_permissions(integer perm) {
        key avatar = llAvatarOnSitTarget();
        if(perm & PERMISSION_TRIGGER_ANIMATION && llKey2Name(avatar) != "" && avatar == llGetPermissionsKey()) {
            stopAnims();
            llStartAnimation(llList2String(ANIMS,0));
            hide();
    }   }   }

 