// Scorekeeping Gate
// This script will make the object fall to one side if it is collided with.
// The object will stand back up after 10 seconds
//  For larger objects, It will give a push.
// If the prim is on group owned land, you need to deed it to the land to allow it to push
//
// It is a useful way of making a fence for a horse race that falls over if a horse or avatar touches it.
//
// Author: Ferd Frederix
// http://metaverse.mitsi.com
//
// start of code - this next line may need modifications depending upon the mass of your object

float timervalue = 1.0;    // wait 10 seconds to tilt back up after no more collisions happen
integer channel = 55555;    // a channel number for scorekeeping, the system sends message on the region channel to a scoreboard
integer debug = FALSE;


DEBUG(string str)
{
    if (debug)
        llOwnerSay(llGetScriptName()+":" +  str);                    // Send the owner debug info so you can chase NPCS
}


default
{

    state_entry()
    {
        llVolumeDetect(FALSE);
        llSetStatus(STATUS_PHANTOM, FALSE);          // make it 
        llVolumeDetect(TRUE);
    }

    // when something collides, this collision start will trigger
    collision_start(integer num)
    {
            key mookey = llDetectedKey(0);
            DEBUG("Collide");
            llRegionSay(-991,(string) mookey + "|" + llGetObjectDesc());
            llResetScript();
    }

   
  

    on_rez(integer start_p)
    {
        llResetScript();
    }
}


 