//This script creates a menu of animations to play for your Animesh.
list animations = ["*STOP*", "live","patin"]; //list of up to 11 animations (inside the contents of the Animesh) w/ the stop button.
integer dialogChannel = -100; //Choose a more "random" if you want.
 
string latestAnimation = ""; //used to stop animation when selecting new one
integer listenHandler; //Always create your listener when needed and remove when done
default
{
    touch_start(integer total_number)
    {
        key owner = llGetOwner(); //initialize the variable owner storing llGetOwner because we use it 3 times within this event
        if(llDetectedKey(0) == owner)
        {
            llListenRemove(listenHandler);  //If having touched the object but not select a dialog option the listener will still be active, so remove just in case
            listenHandler = llListen(dialogChannel, "", owner, ""); //Listen to the owner on the dialog channel selected on line 1
            llDialog(owner, "Select an animation.", animations, dialogChannel); //Show a dialog menu to the owner with the animations list (line 0) as the buttons
                                                                                //Only 12 buttons can fit one menu, to do more buttons look into DialogPlus on the wiki
        }
    }
 
    listen(integer channel, string name, key id, string text)
    {
        //Typically you add checks to make sure the right id or channel is used but we clear out any existing ghost listeners prior to listening which prevents us from having to
 
        if(latestAnimation != "" && latestAnimation != "*STOP*") llStopObjectAnimation(latestAnimation); //If latestAnimation isn't blank AND isn't *STOP*, stop the latestAnimation
        if(text != "*STOP*") llStartObjectAnimation(text); //If the button pressed was not *STOP*, play the animation selected
        latestAnimation = text; //Set the latestAnimation to the button pressed so when this event is ran again we can stop the animation
        llListenRemove(listenHandler); //Remove the listener since we are done
    }
} 