string  BTN_START = "BTN_START";
string  CMD_START = "CMD_START";
string  CMD_RESET = "CMD_RESET";

integer TOP_SIDE = 0;
integer SIDE_SIDE = 2;
vector  REPEAT_ONCE = <1.0, 1.0, 0.0>;
vector  WHITE = <1.0, 1.0, 1.0>;
vector  GREY = <0.3, 0.3, 0.3>;
key     BLANK = "5748decc-f629-461c-9a36-a35a221fe21f";
key     LABEL = "319d0038-04fb-41df-82c0-ff9a7b8b157d";

hide()
{
    llSetPrimitiveParams([
        PRIM_COLOR, ALL_SIDES, GREY, 0.0,
        PRIM_COLOR, TOP_SIDE, WHITE, 0.0,
        PRIM_BUMP_SHINY, SIDE_SIDE, PRIM_SHINY_HIGH, PRIM_BUMP_SHINY,
        PRIM_TEXTURE, ALL_SIDES, (string)BLANK, REPEAT_ONCE, ZERO_VECTOR, 0.0,
        PRIM_TEXTURE, TOP_SIDE, (string)LABEL, REPEAT_ONCE, ZERO_VECTOR, 0.0]);

    llSetPos(<0.175,0.0,-0.01>);
}

show() 
{
    llSetPrimitiveParams([
        PRIM_COLOR, ALL_SIDES, GREY, 1.0,
        PRIM_COLOR, TOP_SIDE, WHITE, 1.0,
        PRIM_BUMP_SHINY, SIDE_SIDE, PRIM_SHINY_HIGH, PRIM_BUMP_SHINY,
        PRIM_TEXTURE, ALL_SIDES, (string)BLANK, REPEAT_ONCE, ZERO_VECTOR, 0.0,
        PRIM_TEXTURE, TOP_SIDE, (string)LABEL, REPEAT_ONCE, ZERO_VECTOR, 0.0]);

    llSetPos(<0.175,0.0,0.01>);
}

default
{
    state_entry()
    {
        show();
    }

    on_rez(integer start_param)
    {
        llResetScript();
    }

    touch_start(integer total_number)
    {
        llPlaySound("NEW selection click", 1);
        
        llMessageLinked( LINK_SET, -1, BTN_START,(key) llDetectedKey(0) );
    }

    link_message(integer sender_number, integer number, string message, key id)
    {
        list msgParts = llParseString2List(message, [" "], []);
        string cmd = llList2String(msgParts, 0);

        if(cmd == CMD_RESET)
        {
            llResetScript();
        }
        else if(cmd == CMD_START)
        {
            state HIDE;
        }
    }
}

state HIDE
{
    state_entry()
    {
        hide();
    }

    link_message(integer sender_number, integer number, string message, key id)
    {
        list msgParts = llParseString2List(message, [" "], []);
        string cmd = llList2String(msgParts, 0);

        if(cmd == CMD_RESET)
        {
            llResetScript();
        }
    }
}