string ggKey2Name(key id)
    {
        return llList2String(llParseString2List(llList2String(llParseString2List(llKey2Name(id), [" "], []), 0), ["."], []), 0);
        
    }

string ggGetLinkDesc(integer linkNr)
    {
        list    data    =   [];
        data    =   llGetLinkPrimitiveParams(linkNr, [ PRIM_DESC ]);
        return  llList2String(data, 0);
    }
    
string ggGetLinkName(integer linkNr)
    {
        list    data    =   [];
        data    =   llGetLinkPrimitiveParams(linkNr, [ PRIM_NAME ]);
        return  llList2String(data, 0);
    }
    
string ggStr_replace(string subject, string search, string replace)
    {
        return llDumpList2String(llParseStringKeepNulls(subject, [search], []), replace);
    }

string ggLeft(string src, string divider)
    {
        integer index = llSubStringIndex( src, divider );
        if(~index)return llDeleteSubString( src, index, -1);
        return src;
    }
    
string ggRight(string src, string divider) 
    {
        integer index = llSubStringIndex( src, divider );
        if(~index)return llDeleteSubString( src, 0, index + llStringLength(divider) - 1);
        return src;
    }
    
string ggGetFigurFarbe(integer linkNr)
    {
        string  beschreibung    =   ggGetLinkDesc(linkNr);
        string  farbe           =   ggLeft(ggLeft(beschreibung, " "), ";");
        return  farbe;
    }
    
string ggGetSpielerFace2Farbe(integer face) 
    {
        if(face == 3)return "Rot";
        if(face == 2)return "Rosa";
        if(face == 0)return "Blau";
        if(face == 1)return "Hellblau";
        if(face == 4)return "Grun";
        if(face == 5)return "Gelb";
        if(face == 7)return "Oronge";
        if(face == 6)return "Pink";
        return "";
    }
    
string ggGetAugenTexturName(integer zahl)
    {
        if(zahl == 1)return "1";
        if(zahl == 2)return "2";
        if(zahl == 3)return "3";
        if(zahl == 4)return "4";
        if(zahl == 5)return "5";
        if(zahl == 6)return "6";
        if(zahl == 7)return "7";
        if(zahl == 8)return "8";
        return "0";
    }
    
string ggKey2Farbe(key AvatarKey) 
    {
        if(SpielerRot        == AvatarKey)return "Rot";
        if(SpielerRosa        == AvatarKey)return "Rosa";
        if(SpielerBlau        == AvatarKey)return "Blau";
        if(SpielerHellBlaut    == AvatarKey)return "Hellblau";
        if(SpielerGrun        == AvatarKey)return "Grun";
        if(SpielerGelb        == AvatarKey)return "Gelb";
        if(SpielerOronge    == AvatarKey)return "Oronge";
        if(SpielerPink        == AvatarKey)return "Pink";
        return "NONE";
    }
    
string ggGetNachsterSpieler(string aktuellerSpieler)
    {
        if(debug)llSay(0,"Starte funktion: ggGetNachsterSpieler("+(string)aktuellerSpieler+")");
        integer    AuswahlGestartet    =    0;
        
        while(1)
        {
            if(SpielerRot != NULL_KEY)
            {
                if(AuswahlGestartet)return "Rot";
                if(aktuellerSpieler == "Rot")AuswahlGestartet        =    1;
            }else{
                if(aktuellerSpieler == "Rot")AuswahlGestartet        =    1;
            }
            
            if(SpielerPink != NULL_KEY)
            {
                if(AuswahlGestartet)return "Pink";
                if(aktuellerSpieler == "Pink")AuswahlGestartet        =    1;
            }else{
                if(aktuellerSpieler == "Pink")AuswahlGestartet        =    1;
            }
            
            if(SpielerOronge != NULL_KEY)
            {
                if(AuswahlGestartet)return "Oronge";
                if(aktuellerSpieler == "Oronge")AuswahlGestartet    =    1;
            }else{
                if(aktuellerSpieler == "Oronge")AuswahlGestartet    =    1;
            }
            
            if(SpielerGelb != NULL_KEY)
            {
                if(AuswahlGestartet)return "Gelb";
                if(aktuellerSpieler == "Gelb")AuswahlGestartet        =    1;
            }else{
                if(aktuellerSpieler == "Gelb")AuswahlGestartet        =    1;
            }
            
            if(SpielerGrun != NULL_KEY)
            {
                if(AuswahlGestartet)return "Grun";
                if(aktuellerSpieler == "Grun")AuswahlGestartet        =    1;
            }else{
                if(aktuellerSpieler == "Grun")AuswahlGestartet        =    1;
            }
            
            if(SpielerHellBlaut != NULL_KEY)
            {
                if(AuswahlGestartet)return "Hellblau";
                if(aktuellerSpieler == "Hellblau")AuswahlGestartet    =    1;
            }else{
                if(aktuellerSpieler == "Hellblau")AuswahlGestartet    =    1;
            }
            
            if(SpielerBlau != NULL_KEY)
            {
                if(AuswahlGestartet)return "Blau";
                if(aktuellerSpieler == "Blau")AuswahlGestartet        =    1;
            }else{
                if(aktuellerSpieler == "Blau")AuswahlGestartet        =    1;
            }
            
            if(SpielerRosa != NULL_KEY)
            {
                if(AuswahlGestartet)return "Rosa";
                if(aktuellerSpieler == "Rosa")AuswahlGestartet        =    1;
            }else{
                if(aktuellerSpieler == "Rosa")AuswahlGestartet        =    1;
            }
        }
        
        return "";
    } 

integer ggrandInt(integer n)
    {
        return (integer)llFrand(n + 1);
    }

integer ggrandIntBetween(integer min, integer max)
    {
        return min + ggrandInt(max - min);
    }
    
integer ggGetFigurStellplatz(integer linkNr)
    {
        string  beschreibung    =   ggGetLinkDesc(linkNr);
        integer position        =   (integer)ggRight(ggRight(ggLeft(beschreibung, " "), ";"), ";");
        return  position;
    }
    
integer ggGetFigurNummer(integer linkNr)
    {
        string  beschreibung    =   ggGetLinkDesc(linkNr);
        integer nummer          =   (integer)ggLeft(ggRight(ggLeft(beschreibung, " "), ";"), ";");
        return  nummer;
    }
    
integer ggGetFigurSchritte(integer linkNr)
    {
        string  beschreibung    =   ggGetLinkDesc(linkNr);
        integer nummer          =   (integer)ggRight(beschreibung, " ");
        return  nummer;
    }

integer ggGetSpielerOffset(string farbe) 
    {
        if(farbe == "Rot")return 0;
        if(farbe == "Rosa")return 10;
        if(farbe == "Blau")return 20;
        if(farbe == "Hellblau")return 30;
        if(farbe == "Grun")return 40;
        if(farbe == "Gelb")return 50;
        if(farbe == "Oronge")return 60;
        if(farbe == "Pink")return 70;
        return 0;
    }
    
integer ggGetFarbe2SpielerFace(string farbe) 
    {
        if(farbe == "Rot")return 3;
        if(farbe == "Rosa")return 2;
        if(farbe == "Blau")return 0;
        if(farbe == "Hellblau")return 1;
        if(farbe == "Grun")return 4;
        if(farbe == "Gelb")return 5;
        if(farbe == "Oronge")return 7;
        if(farbe == "Pink")return 6;
        return 0;
    }

integer ggGetIsFirstPlayer() 
    {
        if(SpielerRot        != NULL_KEY)return 0;
        if(SpielerRosa        != NULL_KEY)return 0;
        if(SpielerBlau        != NULL_KEY)return 0;
        if(SpielerHellBlaut    != NULL_KEY)return 0;
        if(SpielerGrun        != NULL_KEY)return 0;
        if(SpielerGelb        != NULL_KEY)return 0;
        if(SpielerOronge    != NULL_KEY)return 0;
        if(SpielerPink        != NULL_KEY)return 0;
        return 1;
    }
    
integer ggGetPlayerStartPosition(string farbe)
    {
        if(debug)llSay(0,"Starte funktion: ggGetPlayerStartPosition("+farbe+")");
        integer startposition   =   1 + ggGetSpielerOffset(farbe);
        return startposition;
    }
    
integer ggCheckPlayerHaveFigurOut(string farbe)
    {
        if(debug)llSay(0,"Starte funktion: ggCheckPlayerHaveFigurOut("+farbe+")");
        integer primAnzahl      =   llGetNumberOfPrims() + 1;
        integer figurenDraussen =   0;
            
        while(primAnzahl--)
        {
            if(ggGetLinkName(primAnzahl) == "figur")
            {
                if((string)ggGetFigurFarbe(primAnzahl) == farbe)
                {
                    if(ggGetFigurStellplatz(primAnzahl) >= 1 & ggGetFigurStellplatz(primAnzahl) <= 113)figurenDraussen  =   figurenDraussen + 1;
                    if(figurenDraussen == 4)return 1;
                }
            }
        }
        
        if(figurenDraussen)return 1;
        return 0;
    }    
    
integer ggCheckPlayerHaveFigurInField(string farbe)
    {
        if(debug)llSay(0,"Starte funktion: ggCheckPlayerHaveFigurInField("+farbe+")");
        integer primAnzahl      =   llGetNumberOfPrims() + 1;
        integer figurenDraussen =   0;
        
        while(primAnzahl--)
        {
            if(ggGetLinkName(primAnzahl) == "figur")
            {
                if((string)ggGetFigurFarbe(primAnzahl) == farbe)
                {
                    if(ggGetFigurStellplatz(primAnzahl) >= 1 & ggGetFigurStellplatz(primAnzahl) <= 80)figurenDraussen  =   figurenDraussen + 1;
                    if(figurenDraussen == 4)return 1;
                }
            }
        }
        
        if(figurenDraussen)return 1;
        return 0;
    }    
    
integer ggCheckPlayerHaveAllIn(string farbe)
    {
        if(debug)llSay(0,"Starte funktion: ggCheckPlayerHaveAllIn("+farbe+")");
        integer primAnzahl      =   llGetNumberOfPrims() + 1;
        integer figurenDrinnen =   0;
        
        while(primAnzahl--)
        {
            if(ggGetLinkName(primAnzahl) == "figur")
            {
                if((string)ggGetFigurFarbe(primAnzahl) == farbe)
                {
                    if(ggGetFigurSchritte(primAnzahl) >= 80)figurenDrinnen  =   figurenDrinnen + 1;
                }
            }
        }
        
        if(figurenDrinnen == 4)return 1;
        return 0;
    }  
    
integer ggGetStellplatzIstBelegt(integer Stellplatz)
    {
        if(debug)llSay(0,"Starte funktion: ggChekIsStellplatzBusy("+(string)Stellplatz+")");
        integer primAnzahl      =   llGetNumberOfPrims() + 1;
            
        while(primAnzahl--)
        {
            if(ggGetLinkName(primAnzahl) == "figur")
            {
                if((integer)ggGetFigurStellplatz(primAnzahl) == Stellplatz)
                {
                    return 1;
                }
            }
        }

        return 0;
    }
    
    
integer ggGetNachsterStellplatz(integer linkNr, integer schritte)
    {
        if(debug)llSay(0,"Starte funktion: ggGetNachsterStellplatz("+(string)linkNr+", "+(string)schritte+")");
        integer     NeuePosition    =   ggGetFigurStellplatz(linkNr) + schritte;
        
        if((NeuePosition > 80))NeuePosition   =   NeuePosition    -   80;
        
        if((ggGetFigurSchritte(linkNr) + schritte) >= 80)
        {
            list    zielStellplatzListe    =    ggGetTargetPositionListe(ggGetFigurFarbe(linkNr));
            
            if((ggGetFigurSchritte(linkNr) + schritte) == 80)NeuePosition        =    (integer)llList2String(zielStellplatzListe, 0);
            if((ggGetFigurSchritte(linkNr) + schritte) == 81)NeuePosition        =    (integer)llList2String(zielStellplatzListe, 1);
            if((ggGetFigurSchritte(linkNr) + schritte) == 82)NeuePosition        =    (integer)llList2String(zielStellplatzListe, 2);
            if((ggGetFigurSchritte(linkNr) + schritte) == 83)NeuePosition        =    (integer)llList2String(zielStellplatzListe, 3);
        }
        
        return NeuePosition;
    } 
    
integer ggGetIstGehenMoglich(string farbe)
    {
        if(debug)llSay(0,"Starte funktion: ggGetIstGehenMoglich ("+farbe+")");
        integer GehenMoglich    =    0;
        integer insgesamtGehenMoglich    =    0;
        
        integer primAnzahl      =   llGetNumberOfPrims() + 1;
            
        while(primAnzahl--)
        {
            if(ggGetLinkName(primAnzahl) == "figur")
            {
                if(ggGetFigurFarbe(primAnzahl) == farbe)
                {                    
                    //if(ggCheckPlayerHaveFigurOut(ggGetFigurFarbe(llDetectedLinkNumber(0))))
                    if((!Wurfel1Benutzt) & ggGetIstGehenMoglichMitFigur(primAnzahl, wurfel1augen))GehenMoglich = 1;
                    if((!Wurfel2Benutzt) & ggGetIstGehenMoglichMitFigur(primAnzahl, wurfel2augen))GehenMoglich = 1;
                    //if((!(Wurfel1Benutzt + Wurfel2Benutzt)) & ggGetIstGehenMoglichMitFigur(primAnzahl, (wurfel1augen + wurfel2augen)))GehenMoglich = 1;
                }
            }
        }

        return GehenMoglich;
    }
    
integer ggGetIstGehenMoglichMitFigur(integer linkNr, integer schritte)
    {
        if(debug)llSay(0,"Starte funktion: ggGetIstGehenMoglichMitFigur ("+(string)linkNr+", "+(string)schritte+")");
        integer GehenMoglich    =    0;
        
        if(ggGetFigurSchritte(linkNr) == 0)
        {
            if(ggGetFigurStellplatz(linkNr) >= 1 & ggGetFigurStellplatz(linkNr) <= 80)
            {
                GehenMoglich = 1;
            }else{
                if(schritte == 6)
                {
                    GehenMoglich = 1;
                }
            }
        }else{
            if((ggGetFigurSchritte(linkNr) + schritte) <= 83)
            {
                if((ggGetFigurSchritte(linkNr) + schritte) >= 80)
                {
                    if(!ggGetStellplatzIstBelegt(ggGetNachsterStellplatz(linkNr, schritte)))
                    {
                        GehenMoglich = 1;
                    }
                }else{
                    GehenMoglich = 1;
                }
            }
        }

        return GehenMoglich;
    }
    
integer ggGetAusgewehlteAugenzahl()
    {
        if(debug)llSay(0,"Starte funktion: getAusgewehlteAugenzahl");
        
        integer augenzahlZusammen = 0;
                
        if((Wurfel1Ausgewehlt == 1) & (Wurfel1Benutzt == 0))
        {
            augenzahlZusammen     = augenzahlZusammen + wurfel1augen;
            AlteWurfel1augen    =    wurfel1augen;
        }
        
        if((Wurfel2Ausgewehlt == 1) & (Wurfel2Benutzt == 0))
        {
            augenzahlZusammen     = augenzahlZusammen + wurfel2augen;
            AlteWurfel2augen    =    wurfel2augen;
        }
        
        return augenzahlZusammen;
    }

vector ggGetLinkColor(integer linkNr, integer face)
    {
        list    data    =   [];
        data    =   llGetLinkPrimitiveParams(linkNr, [ PRIM_COLOR, face]);
        return  (vector)llList2String(data, 0);
    }
    
vector ggStellplatz2Position(integer Stellplatz)
    {
        if(debug)llSay(0,"Starte funktion: ggStellplatz2Position("+(string)Stellplatz+")");
        vector position    =   (vector)llList2String(Positionen, (Stellplatz - 1));
        return position;
    }
    
key ggFarbe2SpielerKey(string farbe) 
    {
        if(farbe == "Rot")return SpielerRot;
        if(farbe == "Rosa")return SpielerRosa;
        if(farbe == "Blau")return SpielerBlau;
        if(farbe == "Hellblau")return SpielerHellBlaut;
        if(farbe == "Grun")return SpielerGrun;
        if(farbe == "Gelb")return SpielerGelb;
        if(farbe == "Oronge")return SpielerOronge;
        if(farbe == "Pink")return SpielerPink;
        return NULL_KEY;
    }

list ggGetTargetPositionListe(string farbe) 
    {
        if(farbe == "Rot")return ZielPositionenRot;
        if(farbe == "Rosa")return ZielPositionenRosa;
        if(farbe == "Blau")return ZielPositionenBlau;
        if(farbe == "Hellblau")return ZielPositionenHellblau;
        if(farbe == "Grun")return ZielPositionenGrun;
        if(farbe == "Gelb")return ZielPositionenGelb;
        if(farbe == "Oronge")return ZielPositionenOronge;
        if(farbe == "Pink")return ZielPositionenPink;
        return ZielPositionenRot;
    }
    
list ggGetHomePositionListe(string farbe) 
    {
        if(farbe == "Rot")return StartPositionenRot;
        if(farbe == "Rosa")return StartPositionenRosa;
        if(farbe == "Blau")return StartPositionenBlau;
        if(farbe == "Hellblau")return StartPositionenHellblau;
        if(farbe == "Grun")return StartPositionenGrun;
        if(farbe == "Gelb")return StartPositionenGelb;
        if(farbe == "Oronge")return StartPositionenOronge;
        if(farbe == "Pink")return StartPositionenPink;
        return StartPositionenRot;
    }
    
    
ggSetLinkDesc(integer linkNr, string Text)
    {
        llSetLinkPrimitiveParamsFast(linkNr, [ PRIM_DESC, Text]);
    }
    
ggSetLinkTexture(integer linkNr, string Texturname, integer face)
    {
        llSetLinkPrimitiveParamsFast(linkNr, [ PRIM_TEXTURE, face, Texturname, <1, 1, 1>, <1, 1, 1>, 1.5707963267949 ]);
    }
    
ggSetLinkColor(integer linkNr, integer face, vector color, float alpha)
    {
        llSetLinkPrimitiveParamsFast(linkNr, [ PRIM_COLOR, face, color, alpha]);
    }
    
ggSetLinkGlow(integer linkNr, integer face, float intensity)
    {
        llSetLinkPrimitiveParamsFast(linkNr, [ PRIM_GLOW, face, intensity ]);
    }
    
ggSetFigurPosition(integer linkNr, vector position)
    {
        llSetLinkPrimitiveParamsFast(linkNr, [ PRIM_POS_LOCAL, position]);
    }
    
ggSchreibeFigurBeschreibung(integer linkNr, string farbe, integer nummer, integer stellplatz, integer schritte)
    {
        ggSetLinkDesc(linkNr, (string)farbe + ";" + (string)nummer + ";" + (string)stellplatz + " " + (string)schritte);
    }
    
ggSetSpielerKey(string farbe, key SpielerKey) 
    {
        if(farbe == "Rot")SpielerRot                =    SpielerKey;
        if(farbe == "Rosa")SpielerRosa                =    SpielerKey;
        if(farbe == "Blau")SpielerBlau                =    SpielerKey;
        if(farbe == "Hellblau")SpielerHellBlaut        =    SpielerKey;
        if(farbe == "Grun")SpielerGrun                =    SpielerKey;
        if(farbe == "Gelb")SpielerGelb                =    SpielerKey;
        if(farbe == "Oronge")SpielerOronge            =    SpielerKey;
        if(farbe == "Pink")SpielerPink                =    SpielerKey;
    }

ggResetAllStartPositionen()
    {
        ggResetStartPositionen("Rot", StartPositionenRot);
        ggResetStartPositionen("Rosa", StartPositionenRosa);
        ggResetStartPositionen("Blau", StartPositionenBlau);
        ggResetStartPositionen("Hellblau", StartPositionenHellblau);
        ggResetStartPositionen("Grun", StartPositionenGrun);
        ggResetStartPositionen("Gelb", StartPositionenGelb);
        ggResetStartPositionen("Oronge", StartPositionenOronge);
        ggResetStartPositionen("Pink", StartPositionenPink);
    }
    
ggRemoveAllPlayerFromGame()
    {
        ggRemovePlayerFromGame("Rot");
        ggRemovePlayerFromGame("Rosa");
        ggRemovePlayerFromGame("Blau");
        ggRemovePlayerFromGame("Hellblau");
        ggRemovePlayerFromGame("Grun");
        ggRemovePlayerFromGame("Gelb");
        ggRemovePlayerFromGame("Oronge");
        ggRemovePlayerFromGame("Pink");
    }
    
ggRemovePlayerFromGame(string farbe)
    {
        if(debug)llSay(0,"Starte funktion: ggRemovePlayerFromGame("+farbe+")");
        integer primAnzahl      =   llGetNumberOfPrims() + 1;
            
        while(primAnzahl--)
        {
            if(ggGetLinkName(primAnzahl) == "player")
            {
                ggSetLinkColor(primAnzahl, ggGetFarbe2SpielerFace(farbe), ggGetLinkColor(primAnzahl, ggGetFarbe2SpielerFace(farbe)), 0.4);
                ggSetLinkGlow(primAnzahl, ggGetFarbe2SpielerFace(farbe), 0);
            }
        }
        
        ggSetSpielerKey(farbe, NULL_KEY);
        ggSetPunkte(farbe, 0);
        ggResetStartPositionen(farbe, ggGetHomePositionListe(farbe));
        if(SpielerIstDran == farbe)ggNachsterSpieler(1);
        
    }
    
ggPlayerJoinGame(key player, integer face)
    {
        if(debug)llSay(0,"Starte funktion: ggPlayerJoinGame("+(string)player+", "+(string)face+")");
        integer primAnzahl      =   llGetNumberOfPrims() + 1;
            
        while(primAnzahl--)
        {
            if(ggGetLinkName(primAnzahl) == "player")
            {
                if(ggGetIsFirstPlayer())
                {
                    ggSetSpielerKey(ggGetSpielerFace2Farbe(face), player);
                    ggSetLinkColor(primAnzahl, face, ggGetLinkColor(primAnzahl, face), 0.8);
                    SpielerIstDran    =    ggGetSpielerFace2Farbe(face);
                    ggNachsterSpieler(1);
                    ggCleanWurfel(1);
                    ggCleanWurfel(2);
                }else{
                    ggSetSpielerKey(ggGetSpielerFace2Farbe(face), player);
                    ggSetLinkColor(primAnzahl, face, ggGetLinkColor(primAnzahl, face), 0.8);
                }
            }
        }
    }
    
ggResetStartPositionen(string farbe, list positionenListe)
    {
        if(debug)llSay(0,"Starte funktion: ggResetStartPositionen("+farbe+", "+(string)llDumpList2String(positionenListe, ";")+")");
        integer primAnzahl      =   llGetNumberOfPrims() + 1;
            
        while(primAnzahl--)
        {
            if(ggGetLinkName(primAnzahl) == "figur")
            {
                if((string)ggGetFigurFarbe(primAnzahl) == farbe)
                {
                    ggdoFigurBackinHome(primAnzahl);
                }
            }
        }
    }

ggdoFigurBackinHome(integer linkNr)
    {
        if(debug)llSay(0,"Starte funktion: ggdoFigurBackinHome("+(string)linkNr+")");
        list    positionenListe =   ggGetHomePositionListe(ggGetFigurFarbe(linkNr));
        ggSetFigurPosition(linkNr, ggStellplatz2Position((integer)llList2String(positionenListe, (ggGetFigurNummer(linkNr) - 1))));
        ggSchreibeFigurBeschreibung(linkNr, ggGetFigurFarbe(linkNr),  ggGetFigurNummer(linkNr), 0, 0);
    }    
    
ggPrufeStellplatzSchonBelegt(integer stellplatz)
    {
        if(debug)llSay(0,"Starte funktion: ggPrufeStellplatzSchonBelegt("+(string)stellplatz+")");
        integer primAnzahl      =   llGetNumberOfPrims() + 1;
            
        while(primAnzahl--)
        {
            if(ggGetLinkName(primAnzahl) == "figur")
            {
                if(ggGetFigurStellplatz(primAnzahl) == stellplatz)
                {
                    if(ggGetFigurFarbe(primAnzahl) != SpielerIstDran)
                    {
                        ggChat(ggLeft(ggKey2Name(ggFarbe2SpielerKey(ggGetFigurFarbe(primAnzahl))), " "), SPRACHE_SPIELER_WURDE_GEKICKT);
                        rundenWiederholen = rundenWiederholen + 1;
                        ggdoFigurBackinHome(primAnzahl);
                        ggAddPunkte(SpielerIstDran, 1);
                        if(ggGetPunkte(ggGetFigurFarbe(primAnzahl)) != 0)ggSetPunkte(ggGetFigurFarbe(primAnzahl), ggGetPunkte(ggGetFigurFarbe(primAnzahl)) - 1);
                    }else{
                        ggChat("", SPRACHE_SPIELER_SELBER_GEKICKT);
                        ggdoFigurBackinHome(primAnzahl);
                    }
                }
            }
        }
    }    

ggwurfelRoll() 
    {
        if(debug)llSay(0,"Starte funktion: ggwurfelRoll");
        Wurfel1Ausgewehlt     =    0;
        Wurfel2Ausgewehlt     =    0;
        Wurfel1Benutzt        =    0;
        Wurfel2Benutzt        =    0;
        
        integer    WurfelVorgangFertig    =    0;
        
        integer    Seckser   =    ggrandIntBetween(1, 30);
        integer    noPash    =    ggrandIntBetween(1, 10);
        integer durchlauf    =    0;
        
        while(WurfelVorgangFertig == 0)
        {
            durchlauf         =    durchlauf + 1;
            
            wurfel1augen    =   ggrandIntBetween(1, 6);
            wurfel2augen    =   ggrandIntBetween(1, 6);
                    
                    
            if(!ggCheckPlayerHaveFigurOut(SpielerIstDran))
            {
                if(Seckser == 7)wurfel1augen      = 6;
                if(Seckser == 13)wurfel1augen     = 6;
                if(Seckser == 18)wurfel1augen     = 6;
                if(Seckser == 22)wurfel1augen     = 6;
                
                if(Seckser == 16)wurfel2augen     = 6;
                if(Seckser == 21)wurfel2augen     = 6;
                if(Seckser == 27)wurfel2augen     = 6;
                if(Seckser == 28)wurfel2augen     = 6;
            }
            
            if(!ggCheckPlayerHaveFigurInField(SpielerIstDran))
            {
                if(Seckser == 5)wurfel1augen      = 6;
                if(Seckser == 18)wurfel1augen     = 6;
                if(Seckser == 19)wurfel1augen     = 6;
                if(Seckser == 22)wurfel1augen     = 6;
                
                if(Seckser == 9)wurfel2augen      = 6;
                if(Seckser == 12)wurfel2augen     = 6;
                if(Seckser == 23)wurfel2augen     = 6;
                if(Seckser == 27)wurfel2augen     = 6;
            }
            
            if(ggCheckPlayerHaveFigurOut(SpielerIstDran))
            {
                if(Seckser == 7)wurfel1augen      = 3;
                if(Seckser == 13)wurfel1augen     = 3;
                if(Seckser == 8)wurfel1augen      = 3;
                
                if(Seckser == 16)wurfel2augen     = 3;
                if(Seckser == 21)wurfel2augen     = 3;
                if(Seckser == 22)wurfel2augen     = 3;
                
                if(Seckser == 2)wurfel1augen      = 2;
                if(Seckser == 6)wurfel1augen      = 2;
                if(Seckser == 12)wurfel1augen     = 2;
                
                if(Seckser == 3)wurfel2augen      = 2;
                if(Seckser == 15)wurfel2augen     = 2;
                if(Seckser == 20)wurfel2augen     = 2;
                
                if(Seckser == 5)wurfel1augen      = 1;
                if(Seckser == 11)wurfel1augen     = 1;
                if(Seckser == 17)wurfel1augen     = 1;
                
                if(Seckser == 14)wurfel2augen     = 1;
                if(Seckser == 18)wurfel2augen     = 1;
                if(Seckser == 19)wurfel2augen     = 1;
            }
            
            if((wurfel1augen != AlteWurfel1augen) & (wurfel2augen != AlteWurfel2augen) & (wurfel1augen != AlteWurfel2augen) & (wurfel2augen != AlteWurfel1augen))
            {
                if((wurfel1augen != 6) | (wurfel2augen != 6))
                {
                    if((noPash >= 6 & (wurfel1augen != wurfel2augen)))
                    {
                        WurfelVorgangFertig    =    1;
                    }else{
                        if(noPash <= 5)
                        {
                            WurfelVorgangFertig    =    1;
                        }
                    }
                }else{
                    durchlauf    =    durchlauf - 1;
                }
            }
            
            if(durchlauf == 40)WurfelVorgangFertig    =    1;
        }
            
        if(rundenWiederholen != 0)rundenWiederholen = rundenWiederholen - 1;
        if(wurfel1augen == wurfel2augen)rundenWiederholen = rundenWiederholen + 1;
        
        ggzeigeWurfelAugen(1, wurfel1augen, 1);
        ggzeigeWurfelAugen(2, wurfel2augen, 1);
    }
    
ggzeigeWurfelAugen(integer wurfelNummer, integer ausgenzahl, integer status) 
    {
        if(debug)llSay(0,"Starte funktion: ggzeigeWurfelAugen");
        integer     primAnzahl  =   llGetNumberOfPrims() + 1;
        integer        faceNr;    
            
        if(wurfelNummer == 1)faceNr  =   1;
        if(wurfelNummer == 2)faceNr  =   3;  
        
        while(primAnzahl--)
        {            
            if((string)ggGetLinkName(primAnzahl) == "mitte")
            {
                ggSetLinkTexture(primAnzahl, ggGetAugenTexturName(ausgenzahl), faceNr);
                ggSetLinkColor(primAnzahl, faceNr, <1, 1, 1>, 1);
            }
        }
    }
    
ggCleanWurfel(integer wurfelNummer) 
    {
        if(debug)llSay(0,"Starte funktion: ggCleanWurfel");
        integer     primAnzahl    =    llGetNumberOfPrims() + 1;
        integer     faceNr;
  
        if(wurfelNummer == 1)faceNr  =   1;
        if(wurfelNummer == 2)faceNr  =   3;  
            
        Wurfel1Benutzt        =    1;
        Wurfel2Benutzt        =    1;
        
        while(primAnzahl--)
        {        
            if((string)ggGetLinkName(primAnzahl) == "mitte")
            {
                ggSetLinkTexture(primAnzahl, "0", faceNr);
                ggSetLinkColor(primAnzahl, faceNr, <1, 1, 1>, 1);
            }
        }
    }
    
ggDisableWurfel(integer wurfelNummer) 
    {
        if(debug)llSay(0,"Starte funktion: ggCleanWurfel");
        integer     primAnzahl    =    llGetNumberOfPrims() + 1;
        integer     faceNr;
        
        if(wurfelNummer == 1)faceNr  =   1;
        if(wurfelNummer == 2)faceNr  =   3;  
            
        Wurfel1Benutzt        =    1;
        Wurfel2Benutzt        =    1;
        
        while(primAnzahl--)
        {        
            if((string)ggGetLinkName(primAnzahl) == "mitte")
            {
                ggSetLinkColor(primAnzahl, faceNr, <0.161, 0.161, 0.161>, 1);
            }
        }
    }

ggNachsterSpieler(integer force)
    {
        if(debug)llSay(0,"Starte funktion: ggNachsterSpieler");
        string    letzterSpieler    =    SpielerIstDran;
        
        if(force)rundenWiederholen = 0;
        
        if(ggCheckPlayerHaveAllIn(SpielerIstDran))
        {
            ggChat(" ", SPRACHE_SPIEL_GEWONNEN);
            llResetScript();
        }else{
            if((Wurfel1Benutzt & Wurfel2Benutzt) | !ggGetIstGehenMoglich(SpielerIstDran))
            {
                if(rundenWiederholen)
                {
                    ggChat(" ", SPRACHE_DU_BIST_NOCHMAL);
                    ggAddPunkte(SpielerIstDran, 1);
                    ggDisableWurfel(1);
                    ggDisableWurfel(2);
                }else{
                    if(ggGetIsFirstPlayer())
                    {
                        ggChat(" ", SPRACHE_KEINE_SPIELER_MEHR);
                    }else{
                        SpielerIstDran    =    ggGetNachsterSpieler(letzterSpieler);
                        
                        integer primAnzahl      =   llGetNumberOfPrims() + 1;
                            
                        while(primAnzahl--)
                        {
                            if(ggGetLinkName(primAnzahl) == "player")
                            {
                                ggSetLinkGlow(primAnzahl, ggGetFarbe2SpielerFace(letzterSpieler), 0);
                                ggSetLinkGlow(primAnzahl, ggGetFarbe2SpielerFace(SpielerIstDran), 0.6);
                            }
                        }
                        
                        ggChat("", SPRACHE_IST_JETZT_DRAN);
                        
                        ggDisableWurfel(1);
                        ggDisableWurfel(2);
                    }
                }
            }
        }
        
        ResetPunkte = 0;
    }

ggChat(string player, string text)
    {
        if(debug)llSay(0,"Starte funktion: ggChat");
        string    SpielName    =    llGetObjectName();
        llSetObjectName("--> ");
        string    ausgabe    =    ggStr_replace(text, "%CurrentPlayer%", ggKey2Name(ggFarbe2SpielerKey(SpielerIstDran)));
        ausgabe    =    ggStr_replace(ausgabe, "%Player%", player);
        ausgabe    =    ggStr_replace(ausgabe, "%CurrentPlayerPunkte%", (string)ggGetPunkte(SpielerIstDran));
        
        llSay(0, ausgabe);
        llSetObjectName(SpielName);
    }
    
ggAusgewahlteWurfelBenutzen()
    {
        if(debug)llSay(0,"Starte funktion: ggAusgewahlteWurfelBenutzen");
        
        integer augenzahlZusammen = 0;
        
        integer primAnzahl      =   llGetNumberOfPrims() + 1;
                            
        while(primAnzahl--)
        {
            if(ggGetLinkName(primAnzahl) == "mitte")
            {
                if((Wurfel1Ausgewehlt == 1) & (Wurfel1Benutzt == 0))
                {
                    Wurfel1Benutzt     = 1;
                    ggSetLinkColor(primAnzahl, 1, <1.000, 0.345, 0.345>, 1);
                }
                
                if((Wurfel2Ausgewehlt == 1) & (Wurfel2Benutzt == 0))
                {
                    Wurfel2Benutzt     = 1;
                    ggSetLinkColor(primAnzahl, 3, <1.000, 0.345, 0.345>, 1);
                }
                
                return;
            }
        }
    }
    
ggResetAll()
    {
        llResetScript(); 
    }
    
ggSetPunkte(string farbe, integer punkte)
    {
        if(debug)llSay(0,"Starte funktion: ggSetPunkte");
        
        if(farbe == "Rot")PunkteRot = punkte;
        if(farbe == "Rosa")PunkteRosa = punkte;
        if(farbe == "Blau")PunkteBlau = punkte;
        if(farbe == "Hellblau")PunkteHellBlaut = punkte;
        if(farbe == "Grun")PunkteGrun = punkte;
        if(farbe == "Gelb")PunkteGelb = punkte;
        if(farbe == "Oronge")PunkteOronge = punkte;
        if(farbe == "Pink")PunktePink = punkte;
    }
    
ggAddPunkte(string farbe, integer punkte)
    {
        if(debug)llSay(0,"Starte funktion: ggAddPunkte");
        
        if(farbe == "Rot")PunkteRot = PunkteRot + punkte;
        if(farbe == "Rosa")PunkteRosa = PunkteRosa + punkte;
        if(farbe == "Blau")PunkteBlau = PunkteBlau + punkte;
        if(farbe == "Hellblau")PunkteHellBlaut = PunkteHellBlaut + punkte;
        if(farbe == "Grun")PunkteGrun = PunkteGrun + punkte;
        if(farbe == "Gelb")PunkteGelb = PunkteGelb + punkte;
        if(farbe == "Oronge")PunkteOronge = PunkteOronge + punkte;
        if(farbe == "Pink")PunktePink = PunktePink + punkte;
    }
    
integer ggGetPunkte(string farbe)
    {
        if(debug)llSay(0,"Starte funktion: ggGetPunkte");
        
        if(farbe == "Rot")return PunkteRot;
        if(farbe == "Rosa")return PunkteRosa;
        if(farbe == "Blau")return PunkteBlau;
        if(farbe == "Hellblau")return PunkteHellBlaut;
        if(farbe == "Grun")return PunkteGrun;
        if(farbe == "Gelb")return PunkteGelb;
        if(farbe == "Oronge")return PunkteOronge;
        if(farbe == "Pink")return PunktePink;
        return 0;
    }

integer        debug                =    0;

key            SpielerRot                =    NULL_KEY;
key            SpielerRosa                =    NULL_KEY;
key            SpielerBlau                =    NULL_KEY;
key            SpielerHellBlaut        =    NULL_KEY;
key         SpielerGrun                =    NULL_KEY;
key            SpielerGelb                =    NULL_KEY;
key            SpielerOronge            =    NULL_KEY;
key            SpielerPink                =    NULL_KEY;

integer        PunkteRot                =    0;
integer        PunkteRosa                =    0;
integer        PunkteBlau                =    0;
integer        PunkteHellBlaut            =    0;
integer        PunkteGrun                =    0;
integer        PunkteGelb                =    0;
integer        PunkteOronge            =    0;
integer        PunktePink                =    0;

string        SpielerIstDran            =    "";

integer        wurfel1augen            =    0;
integer        wurfel2augen            =    0;
integer        AlteWurfel1augen        =    0;
integer        AlteWurfel2augen        =    0;
integer        Wurfel1Ausgewehlt        =    0;
integer        Wurfel2Ausgewehlt        =    0;
integer        Wurfel1Benutzt            =    1;
integer        Wurfel2Benutzt            =    1;

integer        rundenWiederholen        =    0;

list        Positionen                =    []; 

integer        ResetPunkte                =    0;

integer        configIsLoad            =     0;
key            notecardQueryId            =    NULL_KEY;
integer        notecardLine            =    0;
key            http_request_id            =    NULL_KEY;

list    StartPositionenRot            =    [113,114,115,116];
list    StartPositionenRosa            =    [117,118,119,120];
list    StartPositionenBlau            =    [121,122,123,124];
list    StartPositionenHellblau        =    [125,126,127,128];
list    StartPositionenGrun            =    [129,130,131,132];
list    StartPositionenGelb            =    [133,134,135,136];
list    StartPositionenOronge        =    [137,138,139,140];
list    StartPositionenPink            =    [141,142,143,144];

list    ZielPositionenRot                        =    [81,82,83,84];
list    ZielPositionenRosa                        =    [85,86,87,88];
list    ZielPositionenBlau                        =    [89,90,91,92];
list    ZielPositionenHellblau                    =    [93,94,95,96];
list    ZielPositionenGrun                        =    [97,98,99,100];
list    ZielPositionenGelb                        =    [101,102,103,104];
list    ZielPositionenOronge                    =    [105,106,107,108];
list    ZielPositionenPink                        =    [109,110,111,112];

string        SPRACHE_LADE_CONFIG                =    "Lade... Bitte warten!";
string        SPRACHE_LADEN_FERTIG                =    "Laden fertig. Spiel ist Spielbereit!";
string        SPRACHE_BITTE_WURFEL_ERST            =    "%CurrentPlayer%, du musst erst würfeln.";
string        SPRACHE_DU_BRAUCHSTE_EINE_6        =    "%CurrentPlayer%, du brauchst eine 6 um eine Figur ins Spiel bringen zu können.";
string        SPRACHE_DU_BIST_NICHT_DRAN        =    "%Player%, du bist nicht dran.";
string        SPRACHE_NICHT_DEINE_FIGUR            =    "Das ist nicht deine Farbe %CurrentPlayer%!";
string        SPRACHE_DU_BIST_NOCHMAL            =    "[%CurrentPlayerPunkte%] %CurrentPlayer%, du bist nochmal!";
string        SPRACHE_IST_JETZT_DRAN            =    "[%CurrentPlayerPunkte%] %CurrentPlayer% ist nun dran.";
string        SPRACHE_KEINE_PASSENDE_ZAHL        =    "%CurrentPlayer%, du hast keine Passende Zahl! %Player%";
string        SPRACHE_BEREITS_IM_SPIEL            =    "Sorry %Player%, du bist bereits im Spiel!";
string        SPRACHE_BETRITT_DAS_SPIEL            =    "%Player% spielt jetzt mit!";
string        SPRACHE_VERLASST_DAS_SPIEL        =    "%Player% hat das Spiel verlassen.";
string        SPRACHE_GAME_RESET                =    "%Player% hat das Spiel zurückgesetzt.";
string        SPRACHE_KEINE_SPIELER_MEHR        =    "Spiel ist zu ende. Es sind keine Spieler mehr da.";
string        SPRACHE_SPIEL_GEWONNEN            =    "%CurrentPlayer% hat das Spiel gewonnen!";
string        SPRACHE_SPIELER_WURDE_GEKICKT        =    "%CurrentPlayer% hat %Player% gekickt.";
string        SPRACHE_ES_GIBT_EIN_UPDATE        =    "Es gibt ein Update zu diesem Spiel!";
string        SPRACHE_BITTE_WURFEL_AUSWAHLEN    =    "[%CurrentPlayerPunkte%] %CurrentPlayer%, du musst erst einen Würfel auswählen.";
string        SPRACHE_NICHT_MIT_DIESER_FIGUR    =    "[%CurrentPlayerPunkte%] %CurrentPlayer%, du kanst mit dieser Figur nicht mit den ausgewählten Würfeln gehen.";
string           SPRACHE_SPIELER_SELBER_GEKICKT    =    "%CurrentPlayer% hat sich selber gekickt.";
string          SPRACHE_GAME_RESET_WIEDERHOLEN    =    "%Player%, du musst 3 mal klicken um das Spiel zurückzusetzen.";
default
{
    state_entry()
    {
        ggCleanWurfel(1);
        ggCleanWurfel(2);
    
        llListen(4837483, "", "", "");
        
    
        if (llGetInventoryKey("Positionen") == NULL_KEY)
        {
            return;
        }else{
            ggChat(" ", SPRACHE_LADE_CONFIG);
            notecardQueryId = llGetNotecardLine("Positionen", notecardLine);
        }
    }
    
    listen( integer channel, string name, key id, string message )
    {
        llSay(4837483, "pong");
    }
    
    dataserver(key query_id, string data)
    {
        if (query_id == notecardQueryId)
        {
            if (data == EOF)
            {
                ggChat(" ", SPRACHE_LADEN_FERTIG);
                configIsLoad    =   1;
                ggResetAllStartPositionen();
                ggRemoveAllPlayerFromGame();
            }else{
                ++notecardLine;
                if(data != "")Positionen  =   Positionen + (list)ggRight(data,":");
                notecardQueryId = llGetNotecardLine("Positionen", notecardLine);
            }
        }
    }
    
    
    touch_start(integer num_detected)
    {
        if(configIsLoad)
        {     
            if(ggGetLinkName(llDetectedLinkNumber(0)) == "player")
            {
                if(ggFarbe2SpielerKey(ggGetSpielerFace2Farbe(llDetectedTouchFace(0))) == NULL_KEY)
                {
                    if(ggKey2Farbe(llDetectedKey(0)) == "NONE")
                    {
                        ggChat(ggLeft(ggKey2Name(llDetectedKey(0)), " "), SPRACHE_BETRITT_DAS_SPIEL);
                        ggPlayerJoinGame(llDetectedKey(0), llDetectedTouchFace(0));
                    }else{
                        ggChat(ggLeft(ggKey2Name(llDetectedKey(0)), " "), SPRACHE_BEREITS_IM_SPIEL);
                    }    
                }else{
                    if(ggFarbe2SpielerKey(ggGetSpielerFace2Farbe(llDetectedTouchFace(0))) == llDetectedKey(0))
                    {
                        ggChat(ggLeft(ggKey2Name(llDetectedKey(0)), " "), SPRACHE_VERLASST_DAS_SPIEL);
                        ggRemovePlayerFromGame(ggKey2Farbe(llDetectedKey(0)));
                    }
                }
            }        
            
        if(ggGetLinkName(llDetectedLinkNumber(0)) == "mitte")
        {
            if(llDetectedTouchFace(0) == 0) //Help
            {
                llGiveInventory(llDetectedKey(0), "Help");
            }
                
            if(llDetectedTouchFace(0) == 1) //Würfel 1
            {
                if(ggFarbe2SpielerKey(SpielerIstDran) == llDetectedKey(0))
                {
                    if(Wurfel1Benutzt & Wurfel2Benutzt)
                    {
                        ggwurfelRoll();
                            
                        if(!ggGetIstGehenMoglich(ggKey2Farbe(llDetectedKey(0))))
                        {
                            ggChat("[" + wurfel1augen + "] [" + wurfel2augen + "]", SPRACHE_KEINE_PASSENDE_ZAHL); 
                            ggNachsterSpieler(0);
                        }
                    }else{
                        if(!Wurfel1Benutzt)
                        {
                            Wurfel1Ausgewehlt    =    !Wurfel1Ausgewehlt;
                            if(Wurfel1Ausgewehlt)
                            {
                                ggSetLinkColor(llDetectedLinkNumber(0), 1, <0, 1, 0>, 1);
                            }else{
                                ggSetLinkColor(llDetectedLinkNumber(0), 1, <1, 1, 1>, 1);
                            }
                        }
                    }
                }
            }
            
            if(llDetectedTouchFace(0) == 2) //Reset
            {
                if(ResetPunkte != 3)
                {
                    ResetPunkte = ResetPunkte + 1;
                    ggChat(ggLeft(ggKey2Name(llDetectedKey(0))," "), SPRACHE_GAME_RESET_WIEDERHOLEN);
                
                }else{
                    ggChat(ggLeft(ggKey2Name(llDetectedKey(0))," "), SPRACHE_GAME_RESET);
                    ggResetAll();
                }
            }
                
            if(llDetectedTouchFace(0) == 3) //Würfel 2
            {
                if(ggFarbe2SpielerKey(SpielerIstDran) == llDetectedKey(0))
                {
                    if(Wurfel1Benutzt & Wurfel2Benutzt)
                    {
                        ggwurfelRoll();
                        
                        if(!ggGetIstGehenMoglich(ggKey2Farbe(llDetectedKey(0))))
                        {
                            ggChat("[" + wurfel1augen + "] [" + wurfel2augen + "]", SPRACHE_KEINE_PASSENDE_ZAHL); 
                            ggNachsterSpieler(0);
                        }
                    }else{
                        if(!Wurfel2Benutzt)
                        {
                            Wurfel2Ausgewehlt    =    !Wurfel2Ausgewehlt;
                                
                            if(Wurfel2Ausgewehlt)
                            {
                                ggSetLinkColor(llDetectedLinkNumber(0), 3, <0, 1, 0>, 1);
                            }else{
                                ggSetLinkColor(llDetectedLinkNumber(0), 3, <1, 1, 1>, 1);
                            }
                        }
                    }
                }
            }
        }          
            
            if(ggGetLinkName(llDetectedLinkNumber(0)) == "figur")
            {
                if(ggFarbe2SpielerKey(SpielerIstDran) == llDetectedKey(0))
                {
                    if(ggFarbe2SpielerKey(ggGetFigurFarbe(llDetectedLinkNumber(0))) == llDetectedKey(0))
                    {
                        if((Wurfel1Benutzt == 0) | (Wurfel2Benutzt == 0))
                        {
                            if(ggGetAusgewehlteAugenzahl() != 0)
                            {
                                if(ggCheckPlayerHaveFigurOut(ggGetFigurFarbe(llDetectedLinkNumber(0))))
                                {
                                    if(ggGetFigurStellplatz(llDetectedLinkNumber(0)) == 0)
                                    {
                                        if((wurfel1augen == 6 | wurfel2augen == 6) & ggGetAusgewehlteAugenzahl() == 6)
                                        {
                                            ggPrufeStellplatzSchonBelegt(ggGetPlayerStartPosition(ggGetFigurFarbe(llDetectedLinkNumber(0))));
                                            ggSetFigurPosition(llDetectedLinkNumber(0), ggStellplatz2Position(ggGetPlayerStartPosition(ggGetFigurFarbe(llDetectedLinkNumber(0)))));
                                            ggSchreibeFigurBeschreibung(llDetectedLinkNumber(0), ggGetFigurFarbe(llDetectedLinkNumber(0)), ggGetFigurNummer(llDetectedLinkNumber(0)) ,(ggGetPlayerStartPosition(ggGetFigurFarbe(llDetectedLinkNumber(0)))), 0);
                                            rundenWiederholen    =    rundenWiederholen + 1;
                                            ggAusgewahlteWurfelBenutzen();
                                            ggAddPunkte(SpielerIstDran, 1);
                                            ggNachsterSpieler(0);
                                        }else{
                                            if((wurfel1augen == 6 | wurfel2augen == 6) & ggGetAusgewehlteAugenzahl() > 6)
                                            {
                                                ggPrufeStellplatzSchonBelegt(ggGetPlayerStartPosition(ggGetFigurFarbe(llDetectedLinkNumber(0))) + ((wurfel1augen + wurfel2augen) - 6));
                                                ggSetFigurPosition(llDetectedLinkNumber(0), ggStellplatz2Position(ggGetPlayerStartPosition(ggGetFigurFarbe(llDetectedLinkNumber(0))) + ((wurfel1augen + wurfel2augen) - 6) ));
                                                ggSchreibeFigurBeschreibung(llDetectedLinkNumber(0), ggGetFigurFarbe(llDetectedLinkNumber(0)), ggGetFigurNummer(llDetectedLinkNumber(0)) ,(ggGetPlayerStartPosition(ggGetFigurFarbe(llDetectedLinkNumber(0))) + ((wurfel1augen + wurfel2augen) - 6) ), ((wurfel1augen + wurfel2augen) - 6));
                                                rundenWiederholen    =    rundenWiederholen + 1;
                                                ggAusgewahlteWurfelBenutzen();
                                                ggAddPunkte(SpielerIstDran, 1);
                                                ggNachsterSpieler(0);
                                            }else{
                                                ggChat("", SPRACHE_DU_BRAUCHSTE_EINE_6);  
                                            }
                                        }
                                    }else{
                                        if(ggGetIstGehenMoglich(ggGetFigurFarbe(llDetectedLinkNumber(0))))
                                        {
                                            if(ggGetFigurSchritte(llDetectedLinkNumber(0)) >= 80)
                                            {
                                                if(ggGetIstGehenMoglichMitFigur(llDetectedLinkNumber(0), ggGetAusgewehlteAugenzahl()))
                                                {
                                                    integer AktuelleFigurNachsterStellplatz    =   ggGetNachsterStellplatz(llDetectedLinkNumber(0), ggGetAusgewehlteAugenzahl());
                                                    ggSetFigurPosition(llDetectedLinkNumber(0), ggStellplatz2Position(AktuelleFigurNachsterStellplatz));
                                                    ggSchreibeFigurBeschreibung(llDetectedLinkNumber(0), ggGetFigurFarbe(llDetectedLinkNumber(0)), ggGetFigurNummer(llDetectedLinkNumber(0)),AktuelleFigurNachsterStellplatz, (ggGetFigurSchritte(llDetectedLinkNumber(0)) + (ggGetAusgewehlteAugenzahl())));
                                                    ggAusgewahlteWurfelBenutzen();
                                                    ggNachsterSpieler(0);
                                                }else{
                                                    ggChat("", SPRACHE_NICHT_MIT_DIESER_FIGUR);
                                                }
                                            }else{
                                                if(ggGetIstGehenMoglichMitFigur(llDetectedLinkNumber(0), ggGetAusgewehlteAugenzahl()))
                                                {
                                                    integer AktuelleFigurNachsterStellplatz     =   ggGetNachsterStellplatz(llDetectedLinkNumber(0), ggGetAusgewehlteAugenzahl());
                                                    ggPrufeStellplatzSchonBelegt(AktuelleFigurNachsterStellplatz);
                                                    ggSetFigurPosition(llDetectedLinkNumber(0), ggStellplatz2Position(AktuelleFigurNachsterStellplatz));
                                                    ggSchreibeFigurBeschreibung(llDetectedLinkNumber(0), ggGetFigurFarbe(llDetectedLinkNumber(0)), ggGetFigurNummer(llDetectedLinkNumber(0)),AktuelleFigurNachsterStellplatz, (ggGetFigurSchritte(llDetectedLinkNumber(0)) + (ggGetAusgewehlteAugenzahl())));
                                                    ggAusgewahlteWurfelBenutzen();
                                                    ggNachsterSpieler(0);
                                                }else{
                                                    ggChat("", SPRACHE_NICHT_MIT_DIESER_FIGUR);
                                                }
                                            }
                                        }else{
                                            ggChat("", SPRACHE_KEINE_PASSENDE_ZAHL); 
                                            ggNachsterSpieler(0);
                                        }
                                    }
                                }else{
                                    if((wurfel1augen == 6 | wurfel2augen == 6) & ggGetAusgewehlteAugenzahl() == 6)
                                    {
                                        ggPrufeStellplatzSchonBelegt(ggGetPlayerStartPosition(ggGetFigurFarbe(llDetectedLinkNumber(0))));
                                        ggSetFigurPosition(llDetectedLinkNumber(0), ggStellplatz2Position(ggGetPlayerStartPosition(ggGetFigurFarbe(llDetectedLinkNumber(0)))));
                                        ggSchreibeFigurBeschreibung(llDetectedLinkNumber(0), ggGetFigurFarbe(llDetectedLinkNumber(0)), ggGetFigurNummer(llDetectedLinkNumber(0)) ,(ggGetPlayerStartPosition(ggGetFigurFarbe(llDetectedLinkNumber(0)))), 0);
                                        rundenWiederholen    =    rundenWiederholen + 1;
                                        ggAddPunkte(SpielerIstDran, 1);
                                        ggAusgewahlteWurfelBenutzen();
                                    }else{
                                        if((wurfel1augen == 6 | wurfel2augen == 6) & ggGetAusgewehlteAugenzahl() >= 6)
                                        {
                                            ggPrufeStellplatzSchonBelegt(ggGetPlayerStartPosition(ggGetFigurFarbe(llDetectedLinkNumber(0))) + ((wurfel1augen + wurfel2augen) - 6));
                                            ggSetFigurPosition(llDetectedLinkNumber(0), ggStellplatz2Position(ggGetPlayerStartPosition(ggGetFigurFarbe(llDetectedLinkNumber(0))) + ((wurfel1augen + wurfel2augen) - 6) ));
                                            ggSchreibeFigurBeschreibung(llDetectedLinkNumber(0), ggGetFigurFarbe(llDetectedLinkNumber(0)), ggGetFigurNummer(llDetectedLinkNumber(0)) ,(ggGetPlayerStartPosition(ggGetFigurFarbe(llDetectedLinkNumber(0))) + ((wurfel1augen + wurfel2augen) - 6) ), ((wurfel1augen + wurfel2augen) - 6));
                                            rundenWiederholen    =    rundenWiederholen + 1;
                                            ggAddPunkte(SpielerIstDran, 1);
                                            ggAusgewahlteWurfelBenutzen();
                                        }else{
                                            ggChat("", SPRACHE_DU_BRAUCHSTE_EINE_6);  
                                        }
                                    }
                                    
                                    ggNachsterSpieler(0);
                                }
                            }else{
                                if(ggGetIstGehenMoglich(ggGetFigurFarbe(llDetectedLinkNumber(0))))
                                {
                                    ggChat(" ", SPRACHE_BITTE_WURFEL_AUSWAHLEN);
                                }else{
                                    ggNachsterSpieler(0);
                                }
                            }
                        }else{
                            ggChat(" ", SPRACHE_BITTE_WURFEL_ERST);   
                        }
                    }else{
                        ggChat(" ", SPRACHE_NICHT_DEINE_FIGUR);
                    }
                }else{
                    ggChat(ggLeft(ggKey2Name(llDetectedKey(0)), " "), SPRACHE_DU_BIST_NICHT_DRAN);
                }
            }
        }
    }
    
    on_rez(integer start_param)
    {
        llResetScript(); 
    }
}