integer DEBUG = FALSE;

string  GAME = "Greedy Dice";
integer gameChannel = -1369;
integer gameStartup = TRUE;

string  BTN_PASS = "BTN_PASS";
string  CMD_ENDTURN = "CMD_END_TURN";
string  CMD_STARTTURN = "CMD_START_TURN";
string  CMD_ENDGAME = "CMD_ENDGAME";
string  CMD_UPDGAME = "CMD_UPDGAME";
string  CMD_UPDTURN = "CMD_UPDTURN";
string  CMD_UPDPLAYER = "CMD_UPDPLAYER";

string  CMD_TESTDIEFACE = "CMD_TESTDIEFACE";
string  CMD_TESTDICE = "CMD_TESTDICE";
string  CMD_UNSELECTDIE = "CMD_UNSELECTDIE";
string  CMD_REPORTDIE = "CMD_REPORTDIE";
string  CMD_DIEFACE = "CMD_DIEFACE";
string  BTN_ROLLDICE = "BTN_ROLL_DICE"; 
string  CMD_ROLLDICE = "CMD_ROLL_DICE";
string  DIESELECTED = "DIE_SELECTED";
string  DIEUNSELECTED = "DIE_UNSELECTED";

string  BTN_START = "BTN_START";
string  CMD_START = "CMD_START";

string  BTN_JOIN = "BTN_JOIN";
string  CMD_JOIN = "CMD_JOIN";

string  CMD_RESET = "CMD_RESET"; 

integer playerCnt = 0;

list    dice = [];
integer diceCount = 0;
integer turnScore = 0;
integer gameScore = 0;
integer passFlag = FALSE;
integer firstRoll = TRUE;

list    playerIDList = [];
list    playerNumberList = [];
list    playerRunCount = [];

key     playerID = NULL_KEY;

integer currentPlayerIX = 0;
integer currentPlayer = 0;
string  currentFirstName = "";
list    playerGameScores = [];

string  emptyBoard = "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
string  tieBoard = "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";

string  board = "";

welcomePlayer(key id)
{
    turnScore = 0;

    playerCnt += 1;

    playerID = id;
    playerIDList += id;
    playerNumberList += playerCnt;
    playerGameScores += 0;
    playerRunCount += 0;

    string name = llKey2Name( id );

    llMessageLinked(LINK_SET, currentPlayer, CMD_UPDPLAYER + " " + currentPlayer, playerID);

    string playerName = llKey2Name(playerID);
    list playerNameParts = llParseString2List(playerName, [" "], []);
    string firstName = llList2String(playerNameParts, 0);
    llWhisper(0,  playerName + " has joined the game, welcome to Greedy Dice "+firstName+"!");
}

nextPlayer()
{
    integer loopCount = 0;
    currentPlayerIX = -1;
    while(currentPlayerIX < 0 && loopCount < 2)
    {
        currentPlayer += 1;
        if( currentPlayer > 8 )
        {
            currentPlayer = 0;
            loopCount += 1;
        }
        currentPlayerIX = llListFindList(playerNumberList,[currentPlayer]);
    }

    playerID = llList2Key(playerIDList, currentPlayerIX);
    gameScore = llList2Integer(playerGameScores, currentPlayerIX);
    currentFirstName = llList2String(llParseString2List(llKey2Name(playerID), [" "], []), 0);
    llWhisper( 0, "It is " + currentFirstName + "'s turn.");
}

integer checkPoints()
{
    integer match = FALSE;

    dice = llListSort(dice,1,1);

    integer rollCount = 0;
    integer zero = 0;
    integer one = 0;
    integer two = 0;
    integer three = 0;
    integer four = 0;
    integer five = 0;
    integer six = 0;
    integer sum = 0;

    integer ix = 0;
    for(ix = 0; ix < 6; ix++)
    {
        integer die = 0;
        die = llList2Integer(dice, ix);

        if(die == 0)
        {
            zero += 1;
        }
        else if(die == 1)
        {
            one += 1;
        }
        else if (die == 2)
        {
            two += 1;
        }
        else if (die == 3)
        {
            three += 1;
        }
        else if (die == 4)
        {
            four += 1;
        }
        else if (die == 5)
        {
            five += 1;
        }
        else if (die == 6)
        {
            six += 1;
        }
        if(die != 0)
        {
            rollCount += 1;
        }
    }

    integer points = 0;
    list counts = [];
    counts = [one, two, three, four, five, six];

    ix = 0;
    integer pairs = 0;
    for(ix = 0; ix < 6; ix++)
    {
        if(llList2Integer(counts, ix) == 2)
            pairs += 1;
    }
    if(pairs >= 3)
    {
        points = 800;
    }
    else if(llListFindList(dice, [1,2,3,4,5,6]) >= 0 )
    {
        points = 1500;
    }
    else
    {
        integer dieCnt = 0;
        integer dieFace = 0;
        ix = 0;
        for( ix = 0; ix < 6; ix++)
        {
            dieFace = ix + 1;

            dieCnt = llList2Integer(counts, ix);

            if(dieCnt == 1)
            {
                if(dieFace == 1)
                {
                    points += 100;
                }
                else if(dieFace == 5)
                {
                    points += 50;
                }
                else
                {
                    llWhisper(0,"Die "+(string)dieFace+" has no value, please unselect it before rolling or passing");
                    points = -1;
                    ix = 7;
                }
            }
            else if(dieCnt == 2)
            {
                if(dieFace == 1)
                {
                    points += 200;
                }
                else if(dieFace == 5)
                {
                    points += 100;
                }
                else
                {
                    llWhisper(0,"Die "+(string)dieFace+" has no value, please unselect it before rolling or passing");
                    points = -1;
                    ix = 7;
                }
            }
            else if(dieCnt == 3)
            {
                if(dieFace == 1)
                {
                    points += 1000;
                }
                else
                {
                    points += (dieFace * 100);
                }
            }
            else if(dieCnt == 4)
            {
                if(dieFace == 1)
                {
                    points += 2000;
                }
                else
                {
                    points += (dieFace*2)*100;
                }
            }
            else if(dieCnt == 5)
            {
                if(dieFace == 1)
                {
                    points += 4000;
                }
                else
                {
                    points += ((dieFace+1)*4) * 100;
                }
            }
            else if(dieCnt == 6)
            {
                if(dieFace == 1)
                {
                    llWhisper(0,"Congratulations! A roll of 6 Ones is worth 8000 points!");
                    points = 8000;
                }
                else
                {
                    points = ((dieFace+1)*8) * 100;
                }
                ix = 7;
            }
        }
    }
    if(points > 0)
        diceCount += rollCount;

    return points;
}

integer testPoints()
{
    dice = llListSort(dice,1,1);

    integer rollCount = 0;
    integer zero = 0;
    integer one = 0;
    integer two = 0;
    integer three = 0;
    integer four = 0;
    integer five = 0;
    integer six = 0;
    integer sum = 0;

    integer ix = 0;
    for(ix = 0; ix < 6; ix++)
    {
        integer die = 0;
        die = llList2Integer(dice, ix);

        if(die == 0)
        {
            zero += 1;
        }
        else if(die == 1)
        {
            one += 1;
        }
        else if (die == 2)
        {
            two += 1;
        }
        else if (die == 3)
        {
            three += 1;
        }
        else if (die == 4)
        {
            four += 1;
        }
        else if (die == 5)
        {
            five += 1;
        }
        else if (die == 6)
        {
            six += 1;
        }
        if(die != 0)
        {
            rollCount += 1;
        }
    }

    integer points = FALSE;
    list counts = [];
    counts = [one, two, three, four, five, six];
    
    ix = 0;
    integer pairs = 0;
    for(ix = 0; ix < 6; ix++)
    {
        if(llList2Integer(counts, ix) == 2)
            pairs += 1;
    }
    if(pairs >= 3)
    {
        points = TRUE;
    }

    else if(llListFindList(dice, [1,2,3,4,5,6]) >= 0 )
    {
        points = TRUE;
    }
    else
    {
        // check for 3 pairs
        //
        integer dieCnt = 0;
        integer dieFace = 0;
        ix = 0;
        for( ix = 0; ix < 6; ix++)
        {
            dieFace = ix + 1;

            dieCnt = llList2Integer(counts, ix);

            if(dieCnt == 1 && (dieFace == 1 || dieFace == 5))
            {
                points = TRUE;
                ix = 7;
            }
            else if((dieCnt == 2) && (dieFace == 1 || dieFace == 5))
            {
                points = TRUE;
                ix = 7;
            }
            else if(dieCnt >= 3)
            {
                points = TRUE;
                ix = 7;
            }
        }
    }
    return points;
}

passTurn()
{
    if(!gameStartup)
    {
        gameStartup = FALSE;
        gameScore += turnScore;
        llWhisper(gameChannel, GAME+"|"+CMD_UPDTURN+"|"+(string)playerID+"|"+(string)turnScore);
        llWhisper(0, llList2String(llParseString2List(llKey2Name(playerID), [" "],[]), 0) + " made "+(string)turnScore+" points this turn and has a total of " + (string)(gameScore) + " points.");
    }

    playerGameScores = llListReplaceList(playerGameScores, [gameScore], currentPlayerIX, currentPlayerIX);

    llMessageLinked(LINK_SET, currentPlayer, CMD_ENDTURN, playerID);

    llSleep(0.5);

    nextPlayer();

    llMessageLinked(LINK_SET, currentPlayer, CMD_UPDTURN + " " +(string)gameScore, "");
    llMessageLinked(LINK_SET, currentPlayer, CMD_STARTTURN + " " + currentPlayer, playerID);

    llSleep(0.5);

    dice = [];
    diceCount = 0;
    turnScore = 0;
    passFlag = FALSE;
    firstRoll = TRUE;

    dice = [];
    diceCount = 0;

    llMessageLinked(LINK_SET, 0, CMD_UNSELECTDIE, playerID);
    llSleep(0.5);
}

endGame()
{
    integer ix = 0;

    gameScore += turnScore;
    string firstName = llList2String( llParseString2List(llKey2Name(playerID),[" "],[] ), 0);
    llWhisper(0, firstName + " made "+(string)turnScore+" points this turn and has a total of " + (string)(gameScore) + " points.");
    llWhisper(0, "Congratulations "+firstName+"! You have won the game!");

    llMessageLinked(LINK_SET, currentPlayer, CMD_ENDTURN, playerID);
    llMessageLinked(LINK_SET, -1, CMD_ENDGAME, NULL_KEY);
    llMessageLinked(LINK_SET, currentPlayer, CMD_UPDTURN + " " +(string)gameScore, "");
    llWhisper(gameChannel, GAME+"|"+CMD_UPDGAME+"|"+(string)playerID+"|"+(string)gameScore);
}

startGame()
{
    board = emptyBoard;

    currentPlayer = 0;
}

init()
{
    llWhisper(0, " Welcome to Greedy Dice by Frank Northmead");

    llMessageLinked(LINK_SET, 0, CMD_UPDTURN + " " +(string)"0", "");

    playerCnt = 0;
    playerIDList = [];
}

default
{
    state_entry()
    {
        init();

        state WAITING;
    }

    on_rez(integer start_param)
    {
        llResetScript();
    }
}

state WAITING
{
    state_entry()
    {
    }

    changed(integer change)
    {
       // llResetScript();
    }
    //    messages to linked parts are used for all game running commands
    //
    link_message(integer ch, integer number, string message, key id)
    {
        list msgParts = llParseString2List(message, [" "], []);
        string cmd = llList2String(msgParts, 0);
        string arg1 = llList2String(msgParts, 1);

        if(cmd == BTN_JOIN)
        {
            if(llListFindList(playerIDList, [id]) == -1)
            {
                welcomePlayer(id);

                llMessageLinked(LINK_SET, number, CMD_UPDTURN + " " +(string)0, id);
                llMessageLinked(LINK_SET, number, CMD_JOIN, id);
            }
        }
        else if(cmd == BTN_START)
        {
            if(playerCnt > 0)
            {
                startGame();

                llMessageLinked(LINK_SET, -1, CMD_START, NULL_KEY);

                state PLAY;
            }
        }
        else if( cmd == CMD_RESET)
        {
            llResetScript();
        }
    }
}

state PLAY
{
    state_entry()
    {
        llWhisper(0, "Starting a game of Greedy Dice, have fun!");

        currentPlayer = 0;
        turnScore = 0;
        passTurn();
    }

    changed(integer change)
    {
      // llResetScript();
    }

    link_message(integer sender_number, integer number, string message, key id)
    {
        list msgParts = llParseString2List(message, [" "], []);
        string cmd = llList2String(msgParts, 0);

        if( cmd == CMD_RESET)
        {
            llResetScript();
        }
        else if(cmd == BTN_PASS)
        {
            passFlag = TRUE;

            dice = [];
            llMessageLinked(LINK_SET, 0, CMD_REPORTDIE, id);
        }
        else if(cmd == BTN_ROLLDICE)
        {
            if(firstRoll)
            {
                firstRoll = FALSE;
                llPlaySound("NEW dice roll", 1);

                llMessageLinked(LINK_SET, 0, CMD_ROLLDICE, id);
                llSleep(1.5);

                dice = [];
                llMessageLinked(LINK_SET, 0, CMD_TESTDICE, id);
            }
            else
            {
                dice = [];
                llMessageLinked(LINK_SET, 0, CMD_REPORTDIE, id);
            }
        }
        else if(cmd == CMD_DIEFACE)
        {
            dice += llList2Integer(msgParts, 1);

            if(llGetListLength(dice) >= 6)
            {
                integer points = 0;
                if( (points = checkPoints()) > 0)
                {
                    turnScore += points;

                    if(gameScore+turnScore >= 10000)
                    {
                        endGame();
                    }
                    else
                    {
                        llMessageLinked(LINK_SET, 0, CMD_UPDTURN + " " +(string)(gameScore+turnScore), id);

                        if(diceCount >= 6)
                        {
                            diceCount = 0;
                            llMessageLinked(LINK_SET, 0, CMD_UNSELECTDIE, id);
                            llSleep(0.25);
                        }

                        if(!passFlag)
                        {
                            llPlaySound("NEW dice roll", 1);
                            llMessageLinked(LINK_SET, 0, CMD_ROLLDICE, id);
                            llSleep(0.5);

                            dice = [];
                            llMessageLinked(LINK_SET, 0, CMD_TESTDICE, id);
                        }
                        else
                        {
                            passTurn();
                        }
                    }
                }
                else
                {
                    if(passFlag)
                    {
                        passTurn();
                    }
                    else
                    {
                        llWhisper(0, "You must select some score to bank from the current roll.");

                        llSleep(1.0);
                    }
                }
            }
        }
        else if(cmd == CMD_TESTDIEFACE)
        {
            dice += llList2Integer(msgParts, 1);

            if(llGetListLength(dice) >= 6)
            {
                if( testPoints() == FALSE )
                {
                    llPlaySound("New Fail Sound", 1);

                    llWhisper(0, "There are no points in this roll you lose all points this round, turn is passed to the next player.");

                    llSleep(1.5);

                    turnScore = 0;

                    passTurn();
                }
            }
        }
    }
}

