This script by Ferd Frederix may be used in any manner, modified, and republished.  Unless specified otherwise, my scripts are always free and open source.  Objects made with these scripts may be sold with no restrictions.  All I ask is that you point others to this location should they ask you about it and to not sell this script, unless it is for $0 L. Please help improve my work by reporting bugs and improvements.

  1 // One Script Prim Animation 
  2 // ( rev1.1) add llTextBox 
  3 // Free and Open Source - not for sale but for free use in any build.
  4 
  5 // Original Script by: Ferd Frederix
  6 
  7 integer runtime = FALSE; // set to TRUE after making the notecard
  8  
  9 string NOTECARD = "Movement";   // the notecard for this script, you can add more than 1 script and notecard, just change this line to match
 10 integer playchannel = 1;    // the playback channel, this is the channel you use in LinkMessages
 11  
 12         
 13 integer debug = FALSE;          // if set to TRUE, debug info appears
 14 
 15 
 16 // notecard reading
 17 string priorname;               // the prior animation name so we can spot differences as we read them in
 18 integer iIndexLines;            // lines in a card
 19 integer inotecardIndex = 0;     // notecard counter;
 20 integer move = 0;               // N movements rea from the notecard
 21 
 22 key kNoteCardLines;             // the key of the notecard
 23 key kGetIndexLines;             // the key of the current line
 24 
 25 //communications
 26 integer dialogchannel ;         // dialog boxes 
 27 
 28 integer nPrims;                 // total number of prims
 29 integer PrimsCounter = 0;       // how many have checked in
 30 integer timercounter = 0;       // how many seconds have gone by
 31 integer wantname;               // flag indicating we are waiting for a name to be chatted
 32   
 33 
 34 // the list of coords
 35 list masterlist;        // master list of all positions
 36 list llastPrimList;      // storage of the last prim position we learned
 37 string curranimation;   // what we are playing
 38 
 39 integer STRIDE = 5;     // size of the master list
 40 integer lastSTRIDE = 4; // size of the last prim list
 41 
 42 integer listener;       // temp listener when we are waiting for them to give us a name
 43 
 44 vector InitSize;        // the initial size when the prims were recorded
 45 list LoadedAnims;       // animations read from the notecard added to the Menu display
 46 
 47 // in case of hand editing, we wupe out extra stuff at end
 48 string Getline(list Input, integer line)
 49 {
 50     return llStringTrim(llList2String(Input, line),STRING_TRIM);
 51 }
 52 
 53 Record()
 54 {
 55     if(llStringLength(curranimation) > 0)
 56     {
 57         integer foundmovement = 0;      // will be set if any child moved
 58         integer PrimCounter ;        // skip past the root prim
 59         for (PrimCounter =2; PrimCounter <= nPrims; PrimCounter++ )
 60         {
 61             list my_list = llGetLinkPrimitiveParams(PrimCounter,[PRIM_POSITION,PRIM_ROTATION, PRIM_SIZE ]);
 62             // position is always in region coordinates, even if the prim is a child or the root prim of an attachment.
 63             // rot is always the global rotation, even if the prim is a child or the root prim of an attachment.                 
 64             
 65             // get current prim pos, rot and size
 66             vector      vrealPrimPos    = llList2Vector(my_list,0) - llGetPos();   // position subtract Global Pos
 67             vrealPrimPos /= llGetRot();
 68             rotation    rrealPrimRot    = llList2Rot(my_list,1) / llGetRot();   // rotation subtract Global Rot
 69             vector      vrealPrimSize   = llList2Vector(my_list,2);                 // size  
 70             
 71             // compare it to the last one we had, stride of list is a 4, and it is already sorted
 72             integer iindex = (PrimCounter - 2) * lastSTRIDE;    // zeroth position is PrimCounter - start, or 2
 73             
 74             // get the last thing we remembered about this prim
 75             float       fprimNum        = llList2Integer(llastPrimList, iindex);    // must be 0,1,2, in order
 76             vector      vlastPrimPos    = llList2Vector(llastPrimList, iindex+1);
 77             rotation    rlastPrimRot    = llList2Rot(llastPrimList, iindex+2);
 78             vector      vlastPrimSize   = llList2Vector(llastPrimList, iindex+3);
 79                 
 80             // if anything changed on this prim, we must record it.
 81             if(vlastPrimPos != vrealPrimPos ||
 82                 rlastPrimRot != rrealPrimRot ||
 83                 vlastPrimSize!= vrealPrimSize  
 84             )
 85             {                        
 86                 foundmovement++;
 87                 
 88                 // show owner any changes they mnade
 89                 if(debug)    
 90                 {
 91                     llOwnerSay("prim:" + (string) PrimCounter);
 92                 
 93                     if(vlastPrimPos != vrealPrimPos)
 94                         llOwnerSay("pos delta :" + (string) (vrealPrimPos - vlastPrimPos));
 95                         
 96                     if(rlastPrimRot != rrealPrimRot)
 97                         llOwnerSay("rot delta:" + (string) (llRot2Euler(rrealPrimRot - rlastPrimRot) * RAD_TO_DEG));                   
 98                         
 99                     if(vlastPrimSize != vrealPrimSize)
100                         llOwnerSay("size delta:" + (string) (vrealPrimSize - vlastPrimSize));
101                 }
102                 
103                 //Save them in the master list of all animations
104                 masterlist += curranimation;
105                 masterlist += PrimCounter;
106                 masterlist += vrealPrimPos;
107                 masterlist += rrealPrimRot;
108                 masterlist += vrealPrimSize;
109               
110                 // save them in the last movement list
111                 integer saved = FALSE;
112                 integer i;
113                 integer imax = llGetListLength(llastPrimList);
114                 // save the changes in the last prim list so we can keep our lists smaller
115                 for ( i=0; i < imax; i += lastSTRIDE )
116                 {
117                     if(llList2Float(llastPrimList,i) == PrimCounter)
118                     {
119                         llastPrimList = llListReplaceList(llastPrimList,[vrealPrimPos],i+1,i+1);
120                         llastPrimList = llListReplaceList(llastPrimList,[rrealPrimRot],i+2,i+2);
121                         llastPrimList = llListReplaceList(llastPrimList,[vrealPrimSize],i+3,i+3);
122                         if(debug) llOwnerSay("In history at position " + (string) (i/lastSTRIDE));
123                         saved++;
124                     }
125                 }
126                 
127                 // never moved before?  add it then
128                 if(! saved)
129                 {
130                     if(debug) llOwnerSay("Someone added a new prim and then clicked Record");
131                     llastPrimList += PrimCounter;
132                     llastPrimList += vrealPrimPos;
133                     llastPrimList += rrealPrimRot;
134                     llastPrimList += vrealPrimSize;
135                 }    
136             } // if
137         } // for
138         if(debug)    llOwnerSay("history:" + llDumpList2String(llastPrimList,":"));                   
139         
140         if(!foundmovement)
141             llOwnerSay("You must move at least one child prim.");
142     }         
143     else
144     {
145         llOwnerSay("You must name your animation.");
146         llOwnerSay("Type the new animation name on channel /" + (string) dialogchannel);
147         wantname++;
148     }
149 }
150 
151 // on reset, record the base position in history so we can see changes
152 Clear()
153 {
154     LoadedAnims = [];           // wipe out Menu
155     masterlist = [];            // wipe all recordings
156     llastPrimList = [];         // wipe last animations
157     integer PrimCounter ;       // skip 1, which is the root prim
158     integer counter = 0;
159     // save all the current settings in memory
160     for (PrimCounter=2; PrimCounter <= nPrims; PrimCounter++ )
161     {
162         list my_list = llGetLinkPrimitiveParams(PrimCounter,[PRIM_POSITION,PRIM_ROTATION, PRIM_SIZE ]);
163         
164         // save the local  pos and rot, since llGetLinkPrimitiveParams returns global pos and rot
165         vector primpos      = llList2Vector(my_list,0) - llGetPos();
166         rotation primrot    = llList2Rot(my_list,1) / llGetRot();
167         vector primsize     = llList2Vector(my_list,2) ;
168         
169         llastPrimList += PrimCounter;
170         llastPrimList += primpos;
171         llastPrimList += primrot;
172         llastPrimList += primsize;
173         counter++;
174     }
175     if(debug) llOwnerSay("Saved " + (string) counter + " prims initial position in history");
176 }
177 
178 DumpBack ()
179 {
180     integer i;
181     integer imax = llGetListLength(masterlist);
182     integer howmany = imax / STRIDE ;
183     llOwnerSay((string) howmany + " movements recorded - copy these and paste them into the notecard");
184     
185     integer flag = 0;
186     for (i = 0; i < imax; i+= STRIDE)
187     {
188         if( i == 0 )
189              llOwnerSay( "|start|" + (string) llGetScale());
190              
191         string saniName = llList2String(masterlist,i);
192         curranimation = saniName;
193 
194         float fprimNum = llList2Integer(masterlist,     i+1);
195         integer iprimNum = (integer) fprimNum;
196         vector  vprimPos  = llList2Vector(masterlist,   i+2);
197         rotation rprimRot = llList2Rot(masterlist,      i+3) ;
198         vector  vprimSize  = llList2Vector(masterlist,  i+4);
199 
200         llOwnerSay("|"+ saniName + "|" + (string) iprimNum + "|" + (string) vprimPos + "|" + (string) rprimRot + "|" + (string) vprimSize );
201         flag++;
202     }
203     if(! flag)
204         llOwnerSay("No recording was made, nothing to play back." );
205 }
206 
207 
208 rotation calcChildRot(rotation rdeltaRot)
209 {
210     
211     if(llGetAttached())
212         return rdeltaRot/llGetLocalRot();
213     else
214         return rdeltaRot/llGetRootRotation();
215    
216 }
217 
218 
219 PlayBack (string name)
220 {
221     integer i;
222     integer imax = llGetListLength(masterlist);
223 
224     integer linknum = 0;
225 
226     for (i = 0; i < imax; i+= STRIDE)
227     {
228         string saniName = llList2String(masterlist,i);
229         if(saniName == name)
230         {
231             float fprimNum      = llList2Float(masterlist,i+1);
232             vector  vPos    = llList2Vector(masterlist,i+2);
233             rotation rRot = llList2Rot(masterlist,i+3) ;
234             vector vprimSize    = llList2Vector(masterlist,i+4) ;
235             
236             vector scale = llGetScale();
237             float delta =  scale.x / InitSize.x ;   // see if the root prim has grown or shrunk as a percentage      
238             
239             vPos *= delta;                           // add any difference in size to it positions there
240             vprimSize *= delta;                      // grow the child prim, too
241             
242         
243             // support negative prim numbers as a delay
244             if(fprimNum < 0)
245             {
246                 if(debug) llOwnerSay("Sleeping " + (string) (fprimNum * -1));
247                 llSleep((float) fprimNum * -1);
248             }
249             else
250             {            
251                 if(fprimNum > 1 ) 
252                 {
253                     // set the local pos and locat rot to the prims orientation and position
254                     rRot  = calcChildRot(rRot);
255         
256                     list actions = [PRIM_POSITION,vPos,PRIM_ROTATION,rRot,PRIM_SIZE,vprimSize];
257                     if(debug) llOwnerSay("Moving prim :" + (string) fprimNum + ":" + llDumpList2String(actions,":"));
258                 
259                     llSetLinkPrimitiveParamsFast((integer) fprimNum,actions);
260                 }
261             }
262         }
263     }
264 }
265 
266 MakeMenu()
267 {
268     list amenu = ["Reset","Record","Help","Name","Notecard","Pause"] + LoadedAnims;
269 
270     llListenRemove(listener);
271     listener = llListen(dialogchannel,"","","");
272     
273     amenu = llDeleteSubList(amenu,12,99);
274     
275     llDialog(llGetOwner(), "Pick a command",amenu,dialogchannel);
276 }
277 
278 
279 
280 default
281 {
282     state_entry()
283     {
284         InitSize = llGetScale();            // save the size  when we recorded the prims
285         nPrims = llGetNumberOfPrims();      // how many we are recording
286         if(debug) llOwnerSay(" Total Prims = " + (string) nPrims);
287         Clear();                            
288         
289         string notecardname = llGetInventoryName(INVENTORY_NOTECARD,0);
290         
291         if(llStringLength(notecardname) > 0)
292         {
293             kNoteCardLines = llGetNumberOfNotecardLines(NOTECARD);
294             kGetIndexLines = llGetNotecardLine(NOTECARD,0);
295         }
296         else
297         {
298             llOwnerSay("If you add a notecard, you can save your animations permanently in a notecard named " + NOTECARD);
299         }
300         dialogchannel = (integer) (llFrand(100) +600);
301         
302     }
303 
304     // read notecard on bootup
305     dataserver(key queryid, string data)
306     {
307         if(queryid == kNoteCardLines)
308         {
309             iIndexLines = (integer) data;
310         }
311 
312         if(queryid == kGetIndexLines)
313         {
314             if(data != EOF)
315             {
316                 queryid = llGetNotecardLine(NOTECARD, inotecardIndex);
317                 list lLine = (llParseString2List(data, ["|"], []));
318                 
319                 string junk = llList2String(lLine,0);
320                 string aniname = llList2String(lLine,1);
321                 string aNum = (string) Getline(lLine,2);
322                 
323                 // check for the prim size,and save it, the fiorst line will look like this:
324                 // [18:06]  prim position 1.2: |start|<1.02306, 1.02306, 1.02306>
325                 
326                 if(inotecardIndex == 0 && aniname == "start")
327                 {
328                     InitSize = (vector) aNum;
329                 }
330                 else if(inotecardIndex == 0 && aniname != "start")
331                 {
332                     llOwnerSay("The notecard " + NOTECARD  + " is incorrect, it must begin with 'start|<x,y,z>' with the size of the original prim");
333                 }
334                 else
335                 {
336                 
337                     float Num = (float) aNum;
338                     
339                     vector vPos = (vector) Getline(lLine,3);          // global for calcChild()
340                     rotation rRot = (rotation) Getline(lLine,4);        // global for calcChild()
341                     vector Size  = (vector) Getline(lLine,5);
342                     
343                     vector scale = llGetScale();
344                     float delta =  scale.x / InitSize.x ;   // see if the root prim has grown or shrunk as a percentage      
345             
346                     
347                     if(aniname != priorname)
348                     {
349                         llOwnerSay("Loading animation " + aniname);
350                         priorname = aniname;
351                         LoadedAnims += aniname;
352                     }
353     
354                     if(Num != 1)        // skip root prim
355                     {
356                         masterlist += [aniname];
357                         masterlist += [Num];
358                         masterlist += [vPos];
359                         masterlist += [rRot];
360                         masterlist += [Size];
361     
362                         if(Num > 1)  // not the pauses
363                         {
364                             rRot = calcChildRot(rRot);
365                             vPos *= delta;                           // add any difference in size to it positions there
366                             Size *= delta;                          // grow the child prim, too
367     
368                             llSetLinkPrimitiveParamsFast((integer) Num,[PRIM_POSITION,vPos,PRIM_ROTATION,rRot,PRIM_SIZE,Size]);
369                             move++;
370                         }
371                         
372                     }
373                 }
374                 inotecardIndex++;
375                 integer     InitPerCent = (integer) llRound(( (inotecardIndex+1) / (float) iIndexLines) * 100);
376                 llSetText("Initialising... \n" + (string) InitPerCent + "%" , <1,1,1>, 1.0);
377                 if(InitPerCent >= 100)
378                     llSetText(""  , <1,1,1>, 1.0);
379                 kGetIndexLines = llGetNotecardLine(NOTECARD,inotecardIndex);
380                 
381             }
382             else
383             {
384                 llOwnerSay("initialized with " + (string) move + " movements");
385                 llSetText(""  , <1,1,1>, 1.0);
386             }
387         }
388     }
389 
390 
391     touch_start(integer total_number)
392     {
393         if(llDetectedKey(0) == llGetOwner() && ! runtime)
394         {
395             MakeMenu();
396         }
397         
398         // add any control code here
399         // example:
400         // llMessageLinked(LINK_SET,playchannel,"All","");  // will play Animation named "All"
401         
402     }
403 
404     listen( integer channel, string name, key id, string message )
405     {
406 
407         if(channel == dialogchannel)
408         {
409             if(message == "Reset")
410             {
411                 Clear();
412                 if(debug)    llOwnerSay("Reset = " + llDumpList2String(llastPrimList,":"));
413                 MakeMenu();
414             }
415             else if(message =="Pause")
416             {
417                 masterlist += curranimation;
418                 masterlist += -1;
419                 masterlist += <0,0,0>;  // pos
420                 masterlist += <0,0,0,1>;// rot
421                 masterlist += <0,0,0>;  // size
422                 MakeMenu();
423             }
424             else if(message == "Record")
425             {
426                 Record();
427                 
428                 MakeMenu();
429             }
430             else if(message == "Name")
431             {
432                 llOwnerSay("Type the current animation name on channel /" + (string) dialogchannel);
433                 
434                 wantname++;
435                 MakeMenu();
436                 llTextBox(llGetOwner(),"Enter an Animation Name",dialogchannel);
437             }
438             else if(message =="Menu")
439             {
440                 MakeMenu();
441             }
442             else if(message == "Notecard")
443             {
444                 DumpBack();
445                 MakeMenu();
446             }
447             else if(message == "Help")
448             {
449                 llLoadURL(llGetOwner(),"View online help", "http://secondlife.mitsi.com/secondlife/Posts/Prim-Animator");
450             }
451             else if(wantname)
452             {
453                 curranimation = message;
454             
455                 LoadedAnims += message;
456                 
457                 MakeMenu();
458                 llOwnerSay("Recording is ready for animation '" + curranimation + "'");
459                 llOwnerSay("Position all child  prims, then select the Menu item 'Record', and repeat as necessary. When finished, click 'PlayBack' to play back the animation, or click the animation name.  Click 'Name' to start a new animation sequence");
460                 wantname = 0;
461                 PrimsCounter = 0;
462                 timercounter  = 0;
463                 llSetTimerEvent(1.0);
464             }
465             else
466             {
467                 if(llListFindList(LoadedAnims,[message]) != -1)
468                 {
469                     PlayBack(message);
470                     MakeMenu();
471                 }
472             }
473                 
474                 
475         }
476     }
477 
478     
479 
480     link_message(integer sender_num, integer num, string message, key id)
481     {
482         if(num == playchannel)
483         {
484             if(debug) llOwnerSay("playback animation " + message);
485             PlayBack(message); 
486         }
487     }
 