string gAnimName = "Rollschuhe";
float gStopTimeout = 1.0;

integer gInTimeout;


default
{
    state_entry()
    {
        //llSay(0, "Hello, Avatar!");
        llRequestPermissions(llGetOwner(), PERMISSION_TRIGGER_ANIMATION | PERMISSION_TAKE_CONTROLS | PERMISSION_ATTACH );
        gInTimeout = FALSE;
    }

    //touch_start(integer total_number)
    //{
    //    llSay(0, "Touched.");
    //}

    run_time_permissions(integer perms) {
        llTakeControls(CONTROL_FWD | CONTROL_BACK, TRUE, TRUE);
    }

    on_rez(integer param) {
        llResetScript();
    }    
    control(key name, integer levels, integer edges) {
        //llSay(0, "control");
        if (edges & levels & (CONTROL_FWD | CONTROL_BACK)) {
            //llSay(0, "Debug: on");
            llStartAnimation(gAnimName);
            gInTimeout = FALSE;
            llSetTimerEvent(gStopTimeout/2);
        }
        
        if (edges & ~levels & (CONTROL_FWD | CONTROL_BACK)) {
            //llSay(0, "Debug: off");
            //llStopAnimation(gAnimName);
            gInTimeout = TRUE;
            llSetTimerEvent(gStopTimeout);
        }
    }

    timer() {
        //llSay(0,"Timer");
        if (gInTimeout) {
            //llSay(0,"intimeout");
            llStopAnimation(gAnimName);
            llSetTimerEvent(0.0);
        }        
        else {
            //llSay(0,"notintimeout");
            llStartAnimation(gAnimName);
        }            
    }            
                                    
    attach(key id) {
        //llSay(0, "ok...");
        integer perm = llGetPermissions();
        
        if (id != NULL_KEY) {
            //llSay(0, "yep...");
            if (! (perm & PERMISSION_TRIGGER_ANIMATION & PERMISSION_TAKE_CONTROLS)) {
                llRequestPermissions(llGetOwner(), PERMISSION_TRIGGER_ANIMATION | 
                                                   PERMISSION_TAKE_CONTROLS |
                                                   PERMISSION_ATTACH);
            }
        }
        else {
            //llSay(0, "nope...");
            if (perm & PERMISSION_TRIGGER_ANIMATION) {
                llStopAnimation(gAnimName);   
            }         
        }
    }

}
