// Toboggan rider v04
// v04 20151207 - Introduced test of start_param to prevent llDie to occur when rezzed manually from inventory
// v03 20151205 - Introduced function mysay and myRegionSay
// v02 20151205 - Added floating text on rez, and no text on changed   
// v1.01 added timer to provide a short delay after unsitting 
// v1.00 20141122 Object set to die immidiately after avatar stand
key AvatarUUID;
string Avatar;
string nameBeforeChange; 
// Function mySay v00
// v00 20150208 - Copied from http://wiki.secondlife.com/wiki/MySay
mySay(string objectName, string msg)
{
    // v03 string nameBeforeChange = llGetObjectName();
 
    llSetObjectName(objectName);
    llSay(PUBLIC_CHANNEL, "/me " + msg);
 
    llSetObjectName(nameBeforeChange);
}

myRegionSayTo(string objectName, string msg)
{
    // v03 string nameBeforeChange = llGetObjectName();
 
    llSetObjectName(objectName);
    llRegionSayTo(AvatarUUID, PUBLIC_CHANNEL, "/me " + msg);
 
    llSetObjectName(nameBeforeChange);
}

default 
{
    on_rez(integer start_param) 
    {
        if (start_param != 0) 
        { // if rezzed by script
            // v02 llSetLinkPrimitiveParamsFast(LINK_SET,[ PRIM_TEMP_ON_REZ, TRUE ]);
            // v04 llSetLinkPrimitiveParamsFast(LINK_SET,[ PRIM_TEMP_ON_REZ, TRUE, PRIM_TEXT, "Sit to ride",<1.000, 0.255, 0.212>, 1 ]); // v02 added [ PRIM_TEXT, string text, vector color, float alpha ]
            llSetLinkPrimitiveParamsFast(LINK_ROOT,[ PRIM_TEMP_ON_REZ, TRUE, PRIM_TEXT, "Sit to ride",<1.000, 0.255, 0.212>, 1 ]); // v04 - for multiprim saucer
        }
    }
    
    state_entry() 
    {
        // llSitTarget(<0.0, 0.0, 0.1>, ZERO_ROTATION); 
        // Previous line commented because a sit animation is already in the object
        // A sit target is needed for llAvatarOnSitTarget to work
        // Note that if both the vector and the rotation are zero,
        // the SitTarget is removed instead of set and the following will not work:
        nameBeforeChange = llGetObjectName();

    }
    
    changed(integer change) // something changed
    { 
        if (change & CHANGED_LINK) // and it was a link change
        {
            // v02 llSetLinkPrimitiveParamsFast(LINK_SET,[ PRIM_TEMP_ON_REZ, FALSE ]); 
            // v04 llSetLinkPrimitiveParamsFast(LINK_SET,[ PRIM_TEMP_ON_REZ, FALSE, PRIM_TEXT, "Press up arrow key\n to run forward",<1.000, 0.255, 0.212>, 1 ]);// v02
            llSetLinkPrimitiveParamsFast(LINK_ROOT,[ PRIM_TEMP_ON_REZ, FALSE, PRIM_TEXT, "Press up arrow key\n to run forward",<1.000, 0.255, 0.212>, 1 ]);// v04           
            if (llAvatarOnSitTarget() != NULL_KEY) 
            {                           
                AvatarUUID = llAvatarOnSitTarget();
                Avatar = llKey2Name(AvatarUUID);
                // v03 llSay(0, Avatar + " is riding a snow saucer!"); // v02 public message
                mySay("", Avatar + " is now riding a snow saucer!"); // v03
                // v03 llRegionSayTo(AvatarUUID, 0, "To move the snow saucer around, please use the four arrow keys on your keyboard!"); // v02 private message to riding avatar
                myRegionSayTo("","To move the snow saucer around, please use the four arrow keys on your keyboard!");
 
            }
            else if (llAvatarOnSitTarget() == NULL_KEY) // evaluated as true if key is NULL_KEY
            {
                // v09 llSay(0, Avatar + " abandoned its snow saucer");
                mySay("", Avatar + " has abandonned the snow saucer!"); // v03
                // v03 llRegionSayTo(AvatarUUID, 0, "This was a fun ride, goodbye!"); // v02 private message to riding avatar
                myRegionSayTo("","This was a fun ride, goodbye!"); // v03
                // llDie();
                if (llGetStartParameter() != 0) // v04 To prevent llDie to occur when rezzed manually from inventory
                {
                    llSetTimerEvent(5.0); // set die time to 5 seconds
                }    
            }
        }
    }
    
    timer() 
    {
        llDie(); // delete this object
    }
}