key        playerID = NULL_KEY;
string     playerName = "";

string     CMD_ENDTURN = "CMD_END_TURN";
string     CMD_STARTTURN = "CMD_START_TURN";
string     CMD_ENDGAME = "CMD_ENDGAME";

string     BTN_ROLLDICE = "BTN_ROLL_DICE";
string     CMD_ROLLDICE = "CMD_ROLL_DICE";

string     CMD_RESET = "CMD_RESET";

integer    TOP_SIDE = 0;
integer    SIDE_SIDE = 2;
vector     REPEAT_ONCE = <1.0, 1.0, 0.0>;
vector     WHITE = <1.0, 1.0, 1.0>;
vector     GREY = <0.3, 0.3, 0.3>;
key        BLANK = "5748decc-f629-461c-9a36-a35a221fe21f";
key        LABEL = "a972e318-9afc-47d2-86ae-1d32d5951ef7";

hide()
{
    llSetPrimitiveParams([
        PRIM_COLOR, ALL_SIDES, GREY, 0.0,
        PRIM_COLOR, TOP_SIDE, WHITE, 0.0,
        PRIM_BUMP_SHINY, SIDE_SIDE, PRIM_SHINY_HIGH, PRIM_BUMP_SHINY,
        PRIM_TEXTURE, ALL_SIDES, (string)BLANK, REPEAT_ONCE, ZERO_VECTOR, 0.0,
        PRIM_TEXTURE, TOP_SIDE, (string)LABEL, REPEAT_ONCE, ZERO_VECTOR, 0.0]);

    llSetPos(<-0.175,-0.1,-0.05>);
}

show()
{
    llSetPrimitiveParams([
        PRIM_COLOR, ALL_SIDES, GREY, 1.0,
        PRIM_COLOR, TOP_SIDE, WHITE, 1.0,
        PRIM_BUMP_SHINY, SIDE_SIDE, PRIM_SHINY_HIGH, PRIM_BUMP_SHINY,
        PRIM_TEXTURE, ALL_SIDES, (string)BLANK, REPEAT_ONCE, ZERO_VECTOR, 0.0,
        PRIM_TEXTURE, TOP_SIDE, (string)LABEL, REPEAT_ONCE, ZERO_VECTOR, 0.0]);

    llSetPos(<-0.175,-0.1,0.01>);
}

notTurn(string firstName)
{
    integer ix = (integer) llFrand(5.0);
    if(ix == 0)
    {
        llWhisper(0, firstName + ", Opps! Please don't touch the dice when it is " + playerName+"'s turn!");
    }
    else if (ix == 1)
    {
        llWhisper(0, "Really " + firstName + ", I think it is "+ playerName+"'s time to play or pass!");
    }
    else if (ix == 2)
    {
        llWhisper(0, firstName + ", Please don't click on the dice it is not your turn");
    }
    else if (ix == 3)
    {
        llWhisper(0, "Attention players " + firstName + " is trying to cheat again by ckicking out of turn!");
    }
    else if (ix == 4)
    {
        llWhisper(0, firstName + " how much is an extra roll worth to you? Normally you click during your own turn.");
    }
}

default
{
    state_entry()
    {
        state WAIT;
    }

    on_rez(integer start_param)
    {
        llResetScript();
    }
}

state WAIT
{
    state_entry()
    {
        hide();
    }

    link_message(integer sender_number, integer number, string message, key id)
    {
        list msgParts = llParseString2List(message, [" "], []);
        string cmd = llList2String(msgParts, 0);

        if( cmd == CMD_STARTTURN )
        {
            playerID = id;
            playerName = llList2String(llParseString2List(llKey2Name(id), [" "], []),0);
            
            state PLAY;
        }
        else if( cmd == CMD_RESET )
        {
            state default;
        }
    }
}

state PLAY
{
    state_entry()
    {
        show();
    }

    touch_start(integer num)
    {
        key touchID = llDetectedKey(0);
        if( touchID == playerID )
        {
            llMessageLinked(LINK_ROOT, 0, BTN_ROLLDICE, playerID );
        }
        else
        {
            playerName = llList2String(llParseString2List(llKey2Name(playerID), [" "], []),0);
            notTurn(llList2String( llParseString2List( llKey2Name(llDetectedKey(0)), [" "],[] ), 0 ));
        }
    }

    link_message(integer sender_number, integer number, string message, key id)
    {
        list msgParts = llParseString2List(message, [" "], []);
        string cmd = llList2String(msgParts, 0);

        if(cmd == CMD_ENDTURN || cmd == CMD_ENDGAME)
        {
            state WAIT;
        }
        else if( cmd == CMD_RESET )
        {
            state default;
        }
    }
}