// your textures here
list Textures = ["Silver","Gold","Plasma","MoltenMetal","Amber.Midnight","MetalFoil"];
// your colors here
list Colors = [<1,1,1>,<1,0,0>,<0,1,0>,<0.25,0.41,0.88>,<0,1,0.9>,<1,1,0>,<0.2,0.8,0.2>,<1,0.65,0>];
// your buttons for colors here
list Buttons = ["White","Red","Green","Royalblue","Cyan","Yellow","limegreen","orange"];

integer Channel;
key User;

Menu1()
{
  llDialog(User, "Choose an option:", ["Textures", "Colors"], Channel);
}

Menu2()
{
    llDialog(User, "Choose a texture:", Textures, Channel);
}

Menu3()
{
    llDialog(User, "Choose a color:", Buttons, Channel);
}

default
{
    state_entry()
    {
        Channel = -((integer)llFrand(99999) + 999);
        llListen(Channel, "", NULL_KEY, "");
    }
    on_rez(integer start_param)
    {
        Channel = -((integer)llFrand(99999) + 999);
        llListen(Channel, "", NULL_KEY, "");
    }
    touch_start(integer total_number)
    {
        User = llDetectedKey(0);
        Menu1();
    }
    listen(integer channel, string name, key id, string message)
    {
        if(message == "Textures")
        {
            Menu2();
            return;
        } else if(message == "Colors")
        {
            Menu3();
            return;
        } else
        {
            integer x = llListFindList(Textures, [message]);
            if(x != -1)
            {
                llMessageLinked(LINK_SET, 0, llList2String(Textures, x), NULL_KEY);
            }
            x = llListFindList(Buttons, [message]);
            if(x != -1)
            {
                llMessageLinked(LINK_SET, 1, llList2String(Colors, x), NULL_KEY);
            }
        }
    }
}
