// 2018-03-19  by Shinobar Martinek
integer DEBUG = FALSE;
string obj = "";
string note_name = "";    // configure notecard
vector rel_pos = < 3.0, 1.5, 0.3>;    // meter position < x, y, z>
vector vel = ZERO_VECTOR;
vector pos;
rotation rot;
float zangle = 0;
integer AutoRez = TRUE;
float interval = 60.0;  //seconds
string pop_text = "Touch me to rez a sled.";
vector text_color = <0.5, 1.0, 0.5>;    //<red, green, blue>
string additional_anounce = "Wait a moment.";
string hascome = "";
string nearby = " is near by. Touch me to recall after it is gone.";
integer rez_param = TRUE;
float range = 10;   //meter sensing scope
integer Channel = 0; //0:open chat
string KeyWord = "Now we go!";
float Moment = 5.0;    //seconds

integer request = FALSE;
integer ask = FALSE;
integer running = FALSE;
integer popped = FALSE;
key rezzed = NULL_KEY;
integer handle = 0;
key lineKey;
integer line_count;
string line_buffer;
integer data_mode = 0;

//
debug(string message)
{
    if (DEBUG) { llOwnerSay(message); }
}

popup(string text, vector color)
{
    llSetText(text, color, 1.0);
    popped = TRUE;
}
popdown()
{
    llSetText("", ZERO_VECTOR, 1.0);
    popped = FALSE;
}

rez()
{
        if ( obj != "" )
        {
            llSay(0, obj + " is comming. " + additional_anounce);
//            llSleep(forawhile);
            pos = llGetPos() + rel_pos*llGetRot();
            rot = llGetRot();
            llRezObject(obj, pos, vel, rot, rez_param);
        }
}

test()
{
    llSensor(obj, NULL_KEY, SCRIPTED, range, PI);
}

integer open_note(string name)
{
    note_name = name;
    if ( llGetInventoryKey(note_name) == NULL_KEY )
    {
        note_name = llGetInventoryName(INVENTORY_NOTECARD,0);
    }
    if ( note_name == "" ) { return FALSE; }
    data_mode = 0;
    line_count = -1;
    line_buffer = "";
    next_line();
    return TRUE;
}

string next_line()
{
    if ( line_buffer != EOF )
    { lineKey = llGetNotecardLine( note_name, ++line_count ); }
    return line_buffer;
}

integer parse_line(string line)
{
    string data = line;
    list dataList;
    string name;
    string value;
    //
    if ( data == EOF ) { return -1; }
    if ( llSubStringIndex( data, "//" ) == 0 ) { data = ""; }
    dataList = llParseString2List( data, ["/"], [ ]);
    dataList = llParseString2List(  llList2String( dataList, 0), [";"], [ ]);
    data = llList2String(dataList, 0);
    if ( llSubStringIndex( data, "[" ) == 0 ) {
        ++data_mode;
        return 0;
    }
    if ( data_mode == 0 )
    {
        dataList = llParseString2List( data, ["="], [ ]);
        if ( llGetListLength( dataList ) < 2) { return 0; }
        name = llToLower( llList2String( dataList, 0 ) );
        value = llList2String( dataList, 1 );
//      llOwnerSay( name + " is " + (string)value );

        if ( llSubStringIndex( name, "pos" ) >= 0 )
        {
            rel_pos = (vector)value;
        }
        else if ( llSubStringIndex( name, "angle" ) >= 0 )
        {
            zangle = (float)value;
        }
        else if ( llSubStringIndex( name, "rez" ) >= 0 )
        {
            rez_param = (integer)value;
        }
    }
//    else
//    {
//        targets += [data];
//      llOwnerSay(data);
//    }
    return 0;
}

close_listen()
{
        if (handle) llListenRemove(handle);
        handle = 0;
}

default
{
    state_entry()
    {
        popdown();
        if ( open_note(note_name) )
        {
            llOwnerSay( "Reading " + note_name + ".");
        }
        else
        {
            state active;
        }
    }

    on_rez(integer start_param)
    {
        llSetTimerEvent(0);
        llResetScript();
    }

    dataserver(key query_id, string data) 
    {
        string line;
       //
        if ( query_id = lineKey )
        {
            line_buffer = data;
            line = next_line();
            if ( parse_line(line) )
            {
                llOwnerSay( (string)line_count + " lines read.");
                state active;
            }
        }
    }

}

state active
{
    state_entry()
    {
        debug(llGetScriptName());
        popdown();
        obj = llGetInventoryName(INVENTORY_OBJECT,0);
        if ( obj != "" )
        {
            llSay(0, "Touch me to call a " + obj + ".");
            popup(pop_text, text_color);
            //llSetTimerEvent(interval);
        }
        else
        {
            llOwnerSay("No object found.");
            popup("No object found.", <1.0, 0.5, 0.5>);
        }
        debug("Angle is " + (string)zangle);
        if ( zangle > 0.1 || zangle < -0.1 )
        {
            rot = llEuler2Rot(<0,0,DEG_TO_RAD*zangle>);
        }
    }

    state_exit()
    {
        llSetTimerEvent(0.0);
        running = FALSE;
        close_listen();
    }

    on_rez(integer start_param)
    {
        llSetTimerEvent(0);
        close_listen();
        llSleep(0.2);
        llResetScript();
    }

    changed(integer change)
    {
        if ( change & CHANGED_INVENTORY)
        {
            state default;
        }
    }

    touch_start(integer total_number)
    {
        debug("Touched.");
        if ( obj != "" )
        {
            ask = TRUE;
            request = TRUE;
            test();
            if (!running) llSetTimerEvent(interval);
            running = TRUE;
        }
        popdown();
    }

    sensor(integer num)
    {
        if (request)
        {
            if (ask)
            {
                llSay(0, obj + nearby);
            }

        }
        if (popped) popdown();
        ask = FALSE;
    }

    no_sensor()
    {
        if (request || AutoRez)
        {
            popdown();
            ask = FALSE;
            request = FALSE;
            rezzed = NULL_KEY;
            rez();
        }
        else
        {
            if (!popped) popup(pop_text, text_color);
        }
    }

    object_rez(key id)
    {
        rezzed = id;
        if ( hascome != "" ) llSay(0, obj + hascome);
        close_listen();
        handle = llListen(Channel, "", rezzed, KeyWord);
    }

    listen(integer ch, string speaker, key id, string text)
    {
        debug(llKey2Name(id) + ":" + text);
        if (text != KeyWord) return;
        close_listen();
        popup(pop_text, text_color);
        llSleep(Moment);
        test();
    }

    timer()
    {
        close_listen();
        test();
    }
} 