string KEYWORD = "sound";
string IDLE_SOUND = "s_idle";
integer last_prims;

preload()
{
    integer i = -1;
    string sound = llGetInventoryName(INVENTORY_SOUND, ++i);
    while ( sound != "" )
    {
        llPreloadSound(sound);
        sound = llGetInventoryName(INVENTORY_SOUND, ++i);
    }
}

default
{
    state_entry()
    {
        if ( IDLE_SOUND != "" )
        {
            if (llGetInventoryKey(IDLE_SOUND) == NULL_KEY )
            {
                llOwnerSay(IDLE_SOUND + " not found.");
                IDLE_SOUND = "";
            }
            else
            {
                llLoopSound(IDLE_SOUND, 0.0);
                llSleep(0.5);
            }
        }
        llStopSound();
        last_prims = llGetNumberOfPrims();
    }

    on_rez(integer param)
    {
        llStopSound();
        preload();
        llResetScript();
    }

    changed(integer change)
    {
        if (change & CHANGED_LINK)
        {
            integer prims = llGetNumberOfPrims();
            if ( prims > last_prims ) preload();
            last_prims = prims;
        }
    }

    link_message(integer sender, integer num, string text, key id)
    {
        if (text != KEYWORD ) return;
        if (num)
        {
            llLoopSound(id, 1.0);
        }
        else
        {
            if ( IDLE_SOUND != "" )
            {
                
                llLoopSound(IDLE_SOUND, 0.0);
                llSleep(0.5);
                llStopSound();
            }
        }
    } 
} 