string  BTN_PASS = "BTN_PASS";
string  CMD_ENDTURN = "CMD_END_TURN";
string  CMD_STARTTURN = "CMD_START_TURN";
string  CMD_ENDGAME = "CMD_ENDGAME";

string  CMD_RESET = "CMD_RESET";

key     playerID = NULL_KEY;

integer TOP_SIDE = 0;
integer SIDE_SIDE = 2;
vector  REPEAT_ONCE = <1.0, 1.0, 0.0>;
vector  WHITE = <1.0, 1.0, 1.0>;
vector  GREY = <0.3, 0.3, 0.3>;
key     BLANK = "5748decc-f629-461c-9a36-a35a221fe21f";
key     LABEL = "3a34027e-7369-45ca-8812-4161ce2919c1";

hide()
{
    llSetPrimitiveParams([
        PRIM_COLOR, ALL_SIDES, GREY, 0.0,
        PRIM_COLOR, TOP_SIDE, WHITE, 0.0,
        PRIM_BUMP_SHINY, SIDE_SIDE, PRIM_SHINY_HIGH, PRIM_BUMP_SHINY,
        PRIM_TEXTURE, ALL_SIDES, (string)BLANK, REPEAT_ONCE, ZERO_VECTOR, 0.0,
        PRIM_TEXTURE, TOP_SIDE, (string)LABEL, REPEAT_ONCE, ZERO_VECTOR, 0.0]);

    llSetPos(<0.175,-0.1,-0.01>);
}

show()
{
    llSetPrimitiveParams([
        PRIM_COLOR, ALL_SIDES, GREY, 1.0,
        PRIM_COLOR, TOP_SIDE, WHITE, 1.0,
        PRIM_BUMP_SHINY, SIDE_SIDE, PRIM_SHINY_HIGH, PRIM_BUMP_SHINY,
        PRIM_TEXTURE, ALL_SIDES, (string)BLANK, REPEAT_ONCE, ZERO_VECTOR, 0.0,
        PRIM_TEXTURE, TOP_SIDE, (string)LABEL, REPEAT_ONCE, ZERO_VECTOR, 0.0]);

    llSetPos(<0.175,-0.1,0.01>);
}

default
{
    state_entry()
    {
        state WAIT;
    }

    on_rez(integer start_param)
    {
        llResetScript();
    }
}

state WAIT
{
    state_entry()
    {
        hide();
    }

    link_message(integer sender_number, integer number, string message, key id)
    {
        list msgParts = llParseString2List(message, [" "], []);
        string cmd = llList2String(msgParts, 0);

        if(cmd == CMD_STARTTURN)
        {
            playerID = id;

            state PLAY;
        }
        else if(cmd == CMD_RESET)
        {
            llResetScript();
        }
    }
}

state PLAY
{
    state_entry()
    {
        show();
    }

    touch_start(integer num)
    {
        if(playerID == llDetectedKey(0))
        {
            llMessageLinked(LINK_ROOT, 0, BTN_PASS, playerID);
        }
    }

    link_message(integer sender_number, integer number, string message, key id)
    {
        list msgParts = llParseString2List(message, [" "], []);
        string cmd = llList2String(msgParts, 0);

        if(cmd == CMD_RESET)
        {
            llResetScript();
        }
        else if (cmd == CMD_ENDTURN || cmd == CMD_ENDGAME)
        {
            state WAIT;
        }
    }
}