// sit target configureable
// 2019-11-06  by Shinobar Martinek
integer DEBUG = FALSE;   // verbose chat to the owner
string POP_TEXT = "";   // pop up text
string POP_UNSIT = "";    // pop tex when already sit
string POP_WAIT = "";    // pop tex when restart
vector TEXT_COLOR = <1.0, 1.0, 1.0>;    // <r,g,b> pop up text color
vector UNSIT_COLOR = <1.0, 0.0, 1.0>;
string MENU_TEXT = "";   //  text in pi menu
string MENU_UNSIT = "";    // menu when already sit
vector POSITION = <0.3, 0.0, 0.3>;    // <x,y,z> meters offset  when the agent face to the east
vector ADJUST = <0.0, 0.0, 0.0>;    // auto adjust ratio by the avatar size. require root prim
vector ANGLE = <0.0, 0.0, 0.0>;                  //<x,y,z> degrees 
vector CAMERA_POS = <0.0, 0.0, 0.0>;
vector CAMERA_DIR = <0.0, 0.0, 0.0>;
integer LOCAL = TRUE;  // POSITIONS and angles are local coodinate
integer HIDE = FALSE;   // hide the targete ball when sitting
string ANIMATION = "";
key ANIMATION_ID = "";
//string BASE_ANIMATION = "";   // fixed animation
//list expressions = [];
float INTERVAL = 30.0;    // seconds interval to change pose
float MOMENT = 0.5;     // seconds animations overlap
integer REPEAT = TRUE;  // repeat animations cyclic
integer RESTART = TRUE;    // start the first animation at next sit
integer TOUCH = FALSE; // touch then change pose
integer CHANNEL = 0;   // Remote command channel (0: no remote)
integer STANDUP = FALSE;    // unsit after MOMENT
integer SYNC = FALSE;    // wait a partner sit
string TOUCHME_MSG = "Touch me to change animation.";
//
string note_head = "SITCONFIG";
string note_head2 = "CONFIG";   //backward compatibility
string MISSING = "%s not found.";
string note = "";
integer obsolete = FALSE;
string sound = "";
string pop_text = "";
list welcome_lines = [];
list farewell_lines = [];
list anims = [];
string anim = "";
string last_anim = "";
integer total = 0;
integer index = 0;
string eanim = "";
integer etotal = 0;
integer eindex = 0;
integer overlap = FALSE;
integer freerun = FALSE;
integer channel;
integer handle = 0;
//
rotation org_rot = ZERO_ROTATION;
float STD_SIZE = 1.75;  //meter normal avatar tall
float small = 0.01; //meter to be adjusted
vector adjust = ZERO_VECTOR;
vector target_pos = ZERO_VECTOR;
rotation target_rot = ZERO_ROTATION;
key agent = NULL_KEY;
key last_agent = NULL_KEY;
key last_id = NULL_KEY;
key partner = NULL_KEY;
integer seat_number;
vector v;
//
string data_mode = "";
key lineKey;
integer line_count = -1;

debug(string message)
{
    if (!DEBUG) { return; }
    llOwnerSay(message);
}

pop(string text, vector color)
{
    llSetText(text, color, 1.0);
}

vector half_height()
{
    vector size = llGetScale();
    size = <0.0, 0.0, 0.5*size.z>;
    if ( size.x > 0.5 ) size += <0.5*(size.x - 0.5), 0.0, 0.0>;
    return size;
}

setsit()
{
//    llSetSitText(MENU_TEXT);
  target_pos = ZERO_VECTOR;
  target_rot =  ZERO_ROTATION;
  if ( POSITION == ZERO_VECTOR )
  {
    llSitTarget(ZERO_VECTOR, ZERO_ROTATION);
    llSetCameraEyeOffset(ZERO_VECTOR);
    llSetCameraAtOffset(ZERO_VECTOR);
    debug("Sit target reset.");
  }
  else
  {
      target_pos = POSITION;
      if ( note == "" ) target_pos += half_height();
      target_rot = llEuler2Rot(DEG_TO_RAD*ANGLE);
      if (!LOCAL)
      {
          target_pos = POSITION/org_rot;
          target_rot = llEuler2Rot(DEG_TO_RAD*ANGLE)/org_rot;
          debug("Pos and angle: " + (string)target_pos + ", " + (string)(RAD_TO_DEG*llRot2Euler(target_rot)));
      }
      llSitTarget(target_pos, target_rot);
      setcam();
    }
    //show();
}
setcam()
{
    if (LOCAL)
    {
        llSetCameraEyeOffset(CAMERA_POS);
        llSetCameraAtOffset(CAMERA_DIR);
    }
    else
    {
        llSetCameraEyeOffset(CAMERA_POS/org_rot);
        llSetCameraAtOffset(CAMERA_DIR/org_rot);
    }

}

//home() { llSetRot(org_rot); }

vector adjust_pos(vector adjust_rate)
{
    vector localpos = ZERO_VECTOR;
    v = llGetAgentSize(agent);
    debug("Avatar size=" + (string)v.z);
    adjust = (STD_SIZE - v.z)*adjust_rate;
    if (!LOCAL) adjust = adjust/org_rot;
    if (llVecMag(adjust) < small) return ZERO_VECTOR;
    integer linkNum = llGetNumberOfPrims();
    integer done = FALSE;
    do
    {
        if(agent == llGetLinkKey( linkNum ))//just checking to make sure the index is valid.
        {
            localpos = llList2Vector(llGetLinkPrimitiveParams(linkNum, [PRIM_POS_LOCAL]), 0);
            debug("Original local position = " + (string)localpos);
            llSetLinkPrimitiveParamsFast(linkNum,
                        [PRIM_POS_LOCAL, localpos + adjust ]
                         );
            done = TRUE;
        }
    } while( !done && --linkNum );
    if (!done) adjust = ZERO_VECTOR;
    debug("Adjustment = " + (string)adjust);
    return adjust;
}

hide()
{
    if ( !(POP_WAIT == "" && POP_UNSIT == "" && POP_TEXT == "") ) pop(POP_UNSIT, UNSIT_COLOR);
    llSetSitText(MENU_UNSIT);
    if ( !HIDE ) { return; }
    llSetAlpha(0.0, ALL_SIDES);
}

show()
{
    if ( !(POP_WAIT == "" && POP_UNSIT == "" && POP_TEXT == "") ) pop(POP_TEXT, TEXT_COLOR);
    llSetSitText(MENU_TEXT);
    if ( !HIDE ) { return; }
    llSetAlpha(1.0, ALL_SIDES);
}

startanim(string anim)
{
    if ( anim == "" || anim == NULL_KEY ) { return;}
    llStartAnimation(anim);
}

stopanim(string anim)
{
    if ( anim == "" || anim == NULL_KEY ) { return;}
    debug("Stopping " + (string)anim);
    llStopAnimation(anim);
}

stopallanim_but(string name)
{
    if (agent == NULL_KEY) { return; }
    integer i = 0;
    //llSleep(MOMENT);
    //stopanim("SIT_FEMALE");
    list anims = llGetAnimationList(agent);
    startanim(name);
    //llSleep(MOMENT);
    if (llGetAttached() != 0) return;
    integer m = llGetListLength(anims);
    for (i = 0; i < m; ++i)
    {
        llSleep(0.1);
        stopanim( llList2String(anims, i) );  
    }
}

//baseanim()
//{
//    startanim( BASE_ANIMATION );
//}

string newanim()
{
    //stopanim(eanim);
    //if ( total <= 0 ) {
    //    name = ANIMATION;
    //}
    if ( ++index >= total )
    {
        if (STANDUP) { llUnSit(agent); return ""; }
        else if (REPEAT)
        {
            index = 0;
            if ( partner != NULL_KEY ) index = 1;
        }
        else { return ""; }
    }
    anim = llList2String(anims,index);
    switchanim(anim);
    return anim;
}
string backanim()
{
    //stopanim(eanim);
    //if ( total <= 0 ) {
    //    name = ANIMATION;
    //}
    if ( --index < 0 )
    {
        if (STANDUP) { llUnSit(agent); return ""; }
        else if (REPEAT) { index = total - 1; }
        else { return ""; }
    }
    anim = llList2String(anims,index);
    switchanim(anim);
    return anim;
}
string switchanim(string anim)
{
    startanim(anim);
    if ( anim != last_anim )
    {
        llSleep(MOMENT); // stop last
        stopanim(last_anim);
    }
    last_anim = anim;
    //stopallanim_but(anim);
    return anim;
}

string firstanim(integer num)
{
    index = num - 1;
    last_anim = "";
    string name = newanim();
    //string name = llList2String(anims,index);
    //if ( ++index >= total ) { index = 0; }
    //if ( name != "" ) { stopallanim_but(name); }
    last_anim = name;
    anim = last_anim;
    return name;
}
playtimer(integer onoff)
{
    llSetTimerEvent(0);
    freerun = onoff;
    llSleep(0.1);
    if (freerun) llSetTimerEvent(INTERVAL);
    if (freerun) debug("Freerun set.");
    else debug ("Freerun stopped.");
}

//newexpression()
//{
//    stopanim(last_anim);
//    last_anim=anim;
//    if ( etotal <= 0 ) { return; }
//    eanim = llList2String(expressions, eindex);
//    startanim(eanim);
//    if ( ++eindex >= etotal ) { eindex = 0; }
//}
tellanim()
{
    if (TOUCH || CHANNEL || DEBUG)
        message(NULL_KEY, "Now playing " + (string)anim);
}

message(key agent, string s)
{
    if ( s == "" ) return;
    if (agent == NULL_KEY) llSay(0, s);
    else if ( agent == llGetOwner() ) llOwnerSay(s);
    else llInstantMessage(agent, s);
}

long_message(key agent, list m)
{
    if (llGetListLength(m) <= 0 ) return;
    string s = "";
    string name = "";
    if (agent != NULL_KEY) { name = llKey2Name(agent); }
    integer n = llGetListLength(m);
    integer i = 0;
    for (i = 0; i<n; ++i)
    {
        s = llList2String(m,i);
        if (name != "" )
        {
            s = replace(s, "%f", "%F");    //backward compatible
            s = replace(s, "%s", "%AV");    //backward compatible  
            s = replace(s, "%AV", name);
            s = replace(s, "%F", firstname(agent));
        }
        message(agent,s);
    }
}

string replace(string s, string mark, string rep)
{
    integer i = llSubStringIndex(s, mark);
    while ( i >= 0 )
    {
        s = llDeleteSubString( s, i, i+1 );
        s = llInsertString( s, i, rep);
        i = llSubStringIndex(s, mark);
    }
    return s;
}

string firstname(key agent)
{
    string name;
    integer index;
    name = llKey2Name(agent);
    if (name == "") return ""; 
    index = llSubStringIndex(name, " ");
    if (index > 0) name = llGetSubString(name, 0, index - 1);
    index = llSubStringIndex(name, ".");
    if (index > 0) name = llGetSubString(name, 0, index - 1);
    return name;
}

integer lookup()
{
    debug ("lookup");
    string name;
    anims = [];
    //animids = [];
    if (ANIMATION != "") { anims += [ANIMATION]; }
    integer t = llGetInventoryNumber(INVENTORY_ANIMATION);
    integer i;
    for ( i = 0; i < t; ++i )
    {
        name = llGetInventoryName(INVENTORY_ANIMATION,i);
        if ( name != "" && name != ANIMATION ) {
            anims += [name];
            //animids += [llGetInventoryKey(name)];
        }
    }
    total = llGetListLength(anims);
    index = 0;
    string s;
    if ( total > 0 ) { s = (string)total; }
    else { s = "No"; } 
    debug(s + " animations found.");
    //
    if ( llGetInventoryKey(sound) != NULL_KEY )
    { debug( sound + " found."); }
    //
    return total;
}

string open_note(string head)
{
    if (llGetInventoryKey(head) != NULL_KEY )
    {
        note = head;
    }
    else
    {
        note = "";
        string name = "";
        integer loop = TRUE;
        integer i = -1;
        while (loop)
        {
            name = llGetInventoryName(INVENTORY_NOTECARD,++i);
            if ( name == "" ) { loop = FALSE; }
            else if (llSubStringIndex(name, head) == 0)
            {
                note = name;
                loop = FALSE;
            }
        }
    }
    if ( note == "" )
    {
        message(llGetOwner(), replace(MISSING, "%s", head));
        return "";
    }
    debug("Reading... " + note);
    data_mode = "";
    lineKey = NULL_KEY;
    line_count = -1;
    data_mode = "";
    next_line();
    return note;
}

next_line()
{
    lineKey = llGetNotecardLine( note, ++line_count );
}

integer parse_line(string line)
{
    string s = line;
    list dataList;
    string name;
    string value;
    //
    if ( s == EOF ) { return -1; }
    s = llStringTrim(line, STRING_TRIM);
    if (llSubStringIndex(s,"[") == 0 )
    {
        s = llGetSubString(s,1,-1);
        s = llList2String(llParseString2List(s,["]"],[]),0);
        data_mode = llToLower(llStringTrim(s, STRING_TRIM));
        if ( llSubStringIndex( data_mode, "anim") == 0 ) { anims = []; } 
        //else if ( llSubStringIndex(data_mode, "exp")　== 0 ) { expressions = []; } 
        else if ( llSubStringIndex( data_mode, "welcome") == 0 ) { welcome_lines = []; }
        else if ( llSubStringIndex( data_mode, "farewel") == 0 ) { farewell_lines = []; }
        return 0;
    }
    if ( llSubStringIndex(data_mode, "anim") == 0 )
    {
        anims += [s];
        return 1;
    } 
//    if ( llSubStringIndex(data_mode, "exp")　== 0 )
//    {
//        expressions += [s];
//        return 1;
//    } 
    if (llSubStringIndex(data_mode,"pop") >= 0 )
    {
        if (pop_text == "") { pop_text = line; }
        else { pop_text += "\n" + line; }
        return 1;
    }
    if (llSubStringIndex(data_mode,"welcome") >= 0 )
    {
        welcome_lines += [line];
        return 1;
    }
    if (llSubStringIndex(data_mode,"farewel") >= 0 )
    {
        farewell_lines += [line];
        return 1;
    }
    if ( s == "" ) { return 0; }
    if ( llSubStringIndex( s, "//" ) == 0 ) { return 0; }
    dataList = llParseString2List( s, ["/"], [ ]);
    dataList = llParseString2List(  llList2String( dataList, 0), [";"], [ ]);
    s = llList2String(dataList, 0);
    dataList = llParseString2List( s, ["="], [ ]);
        if ( llGetListLength( dataList ) < 2) { return 0; }
        name = llToLower( llStringTrim(llList2String( dataList, 0 ),STRING_TRIM) );
        value = llStringTrim(llList2String( dataList, 1 ),STRING_TRIM);
        //debug( name + " is " + (string)value );

        if ( llSubStringIndex( name, "unsit_color" ) >= 0 )
        {
            UNSIT_COLOR = (vector)value;
        }
        else if ( llSubStringIndex( name, "color" ) >= 0 )
        {
            TEXT_COLOR = (vector)value;
        }
        else if ( llSubStringIndex( name, "pop_unsit" ) >= 0 )
        {
            POP_UNSIT = EjectQuotes(value);
        }
        else if ( llSubStringIndex( name, "pop_wait" ) >= 0 )
        {
            POP_WAIT = EjectQuotes(value);
        }
        else if ( llSubStringIndex( name, "pop" ) >= 0 )
        {
            POP_TEXT = EjectQuotes(value);
        }
        else if ( llSubStringIndex( name, "unsit" ) >= 0 )
        {
            MENU_UNSIT = EjectQuotes(value);
        }
        else if ( llSubStringIndex( name, "menu" ) >= 0 )
        {
            MENU_TEXT = EjectQuotes(value);
        }
        else if ( llSubStringIndex( name, "camera_pos" ) >= 0 )
        {
            CAMERA_POS = (vector)value;
        }
        else if ( llSubStringIndex( name, "camera_dir" ) >= 0 )
        {
            CAMERA_DIR = (vector)value;
        }
        else if ( llSubStringIndex( name, "pos" ) >= 0 )
        {
            POSITION = (vector)value;
        }
        else if ( llSubStringIndex( name, "adjust" ) >= 0 )
        {
            ADJUST = (vector)value;
        }
        else if ( llSubStringIndex( name, "angle" ) >= 0 )
        {
            ANGLE = (vector)value;
        }
        else if ( llSubStringIndex( name, "local" ) >= 0 )
        {
            LOCAL = Logical(value);
        }
        else if ( llSubStringIndex( name, "hide" ) >= 0 )
        {
            HIDE = Logical(value);
        }
//        else if ( llSubStringIndex( name, "base" ) == 0 )
//        {
//            BASE_ANIMATION = EjectQuotes(value);
//        }
        else if ( llSubStringIndex( name, "animation_id" ) >= 0 )
        {
            ANIMATION_ID = EjectQuotes(value);
        }
        else if ( llSubStringIndex( name, "animation" ) >= 0 )
        {
            ANIMATION = EjectQuotes(value);
        }
        else if ( llSubStringIndex( name, "repeat" ) >= 0 )
        {
            REPEAT = Logical(value);
        }
        else if ( llSubStringIndex( name, "restart" ) >= 0 )
        {
            RESTART = Logical(value);
        }
        else if ( llSubStringIndex( name, "interval" ) >= 0 )
        {
            INTERVAL = (float)value;
        }
        else if ( llSubStringIndex( name, "moment" ) >= 0 )
        {
            MOMENT = (float)value;
        }
        else if ( llSubStringIndex( name, "touchme" ) >= 0 )
        {
            TOUCHME_MSG = EjectQuotes(value);
        }
        else if ( llSubStringIndex( name, "touch" ) >= 0 )
        {
            TOUCH = Logical(value);
        }
        else if ( llSubStringIndex( name, "channel" ) >= 0 )
        {
            CHANNEL = (integer)value;
        }
                else if ( llSubStringIndex( name, "standup" ) >= 0 )
        {
            STANDUP = Logical(value);
        }
        else if ( llSubStringIndex( name, "sync" ) >= 0 )
        {
            SYNC = Logical(value);
        }
        else if ( llSubStringIndex( name, "debug" ) >= 0 )
        {
            DEBUG = Logical(value);
        }
        return 0;
}

integer Logical(string str)
{
    string s = llToLower(str);
    if ( s == "true" ) { return TRUE; }
    if ( s == "false" ) { return FALSE; }
    return (integer)str;
}

string EjectQuotes(string str)
{
    string s;
    integer n;
    string QUOTE = "\"";
    s = str;
    if ( llGetSubString(s,0,0) == QUOTE )
    { s = llGetSubString(s,1,-1); }
    n = llStringLength(s);
    if ( llGetSubString(s, n -1 , -1) == QUOTE )
    {
        if ( n <= 1 ) { s = ""; }
        else { s = llGetSubString(s,0,n-2); }
    }
    return s;
}

hotstart()
{
    debug(llGetScriptName());
    playtimer(FALSE);   //llSetTimerEvent(0);
    seat_number = (integer)llList2String(llParseString2List(llGetObjectName(),[" "],[]),-1);
    if (POP_WAIT != "") pop(POP_WAIT, UNSIT_COLOR);
    llSetSitText(MENU_UNSIT);
    obsolete = FALSE;
    if ( open_note(note_head) == "" )
    {
        if ( open_note(note_head2) != "" ) obsolete = TRUE;
        else
        {
            //DEBUG = FALSE;
            afterwork();
        }
    }
}

afterwork()
{
    debug ("afterwork");
    if (obsolete)
    {
        DEBUG = TRUE;
        message(llGetOwner(), "'" + note + "' is obsolute. Use '" + note_head + "' instead.");
    }
    channel = CHANNEL;
    setsit();
    lookup();
    if (ANIMATION != "")
    {
        message(llGetOwner(), "Anmation = " + ANIMATION); 
        //anims = [ ANIMATION ] + anims;
    }
    //total = llGetListLength(anims);
    //etotal = llGetListLength(expressions);
    message(llGetOwner(), "Ready.");
    if ( llAvatarOnSitTarget() != NULL_KEY ) hide();
    else show();
    setanim();
    start_listen(channel);
}

setanim()
{
    if ( llGetAttached() != 0 )
    {
        debug("Attached.");
        agent = llGetOwner();
        if ( sound != "" )
        { llTriggerSound(sound, 1.0); }
        //if (llGetListLength(welcome_lines) > 0 )
        //{ long_message(agent, welcome_lines); }
    }
    else
    {
        agent = llAvatarOnSitTarget();
    }
    if (agent != NULL_KEY)
    {
        if (total > 0 || ANIMATION != "" ) {
            if ( agent == last_agent && llGetPermissions() & PERMISSION_TRIGGER_ANIMATION )
            {
                //if ( anim != "" ) startanim(anim);
                //else
                init_anim();
            }
            else
                llRequestPermissions(agent, PERMISSION_TRIGGER_ANIMATION);
        }
    }
    last_agent = agent;
}

init_anim()
{
    if (partner != NULL_KEY)
    {
        anim = firstanim(1);
    }
    else if ( RESTART || SYNC ) { anim = firstanim(0);}
    else { anim = firstanim(index); }
    startanim(anim);
    if ( llGetAttached() == 0 )
    {
        stopanim("SIT");
        stopanim("SIT_FEMALE");
    }
    llSleep(MOMENT);
    tellanim();
    stopallanim_but(anim);
    startanim(anim);
    //if (CHANNEL) start_listen();
    start_timer();
}

start_listen(integer ch)
{
    if ( ch == 0 ) return; 
    handle = llListen(ch, "", NULL_KEY, "");
    debug("Listning channel#" + (string)ch + ".");
}

start_timer()
{
    if (SYNC)
    {
        if ( partner != NULL_KEY )
        {
            debug("Partner is " + llKey2Name(partner) + ".");
            if ( INTERVAL >= 0.1 && total > 2 || llGetAttached() != 0 ) playtimer(TRUE);
            else playtimer(FALSE);
        }
        else
        {
            debug("Partner not found.");
            playtimer(FALSE);
        }
    }
    else if ( INTERVAL >= 0.1 && total > 1 || llGetAttached() != 0 ) playtimer(TRUE);
    else
    {
        playtimer(FALSE);
        //if ( total > 1 && TOUCH && TOUCHME_MSG != "" ) message(NULL_KEY, TOUCHME_MSG);
    }
    if ( total > 1 && TOUCH && TOUCHME_MSG != "" ) message(NULL_KEY, TOUCHME_MSG);
}

command(string str, integer num, key id)
{
    debug("command: cmd=" + str + " num=" + (string)num + " id=" + (string)id);
        if (llSubStringIndex(str, "unsit") == 0)
        {
            agent = llAvatarOnSitTarget();
            if ( agent != NULL_KEY ) llUnSit(agent);
        }
        else if (llSubStringIndex(str, "sit") == 0)
        {
            //if (sender == llGetLinkNumber()) { return; }
            if (!SYNC) return;
            if ( id == last_id ) return;
            last_id = id;
            partner = id;
            if ( agent == NULL_KEY ) return;
            if ( partner == NULL_KEY )
            {
                playtimer(FALSE);
                index = -1;
            }
            else
            {  
                if ( INTERVAL >= 0.1 && total > 2 ) playtimer(TRUE);
            }
            anim = newanim();
            tellanim();
        }
        else if ( str == "up" || str == "next" ) { anim = newanim(); tellanim();}
        else if ( str == "down" || str == "prev" ) { anim = backanim(); tellanim();}
        else if ( str == "anim" )
        {
            index = num - 1;
            anim = newanim();
            tellanim();
        }
}

default
{
    state_entry()
    {
        //llSetClickAction(CLICK_ACTION_SIT);
        channel = CHANNEL;
        org_rot = llGetRot();
        hotstart();
    }
 
    on_rez(integer param)
    {
        if (param) channel = param;
        setcam();
        show();
        setanim();
        start_listen(channel);
    }

    dataserver(key query_id, string data) 
    {
        if ( query_id != lineKey ) { return; }
        if ( parse_line(data) < 0 ) {
            message(llGetOwner(), (string)line_count + " lines read.");
            afterwork();
        } else {
            next_line();
        }
    }
 
    changed(integer change) {
        //debug("Change:" + (string)change);
        if (change & CHANGED_INVENTORY) {
            llSleep(1.0);
            //DEBUG = TRUE;
            hotstart();
        }
        else if (change & CHANGED_SCALE )
        {
            llSleep(1.0);
            setsit();
            return;
        }
        else if (change & CHANGED_LINK) {
          agent = llAvatarOnSitTarget();
          if ( agent == last_agent ) return;
          last_agent = agent;
          if (agent == NULL_KEY ) llSleep(MOMENT);
          else debug(llKey2Name(agent) + " is sit.");
          llMessageLinked(LINK_ALL_OTHERS,seat_number,"sit",agent);
          if (channel) llWhisper(channel, "sit " + (string)seat_number + " " + (string)agent);
            if (agent != NULL_KEY) {
                if (total > 0) {
                    llRequestPermissions(agent,PERMISSION_TRIGGER_ANIMATION);
                }
                hide();
                if ( sound != "" )
                { llTriggerSound(sound, 1.0); }
                long_message(agent, welcome_lines);
                if (STANDUP)
                {
                    llSleep(MOMENT);
                    llUnSit(agent);
                    return;
                }
                adjust = ZERO_VECTOR;
                if ( llVecMag(ADJUST) > small )
                {
                    adjust = adjust_pos(ADJUST);
                }
            } else {
                show();
                long_message(last_agent, farewell_lines);
                playtimer(FALSE);
                if (RESTART) { index = 0; }
                last_anim = "";
            }
        }
        if ( change & CHANGED_TELEPORT )
        {
            if (last_agent == NULL_KEY) return;
            debug("CHANGED_TELEPORT");
            llSleep(4.0);
            setanim();
        }
        if ( change & CHANGED_REGION )
        {
            if (last_agent == NULL_KEY) return;
            debug("CHANGED_REGION");
            //show();
            if ( llGetAttached() == 0 )
            {
                key agent = NULL_KEY;
                integer i;
                for ( i = 0; i < 30 && agent == NULL_KEY; ++i)
                {
                    llSleep(2.0);
                    agent = llAvatarOnSitTarget();
                }
            }         
            setcam();
            llSleep(1.0);
            setanim();
        }
    }
    
    run_time_permissions(integer perm) {
        if (perm & PERMISSION_TRIGGER_ANIMATION) {
            init_anim();
        }
    }

    timer()
    {
        if ( !llGetAttached() && llAvatarOnSitTarget() == NULL_KEY ) {
            hotstart();
            return;
        }
        if (freerun)
        {
            anim = newanim();
        }
        else
        {
            llSetTimerEvent(0.0);
            //stopallanim_but(anim);
        }
    }
    
    touch_start(integer total_number)
    {
        if (TOUCH == FALSE) { return; }
        if ( llDetectedKey(0) != llAvatarOnSitTarget() ) { return; }
        if ( anim == "" || anim  == NULL_KEY ) { return; }
        llSetTimerEvent(0);
        //if (overlap) { newexpression(); }
        anim = newanim();
        tellanim();
        if (freerun) { llSetTimerEvent(INTERVAL); }
    }

    listen(integer ch, string name, key speaker, string msg)
    {
        debug("listen:" + msg);
        list dataList = llParseString2List(msg, [" "], [ ]);
        string cmd = llList2String(dataList, 0);
        integer num = llList2Integer(dataList, 1);
        key id = llList2Key(dataList, 2);
        if ( cmd == "sit" )
        {
            command(cmd, num, id);
        }
        else
        {
            command(cmd, num, NULL_KEY);
        }
    }
    
    link_message(integer sender, integer num, string str, key id)
    {
        debug((string)sender + ":" + (string)num + ":" + str + " " + (string)id);
        if ( str == "sit" )
        {
            if (sender == llGetLinkNumber()) return;
            if (!SYNC) return;
        }
        command(str, num, id);
    }
}
 