integer   dieNum = 0;
integer   dieValue = 0;

key       playerID = NULL_KEY;
string    playerName = "";

string    CMD_ENDTURN = "CMD_END_TURN";
string    CMD_STARTTURN = "CMD_START_TURN";
string    CMD_ROLLDICE = "CMD_ROLL_DICE";
string    CMD_UNSELECTDIE = "CMD_UNSELECTDIE";

string    CMD_TESTDIEFACE = "CMD_TESTDIEFACE";
string    CMD_TESTDICE = "CMD_TESTDICE";
string    CMD_REPORTDIE = "CMD_REPORTDIE";
string    CMD_DIEFACE = "CMD_DIEFACE";

string    CMD_RESET = "CMD_RESET";
string    CMD_DEBUG = "CMD_DEBUG";
string    CMD_ON = "ON";
string    CMD_OFF = "OFF";

integer   TOP_FACE = 0;
vector    RED = <1.0, 0.0, 0.0>;
vector    WHITE = <1.0, 1.0, 1.0>;
vector      BLUE = <0.2, 0.2, 1.0>;

list    diceTextures = ["612a8011-97b8-44c7-abe3-9b4949821203",
    "de3e8288-8dd3-4b19-9705-a1331bce318c",
    "88ee9e68-b12d-4dca-abfc-bf2bb096a2c6",
    "072ca453-9ab1-46ad-a214-f0dcc3108d9e",
    "f8dbeb74-3bea-44ae-9ce3-733e56f70fb8",
    "40a99fe1-9222-4480-bf0c-a4ce76128e16"];

list    diceSides = ["0,4,1,3,2,5","2,0,1,3,5,4","3,4,0,5,2,1","1,4,5,0,2,3","4,5,1,1,0,2","5,2,1,3,4,0"]; // 0 on top

notTurn(string firstName)
{
    integer ix = (integer) llFrand(5.0);
    if(ix == 0)
    {
        llWhisper(0, firstName + ", Opps! Please don't touch the dice when it is " + playerName+"'s turn!");
    }
    else if (ix == 1)
    {
        llWhisper(0, "Really " + firstName + ", I think it is "+ playerName+"'s time to play or pass!");
    }
    else if (ix == 2)
    {
        llWhisper(0, firstName + ", Please don't click on the dice it is not your turn");
    }
    else if (ix == 3)
    {
        llWhisper(0, "Attention players " + firstName + " is trying to cheat again by ckicking out of turn!");
    }
    else if (ix == 4)
    {
        llWhisper(0, firstName + " how much is an extra roll worth to you? Normally you click during your own turn.");
    }
}

setTexture(integer val)
{
    integer i = 0;
    for (i = 0; i < 6; i++)
    {
        string faces = llList2String(diceSides, val);
        list sides = llParseString2List(faces, [","], [""]);

        key textureID = (key) llList2String(diceTextures, i);
        llSetTexture(textureID, llList2Integer(sides, i) );
    }
}

show(vector color)
{
    llSetPrimitiveParams([PRIM_COLOR, ALL_SIDES, color, 1.0]);
}

hide()
{
    llSetPrimitiveParams([PRIM_COLOR, ALL_SIDES, WHITE, 0.0]);
}
rollDie()
{
    integer oldDieValue = dieValue;
    while(oldDieValue == dieValue)
    {
        dieValue = ((integer)llFrand(6.0));
    }

    setTexture(dieValue);
}

init()
{
    dieNum = (integer) llGetSubString( llGetObjectDesc(), 1, 1);

    playerID = NULL_KEY;
}

default
{
    state_entry()
    {
        init();

        state WAIT;
    }

    on_rez(integer num)
    {
        llResetScript();
    }
}

state WAIT
{
    state_entry()
    {
        hide();

        dieValue = 0;
    }
    touch_start(integer total_number)
    {
        llPlaySound("NEW selection click", 1);
        llWhisper(0,"Please click ROLL to roll the dice first");
    }
    link_message(integer sender_number, integer number, string message, key id)
    {
        list msgParts = llParseString2List( message, [" "], [] );
        string cmd = llList2String( msgParts, 0 );
        string arg1 = llList2String( msgParts, 1 );

        if( cmd == CMD_STARTTURN )
        {
            playerID = id;
            playerName = llList2String(llParseString2List(llKey2Name(playerID), [" "], []),0);
            hide();
        }
        else if( cmd == CMD_ROLLDICE )
        {
            show( WHITE );
            
            rollDie();
            
            state UNSELECTED;
        }
        else if( cmd == CMD_RESET )
        {
            llResetScript();
        }
    }
}

state SCORED
{
    state_entry()
    {
        show( BLUE );
    }

    touch_start(integer total_number)
    {
        if(llDetectedKey(0) != playerID)
        {
            notTurn(llList2String( llParseString2List( llKey2Name(llDetectedKey(0)), [" "],[] ), 0 ));
        }
    }

    link_message(integer sender_number, integer number, string message, key id)
    {
        list msgParts = llParseString2List(message, [" "], []);
        string cmd = llList2String(msgParts, 0);
        string arg1 = llList2String(msgParts, 1);

        if( cmd == CMD_ENDTURN )
        {
            state WAIT;
        }
        else if( cmd == CMD_ROLLDICE )
        {
        }
        else if( cmd == CMD_REPORTDIE )
        {
            llMessageLinked(LINK_ROOT, 0, CMD_DIEFACE+" "+(string)0, NULL_KEY);
        }
        else if (cmd == CMD_TESTDICE )
        {
            llMessageLinked(LINK_ROOT, 0, CMD_TESTDIEFACE+" "+(string)0, NULL_KEY);
        }
        else if( cmd == CMD_UNSELECTDIE)
        {
            state UNSELECTED;
        }
        else if(cmd == CMD_RESET)
        {
            llResetScript();
        }
    }
}

state SELECTED
{
    state_entry()
    {
        show( RED );
    }

    touch_start(integer total_number)
    {
        if(llDetectedKey(0) == playerID)
        {
            llPlaySound("NEW selection click", 1);

            state UNSELECTED;
        }
        else if(llDetectedKey(0) != playerID )
        {
            notTurn(llList2String( llParseString2List( llKey2Name(llDetectedKey(0)), [" "],[] ), 0 ));
        }
    }

    link_message(integer sender_number, integer number, string message, key id)
    {
        list msgParts = llParseString2List(message, [" "], []);
        string cmd = llList2String(msgParts, 0);
        string arg1 = llList2String(msgParts, 1);

        if(cmd == CMD_ENDTURN)
        {
            state WAIT;
        }
        else if( cmd == CMD_REPORTDIE )
        {
            llMessageLinked(LINK_ROOT, 0, CMD_DIEFACE+" "+(string)(dieValue+1), NULL_KEY);
        }
        else if( cmd == CMD_ROLLDICE )
        {
            state SCORED;
        }
        else if( cmd == CMD_UNSELECTDIE)
        {
            state UNSELECTED;
        }
        else if(cmd == CMD_RESET)
        {
            llResetScript();
        }
    }
}

state UNSELECTED
{
    state_entry()
    {
        show( WHITE );
    }

    touch_start(integer total_number)
    {
        if(llDetectedKey(0) == playerID)
        {
            llPlaySound("NEW selection click", 1);
            state SELECTED;
        }
        else if(llDetectedKey(0) != playerID)
        {
            notTurn(llList2String( llParseString2List( llKey2Name(llDetectedKey(0)), [" "],[] ), 0 ));
        }
    }

    link_message(integer sender_number, integer number, string message, key id)
    {
        list msgParts = llParseString2List(message, [" "], []);
        string cmd = llList2String(msgParts, 0);
        string arg1 = llList2String(msgParts, 1);

        if( cmd == CMD_ENDTURN )
        {
            state WAIT;
        }
        else if( cmd == CMD_ROLLDICE )
        {
            rollDie();
        }
        else if( cmd == CMD_REPORTDIE )
        {
            // die not selected, so report zero for it's face/value
            //
            llMessageLinked(LINK_ROOT, 0, CMD_DIEFACE+" " + (string)0, NULL_KEY);
        }
        else if (cmd == CMD_TESTDICE )
        {
            llMessageLinked(LINK_ROOT, 0, CMD_TESTDIEFACE+" "+(string)(dieValue+1), NULL_KEY);
        }
        else if(cmd == CMD_RESET)
        {
            llResetScript();
        }
    }
}