key     playerID = NULL_KEY;
string  playerName = "";

string  CMD_RESET = "CMD_RESET";
string  CMD_STARTTURN = "CMD_START_TURN";
string  CMD_UPDPLAYER = "CMD_UPDPLAYER";
string  CMD_ENDGAME = "CMD_ENDGAME";
string  CMD_ROLLDICE = "CMD_ROLL_DICE";

integer TOP_SIDE = 0;
integer SIDE_SIDE = 2;
vector  REPEAT_ONCE = <1.0, 1.0, 0.0>;
vector  GOLD = <1.0, 0.6, 0.0>;
vector  BLACK = <0, 0, 0>;
key     BLANK = "5748decc-f629-461c-9a36-a35a221fe21f";
key     LABEL = "447cbba5-2eb6-43b2-bf8c-a09cb4869422";

hide()
{
    llSetPrimitiveParams([
        PRIM_COLOR, ALL_SIDES, BLACK, 0.0,
        PRIM_COLOR, TOP_SIDE, GOLD, 0.0,
        PRIM_BUMP_SHINY, SIDE_SIDE, PRIM_SHINY_HIGH, PRIM_BUMP_SHINY,
        PRIM_TEXTURE, ALL_SIDES, (string)BLANK, REPEAT_ONCE, ZERO_VECTOR, 1.0,
        PRIM_TEXTURE, TOP_SIDE, (string)LABEL, REPEAT_ONCE, ZERO_VECTOR, 1.0]);

    llSetPos(<0.0,0.1,-0.01>);
}

show()
{
    llSetPrimitiveParams([
        PRIM_COLOR, ALL_SIDES, BLACK, 1.0,
        PRIM_COLOR, TOP_SIDE, GOLD, 1.0,
        PRIM_BUMP_SHINY, SIDE_SIDE, PRIM_SHINY_HIGH, PRIM_BUMP_SHINY,
        PRIM_TEXTURE, ALL_SIDES, (string)BLANK, REPEAT_ONCE, ZERO_VECTOR, 0.0,
        PRIM_TEXTURE, TOP_SIDE, (string)LABEL, REPEAT_ONCE, ZERO_VECTOR, 0.0]);

    llSetPos(<0.0,0.1,0.01>);
}

default
{
    state_entry()
    {
        hide();
    }

    link_message(integer sender_number, integer number, string message, key id)
    {
        list msgParts = llParseString2List( message, [" "], [] );
        string cmd = llList2String( msgParts, 0 );

        if( cmd == CMD_RESET )
        {
            llResetScript();
        }
        else if(cmd == CMD_STARTTURN)
        {
            state STARTTURN;
        }
    }
}

state STARTTURN
{
    state_entry()
    {
        show();
    }

    link_message(integer sender_number, integer number, string message, key id)
    {
        list msgParts = llParseString2List( message, [" "], [] );
        string cmd = llList2String( msgParts, 0 );

        if( cmd == CMD_RESET )
        {
            llResetScript();
        }
        else if(cmd == CMD_ROLLDICE)
        {
            state default;
        }
    }
}