// 2019-11-24  by Shinobar Martinek
integer DEBUG = 0;   //debug level, 1:verbose message to the owner, 2: echo the COURSE
integer BALLOON = FALSE;    //no tilt
integer BOAT = FALSE;       //never land
integer FOLLOW_TERRAIN = FALSE;  //go down following terrain, recommended FALSE for aircrafts
integer PHYSICS = FALSE; // use physic vehicle
integer STAY_PHANTOM = TRUE;    //prims to be phantom
integer MAX_PASSENGERS = 2;  //starts imidiately when MAX_PASSENGERS sit, 0:never auto start
integer MENU = TRUE;        //show menu to choose destination
integer OWNER_ONLY = FALSE;  // show menu only to the owner
integer ONLINE_CHECK = TRUE;    //check if next region is online, sometimes fails for varregions 
integer STANDUP_OK = FALSE;      //continue tour even with no passengers
integer STANDUP_ANYTIME = FALSE; //wait reride anytime the passengers stand up
integer FAST_BACK_HOME = 2; // back home fast in the same region, SPEED_HIGH*FAST_BACKHOME in another regions
integer CALL_CHANNEL = 0; // calling enable
integer SURFACE_ON_REZ = FALSE; //positioning on the surface at rezed

float GROUND_LEVEL = 0.1;   //usually at the lower edge of the root prim
float FLOAT_LEVEL = -0.1;   //offset from the water level
float DIVE_LEVEL = -0.7;  //dive this level if can
float SINK_LEVEL = -1.0; //entire body is under the water level, splashing stops under this level
float FLIGHT_LEVEL = 0.0;   //meter, lowest flight height for aircrafts

//sounds
string ENGINE_SOUND = "";
string IDLE_SOUND = "";
string START_SOUND = "";
string STOP_SOUND = "";
string NOTE_SOUND = "airplane-pa";
float START_MOMENT = 0.5;   //seconds wait before start
float STOP_MOMENT = 1.0;    //seconds wait after stop

//messages
//string WELCOME_MESSAGE = "Thank you for riding.";
string TOUCHME_MESSAGE = "Touch me to start.
タッチすると発進します。";
string LAUNCH_MESSAGE = "Now we go!";
string GOODBY_MESSAGE = "Thank you and goodby.";
string WAIT_MESSAGE = "Wait a moment...";
string READY_MESSAGE = "Touch me to ride.";
string NOTREADY_MESSAGE = "Sorry, not ready to ride.";
string OVERRUN_MESSAGE = "Over run.";
string BLOCKED_MESSAGE = "Dead locked.";
string OFFLINE_MESSAGE = "Next region seems offline.";
string ARRIVED_MESSAGE = "%s に着きました。";
string BRIEFSTOP_MESSAGE = "Brief stop for %s seconds. %s 秒 停止します。";
string TOUCHANDGO_MESSAGE = "Or touch me to restart imideately. タッチすると、すぐに発進します。";
string WAITING_MESSAGE = "Waiting your ride for %s seconds.";
string WAITING_MESSAGE0 = "Waiting your ride.";
string FROM_MENU = "メニューから行き先を選んでください。";
string MENU_MESSAGE = "Choose destination where to go.
行き先を選んでください。";
string MENU_CLOSED = "行き先はすでに決定しました。";
string BOUNDFOR = "%s に向かいます。";
integer POPUP = TRUE;   //show status on floating text
vector NORMAL_COLOR = <0.5, 1.0, 0.5>;
vector ERR_COLOR = <1.0, 0.5, 1.0>;

//buttons
string BACK = "Back <--";
string NEXT = "-->Next";
string BLANK = "......";
string CANCEL = "*Cancel*";
string ROUND = "ROUND TOUR";
string EVERY = "EVERY STOP";
string TOUR_START = "START";
string START_STATION = "START POINT";
string END_STATION = "TERMINAL";

//boundery
float TOOFAR = 1000.0;  //maters limit from the original point

//speed
float SPEED_HIGH = 40.0;     //meter per second
float SPEED_MID = 8.0;  //meter per second to pass the turning points
float SPEED_MIN = 4.0;  //meter per second to aproach station
//float BLOCK_SPEED = 0.5;   //meter per second to judge blocking
float MILE = 20.0;      // traveling length to see not deadlocked
float SLOWER = 4.0;     //2.0 - second accel/dump
float INTERVAL = 1.0;   //seconds


//route interpolation
float NEAR_STATION = 10.0;  //meter ignore for starting point
float NEAR = 1.0;   //x span, where span = speed x INTERVAL
float LINE_FORCE = 1.0;    //0.0-1.0: how close to polygonal line

//search water route, boat only
float ANGLE_STEP = 6.0; //degree to search directtion, BOAT only
float ANGLE_MAX = 90.0;     //degree max to search, BOAT only
float ANGLE_TIME = 16;      //angle search retry times limit, BOAT only;

//vehicle body orientation
float DELTA = 0.05;  // radian, clearance of adusting new rotation
float MAX_OMEGA = 1.0;  //radian per second
float FOLLOW_ANGLE_STRENGTH = 4.0;  //normally 4.0, phisical only

//timings
integer PARKING_TIME = 10;    //seconds brief stop
integer DOOR_TIME = 0;     //wait at the tour end
integer STAND_TIME = 60;    //parking time if stand up
integer TIMEOUT = 0;  //seconds before disappering at disposal
integer MENU_TIMEOUT = 180; //seconds timeout to repry menu
integer BLOCK_TIME = 60; // x INTERVAL to see blocking
integer RETRY_TIME = 3;     //times retry back home
float MOMENT = 1.0; // wait time before back home
float REGION_MOMENT = 1.0;  //second wait time at crossing regions
integer CROSSING_TIMEOUT = 120;  //seconds after crossing regions

//link message
integer ENGINE_SPEED = 3;           //>=3, propella rps
string POWER_COMMAND = "engine";
string LIGHT_COMMAND = "light";
string SPLASH_COMMAND = "splash";
string SOUND_COMMAND = "sound";
string DOOR_COMMAND = "door";
integer OPEN = FALSE;   // door open
integer CLOSE = TRUE;   //door close

//variables
list regions = [];
list offsets = [];
list stations = []; // COURSE is read from a note card
list terminals = [];
list buttons = [];
rotation STD_ROT = ZERO_ROTATION;
vector STD_ARROW = <1.0, 0.0, 0.0>; //toward east
float ground_level;
float float_level;
float dive_level;
float sink_level;
string note_head = "COURSE";
string note = "";
integer line_count;
key lineKey;
string org_region = "";
string now_region;
integer region_x = 0;
integer region_y = 0;
integer offset_x = 0;
integer offset_y = 0;
integer offset_u = 256;
vector corner;
integer org_wx;
integer org_wy;
integer org_ix;
integer org_iy;
string org_station = "";
string parking_station = "";
string request_station = "";
integer reverse = TRUE;
integer bound_index;
integer start_index = 0;
integer over_index = 0;
integer round_start = FALSE;
string region;
string fatal = "";
key last_sitter = NULL_KEY;

integer relative;
vector org_pos = ZERO_VECTOR;
vector org_t = ZERO_VECTOR;
rotation org_rot = ZERO_ROTATION;
vector milestone = ZERO_VECTOR;
integer org_prims;
integer ready = FALSE;
integer origin = FALSE;
integer hovering = FALSE;
integer hopping = FALSE;
integer diving = FALSE;
integer land = FALSE;
integer passengers = 0;
integer tstatus = 0; // tour status
integer pcount = 0; // parking counter
integer bcount = 0; // blocking counter
integer rcount = 0; // return counter
integer acount = 0; // angle search counter
integer ccount = 0; //crossing region counter
integer crossing_failed = FALSE;
integer powered = FALSE;
integer splashing = FALSE;
integer sky = FALSE;
integer crossing = FALSE;
integer returning = FALSE;
integer raised = FALSE;
integer landing = FALSE;
float span;
float speed;
float high_speed;
float low_speed;
vector offset;
vector now_pos;
rotation now_rot;
vector target;
vector next_pos;
rotation next_rot;
vector old_pos;
vector last_pos;
rotation last_rot;
vector now_t;
vector next_t;
vector last_speed;
float distance;
float small;
integer index;
string station_name;
vector position;
vector arrow;
vector old_arrow;
vector horisontal;
float angle;
rotation rot;
integer disposal;
integer debuglevel;
integer looped = FALSE;
integer oneway = FALSE;
integer shortcut = FALSE;
integer channel;
integer handle = 0;
integer call_handle = 0;
integer lcount = 0;
integer page;
string boundfor = "";
string s = "";
integer reset = FALSE;
integer door_state;

debug(string msg)
{
    if (debuglevel) llOwnerSay(msg);
}
error(string msg)
{
    llSay(0, msg);
    if (POPUP) popup(msg, ERR_COLOR);
}

popup(string text, vector color)
{
    if (POPUP) llSetText(text, color, 1.0);
}
popdown()
{
    if (POPUP) llSetText("", ZERO_VECTOR, 1.0);
}

vehicle()
{
    llSetVehicleType(VEHICLE_TYPE_AIRPLANE);
    hover(BALLOON || BOAT);
    llSetVehicleVectorParam(VEHICLE_LINEAR_MOTOR_OFFSET, llGetPos() - llGetCenterOfMass());
    llSetVehicleVectorParam(VEHICLE_ANGULAR_MOTOR_DIRECTION, ZERO_VECTOR);
    //llSetVehicleVectorParam(VEHICLE_LINEAR_MOTOR_DIRECTION, ZERO_VECTOR);
    llSetVehicleFloatParam(VEHICLE_LINEAR_MOTOR_TIMESCALE, 1.0);
    llSetVehicleFloatParam(VEHICLE_LINEAR_MOTOR_DECAY_TIMESCALE, 4.0);
    llSetVehicleVectorParam(VEHICLE_LINEAR_FRICTION_TIMESCALE, <8.0, 2.0, 1.0>);
    llSetVehicleFloatParam(VEHICLE_ANGULAR_MOTOR_TIMESCALE, 0.5);
    llSetVehicleFloatParam(VEHICLE_ANGULAR_MOTOR_DECAY_TIMESCALE, 1.0);
    llSetVehicleVectorParam(VEHICLE_ANGULAR_FRICTION_TIMESCALE, <1.0, 1.0, 4.0>);
        llSetVehicleFloatParam(VEHICLE_ANGULAR_DEFLECTION_TIMESCALE, INTERVAL);
        float e = 1.0;
        if (BALLOON) e = 0.0;
        llSetVehicleFloatParam(VEHICLE_ANGULAR_DEFLECTION_EFFICIENCY, e);       
    llSetVehicleFloatParam(VEHICLE_VERTICAL_ATTRACTION_TIMESCALE, 1.0);
    llSetVehicleFloatParam(VEHICLE_VERTICAL_ATTRACTION_EFFICIENCY, 1.0);
    if (FOLLOW_TERRAIN) llSetVehicleFlags(VEHICLE_FLAG_NO_DEFLECTION_UP);
    //llSetVehicleFlags(VEHICLE_FLAG_LIMIT_ROLL_ONLY);
}
physics(integer onoff)
{
    if (onoff)
    {
        if (!crossing)
        {
            llSetStatus(STATUS_PHANTOM, FALSE);
            //llSetLinkPrimitiveParams(LINK_ALL_CHILDREN, [PRIM_PHYSICS_SHAPE_TYPE, PRIM_PHYSICS_SHAPE_NONE]);
        }
        llSetStatus(STATUS_PHYSICS, TRUE);
    }
    else
    {
        hover(FALSE);
        llSetStatus(STATUS_PHYSICS, FALSE);
        if (crossing) return;
        if (STAY_PHANTOM) llSetStatus(STATUS_PHANTOM, TRUE);
        //else
        //llSetLinkPrimitiveParams(LINK_ALL_CHILDREN, [PRIM_PHYSICS_SHAPE_TYPE, PRIM_PHYSICS_SHAPE_PRIM]);
    }
}
hover(integer onoff)
{
    float value = 0.0;
    if (onoff)
    {
        if (hovering) return;
        value = 1.0;
        debug("Hovering...");
    }
    else
    {
        if (!hovering) return;
        debug("Hovering stop.");
    }
    llSetVehicleFloatParam(VEHICLE_BUOYANCY, value);
    hovering = onoff;
}

adjust_target(integer raise)
{
    if ( target.z < position.z) target.z = position.z;
    target = adjust_height(target, FALSE, raise); //rewrite by the new terrain
    if ( target.z < position.z) target.z = position.z;
    if ( tstatus == 0 && DEBUG < 2 ) return;
    s = "adjusted";
    if (raised) s = "raised";
    else if (landing) s = "lowered";
    if (DEBUG > 1) debug("Target " + s + "=" + (string)target + " " + station_name);
}
vector adjust_height(vector p, integer seek, integer raise)
{
    offset = p - now_t;
    float w = llWater(offset) + float_level;
    float g = llGround(offset) + ground_level ;
    float d = dive_level;
    float z;
    float distance = llVecMag(horizont(p - target));
    if ( distance < NEAR_STATION && station_name != "" )
    {
        d *= distance/NEAR_STATION;
    }
    z = w + d;
    land = FALSE;
    if ( g > z ) z = g;
    if ( g > w )
    {
        land = TRUE;
        z = g;
        if (d > 0.0) z += d;
        if (passengers > 0 && BOAT && seek && (station_name == "" || distance > NEAR_STATION) && ++acount < ANGLE_TIME )
        {
            //debug("Angle count=" + (string)acount);
            if ( speed > SPEED_MID ) speed = SPEED_MID;
            vector a;
            float angle = 0;
            vector better = offset;
            float lowest = llGround(offset);
            while ( land && llFabs(angle) < ANGLE_MAX )
            {
                if ( angle > 0 ) angle = -angle - ANGLE_STEP;
                else angle = -angle + ANGLE_STEP;
                a =offset*llAxisAngle2Rot(<0, 0, 1.0>, DEG_TO_RAD*angle);
                g = llGround(a);
                if ( g < lowest ) better = a; 
                land = check_land(a);
            }
            if (land) a = better;
            offset = a;
            p = now_t + offset;
            z =  llWater(offset) + float_level;
        }
    }
    else acount = 0;
    raised = FALSE;
    if (FLIGHT_LEVEL > 0.0 && raise)
    {
        if (landing)
        {
            p.z = position.z;
            raised = FALSE;
        }
        else //if ( land || station_name != "" )
        {
            z += FLIGHT_LEVEL;
            raised = TRUE;
        }
        //else raised = FALSE;
    }
    if ( p.z < z || (FOLLOW_TERRAIN && !sky) ) p.z = z;
    if ( p.z < g ) p.z = g;
    return p;
}

integer initial_station()
{
    integer m = llGetListLength(stations);
    vector now_t = p2t(llGetPos());
    tstatus = 0;
    reverse = FALSE;
    crossing = FALSE;
    if (boundfor != "" ) index = llListFindList(stations, [boundfor]);
    else index = -1;
    bound_index = index;
    //debug("Original bound_index= " + (string)bound_index);
    if ( index >= 0 )
    {
            debug("'" + boundfor + "' found at index=" + (string)index + ".");
            over_index = index + 1;
            if (shortcut) start_index = index - 1; 
    }
    else index = 0;
    if ( !shortcut &&  !(looped && bound_index < 0 ) )  //  && !oneway
    {
        string err = "";
        float over_head = PARKING_TIME*SPEED_HIGH; // meter
        float sum = -1.0;
        float term = -1.0;
        float here = -1.0;
        vector last_target;
        vector top_target;
        index = 0;
        while(next_station())
        {
            //debug("Index#" + (string)(index - 2) + ":" + (string)position + " " + station_name);
            if ( target.z < 0.001 ) adjust_target(FALSE);
            if ( sum < 0.0 )
            {
                sum = 0.0;
                top_target = target;
                last_target = target;
            }
            else
            {
                sum += llVecMag(target - last_target) + 0.5*over_head;
                if (crossing) sum += over_head;
            }
            crossing = FALSE;
            if ( term < 0 && station_name == boundfor) term = sum;
            if ( here < 0 && llVecMag(target - now_t) < NEAR_STATION ) here = sum;
            last_target = target;
        }
        if ( bound_index < 0 ) term = 0.5*sum;
        sum += llVecMag(top_target - last_target);
        debug( "(sum, term, here) = (" + (string)sum + ", " + (string)term + ", " + (string)here + ")" ); 
        if ( term < 0 ) err = "Target '" + boundfor  + "' not found in the course. ";
        if ( here < 0 ) err += "Current position not found in the course.";
        if ( err != "" ) llSay(0, err);
        else
        {
            if (looped)
            {
                float div = term - here;        
                if ( (div > 0 && div > 0.5*sum) || (div < 0 && div > -0.5*sum) ) reverse = TRUE; 
            }
            else if ( term < here ) reverse = TRUE;
        }
    }
    else if ( start_index >= m - 2 && (!shortcut) && (!(looped && bound_index < 0)) ) reverse = TRUE;
    if (reverse) debug("Took reverse course.");

    if ( bound_index < 0 ) over_index = start_index + 2;
    if (reverse) over_index = over_index - 4;
    round_start = FALSE;
    if ( !looped && bound_index < 0 )
    {
        over_index = m;
        if (reverse) over_index = -2;
        round_start = TRUE;
    }    
    debug("Start index, over index: " + (string)start_index + ", " + (string)over_index);
    index = start_index;
    tstatus = -1;
    if ( FLIGHT_LEVEL > 0.0 ) landing = TRUE;
    if (!over_station())
    {
        llOwnerSay( "Index=" + (string)index + " out of range.");
        return FALSE;
    }
    if (DEBUG > 1) debug("Target=" + (string)target + ", Now_t=" + (string)now_t);
    if ( llVecMag( target - now_t ) < NEAR_STATION )
    {
        debug("Skipped near station.");
        if (!over_station())
        {
            llOwnerSay( "Index=" + (string)index + " out of range.");
            return FALSE;
        }
    }
    //if ( bound_index >= 0 && station_name != boundfor ) station_name = "";
    landing = FALSE;
    if ( FLIGHT_LEVEL > 0.0 )
    {
        adjust_target(TRUE); //position = now_t + <0, 0, FLIGHT_LEVEL>;
        now_t = p2t(llGetPos());
        station_name = "";
        if (reverse) index += 2;
        else index -= 2;
    }
    crossing = FALSE;
    next_step();
    return TRUE;
}

integer cyclic(integer i)
{
    integer  m = llGetListLength(stations);
    if (reverse)
    {
        if (i < 0 ) i = m - 2;
    }
    else
    {
        if (i >= m ) i = 0;
    }
    //debug("Cyclic index=" + (string)i);
    return i;
}

integer over_station()
{ 
    if (looped) index = cyclic(index);
    if (!next_station())
    {
        if (!looped) return FALSE;
        index = cyclic(index);
        if (!next_station())
        {
            llOwnerSay("Failed to find next station over the cource edge.");
            return FALSE;
        }
    }
    return TRUE;
}
integer pick_station(integer i)
{
    integer m = llGetListLength(stations);
    if (i >= m || i < 0) return FALSE;
    position = llList2Vector(stations, i);
    station_name = llList2String(stations, ++i);
    return TRUE;
}
integer next_station()
{
    integer m = llGetListLength(stations);
    if (!pick_station(index))
    {
        debug("Reached the end of the course.");
        return FALSE;
    }
    if (reverse) index -= 2;
    else index += 2;    
    if (DEBUG > 1)
    {
        debug("#" + (string)index + (string)position + station_name);
    }
    if ( station_name == "*check*" )
    {
        if (tstatus > 0)
        {
            if (reverse) position = -position;
            if (tstatus) debug( "Checking dirction: " + (string)position);
            if ( tstatus && !region_online(position) )
            {
                llWhisper(0, OFFLINE_MESSAGE);
                return FALSE;
            }
        }
        else crossing = TRUE;
        if (!pick_station(index))
        {
            debug("Reached the end of the course after '*check*'.");
            return FALSE;
        }
        if (reverse) index -= 2;
     else index += 2;    
    }
    //target = position;
    if ( !relative && position == ZERO_VECTOR )
    {
        llOwnerSay("Missing target.");
        return FALSE;
    }
    sky = position.z > 0.0;
    if (relative) position = r2t(position);
    if ( llVecMag(position - org_t) > TOOFAR )
    {
        llOwnerSay("Target is too far from the original point.");
        return FALSE;
    }
    target = position;
    if ( tstatus != 0 )
    {
        if ( bound_index >= 0 && station_name != boundfor ) station_name = "";
        adjust_target(TRUE);
    }
    return TRUE;
}

vector horizont(vector a)
{
    vector h = a;
    h.z = 0.0;
    return h;
}
vector norm(vector a)
{
     if ( llVecMag(a) > 1.0 ) return llVecNorm(a);
     else return a;
}

vector next_step()
{
    float rate;
    arrow = target - now_t;
    distance = llVecMag(arrow);
    high_speed = SPEED_HIGH;
    low_speed = SPEED_MIN;
    span = speed*INTERVAL;
    if ( SLOWER > 0.0) speed += span/SLOWER;
    else speed = SPEED_HIGH;
    if ( distance < SLOWER*SPEED_HIGH )
    {
        if (SLOWER > 0.0 ) high_speed = distance/SLOWER;
        else high_speed = SPEED_HIGH;
        if ( station_name != "" )
        {
            if (FLIGHT_LEVEL > 0.0 && !landing ) low_speed = 2.0*SPEED_MIN;
            else low_speed = SPEED_MIN;
            if ( high_speed < SPEED_MIN ) high_speed = SPEED_MIN;
        }
        else
        {
            if ( high_speed < SPEED_MID ) high_speed = SPEED_MID;
            if ( high_speed < speed ) low_speed = SPEED_MID;
        }
    }
    if ( high_speed < low_speed ) high_speed = low_speed;
    if (crossing) high_speed = SPEED_MIN;
    if ( speed < low_speed ) speed = low_speed;
    if ( speed > high_speed ) speed = high_speed;
    if ( passengers <= 0 && FAST_BACK_HOME != 0 ) speed = (float)llAbs(FAST_BACK_HOME)*SPEED_HIGH;
    span = speed*INTERVAL;
    arrow = norm(arrow);
    if ( passengers > 0 && LINE_FORCE < 1.0 && llVecMag(horizont(arrow)) > 0.5 && llVecMag(horizont(old_arrow)) > 0.5 && span*llVecMag(horizont(arrow) - horizont(old_arrow)) > DELTA )
    {
        rot = llRotBetween(horizont(old_arrow), horizont(arrow));
        angle = llRot2Angle(rot);
        rate = (1.0*span + NEAR)/distance + LINE_FORCE*LINE_FORCE;
        if (rate > 1.0) rate = 1.0;
        if ( (1.0 - rate)*angle > 0.5*PI )
        {
            //debug((string)angle);
            rate = rate + 0.5 + 0.5*LINE_FORCE;
            if (rate > 1.0) rate = 1.0;
        }
        angle = rate*angle;
        old_arrow.z = arrow.z;
        arrow = old_arrow*llAxisAngle2Rot(llRot2Axis(rot), angle);
        arrow = norm(arrow);
        old_arrow = arrow;
    }
    if ( distance > span )
    {
        offset = span*arrow;
    }
    else offset = target - now_t;
    next_t = adjust_height(now_t + offset, TRUE, TRUE);
    offset = next_t - now_t;
    arrow = norm(offset);
    if ( FLIGHT_LEVEL < 0.01 ) old_arrow = arrow;
    if ( llVecMag(offset) > span )
    {
        offset = span*arrow;
    }
    return offset;
}

float zangle(vector h)
{
    float angle = llAtan2(h.y, h.x);
    return angle;
}

new_rotation(vector offset)
{
    now_rot = llGetRot();
    rot = now_rot;
    next_rot = now_rot;
    vector my_arrow = STD_ARROW*rot;
    vector new_arrow = norm(offset);
    vector my_h = norm(horizont(my_arrow));
    vector h = norm(horizont(new_arrow));
    float angle;
    float w = 0.0;
    vector Y = <0.0, 1.0, 0.0>;
    vector Z = <0.0, 0.0, 1.0>;
    if ( llVecMag(offset) < SPEED_MIN*INTERVAL ) return;
    if ( llVecMag(new_arrow - my_arrow) < DELTA ) return;
    if ( BALLOON && llVecMag(my_h) < 0.5 ) return;
    if ( BALLOON && llVecMag(h) < 0.5 ) return;
    if ( BALLOON && llVecMag(h - my_h ) < DELTA ) return;
    angle = zangle(h) - zangle(my_h);
    if ( angle > PI ) angle = angle - 2.0*PI;
    else if ( angle < -1.0*PI ) angle = angle + 2.0*PI;
    //debug("Angle =" + (string)(RAD_TO_DEG*angle));
    w = angle/INTERVAL;
    if ( llFabs(w) > MAX_OMEGA )
    {
        if ( w > 0.0 ) w = MAX_OMEGA;
        else w = -MAX_OMEGA;
    }
    angle = 0.0;
    float dz = new_arrow.z - my_arrow.z;
    if (BALLOON) dz = my_arrow.z;
    if (llFabs(dz) > DELTA) angle = llAtan2(dz, 1.0); // pitch
    //debug("Angle =" + (string)(RAD_TO_DEG*angle));    
    if (PHYSICS)
    {
        angle = angle/INTERVAL;
        llSetVehicleVectorParam(VEHICLE_ANGULAR_MOTOR_DIRECTION,  FOLLOW_ANGLE_STRENGTH*<0, angle, w>);
    }
    else
    {
        angle = w*INTERVAL; 
        rot = llAxisAngle2Rot(Z, angle);
        next_rot= now_rot*rot;
        if (!BALLOON)
        {
            h = my_h*rot;
            new_arrow = <h.x, h.y, new_arrow.z>;
            next_rot = llRotBetween(STD_ARROW, h)*llRotBetween(h, new_arrow);
        }
    }
}

integer region_online(vector direction)
{
    return !llEdgeOfWorld(llGetPos(), direction);
}

integer check_land(vector offset)
{
    land = (llGround(offset) + ground_level > llWater(offset) +  float_level);
    return land;
}

watch()
{
    now_pos = llGetPos();
    now_rot = llGetRot();
    now_t = p2t(now_pos);
    land = check_land(ZERO_VECTOR);
    hopping = now_pos.z > llWater(offset) + ground_level;
    diving = now_pos.z < llWater(offset) + sink_level;
    if (crossing_failed)
    {
        if (llGetNumberOfPrims() > org_prims)
        {
            unsit();
        }
    }
    if (crossing)
    {
        if (llGetNumberOfPrims() > org_prims || passengers <= 0 )
        {
            llWhisper(0, "Crossing regions completed.");
            adjust_target(TRUE);
            crossing = FALSE;
        }
        if ( --ccount <= 0 )
        {
            llSay(0, "Crossing regions timeout.");
            passengers = 0;
            //crossing = FALSE;
            //if (crossing_failed)
            //{
                error("Crossing regions Fault");
                shutdown();
                return;
            //}
            //crossing_failed = TRUE;
            //if (!returning) tour_end();
        }
    }
    if (!hopping && !diving) { if (!splashing) splash(TRUE); }
    else if (splashing) splash(FALSE);
    offset = next_step();
    //debug((string)offset);
    next_t = now_t + offset;
    next_rot = now_rot;
    if ( !BALLOON || llVecMag(horizont(target - now_t)) > span ) new_rotation(offset);
    if (!powered) power(TRUE);
    if (PHYSICS)
    {
        if (!BALLOON && !BOAT)
        {
            if (land && hovering) hover(FALSE);
            else if (!land && !hovering) hover(TRUE);
        }
        last_speed = offset/INTERVAL/llGetRot();
        move(last_speed);
    }
    else
    {
        next_pos = t2p(next_t);
        llSetKeyframedMotion( [next_pos - now_pos, next_rot/now_rot, INTERVAL], []);
    }
    small = NEAR;
    if ( FLIGHT_LEVEL > 0.0 )
    {
        if (landing) small = 0.7;
    }
    else if ( station_name != "" && !raised ) small = 0.7;
    if ( small < 0.7 ) small = 0.7;
    if ( llVecMag(target - now_t) < small*speed*INTERVAL )
    {
        //debug("Near the station " + station_name);
        raised = FALSE;
        if ( station_name == "*check*" )
        {
            debug("Station Name is *check*. Why?");
            llWhisper(0, OFFLINE_MESSAGE);
            unsit();
            return;
        }
        else if ( station_name != "" )
        {
          passengers = llGetNumberOfPrims() - org_prims;
          if ( passengers > 0 || station_name == request_station )
          {
            if ( FLIGHT_LEVEL > 0.0 && !landing )
            {
                landing = TRUE;
                adjust_target(TRUE);
                return;
            }
            else
            {
                landing = FALSE;
                old_arrow = STD_ARROW*(llGetRot()/STD_ROT);
                string msg = replace_keyword(ARRIVED_MESSAGE, "%s", station_name );
                llWhisper(0, msg );
                popup(msg, NORMAL_COLOR);
                debug("Index=" + (string)index );
                power(FALSE);
                locate(t2p(target));
                correct_position();
                attention();
                speed = 0.0; //SPEED_MIN;
                parking_station = station_name;
                //scan_terminal();
                if (station_name == boundfor || (round_start && index == over_index) )
                {
                    boundfor = "";
                    if ( passengers > 0 ) unsit();
                    //buttons = [];
                    tstatus = 0;
                    if (oneway || llVecMag(now_t - org_t ) < NEAR_STATION) tour_pause(DOOR_TIME);
                    else tour_pause(STAND_TIME);
                    return;
                }
                pcount = (integer)((float)PARKING_TIME/INTERVAL);
                if (BRIEFSTOP_MESSAGE != "" ) llWhisper(0, replace_keyword(BRIEFSTOP_MESSAGE, "%s", (string)PARKING_TIME ) + "
" +  TOUCHANDGO_MESSAGE);
                //attention();
                if ( FLIGHT_LEVEL > 0.0 )
                {
                    target += <0, 0, FLIGHT_LEVEL>;
                    station_name = "";
                    if (DEBUG > 1) debug("Target raised =" + (string)target);
                    return;
                }
            }
          }
        }
        if (!over_station())
        {
            llSay(0, "Next station not found.");
            tour_end();
            return;
        }
        //debug("bound_index= " + (string)bound_index);
        //if ( bound_index >= 0 && station_name != boundfor ) station_name = "";
        round_start = TRUE;
    }
    if ( llVecMag(now_t - milestone) > MILE  || crossing)
    {
        bcount = 0;
        milestone = now_t;
    }
    else
    {
        //debug("Speed=" + (string)speed);
        if ( ++bcount > BLOCK_TIME )
        {
            bcount = 0;
            now_pos = llGetPos();
            now_region = llGetRegionName();
            llSay(0, BLOCKED_MESSAGE + " at " + now_region + (string)now_pos);
            error(BLOCKED_MESSAGE);
            vector arrow = <128.0, 128.0, now_pos.z>; 
            arrow = llVecNorm(arrow - now_pos);
            llSetPos(10.0*arrow + now_pos);
            unsit();
            if (now_region == org_region || disposal) tour_end();
            else shutdown;
            return;
        }
    }
    last_pos = now_pos;
    last_rot = now_rot;

}

move(vector v)
{
        llSetVehicleVectorParam(VEHICLE_LINEAR_MOTOR_DIRECTION, v);
}

power(integer onoff)
{
    if (onoff)
    {
        if (PHYSICS)
        {
            physics(TRUE);
            vehicle();
        }
        else
        {
            physics(FALSE);
        }
        if (passengers > 0 && !powered)
        {
            stop_sound();
            if ( START_SOUND != "" ) llTriggerSound(START_SOUND, 1.0);
            if ( START_MOMENT > 0.1 )
            {
                engine(ENGINE_SPEED/3);
                llSleep(START_MOMENT);
            }
        }
        if (ENGINE_SOUND != "") loop_sound(ENGINE_SOUND);
        if (crossing) return;
        engine(ENGINE_SPEED);
        powered = TRUE;
    }
    else
    {
        if (PHYSICS) physics(FALSE);
        else llSetKeyframedMotion( [], []);
        if (crossing) return;
        stop_sound();
        if ( START_SOUND != "" ) llTriggerSound(START_SOUND, 0.0);
        splash(FALSE);
        if (passengers > 0 && powered )
        {
            if (STOP_SOUND != "" ) llTriggerSound(STOP_SOUND, 1.0);
            if (STOP_MOMENT > 0.1)
            {
                engine(ENGINE_SPEED/3);
                llSleep(STOP_MOMENT);
            }
        }
        engine(0);
         //if (ENGINE_SOUND != "" ) stop_sound();
        powered = FALSE;
    }
}
engine(integer speed)
{
    llMessageLinked(LINK_SET, speed, POWER_COMMAND, NULL_KEY);
}
light(integer onoff)
{
    integer step = onoff;
    if (step) step = 1;
    llMessageLinked(LINK_SET,step, LIGHT_COMMAND, NULL_KEY);
}
splash(integer onoff)
{
    llMessageLinked(LINK_SET,onoff, SPLASH_COMMAND, NULL_KEY);
    splashing = onoff;
    if (splashing) debug ("Splash.");
}
loop_sound(string sound)
{
    key id = llGetInventoryKey(sound);
    llMessageLinked(LINK_SET, TRUE, SOUND_COMMAND, id);
}
stop_sound()
{
     llMessageLinked(LINK_SET, FALSE, SOUND_COMMAND, NULL_KEY);
}
door(integer close)
{
    llMessageLinked(LINK_SET,close, DOOR_COMMAND, NULL_KEY);
    door_state = close;
}

tour_start()
{
    //if (tstatus > 0) { return; }
    close_menu();
    door(CLOSE);
    tstatus = -1;
    pcount = 0;
    bcount = 0;
    rcount = 0;
    origin = TRUE;
    popdown();
    parking_station = "";
    if (!initial_station())
    {
        string err = "";
        if ( boundfor == "" ) err = "Target station not set.";
        else err = "Trouble around the initial station '" + boundfor + "'. Probably the course '" + note + "' is wrong.";
        llSay(0, err + "
" + NOTREADY_MESSAGE);
        llSleep(4.0);
        tour_end();
        return;
    }
    if (boundfor == "")
    {
        if (looped) boundfor = ROUND;
        else boundfor = EVERY;
    }
    llWhisper(0, replace_keyword(BOUNDFOR, "%s", boundfor ) );
    //light(TRUE);
    power(TRUE);
    llSetTimerEvent(0);
    llSetTimerEvent(INTERVAL);
}

launch()
{
    tstatus = 1;
    parking_station = "";
    llWhisper(0, LAUNCH_MESSAGE);
}

set_parking(integer timeout)
{
    pcount = (integer)((float)timeout/INTERVAL);
    string msg = replace_keyword(WAITING_MESSAGE, "%s", (string)timeout);
    llSay(0, msg );
    popup(WAITING_MESSAGE0, NORMAL_COLOR);
}

tour_pause(integer timeout)
{
    if (timeout <= 0 )
    {
        tour_end();
        return;
    }
    power(FALSE);
    //light(FALSE);
    door(OPEN);
    tstatus = 0;
    lcount = 0;
    //scan_terminal();
    if ( request_station == parking_station ) request_station = "";
    set_parking(timeout);
}

tour_cont()
{
    popdown();
    door(CLOSE);
    pcount = 0;
    tstatus = 1;
    parking_station = "";
}

tour_end()
{
    debug("Tour end. Original station: " + org_station + "(" + org_region + ") " + (string)org_pos);
    string err = "";
    unsit();
    shutdown();
    llSleep(MOMENT);
    pcount = 0;
    tstatus = 0;
    returning = TRUE;
    landing = FALSE;
    if (disposal) llDie();
    if ( origin && ( now_region != org_region || !FAST_BACK_HOME && llVecMag(now_pos - org_pos ) > NEAR_STATION ) )
    {
        if ( ++rcount < RETRY_TIME )
        {
            if (!travel_to(org_station))
            {
                llSay(0, "'" + org_station + "' not found.");
                return;
            }
            return;
        }
        else err = "Retried " + RETRY_TIME + ". ";
        if ( err != "" )
        {
            error(err + "Abort back home");
            shutdown();
            llSleep(10.0);
            if ( now_region != org_region ) return; 
        }
    }
    tstatus = 0;
    if ( now_region == org_region ) back_home();
    shutdown();
    popup(WAIT_MESSAGE, ERR_COLOR);
    returning = FALSE;
    reset_script();
    return;
}

integer travel_to(string station)
{
    //request_station = "";
    if ( org_station == "" ) start_point();
    scan_terminal();
    if ( llListFindList(terminals, station) < 0 ) return FALSE;
    boundfor =  station;
    tour_start();
    return TRUE;
}

back_home()
{
    power(FALSE);
    llSetRot(org_rot);
    locate(org_pos);
    llSetRot(org_rot);
}
locate(vector p)
{
    vector now_pos=llGetPos();
    vector old_pos= ZERO_VECTOR;
    float clearance = 0.1;
    while ( llVecMag(now_pos - p) > clearance && llVecMag(now_pos - old_pos) > clearance )
    {
        llSetPos(p);
        old_pos = now_pos;
        now_pos = llGetPos();
    }
     llSetPos(p);
}

float hover_level()
{
    if (land) return (llGround(ZERO_VECTOR) + ground_level);   
    return (llWater(ZERO_VECTOR) + float_level);
}

correct_position()
{
    llSetStatus(STATUS_PHYSICS, FALSE);
    vector roll = llRot2Euler(llGetRot());
    roll.x = 0.0; roll.y = 0.0;
    rotation rot = llEuler2Rot(roll);
    llSetRot(rot);
    llSetRot(rot);
}

surface()
{
    //llSetStatus(STATUS_PHYSICS, FALSE);
    vector roll = llRot2Euler(llGetRot());
    roll.x = 0.0; roll.y = 0.0;
    rotation rot = llEuler2Rot(roll);
    vector pos = llGetPos();
    vector old_pos = pos;
    check_land(ZERO_VECTOR);
    float z = hover_level();
    float altitude = pos.z - z;
    float ALLOWANCE = 0.1;
    debug((string)ground_level);
    if ( altitude > ALLOWANCE )
    {
        if (BOAT)
        {
            pos.z = z;
            locate(pos);            
        }
        else
        {
            float clearance = 0.01;
            float old_z = pos.z;
            debug("Wait for a moment to fix position.");
            physics(TRUE);
            hover(FALSE);
            llSleep(0.5);
            integer falling = TRUE;
            while ( pos.z > z + ALLOWANCE && falling)
            {
                llSleep(1.0);
                pos = llGetPos();
                pos.x = old_pos.x;
                pos.y = old_pos.y;
                llSetPos(pos);
                falling = (old_z - pos.z > clearance);
                old_z = pos.z;
            }
            physics(FALSE);
            llSetPos(pos);
        }
    }
    altitude = pos.z - z;
    if ( altitude < -ALLOWANCE )
    {
        pos.z = z;
        locate(pos);
    }
    else
    {
        llSetRot(rot);
    }
    correct_position();
    debug("Surface");
}

unsit()
{
    key agent = llAvatarOnSitTarget();
    if (agent) { llUnSit(agent); } 
    llMessageLinked(LINK_SET,0,"unsit", NULL_KEY);
    llSleep(1.0);
}

integer start_point()
{
    integer i;
    now_region = llGetRegionName();
    org_region = now_region;
    org_pos = llGetPos();
    org_rot = llGetRot();
    now_pos = org_pos;
    now_rot = org_rot;
    next_rot = org_rot;
    //debug("Original Rot.=" + (string)org_rot);
    region_x = 0;
    region_y = 0;
    if ( llGetListLength(regions) > 0 )
    {
        i = llListFindList( regions, [now_region]);
        if ( i >= 0 )
        {
            region_x = (integer)llList2String(offsets, 2*i);
            region_y = (integer)llList2String(offsets, 2*i + 1);
        }
        else
        {
            fatal = "Start region '" + now_region + "' does not appear
in '" + note + "'.";
            error(fatal);
            return FALSE;
        }
    }
    org_ix = region_x;
    org_iy = region_y;
    corner = llGetRegionCorner();
    org_wx = (integer)(corner.x/256.0 + 0.5);
    org_wy = (integer)(corner.y/256.0 + 0.5);
    org_t = p2t(org_pos);
    now_t = org_t;
    milestone = now_t;
    old_arrow = STD_ARROW*(llGetRot()/STD_ROT);
    org_station = "";
    debug("Original station cleared.");
    return TRUE;
}

vector p2t(vector pos)
{
    vector t = pos;
    t.x += offset_u*(float)region_x;
    t.y += offset_u*(float)region_y;
    return t;
}
vector t2p(vector t)
{
    vector p = t;
    p.x -= offset_u*(float)region_x;
    p.y -= offset_u*(float)region_y;
    return p;
}

vector r2t(vector rel)
{
    return rel*org_rot + org_t;
}

cross_region()
{
    if (crossing)
    {
        llWhisper(0, "Passengers failed to cross regions.");
        passengers = 0;
    }
    crossing = TRUE;
    ccount = (integer)((float)CROSSING_TIMEOUT/INTERVAL);
    power(FALSE);
    llSetTimerEvent(0);
    if ( passengers > 0 )
    {
        if ( REGION_MOMENT > 0.0 )
        {
            llWhisper(0, "Crossing regions. It takes a moment.");
            llSleep(REGION_MOMENT);
            speed = SPEED_MIN;
        }
        else llWhisper(0, "Crossing regions.");
    }
    now_region = llGetRegionName();
    corner = llGetRegionCorner();
    region_x = (integer)(corner.x/256.0 + 0.5) - org_wx + org_ix;
    region_y = (integer)(corner.y/256.0 + 0.5) - org_wy + org_iy;    
    vector new_pos = llGetPos();
    new_pos.z = last_pos.z;
    locate(new_pos);
    llSetRot(last_rot);
    hovering = FALSE;   //buoyancy may be losed
    power(TRUE);
    if (PHYSICS)
    {
        if ( llVecMag(last_speed) > SPEED_MIN )
            last_speed = SPEED_MIN*llVecNorm(last_speed);
        move(last_speed);
    }
    llSetTimerEvent(INTERVAL);
    if ( passengers <= 0 && now_region == org_region && FAST_BACK_HOME > 0 ) tour_end();
}

string open_note(string head)
{
    if (llGetInventoryKey(head) != NULL_KEY )
    {
        note = head;
    }
    else
    {
        note = "";
        string name = "";
        integer cont = TRUE;
        integer i = -1;
        while (cont)
        {
            name = llGetInventoryName(INVENTORY_NOTECARD,++i);
            if ( name == "" ) { cont = FALSE; }
            else if (llSubStringIndex(name, head) == 0)
            {
                note = name;
                cont = FALSE;
            }
        }
    }
    if ( note == "" )
    {
        llOwnerSay(head + " NOT found.");
        return "";
    }
    debug("Reading... " + note);
    lineKey = NULL_KEY;
    line_count = -1;
    next_line();
    return note;
}

next_line()
{
    lineKey = llGetNotecardLine( note, ++line_count );
}
integer isnum(string s)
{
    if ( s == "" ) return FALSE;
    if ( llSubStringIndex("0123456789.-+", llGetSubString(s, 0, 0)) >=0 )
      return TRUE;
    else return FALSE;
}
integer parse_line(string line)
{
    string s;
    list dataList;
    float x;
    float y;
    float z;
    integer ix;
    integer iy;
    integer dx;
    integer dy;
    integer i;
    integer j;
    integer n;
    if (line == EOF) { return -1; }
    i = llSubStringIndex( line, "//" );
    if ( i == 0 ) { return 0; }
    if ( i > 0 )
    {
        line = llGetSubString(line, 0, i - 1);
    }
    line = llStringTrim(line, STRING_TRIM);
    if (line == "" ) return 0;
    dataList = llParseString2List( line, [" "], [ ]);
    n = llGetListLength( dataList );
    if ( n <= 0 ) { return 0; }
    j = 0;
    s = llList2String( dataList, j);
    if ( isnum(s) )
    {
        x = (float)s;
        y = (float)llList2String(dataList, ++j);
        z = 0;
        if ( x < 0.001 || y < 0.001 )
        {
            if (!relative) debug("Asume 'local'."); 
            relative = TRUE;
        }
        x += (float)(offset_x*offset_u);
        y += (float)(offset_y*offset_u);
        if (relative) z = -256.0;
        s = "";
        if ( ++j < n) s = llList2String( dataList, j );
        if ( isnum(s) )
        {
            z = (float)s; s="";
            if ( ++j < n ) s = llList2String( dataList, j );
        }
        if ( s != "" ) s = llGetSubString( line, llSubStringIndex( line, s), -1);
        if (debuglevel > 1) debug((string)x + ", " + (string)y + ", "  + (string)z + ", " + s);
        stations += [ <x, y, z>, s ];
        return 0;
    }
    else
    {
        s = llToLower(s);
        if ( s == "offset" )
        {
            ix = (integer)llList2String( dataList, ++j );
            iy = (integer)llList2String( dataList, ++j );
            s = "";
            if ( ++j < n ) s = llList2String( dataList, j );
            if ( s != "" ) s = llGetSubString( line, llSubStringIndex( line, s), -1);
            s = llStringTrim(s, STRING_TRIM);
            region = s;
            if ( region != "" )
            {
                i = llListFindList(regions,[region]);
                if ( i < 0 )
                {
                    regions += [region];
                    offsets += [ix, iy];
                }
                else
                {
                    dx = (integer)llList2String(offsets, 2*i);
                    dy = (integer)llList2String(offsets, 2*i + 1);
                    if ( ix != dx || iy != dy )
                    {
                        fatal = "Invalid COURCE.";
                        llOwnerSay("Duplicated region with different offset:" + "
Offset " + (string)dx + " " + (string)dy + " " + region + "
Offset " + (string)ix + " " + (string)iy + " " + region );
                    }
                }
            }
            if (ONLINE_CHECK)
            {
                dx = ix - offset_x;
                dy = iy - offset_y;
                if ( dx || dy )
                {
                    stations += [ <(float)dx, (float)dy, 0.0>, "*check*" ];
                    if (debuglevel > 1) debug("Add check line."); 
                }
            }
            offset_x = ix;
            offset_y = iy;
            if (debuglevel > 1) debug("Offset: " + (string)offset_x + ", " + (string)offset_y + " Region:" + region);
        }
        else
        {
            debug( note +": " + s);
            if ( s == "local" || s == "relative" ) relative = TRUE;
            else if ( s == "loop" ) looped = TRUE;
            else if ( s == "oneway" ) oneway = TRUE;
            else if ( s == "shortcut" ) shortcut = TRUE;
            else if ( s == "debug" )
            {
                debuglevel = 2;
            }
            else
            {
                llOwnerSay("Ilegal statement found at line " + (string)line_count + ":
" + line );
            }
        }
        return 0;
    }
}

scan_terminal()
{
    integer index_save = index;
    terminals = [];
    buttons = [];
    string s;
    now_pos = llGetPos();
    now_t = p2t(now_pos);
    start_index = 0;
    float short = TOOFAR;
    float distance = 0.0;
    reverse = FALSE;
    integer reversible = TRUE;
    if (oneway || shortcut) reversible = FALSE;
    if (looped) reversible = TRUE;
    if (returning) reversible = TRUE;
    index = llGetListLength(stations) - 1;
    if ( llList2String(stations, index) == ""  && !looped)
    {
        stations = llListReplaceList(stations, [END_STATION], index, index);
        debug("Marked " + END_STATION + " at index=" + (string)index);
    }
    integer near = FALSE;
    integer leaving = FALSE;
    index = 0;
    while ( next_station() )
    {
        if ( target.z < 0.01 ) adjust_target(FALSE);
        if (DEBUG > 1) debug("Target=" + (string)target);
        distance = llVecMag(target - now_t);
        if ( distance < short )
        {
            start_index = index - 2;
            short = distance;
            if ( !reversible )
            {
                terminals = [];
                buttons = [];
                debug(station_name + ", Distance=" + (string)distance + " Terminals cleared.");
            }
        }
        else if (near) leaving = TRUE;
        near = distance < NEAR_STATION;
        if ( !near )
        {
            if ( station_name != "" && llListFindList(terminals, [station_name]) < 0 )
            {
                //debug("Terminal:" + station_name);
                terminals += [station_name];
                s = button_label(station_name);
                buttons += [s];
                debug("Terminal:" + s);
            }
        }
    }

    index = start_index;
    next_station();
    index = index - 2;
    if ( llListFindList(stations, [START_STATION]) < 0)
    {
        if ( short > NEAR_STATION  )
        {
            vector t = ZERO_VECTOR;
            if (!relative) t = now_t; 
            stations = llListInsertList(stations, [ t, START_STATION], index);
            debug("short=" + (string)short + ": Inserted " + START_STATION + " at index#" + (string)index);
        }
        else if ( station_name == "" )
        {
            stations = llListReplaceList(stations, [START_STATION], index + 1, index + 1);
            debug("Marked " + START_STATION + " at index#" + (string)index);
        }
    }
    parking_station = llList2String(stations, start_index + 1);
    debug( "Parking station:" + parking_station);
    if ( org_station == "" ) org_station = parking_station;
    debug( "Original station: " + org_station + ", Start index=" + (string)start_index);
    debug("Number of terminals=" + (string)llGetListLength(terminals));
    if ( llGetListLength(terminals) == 0 && !looped) terminals = [END_STATION];
    //if (MENU)
    //{
        if (llGetListLength(buttons) == 0 ) buttons = [TOUR_START];
        else if (llGetListLength(buttons) > 1 )
        {
            if (looped) buttons += [ROUND];
            else buttons += [EVERY];
        }
    //}
    index = index_save;
}

afterwork()
{
    integer m = llGetListLength(stations);
    integer top;
    integer last;
    if ( fatal != "" )
    {
        error(fatal);
        return;
    }
    reverse = FALSE;
    index = 0;
    top = index;
    if (!next_station())
    {
        fatal = "No station in '" + note + "'.";
        error(fatal);
        return;
    }
    if (looped && m > 2)
    {
        vector top_target = target;
        index = m - 2;
        last = index;
        if (next_station())
        {
            if (llVecMag(target - top_target) < NEAR_STATION)
            {
                //debug("Top target#" + (string)top + (string)top_target);
                //debug("Last target#" + (string)last + (string)target);
                debug("Deleting last target " + (string)target);
                stations = llDeleteSubList(stations, m - 2, m - 1);
                m = m - 2;
                while(llList2String(stations, m - 1) == "*check*")
                {
                    stations = llDeleteSubList(stations, m - 2, m - 1);
                    m = m - 2;
                }
                
            }
        }
    }
    finishwork();
}
finishwork()
{
    start_point();
    scan_terminal();
    buttons = [];
    if (disposal)
    {
        if (TIMEOUT > 0) set_parking(TIMEOUT);
        llSetTimerEvent(INTERVAL);
    }
    ready = start_point();
    if (!ready) return;
    llSay(0, READY_MESSAGE);
    popup(READY_MESSAGE, NORMAL_COLOR);
    attention();
    open_call();
}

open_call()
{
    close_call();
    if (CALL_CHANNEL)
    {
        call_handle = llListen(CALL_CHANNEL, "", NULL_KEY, "");
    }
}
close_call()
{
    if (call_handle) llListenRemove(call_handle);
    call_handle = 0;
}

start_menu(key agent)
{
    debug("Menu to be shown to " + llKey2Name(agent) + ".");
    lcount = (integer)((float)MENU_TIMEOUT/INTERVAL);
    show_menu(agent);
    llInstantMessage(agent, FROM_MENU);
}
show_menu(key agent)
{
    if (handle == 0 ) handle = llListen(channel, "", NULL_KEY, "");
    if (lcount <= 0 ) llSetTimerEvent(INTERVAL);
    lcount = (integer)((float)MENU_TIMEOUT/INTERVAL);
    string msg = MENU_MESSAGE;
    list menu = [];
    integer total = llGetListLength(buttons);
    integer m = (total + 8)/9;
    if ( total < 12 ) m = 0;
    if ( m == 0 )
    {
        menu = [CANCEL] + buttons;
    }
    else
    {
        if ( page <= 0 || page > m ) page = 1;
        msg = "Page " + (string)page +"/" + (string)m + "\n" + msg;
        if (page == 1) menu = [ CANCEL, BLANK, NEXT ];
        else if (page == m) menu = [ CANCEL, BACK, BLANK ];
        else menu = [ CANCEL, BACK, NEXT ];
        menu +=  llList2List(buttons, (page -1)*9, page*9 -1);
    }
    llDialog(agent, msg, menu, channel);
}
close_menu()
{
    if (handle) llListenRemove(handle);
    handle = 0;
    lcount = 0;
}

string button_label(string str)
{
    string  esc = llEscapeURL(str);
    esc = replace_keyword(esc, "%20", " ");
    esc = replace_keyword(esc, "%40", "@");
    //esc = replace_keyword(esc, "%2C", ",");
    if ( llSubStringIndex(esc, "%") < 0 ) return llGetSubString(str, 0, 22);
    else
    {
        debug("Escaped:" + esc);
        return llGetSubString(str, 0, 6);
    }
}

string replace_keyword(string src, string keyword, string value)
{
    if ( keyword == "" ) return src;
    string s = src;
    integer i;
    integer n = llStringLength(keyword) - 1;
    i = 0;
    while( i >= 0 )
    {
        i = llSubStringIndex(s, keyword);
        if ( i >= 0 )
        {
            s = llDeleteSubString( s, i, i + n );
            s = llInsertString( s, i, value);
        }
    }
    return s;
}

attention()
{
    if (NOTE_SOUND == "") return;
    llTriggerSound(NOTE_SOUND, 1.0);
    llSleep(0.5);
}
resize()
{
    vector size = llGetScale();
    ground_level = GROUND_LEVEL + 0.5*size.z;
    float_level = FLOAT_LEVEL + 0.5*size.z;
    dive_level = DIVE_LEVEL + 0.5*size.z;
    sink_level = SINK_LEVEL + 0.5*size.z;
}

first_passenger(key agent)
{
    debug("First passenger is " + llKey2Name(agent) + ".");
    popdown();
    if ( org_station == "" )
    {
        if (!start_point()) return;
    }
    light(TRUE);
    scan_terminal();
}

coldstart()
{
    shutdown();
    disposal = FALSE;
    debuglevel = DEBUG;
    if (PHYSICS) llSetLinkPrimitiveParamsFast(LINK_ALL_CHILDREN, [PRIM_PHYSICS_SHAPE_TYPE, PRIM_PHYSICS_SHAPE_NONE]);
    //if (MENU)
    //{
        channel = -1*llCeil(llFrand(990.0) + 10.0);
        debug("Cannel=" + (string)channel);
    //}
    resize();
    unsit();
    org_prims = llGetNumberOfPrims();
    origin = FALSE;
    ready = FALSE;
    fatal = "";
    //if (NOTE_SOUND != "") llPreloadSound(NOTE_SOUND);
    if (open_note(note_head) != "")
    {
        debuglevel = DEBUG;
        relative = FALSE;
        looped = FALSE;
        oneway = FALSE;
        shortcut = FALSE;
        regions = [];
        offsets = [];
        stations = [];
        offset_x = 0;
        offset_y = 0;
        offset_u = 256;
    }
    else
    {
        fatal = note_head + " not found.";
        error(fatal);
    }
}
hotstart()
{
    shutdown();
    request_station = "";
    origin = FALSE;
    ready = FALSE;
    finishwork();
}

shutdown()
{
    llSetTimerEvent(0);
    stop_sound();
    power(FALSE);
    light(FALSE);
    door(CLOSE);
    close_menu();
    close_call();
}

reset_script()
{
    shutdown();
    reset = TRUE;
    llSetTimerEvent(0.2);
}

default
{
    state_entry()
    {
        llOwnerSay(llGetScriptName() + " reset.");
        popup(WAIT_MESSAGE, ERR_COLOR);
        coldstart();
    }

    on_rez(integer param) {
        llSetTimerEvent(0);
        if (SURFACE_ON_REZ)
        { 
            popup(WAIT_MESSAGE, ERR_COLOR);
            llSay(0,WAIT_MESSAGE);
            surface();
        }
        if (param == 0)
        {
            reset_script();
            return;
        }
        disposal = TRUE;
        popdown();
        hotstart();
    }

    changed(integer change)
    {
        debug("Change=" + (string)change);
        //if (change & CHANGED_INVENTORY || change & CHANGED_SCALE) {
        if (change & CHANGED_INVENTORY) {
            llOwnerSay("Script reset due to some inventory is changed.");
            reset_script();
            return;
        }

        if (change & CHANGED_LINK)
        {
            key agent = llAvatarOnSitTarget();
            integer old_passengers = passengers;
            passengers = llGetNumberOfPrims() - org_prims;
            if ( passengers > 0 )
            {
                if (!ready)
                {
                    llWhisper(0, NOTREADY_MESSAGE);
                    llSleep(4.0);
                    unsit();
                    return;
                }
                else if ( tstatus == 0 )
                {
                    if (agent != NULL_KEY ) debug(llKey2Name(agent) + " sit on the main seat.");
                    if (OWNER_ONLY && agent != llGetOwner() ) return;
                    //llWhisper(0, WELCOME_MESSAGE);
                    if (llGetListLength(buttons) <= 0) first_passenger(agent);
                    if ( llGetListLength(buttons) > 1 || MENU )
                    {
                        if (lcount <= 0 ) llSetTimerEvent(INTERVAL);
                        if (agent != NULL_KEY && agent != last_sitter ) start_menu(agent);
                    }
                    else
                    {
                        if ( llGetListLength(terminals) == 1 ) boundfor = llList2String(terminals, 0);
                        else boundfor = "";
                        //debug ("Bound for " + boundfor + ".");
                        if ( MAX_PASSENGERS > 0 && passengers >= MAX_PASSENGERS ) tour_start();
                        else
                        {
                            popup(TOUCHME_MESSAGE,NORMAL_COLOR);
                            llSay(0, TOUCHME_MESSAGE);
                            attention();
                        }
                    }
                }
            }
            else if (!STANDUP_OK)
            {
                buttons = [];
                if ( pcount <= 0 && ready && !returning && !STANDUP_ANYTIME ) tour_end();
            }
            if ( passengers < old_passengers && door_state == CLOSE && !returning ) tour_pause(STAND_TIME);
            last_sitter = agent;
        }
        if (change & CHANGED_REGION)
        {
            cross_region();
        }
        if ( change & CHANGED_REGION_START ) {
            if ( tstatus > 0 ) tour_end();
        }
    }
    
    touch_start(integer num)
    {
        key agent = llDetectedKey(0);
        debug(llKey2Name(agent) + " touched.");
        if (OWNER_ONLY && agent != llGetOwner() ) return;
        if ( passengers <= 0 && agent == llGetOwner())
        {
            surface();
            reset_script();
            return;
        }
        if (ready && passengers > 0 && tstatus == 0)
        {
            if ( passengers >= MAX_PASSENGERS && llGetListLength(buttons) <= 1 && !MENU ) tour_start();
            else
            {
                if ( lcount < MENU_TIMEOUT - 10.0/INTERVAL ) start_menu(agent);
            }
        }
        else if (pcount > 0)
        {
            tour_cont();
        }
    }
    
    timer()
    {
        if (reset)
        {
            llSetTimerEvent(0);
            llSleep(0.1);
            llResetScript();
        }
        else if (lcount > 0)
        {
            if ( --lcount <= 0 )
            {
                //debug("Menu reply timeout.");
                llSetTimerEvent(0);
                close_menu();
                unsit();
                llWhisper(0, "timeout. Tour canceled.");
            }
            return;
        }
        else if (tstatus < 0) { launch(); }
        else if (pcount > 0)
        {
            if ( pcount > PARKING_TIME && request_station != "" ) pcount = PARKING_TIME;
            if ( --pcount <= 0 )
            {
                tour_cont();
                if ( request_station != "" )
                {
                    travel_to(request_station);
                    return;
                }
                else
                {
                    if (passengers < 1 && !STANDUP_OK) tstatus = 0;
                    if ( tstatus <= 0 )
                    {
                        llSetTimerEvent(0);
                        if ( passengers > 0 && boundfor != "" ) return;
                        llSay(0, "Timeout.");
                        if (disposal) llDie();
                        else tour_end();
                    }
                }
            }
        }
        else if (tstatus > 0) { watch(); }
        else
        {
            llSetTimerEvent(0);
        }
    }


    listen(integer ch, string name, key agent, string msg)
    {
        integer index;
        debug((string)ch + ":" + msg);
        if ( ch == CALL_CHANNEL )
        {
            integer i = llListFindList(stations, [msg]);
            if (i < 0 )
            {
                llOwnerSay("'" + msg + "' not found in stations.");
                return;
            }
            //debug( "'" + msg + "' found at index#" + i + " in stations.");
            vector pos = llList2Vector(stations, i - 1);
            if (relative) pos = r2t(pos);
            pos = adjust_height(pos, FALSE, FALSE);
            //debug("Position=" + (string)position);
            if ( msg == boundfor ) return;
            else if ( msg == parking_station )
            {
                if ( tstatus == 0 || pcount > 0 ) door(OPEN);
                return;
            }
            if ( request_station == "" )
            {
                request_station = msg;
                if ( passengers <= 0 )
                {
                    debug("Request now: " + request_station);
                    travel_to(request_station);
                }
                else debug("Request queued: " + request_station);
            }
            return;
        }
        else if ( ch != channel ) return;
        llSetTimerEvent(0);
        if (tstatus != 0)
        {
            llInstantMessage(agent, MENU_CLOSED);
            return;
        }
        if ( passengers < 1 ) return;
        msg = llStringTrim(msg, STRING_TRIM);
        if ( msg == CANCEL )
        {
            llWhisper(0, "Tour canceled.");
            unsit();
        }
        else if ( msg == BACK  && page > 1 )
        {
            --page;
            start_menu(agent);
            return;
        }
        else if (msg == NEXT)
        {
            ++page;
            show_menu(agent);
            return;
        }
        else
        {
            index = llListFindList(buttons, [msg]);
            if ( index >= 0 )
            {
                close_menu();
                boundfor = llList2String(terminals,index);
                if ( boundfor == "" ) boundfor = msg;
                tour_start();
            }
        }
    }

    dataserver(key query_id, string data) 
    {
        if ( query_id != lineKey ) { return; }
        if ( parse_line(data) < 0 ) {
            debug((string)line_count + " lines read.");
            afterwork();
        } else {
            next_line();
        }
    }

    link_message(integer sender, integer num, string str, key id)
    {
        debug((string)sender + ":" + (string)num + ":" + str + ":" + (string)id + "(" + llKey2Name(id) + ")" );
        if (str != "sit" ) return;
        if (!ready) return;
        if (tstatus != 0) return;
        if ( id == NULL_KEY ) return;
        if (OWNER_ONLY && id != llGetOwner() ) return;
        if ( llGetListLength(buttons) <= 0 ) first_passenger(id);
        if ( llGetListLength(buttons) <= 1  && !MENU ) return;
        start_menu(id);
        last_sitter = id;
    }
}
 