// Touch the object to light it up.
// Lighting is configurable.
 
integer light_s    = TRUE;
vector  lightcolor = <1.0, 0.15, 0.15>;
float   intensity  = 1.0;             // 0.0 <= intensity <= 1.0
float   radius     = 2.5;            // 0.1 <= radius <= 20.0
float   falloff    = 0.01;            // 0.01 <= falloff <= 2.0
float   glow       = 0.05;
 

 
default
{
    on_rez(integer iStartParameter)
    {
        llResetScript();
    }
    state_entry()
    {
      llSetColor(lightcolor, ALL_SIDES);
      llSetTimerEvent(0.15); 
      
    }
    link_message(integer Sender, integer Number, string String, key Key) // This script is in the object too.
    {
      
       if(String == "XCONTROL") {
            
             if (!Number) {
                 light_s    = FALSE;
                 llSetTimerEvent(0.0); 
                 llSetPrimitiveParams([
        PRIM_POINT_LIGHT, light_s, lightcolor, intensity, radius, falloff,
        PRIM_FULLBRIGHT, ALL_SIDES, light_s,
        PRIM_GLOW,       ALL_SIDES, glow
    ]);
            } else {   
             light_s    = TRUE;
             llSetTimerEvent(0.15); 
            }
        }     
    }
    timer()
    {
        intensity = 0.5+llFrand(0.5);
        if(!light_s) intensity = 0;
        llSetPrimitiveParams([
        PRIM_POINT_LIGHT, light_s, lightcolor, intensity, radius, falloff,
        PRIM_FULLBRIGHT, ALL_SIDES, light_s,
        PRIM_GLOW,       ALL_SIDES, glow
    ]);
    }
}