key       playerID = NULL_KEY;
integer   digitNum = 0;

string    CMD_ENDTURN = "CMD_END_TURN";
string    CMD_STARTTURN = "CMD_START_TURN";
string    CMD_ROLLDICE = "CMD_ROLL_DICE";

string    DIEROLL = "DIE_ROLL";
string    DIESELECTED = "DIE_SELECTED";
string    DIEUNSELECTED = "DIE_UNSELECTED";

string    CMD_RESET = "CMD_RESET";
string    CMD_UPDTURN = "CMD_UPDTURN";

string    BTN_START = "BTN_START";
string    CMD_START = "CMD_START";

string    BTN_JOIN = "BTN_JOIN"; 
string    CMD_JOIN = "CMD_JOIN";

updScore(integer score)
{
    integer digit = score - ( (integer)(score/(digitNum*10)) ) * (digitNum*10);

    digit = (integer)(digit / digitNum);

    digit = 360-(90*digit);
    
    float offset = ((float)digit) / 1000;
    llSetPrimitiveParams([PRIM_TEXTURE, 0, "numbers", <1,0.09,0.0>, <0,offset,0>, 0]);
}

init()
{
    digitNum = (integer) llGetObjectDesc();
}

default
{
    state_entry()
    {
        init();
    }

    link_message(integer sender_number, integer number, string message, key id)
    {
        list msgParts = llParseString2List( message, [" "], [] );
        string cmd = llList2String( msgParts, 0 );
        integer num1 = llList2Integer(msgParts, 1);

        if(cmd == CMD_JOIN || cmd == CMD_START)
        {
            state WAIT;
        }
        else if( cmd == CMD_STARTTURN )
        {
            playerID = id;

            state PLAY;
        }
        else if( cmd == CMD_UPDTURN)
        {
            updScore(num1);
        }

        else if( cmd == CMD_RESET )
        {
            llResetScript();
        }
    }
}


state WAIT
{
    state_entry()
    {
    }

    link_message(integer sender_number, integer number, string message, key id)
    {
        list msgParts = llParseString2List(message, [" "], []);
        string cmd = llList2String(msgParts, 0);
        integer num1 = llList2Integer(msgParts, 1);

        if( cmd == CMD_STARTTURN )
        {
            playerID = id;

            state PLAY;
        }
        else if( cmd == CMD_UPDTURN)
        {
            updScore(num1);
        }
        else if( cmd == CMD_RESET )
        {
            state default;
        }
    }
}



state PLAY
{
    state_entry()
    {
    }

    link_message(integer sender_number, integer number, string message, key id)
    {
        list msgParts = llParseString2List(message, [" "], []);
        string cmd = llList2String(msgParts, 0);
        integer num1 = llList2Integer(msgParts, 1);

        if(cmd == CMD_ENDTURN)
        {
            state WAIT;
        }
        else if( cmd == CMD_UPDTURN)
        {
            updScore(num1);
        }
        else if( cmd == CMD_RESET )
        {
            state default;
        }
    }
}