// KU - OnTouchRezObject v05
// v05 20161216 - Boxed for distribution
// v04 20151207 - Added rezzing sound
// v03 20151206 - Renamed to "KU - Snow saucer rezzer "
// v02 20151205 - Adjusted for Snow saucer dispenser
// v01 20141122 - Adjusted for Toboggan dispenser
// v00 20141122 - Copied from http://wiki.secondlife.com/wiki/LlRezObject

// Rez an object on touch, with relative position, rotation, and velocity all described in the rezzing prim's coordinate system.
string object = "KU - Snow saucer v11"; // Name of object in inventory
// "KU - Snow saucer v11" - Introduced sound and replace smoke with snow particle
vector relativePosOffset = <2.0, 0.0, 0.0>; // "Forward" and a little "above" this prim
vector relativeVel = <1.0, 0.0, 0.0>; // Traveling in this prim's "forward" direction at 1m/s
// rotation relativeRot = <0.707107, 0.0, 0.0, 0.707107>; // Rotated 90 degrees on the x-axis compared to this prim
rotation relativeRot = <0.00,0.00,0.00,0.00>;
integer startParam = 10;
 
default
{
    touch_start(integer a)
    {
        vector myPos = llGetPos();
        rotation myRot = llGetRot();
 
        vector rezPos = myPos+relativePosOffset*myRot;
        vector rezVel = relativeVel*myRot;
        rotation rezRot = relativeRot*myRot;
        
        llPlaySound("snd_dream31_wav", 1.0); 
        llRezObject(object, rezPos, rezVel, rezRot, startParam);
    }
}