// Douglas Maxwell          Fire and Smoke Script       31 January 2014
//
//  Derived in part from "Fire" PARTICLE TEMPLATE v1 - by Jopsy Pendragon - 4/8/2008
//
//** The original 'free' version of this script came from THE PARTICLE LABORATORY. **//

string  CONTROLLER_ID = "A"; // See comments at end regarding CONTROLLERS.
integer AUTO_START = TRUE;   // Optionally FALSE only if using CONTROLLERS.

list particle_parameters=[]; // stores your custom particle effect, defined below.
list target_parameters=[]; // remembers targets found using TARGET TEMPLATE scripts.

help()
{
    llSay(0, "\n 
            Channel 35 
            reset to stop
            fire to burn");
}

default 
  {
    state_entry()
     { 
     
         llListen(35,"",NULL_KEY,"");
            }
     listen(integer channel, string name, key id, string msg)
    {
         if (msg =="help")
        {
            help();
        }
        if( msg== "reset" )
        {                                          //When you say 'reset' on channel 35, it will go back to a non-invisiprim.
        llSetLinkAlpha(LINK_SET, 0.0, ALL_SIDES);
        llParticleSystem([]);
        }
         if( msg== "fire" )
        {                                          //When you say 'fire' on channel 35, it will go invisible.
        llSetLinkAlpha(LINK_SET, 1.0, ALL_SIDES);
        particle_parameters = [  // start of particle settings
           // Texture Parameters:
           PSYS_SRC_TEXTURE, llGetInventoryName(INVENTORY_TEXTURE, 0), 
           PSYS_PART_START_SCALE, <1.25,1.25,FALSE>,  PSYS_PART_END_SCALE, <1.5,1.5, FALSE>, 
           PSYS_PART_START_COLOR, <1,1,0>,    PSYS_PART_END_COLOR, <.4,0,0>, 
           PSYS_PART_START_ALPHA, (float).8,            PSYS_PART_END_ALPHA, (float).0,     
         
           // Production Parameters:
           PSYS_SRC_BURST_PART_COUNT, (integer)2, 
           PSYS_SRC_BURST_RATE, (float) 0.03,  
           PSYS_PART_MAX_AGE, (float).75, 
           PSYS_SRC_MAX_AGE,(float) 0.0,  
        
           // Placement Parameters:
           PSYS_SRC_PATTERN, (integer)2, // 1=DROP, 2=EXPLODE, 4=ANGLE, 8=ANGLE_CONE,
           
           // Placement Parameters (for any non-DROP pattern):
           PSYS_SRC_BURST_SPEED_MIN, (float).1,   PSYS_SRC_BURST_SPEED_MAX, (float).3, 
        // PSYS_SRC_BURST_RADIUS, 0.0,
        
           // Placement Parameters (only for ANGLE & CONE patterns):
           PSYS_SRC_ANGLE_BEGIN, (float) .03*PI,     PSYS_SRC_ANGLE_END, (float)0.00*PI,  
        // PSYS_SRC_OMEGA, <0,0,0>, 
        
           // After-Effect & Influence Parameters:
           PSYS_SRC_ACCEL, <0.0,0.0,15.5>,  
        // PSYS_SRC_TARGET_KEY,      llGetLinkKey(llGetLinkNum() + 1),       
              
           PSYS_PART_FLAGS, (integer)( 0         // Texture Options:     
                                | PSYS_PART_INTERP_COLOR_MASK   
                                | PSYS_PART_INTERP_SCALE_MASK   
                                | PSYS_PART_EMISSIVE_MASK   
                                | PSYS_PART_FOLLOW_VELOCITY_MASK
                                                  // After-effect & Influence Options:
                                | PSYS_PART_WIND_MASK            
                                | PSYS_PART_BOUNCE_MASK          
                             // | PSYS_PART_FOLLOW_SRC_MASK     
                             // | PSYS_PART_TARGET_POS_MASK     
                             // | PSYS_PART_TARGET_LINEAR_MASK   
                            ) 
            //end of particle settings                     
        ];
        
        if ( AUTO_START ) llParticleSystem( particle_parameters );
        
    }
}
    link_message( integer sibling, integer num, string mesg, key target_key ) {
        if ( mesg != CONTROLLER_ID ) { // this message isn't for me.  Bail out.
            return;
        } else if ( num == 0 ) { // Message says to turn particles OFF:
            llParticleSystem( [ ] );
        } else if ( num == 1 ) { // Message says to turn particles ON:
            llParticleSystem( particle_parameters + target_parameters );
        } else if ( num == 2 ) { // Turn on, and remember and use the key sent us as a target:
            target_parameters = [ PSYS_SRC_TARGET_KEY, target_key ];
            llParticleSystem( particle_parameters + target_parameters );
        } else { // bad instruction number
            // do nothing.
        }            
    }
     
}