vector opensize=<0.062,1.242,0.82>;
vector closedsize=<0.031,0.414,0.547>;
string book="closed";
integer pagesets=9;
// here enter the number of pages
list pageUUIDs=["e2b9287c-7a25-4b62-9d60-2a5e81426152","810c68b6-93ab-4d9f-b697-c7f15bc2d096","7b8f1587-7267-4c2f-83ff-f14ebe2dc6dc","51cd7b66-0c8c-4633-aa7b-0386cbe4061a","89d1af64-4712-4129-97b3-1f31c58f004a","d76d3b3a-fe85-414b-869d-92087a61abd6","55fbdc64-6914-4233-880d-6abf97ccdd68","0f88b731-179f-4063-96af-be4e58fd5b0e","e9ea43a2-fe91-429e-8f94-4cb95fb2174c"];
// here enter all UUIDs of the pictures that make the double pages
integer pageset=0;

settexture()
{
    string ID=llList2String(pageUUIDs,pageset);
    key textureID=(key) ID;
    llSetTexture("041d02c0-b2fa-4ddf-bafb-c438adf72fc4",0);
// texture of upper face
    llSetTexture("810c68b6-93ab-4d9f-b697-c7f15bc2d096",1);
// texture of right side face on open
    llSetTexture("e2b9287c-7a25-4b62-9d60-2a5e81426152",3);
// texture of first side face on open
    llSetTexture("041d02c0-b2fa-4ddf-bafb-c438adf72fc4",4);
// texture below face on open
    llSetTexture("63f5294b-6a33-4219-97cc-d3965b7106fb",2);
// texture backside on open
    llSetPrimitiveParams([PRIM_TEXTURE, 5, textureID, <0.5,1,0>, <0.25,0,0>, 0.0]);
    llSetPrimitiveParams([PRIM_TEXTURE, 6, textureID, <0.5,1,0>, <-0.25,0,0>, 0.0]);
    //    llSetTexture(textureID,5);
    // texture all inner right pages
    //    llSetTexture(textureID,6);
    // texture all inner left pages
    llSetTexture("041d02c0-b2fa-4ddf-bafb-c438adf72fc4",7);
// texture below face on open
}

closebook()
{
    llSetPrimitiveParams([PRIM_TYPE, PRIM_TYPE_BOX, 0, <0,1,0>, 0.0, <0,0,0>, <1,1,1>, <0,0,0>]);
    llSetPrimitiveParams([PRIM_SIZE, closedsize]);
    llSetTexture("041d02c0-b2fa-4ddf-bafb-c438adf72fc4",0);
// texture above face
    llSetTexture("041d02c0-b2fa-4ddf-bafb-c438adf72fc4",1);
// texture right side face
    llSetTexture("63f5294b-6a33-4219-97cc-d3965b7106fb",2);
// texture back face
    llSetTexture("63f5294b-6a33-4219-97cc-d3965b7106fb",3);
// texture left side face
    llSetTexture("8df88c99-8b1e-4807-8324-5efd9588cad1",4);
// texture cover face
    llSetTexture("041d02c0-b2fa-4ddf-bafb-c438adf72fc4",5);
// texture below face
}

default
{    
    state_entry()
    {
        closebook();
        book="closed";
        pageset=0;
    }
    
    touch_start(integer num_times)
    {
        if(book=="closed")
        {
            book="open";
            llSetPrimitiveParams([PRIM_TYPE, PRIM_TYPE_BOX, 0, <0,0.725,0>, 0.0, <0,0,0>, <1,1,1>, <0,0,0>]);
            llSetPrimitiveParams([PRIM_SIZE, opensize]);
            settexture();
        } else if(book=="open")
        {
            pageset=pageset + 1;
            if(pageset>(pagesets-1))
            {
                closebook();
                book="closed";
                pageset=0;
            } else {
                settexture();
            }
        }
    } 
}