//revision 14, compiled for mono

//revision 13, added chat command to sync anims.  Renamed "voice" config option to "chat".

//Revision 12, used bitwise & instead of == in the changed event, just in case some other change happens at the exact moment someone sits.

//Revision 11, Changed the style of the config file so I can use llParseString2List instead of the substring method previously used.  Changed the logic of the config parsing to be more clean.  Also allow a list of face anims now, that will be cycled through.  Added an option to configure the channel on which the ball listens for chat commands

//Revision 10, Ilse Mannonen, added "always_hide" option.  Another way to build poses into furniture without visible balls, but also not requiring use of offset vectors.

//Revision 9, Ilse Mannonen, animations in linked sets now sync when someone sits.

//Revision 8, Ilse Mannonen, fixed a bug in the face emoter so that the timer stops if there's no one sitting on the ball

//Revision 7, Ilse Mannonen, added on option to remain visible when sat upon, so that the script can be usedin furniture without need for a separate poseball

//Revision 6, Ilse Mannonen, commented out the llStopAnimation that gets called when the av stands, because it complained whenever someone logged off while sitting on the ball.  Added a rotation option, and moved its configuration, as well as that of the emote and emote timer, into the config file.

//Revision 5, Ilse Mannonen, added option to have a timed facial expression
//on sit, start a timer
//when the timer goes, play the animation
//when the person stands up, stop the timer

//Pose Ball script, Revision 4.3
//Notecard configuration enabled, switchable link_message/touch_start/llListen support, sit_text, floating text, alpha.
//Version 4.3 fixs link_set hide/show and permission sensing issues.

//By CrystalShard Foo.
//Work started - October 10th.
//Last compile - November 7th.

//This script will let you choose if you want to turn the ball visible on CLICK, or by using a SHOW/HIDE voice command.
//You can also set the offset and the title of the ball, as well as the sit button text - all with a notecard.

//This script is free and comes without support. Dont contact me. Ask a local geek for help if it gets messy.

// ** This script is NOT FOR SALE **
//You can use it in commercial products as long as you give this script to anyone who asks for it.
//You can use this source, distribute it and modify it freely, but leave the credits intact!
//(You can add your own name to the list, ofcourse. Like, "Modified by John Doe")



string TITLE="";            //This text will appear in the floating title above the ball
string ANIMATION="";             //Put the name of the pose/animation here!
list lstEmotes=[];
float fltEmoteRepeat=3.0;
integer intCurrentEmote = 0;

vector offset=<0,0,0.5>;            //You can play with these numbers to adjust how far the person sits from the ball. ( <X,Y,Z> )
vector vecRot=<0,0,0>; 
integer use_chat = FALSE;
integer hide_on_sit = TRUE;
integer always_invisible = FALSE;

string  gNotecard = "CONFIG";
integer gLine = 0;

integer listenHandle = -1;
integer listenChannel = 3;
integer masterswitch = TRUE;
integer visible = TRUE;
float base_alpha = 1.0;
key avatar;

key dataserver_key = NULL_KEY;

show()
{
    if (!always_invisible)
    {
        visible = TRUE;
        llSetText(TITLE, <1,1,1>,1);        
        llSetAlpha(base_alpha, ALL_SIDES);        
    }
}

hide()
{
    if (hide_on_sit == TRUE)
    {
        visible = FALSE;
        llSetText("", <1,1,1>,1);        
        llSetAlpha(0, ALL_SIDES);        
    }
}

next_line()
{
    gLine++;
    dataserver_key = llGetNotecardLine(gNotecard,gLine);
}

use_defaults()
{
    llSetSitText("Sit Here");
    if(visible == FALSE)
        llSetText("",<1,1,1>,1);
    else
        llSetText(TITLE,<1,1,1>,1);
}

init()
{

    if(llGetInventoryNumber(INVENTORY_ANIMATION) == 0)      //Make sure we actually got something to pose with.
    {
        llWhisper(0,"Error: No animation found. Cannot pose.");
        ANIMATION = "sit";
    }
    else
        ANIMATION = llGetInventoryName(INVENTORY_ANIMATION,0);

    if(llGetInventoryNumber(INVENTORY_NOTECARD) != 0)       //If the notecard is present, use it for configuration.
    {
        integer i;
        for(i=0;i<llGetInventoryNumber(INVENTORY_NOTECARD);i++)
            if(llGetInventoryName(INVENTORY_NOTECARD,i) == gNotecard)
            {
                gLine = 0;
                dataserver_key = llGetNotecardLine(gNotecard, 0);
                return;
            }
        use_defaults();
    }
    else            //No configuration notecard found... lets use the defaults.
        use_defaults();
}

default
{
    state_entry()
    {
        llSetText("Loading configuration...",<1,1,1>,1);
        rotation rot = llEuler2Rot(vecRot * DEG_TO_RAD); 
        llSitTarget(offset,rot);
        init();
        if (always_invisible)
        {
            llSetAlpha(0, ALL_SIDES);
        }
    }

    link_message(integer sender_num, integer num, string str, key id)
    {
        if(num == 99)
        {
            if(str == "show")
            {
                masterswitch = FALSE;
                hide();
                return;
            }
            else if(str == "hide")
            {
                masterswitch = TRUE;
                show();
            }
            else if(str == "sync")
            {
                //briefly stop and start the animation
                if (llAvatarOnSitTarget() != NULL_KEY && llGetPermissions() & PERMISSION_TRIGGER_ANIMATION)
                {
                    llStopAnimation(ANIMATION);
                    llStartAnimation("sit");
                    llSleep(0.1);                
                    llStopAnimation("sit");                
                    llStartAnimation(ANIMATION);                   
                }
            }
        }
    }
    
    touch_start(integer detected)
    {
        if(use_chat == FALSE)
        {
            if(visible == TRUE)
                hide();
            else
                show();
        }
        else
            llSay(0,llDetectedName(0)+", say '/1 Hide' to hide me, or '/1 Show' to make me show. Or just right-click and sit on me to use me.");
    }
    
    changed(integer change)
    {
        if(change & CHANGED_LINK)
        {
            avatar = llAvatarOnSitTarget();
            if(avatar != NULL_KEY)
            {
                hide();
                llRequestPermissions(avatar,PERMISSION_TRIGGER_ANIMATION);
                string strEmote = llList2String(lstEmotes, intCurrentEmote);
                if (strEmote != "" )
                {
                    llSetTimerEvent(fltEmoteRepeat);
                }
            }
            else
            {
                if (llGetPermissionsKey() != NULL_KEY) 
                    //llStopAnimation(ANIMATION);
                    llSetTimerEvent(0);
                if(masterswitch == TRUE)
                {
                    if (!always_invisible)
                    {
                        llSetAlpha(base_alpha,ALL_SIDES);
                        llSetText(TITLE,<1,1,1>,1);                        
                    }
                }
            }
        }
        
        if(change == CHANGED_INVENTORY)
        {
            llResetScript();
        }
    }
    
    run_time_permissions(integer perm)
    {
        if(perm & PERMISSION_TRIGGER_ANIMATION)
        {
            llStopAnimation("sit");
            llStartAnimation(ANIMATION);
            if(visible == TRUE)
                base_alpha = llGetAlpha(ALL_SIDES);
            else
                base_alpha = 1.0;
            if (hide_on_sit == TRUE) 
            {
                llSetAlpha(0.0,ALL_SIDES);
                llSetText("",<1,1,1>,1);                
            }
            ///send sync link message
            if (llAvatarOnSitTarget() != NULL_KEY)
            {
                //only send if the person is still sitting
                llMessageLinked(LINK_SET,99,"sync",NULL_KEY);                
            }
        }
    }
    
    listen(integer channel, string name, key id, string message)
    {
        if(llStringLength(message)!=4)
            return;
        
        message = llToLower(message);
        
        if(message == "show")
        {
            show();
        }
        else if(message == "hide")
        {
            hide();            
        }
        else if (message == "sync")
        {
            //briefly stop and start the animation
            if (llAvatarOnSitTarget() != NULL_KEY && llGetPermissions() & PERMISSION_TRIGGER_ANIMATION)
            {
                llStopAnimation(ANIMATION);
                llStartAnimation("sit");
                llSleep(0.1);                
                llStopAnimation("sit");                
                llStartAnimation(ANIMATION);                    
            }            
        }
    }
    
    dataserver(key queryid, string data)
    {
        if(queryid != dataserver_key)
        {
            return;            
        }
        
        if(data != EOF)
        {
            string param = llList2String(llParseString2List(data, ["="], []), 0);
            string value = llList2String(llParseString2List(data, ["="], []), 1);
            if(param == "title")
            {
                TITLE = value;
            }
            else if(param == "offset")
            {
                integer length = llStringLength(value);
                if(llGetSubString(value,0,0) != "<" || llGetSubString(value,length - 1,length) != ">")
                {
                    llSay(0,"Error: The numbers in the offset value lack the '<' and '>' signs. (Should be something like <3,1,6> )");
                    offset = <0,0,0.5>;
                }
                else
                    offset = (vector)value;
                
                if(offset == <0,0,0>)
                    offset = <0,0,0.01>;
                rotation rot = llEuler2Rot(vecRot * DEG_TO_RAD);     
                llSitTarget(offset,rot);
            }
            else if(param == "chat")
            {
                value = llToLower(value);
            
                if(listenHandle != -1)
                {
                    llListenRemove(listenHandle);
                    listenHandle = -1;
                }
                
                if(value !="no" && value != "yes" && value != "true" && value != "false")
                    use_chat = FALSE;
                else
                    if(value == "no" || value == "false")
                        use_chat = FALSE;
                    else
                    {
                        use_chat = TRUE;
                    }
            }
            else if (param == "listen_channel")
            {
                if (value == "0")
                {
                    llSay(DEBUG_CHANNEL, "Listening for hide and show commands on channel 0 is not allowed.  Please choose another channel.");
                    use_chat = FALSE;
                }
                else
                {
                    listenChannel = (integer)value;                    
                }
            }
            else if(param == "sit_button")
            {
                llSetSitText(value);
            }
            else if (param == "face_emotes")
            {
                lstEmotes = llParseString2List(value, ["|"],[]);
            }
            else if (param == "emote_timer")
            {
                fltEmoteRepeat = (float)value;                   
            }
            else if (param == "rotation")
            {
                integer length = llStringLength(value);
                if(llGetSubString(value,0,0) != "<" || llGetSubString(value,length - 1,length) != ">")
                {
                    llSay(0,"Error: The numbers in the rotation value lack the '<' and '>' signs. (Should be something like <30,90,0> )");
                    vecRot = <0,0,0>;
                }
                else
                {
                    vecRot = (vector)value;                    
                }
                rotation rot = llEuler2Rot(vecRot * DEG_TO_RAD);     
                llSitTarget(offset,rot);
            }
            else if (param == "hide_on_sit")
            {
                value = llToLower(value);
                if (value == "false" || value == "no")
                {
                    hide_on_sit = FALSE;                    
                }
            }
            else if (param == "always_invisible")
            {
                value = llToLower(value);
                if (value == "true" || value == "yes")
                {
                    always_invisible = TRUE;
                    llSetAlpha(0, ALL_SIDES);                    
                }
            }
            next_line();
        }
        else
        {
            //don't set the text til we've reached EOF
            if(visible == FALSE)
            {
                llSetText("",<1,1,1>,1);                
            }
            else
            {
                llSetText(TITLE,<1,1,1>,1);                
            }
            
            if (use_chat)
            {
                listenHandle = llListen(listenChannel,"",NULL_KEY,"");                
            }
        }
    }
    
    timer()
    {
        if (llAvatarOnSitTarget() != NULL_KEY)
        {
            intCurrentEmote++;
            if (intCurrentEmote >= llGetListLength(lstEmotes))
            {
                intCurrentEmote = 0;
            }
            string strEmote = llList2String(lstEmotes, intCurrentEmote);
            llStartAnimation(strEmote);            
        }
        else
        {
            llSetTimerEvent(0);
        }
    }
    
    on_rez(integer start_param)
    {
        llResetScript();
    }
}