vector velocity;
integer shot = FALSE; 
integer fade = FALSE;
float alpha = 1.0;
float damage = 100;
float hitpower = 999;
float lifetime = 2;

explode()
{
    llSetStatus(STATUS_PHYSICS, FALSE); 
    llTriggerSound("bb492eaf-add0-4566-b95b-ff1de599d970", 10.0);
    llPushObject(llDetectedKey(0), <0,0,hitpower>, <0,0,0>, FALSE);
    //llDie();
    llMessageLinked(LINK_SET, 0, "bang", "NULL_KEY");
    llSleep(0.5);
    doParticles();
    llSleep(10);
    llParticleSystem([]);
}


doParticles()
{
    llParticleSystem([
        PSYS_PART_FLAGS,            PSYS_PART_INTERP_COLOR_MASK | PSYS_PART_INTERP_SCALE_MASK | PSYS_PART_WIND_MASK,
        PSYS_SRC_PATTERN,           PSYS_SRC_PATTERN_ANGLE,
        PSYS_PART_START_COLOR,      <0.6, 0.6, 0.6>,
        PSYS_PART_END_COLOR,        <0.8, 0.8, 0.8>,
        PSYS_PART_START_ALPHA,      1.0,
        PSYS_PART_END_ALPHA,        0.0,
        PSYS_PART_START_SCALE,      <0.6, 0.6, 0.6>,
        PSYS_PART_END_SCALE,        <3.5, 3.5, 0.0>,
        PSYS_PART_MAX_AGE,          10.0,
        PSYS_SRC_ACCEL,             <0.0, 0.0, 0.6>,
        PSYS_SRC_TEXTURE,           "4c618610-eb59-410e-87bd-152a66d0edc9",
        PSYS_SRC_BURST_RATE,        0.1,
        PSYS_SRC_INNERANGLE,        0.0,
        PSYS_SRC_OUTERANGLE,        0.0,
        PSYS_SRC_BURST_PART_COUNT,  1,
        PSYS_SRC_BURST_RADIUS,      0.0,
        PSYS_SRC_BURST_SPEED_MIN,   0.0,
        PSYS_SRC_BURST_SPEED_MAX,   0.1
    ]);
}


default
{
    state_entry()
    {
        llSetDamage(damage);
    }
    
    on_rez(integer start_param)
    {
        llSetStatus(STATUS_DIE_AT_EDGE, TRUE);
        llSetBuoyancy(1.0);
        llCollisionSound("", 1.0);          //  Disable collision sounds
        velocity = llGetVel() * 5;
        float vmag;
        vmag = llVecMag(velocity);
        if (vmag > 0.1) shot = TRUE;
        llSetTimerEvent(lifetime);
    }

    collision_start(integer total_number)
    {
        explode();
    }
    
    timer()
    {
        if (!fade)
        {
            if (shot)
            {
                explode();
            }
        }   
        else
        {
            llSetAlpha(alpha, -1);
            alpha = alpha * 0.999999;  
            if (alpha < 0.1) 
            {
                explode();
            }     
        }
    }
}